/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.service;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import dn.recordFormChanges;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class contractService {
    private static final Logger contractServiceLogger;
    private final String[] excludesArray = new String[]{"ID", "ORGID", "BINDID", "CREATEDATE", "CREATEUSER", "UPDATEDATE", "UPDATEUSER", "PROCESSDEFID", "ISEND"};
    private static volatile contractService instance;

    private contractService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static contractService getInstance() {
        if (instance != null) return instance;
        Class<contractService> clazz = contractService.class;
        synchronized (contractService.class) {
            if (instance != null) return instance;
            instance = new contractService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, Object> SaveContract(UserContext uc, String bindid, boolean isSubmit) {
        contractServiceLogger.info("\u5408\u540c\u63d0\u4ea4\u540e");
        HashMap<String, Object> resultDto = new HashMap<String, Object>();
        try {
            boolean idApply = true;
            BO contractBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT_APPLY", bindid);
            if (contractBO == null) {
                idApply = false;
                contractBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT", bindid);
            }
            if (contractBO.getString("IS_SUBMIT").equals("1")) {
                isSubmit = true;
            }
            String TYPE_ID = contractBO.getString("TYPE_ID");
            if (isSubmit) {
                contractBO.set("IS_SUBMIT", (Object)1);
            } else {
                contractBO.set("IS_SUBMIT", (Object)0);
            }
            if (TYPE_ID.equals("1199")) {
                DBSql.update((String)"UPDATE BO_EU_DNCTT_CONTRACT_SERVICE SET OLD_QUANTITY = QUANTITY, OLD_UNIT_PRICE = UNIT_PRICE, OLD_TOTAL_PRICE = TOTAL_PRICE, OLD_UNIT_COST=UNIT_COST, OLD_TOTAL_COST =TOTAL_COST WHERE BINDID=?", (Object[])new Object[]{bindid});
                String PERIOD_TYPE = contractBO.getString("PERIOD_TYPE");
                Integer OCCURRENCES = (Integer)contractBO.get("OCCURRENCES", Integer.class);
                Date START_DATE = (Date)contractBO.get("START_DATE", Date.class);
                Date END_DATE = (Date)contractBO.get("END_DATE", Date.class);
                if ((END_DATE == null || END_DATE.before(START_DATE)) && OCCURRENCES != null && OCCURRENCES > 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(START_DATE);
                    if (PERIOD_TYPE.equals("612")) {
                        calendar.add(2, OCCURRENCES * 6);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else if (PERIOD_TYPE.equals("610")) {
                        calendar.add(2, OCCURRENCES);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else if (PERIOD_TYPE.equals("611")) {
                        calendar.add(2, OCCURRENCES * 3);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else if (PERIOD_TYPE.equals("613")) {
                        calendar.add(2, OCCURRENCES * 12);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else {
                        resultDto.put("success", false);
                        resultDto.put("msg", "\u5468\u671f\u7c7b\u578b\u8f93\u5165\u9519\u8bef\uff01");
                        return resultDto;
                    }
                    contractBO.set("END_DATE", (Object)END_DATE);
                }
            }
            contractBO.set("ADJUST_SETUP_FEE", contractBO.get("SETUP_FEE"));
            if (StringUtils.isBlank((CharSequence)contractBO.getString("BILL_TO_ACCOUNT_ID"))) {
                contractBO.set("BILL_TO_ACCOUNT_ID", (Object)contractBO.getString("ACCOUNT_ID"));
                contractBO.set("BILL_TO_ACCOUNT_NAME", (Object)contractBO.getString("ACCOUNT_NAME"));
            }
            if (idApply) {
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_APPLY", contractBO);
            } else {
                recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5408\u540c\u7f16\u8f91");
                this.ContractExcManage(uc, bindid);
            }
            contractServiceLogger.info("\u5408\u540c\u63d0\u4ea4\u540e\uff0c\u8fdb\u884c\u6570\u636e\u5904\u7406");
            RowMap dto = new RowMap(contractBO.asMap());
            if (idApply) {
                this.insertContract(uc, dto);
            } else {
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_RATE set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_MILESTONE set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_SERVICE set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_COST_DEFAULT set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_BLOCK set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
            }
            DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_COST set ACCOUNT_ID=?,BILL_ACCOUNT_ID=? where CONTRACT_ID=?", (Object[])new Object[]{dto.getString("ACCOUNT_ID"), dto.getString("BILL_ACCOUNT_ID"), dto.getString("ID")});
            if (TYPE_ID.equals("1199")) {
                try {
                    this.AddContractServiceProduct(uc, dto);
                    boolean flag = this.AddServiceServiceBundle(uc, dto);
                    if (!flag) {
                        resultDto.put("success", false);
                        resultDto.put("msg", "\u65b0\u589e\u670d\u52a1\u6216\u670d\u52a1\u5305\u5931\u8d25\uff01");
                        return resultDto;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    contractServiceLogger.info("info--\u5931\u8d25\u3002\u3002\u3002");
                    resultDto.put("success", false);
                    resultDto.put("msg", e.getMessage());
                    return resultDto;
                }
            }
            resultDto.put("success", true);
            return resultDto;
        }
        catch (Exception e) {
            e.printStackTrace();
            contractServiceLogger.info("info--\u5931\u8d25\u3002\u3002\u3002");
            resultDto.put("success", false);
            return resultDto;
        }
    }

    public void insertContract(UserContext uc, RowMap contract) throws SQLException {
        String contractBINDID = null;
        String APPLY_ID = contract.getString("ID");
        String APPLY_BINDID = contract.getString("BINDID");
        String exitsBOID = DBSql.getString((String)"select ID from BO_EU_DNCTT_CONTRACT where APPLY_ID=?", (Object[])new Object[]{APPLY_ID});
        String processDefId = "obj_4bac3fd23814406c8d224ef2094ac274";
        if (StringUtils.isNotBlank((CharSequence)exitsBOID)) {
            BO contractBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", exitsBOID);
            for (String key : this.excludesArray) {
                contract.remove((Object)key);
            }
            contractBO.setAll((Map)contract);
            contractBO.set("APPLY_ID", (Object)APPLY_ID);
            recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5408\u540c\u7f16\u8f91");
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", contractBO);
            contract.put("BINDID", (Object)contractBO.getBindId());
            contract.put("ID", (Object)contractBO.getId());
            contract.put("CONTRACT_ID", (Object)contractBO.getId());
            contractBINDID = contractBO.getBindId();
        } else {
            ProcessInstance contractInstance = SDK.getProcessAPI().createBOProcessInstance(processDefId, uc.getUID(), contract.getString("NAME"));
            BO contractBO = new BO();
            for (String key : this.excludesArray) {
                contract.remove((Object)key);
            }
            contractBO.setAll((Map)contract);
            contractBO.set("APPLY_ID", (Object)APPLY_ID);
            contractBO.setBindId(contractInstance.getId());
            recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5408\u540c\u65b0\u589e");
            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT", contractBO, uc);
            exitsBOID = contractBO.getId();
            contract.put("BINDID", (Object)contractInstance.getId());
            contract.put("ID", (Object)contractBO.getId());
            contract.put("CONTRACT_ID", (Object)contractBO.getId());
            contractBINDID = contractBO.getBindId();
        }
        contract.put("PROCESSDEFID", (Object)processDefId);
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_RATE set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_MILESTONE set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_SERVICE set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_BLOCK set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddServiceServiceBundle(UserContext uc, RowMap contract) throws SQLException {
        contractServiceLogger.info("\u65b0\u589e\u670d\u52a1\u6216\u670d\u52a1\u5305");
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            List serviceList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").connection(conn)).addQuery("BINDID=", contract.get((Object)"BINDID"))).list();
            for (BO service : serviceList) {
                this.AddServiceServiceBundleOne(uc, conn, contract, service);
            }
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            conn.rollback();
            contractServiceLogger.error("AddServiceServiceBundle--error--\u5931\u8d25\u3002\u3002\u3002", (Throwable)e);
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        return false;
    }

    public boolean AddServiceServiceBundleOne(UserContext uc, Connection conn, RowMap contract, BO service) {
        LocalDate currMontLastDay;
        if (service == null) {
            return false;
        }
        boolean isCreate = false;
        LocalDate START_DATE = contractService.getLocalDate(contract.get((Object)"START_DATE"));
        LocalDate END_DATE = contractService.getLocalDate(contract.get((Object)"END_DATE"));
        LocalDate EFFECTIVE_DATE = contractService.getLocalDate(service.get("EFFECTIVE_DATE"));
        String PERIOD = service.getString("PERIOD");
        String ADJUST_PERIOD = service.getString("ADJUST_PERIOD");
        if (EFFECTIVE_DATE == null || StringUtils.isBlank((CharSequence)PERIOD) && StringUtils.isBlank((CharSequence)ADJUST_PERIOD)) {
            isCreate = true;
        }
        if (EFFECTIVE_DATE == null) {
            EFFECTIVE_DATE = START_DATE;
            isCreate = true;
        }
        if (StringUtils.isNotBlank((CharSequence)ADJUST_PERIOD)) {
            LocalDate ADJUST_PERIOD_END;
            LocalDate ADJUST_PERIOD_START = contractService.getLocalDate(ADJUST_PERIOD.split("~")[0]);
            if (!ADJUST_PERIOD_START.isEqual(EFFECTIVE_DATE)) {
                isCreate = true;
            }
            if (StringUtils.isBlank((CharSequence)PERIOD) && !(ADJUST_PERIOD_END = contractService.getLocalDate(ADJUST_PERIOD.split("~")[1])).isEqual(END_DATE)) {
                isCreate = true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)PERIOD)) {
            LocalDate PERIOD_START;
            LocalDate PERIOD_END = contractService.getLocalDate(PERIOD.split("~")[1]);
            if (!PERIOD_END.isEqual(END_DATE)) {
                isCreate = true;
            }
            if (StringUtils.isBlank((CharSequence)ADJUST_PERIOD) && !(PERIOD_START = contractService.getLocalDate(PERIOD.split("~")[0])).isEqual(EFFECTIVE_DATE)) {
                isCreate = true;
            }
        }
        String effectiveDateStr = EFFECTIVE_DATE.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        effectiveDateStr = "%" + effectiveDateStr + "%";
        if (DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE CONTRACT_SERVICE_ID=? AND EFFECTIVE_DATE LIKE ?", (Object[])new Object[]{service.get("ID"), effectiveDateStr}) == 0 && DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? AND PERIOD_BEGIN_DATE LIKE ?", (Object[])new Object[]{service.get("ID"), effectiveDateStr}) == 0) {
            isCreate = true;
        }
        if (service.get("ADJUSTED_PRICE") == null || StringUtils.isBlank((CharSequence)service.getString("ADJUSTED_PRICE"))) {
            isCreate = true;
        } else {
            BigDecimal ADJUSTED_PRICE = new BigDecimal(service.getString("ADJUSTED_PRICE"));
            if ((ADJUSTED_PRICE = ADJUSTED_PRICE.setScale(8, RoundingMode.HALF_UP)).compareTo(contractService.multiply(service.get("QUANTITY"), service.get("UNIT_PRICE"))) != 0) {
                isCreate = true;
            }
        }
        if (!isCreate) {
            return true;
        }
        if (DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE APPROVE_AND_POST_USER_ID IS NOT NULL AND LENGTH(APPROVE_AND_POST_USER_ID)>1 AND APPROVE_AND_POST_DATE IS NOT NULL AND  BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")}) > 0) {
            return true;
        }
        if (DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE APPROVE_AND_POST_USER_ID IS NOT NULL AND LENGTH(APPROVE_AND_POST_USER_ID)>1 AND APPROVE_AND_POST_DATE IS NOT NULL AND  BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")}) > 0) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)ADJUST_PERIOD)) {
            List csaIdList = DBSql.getList((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")});
            for (String csaId : csaIdList) {
                DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE where BINDID=? and CONTRACT_SERVICE_ADJUST_ID=? ", (Object[])new Object[]{service.get("BINDID"), csaId});
            }
            DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")});
        }
        if (StringUtils.isNotBlank((CharSequence)PERIOD)) {
            List cspIdList = DBSql.getList((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where BINDID=? and CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("OBJECT_ID"), service.get("ID")});
            for (String cspId : cspIdList) {
                DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE where BINDID=? and CONTRACT_SERVICE_PERIOD_ID=? ", (Object[])new Object[]{service.get("BINDID"), cspId});
            }
            DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where BINDID=? and CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("OBJECT_ID"), service.get("ID")});
        }
        service.set("CONTRACT_ID", contract.get((Object)"ID"));
        service.set("EFFECTIVE_DATE", (Object)EFFECTIVE_DATE);
        if (service.getString("OBJECT_TYPE").equals("1")) {
            int NEED_PURCHASE = DBSql.getInt((Connection)conn, (String)"select NEED_PURCHASE from BO_EU_DNIVT_SERVICE where ID=? ", (Object[])new Object[]{service.getString("OBJECT_ID")});
            if (NEED_PURCHASE == 1) {
                service.set("STATUS_ID", (Object)"4461");
            } else {
                service.set("STATUS_ID", (Object)"4460");
            }
        }
        int maxPeriod = contract.getInt("PERIOD_TYPE") > (Integer)service.get("PERIOD_TYPE", Integer.class) ? contract.getInt("PERIOD_TYPE") : ((Integer)service.get("PERIOD_TYPE", Integer.class)).intValue();
        BigDecimal rate = this.GetPeriodRate(contract.getString("PERIOD_TYPE"), service.getString("PERIOD_TYPE"));
        BigDecimal unit_cost = (BigDecimal)service.get("UNIT_COST", BigDecimal.class);
        BigDecimal unit_price = (BigDecimal)service.get("UNIT_PRICE", BigDecimal.class);
        if (rate.compareTo(BigDecimal.ONE) > 0) {
            unit_cost = unit_cost.multiply(rate);
            service.set("UNIT_COST", (Object)unit_cost);
            unit_price = unit_price.multiply(rate);
            service.set("UNIT_PRICE", (Object)unit_price);
        }
        contractServiceLogger.info("\u8ba1\u7b97-service-ADJUSTED_PRICE");
        service.set("ADJUSTED_PRICE", (Object)contractService.multiply(service.get("QUANTITY"), service.get("UNIT_PRICE")));
        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE", service, conn);
        List<String> sbsList = null;
        String serviceIds = DBSql.getString((String)"select SERVICE_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{service.get("OBJECT_ID")});
        if (StringUtils.isNotBlank((CharSequence)serviceIds)) {
            sbsList = Arrays.asList(serviceIds.split(","));
        }
        String BILL_METHOD_ID = null;
        if (service.getString("OBJECT_TYPE").equals("2")) {
            BILL_METHOD_ID = DBSql.getString((Connection)conn, (String)"select BILL_METHOD_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
            if (sbsList != null) {
                for (String sbs : sbsList) {
                    if (DBSql.getInt((Connection)conn, (String)"select count(1) from BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE where SERVICE_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{sbs, service.get("ID")}) != 0) continue;
                    BO csbs = new BO();
                    csbs.set("SERVICE_ID", (Object)sbs);
                    csbs.set("CONTRACT_SERVICE_ID", service.get("ID"));
                    csbs.setBindId(service.getString("BINDID"));
                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE", csbs, uc, conn);
                }
            }
        } else {
            BILL_METHOD_ID = DBSql.getString((Connection)conn, (String)"select BILL_METHOD_ID from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
        }
        String vendor_account_id = DBSql.getString((Connection)conn, (String)"select VENDOR_ACCOUNT_ID from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
        if (StringUtils.isNotBlank((CharSequence)BILL_METHOD_ID) && BILL_METHOD_ID.equals("4601") && START_DATE.getDayOfMonth() != 1 && (currMontLastDay = START_DATE.with(TemporalAdjusters.lastDayOfMonth())).isBefore(END_DATE)) {
            START_DATE = currMontLastDay.plusDays(1L);
        }
        Map<String, Object> firstPeriodDate = this.getFirstPeriodDate(START_DATE, END_DATE, EFFECTIVE_DATE, contract.getString("PERIOD_TYPE"), service.getString("PERIOD_TYPE"));
        boolean isStartOfPeriod = (Boolean)firstPeriodDate.get("isStartOfPeriod");
        LocalDate start = contractService.getLocalDate(firstPeriodDate.get("periodStart"));
        LocalDate end = contractService.getLocalDate(firstPeriodDate.get("periodEnd"));
        ADJUST_PERIOD = null;
        contractServiceLogger.info("getFirstPeriodDate" + firstPeriodDate.toString());
        if (!isStartOfPeriod) {
            LocalDate periodEnd = contractService.getNextPeriodStart(start, String.valueOf(maxPeriod)).minusDays(1L);
            BigDecimal periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(EFFECTIVE_DATE, end), contractService.GetPeriodDays(start, periodEnd));
            BO csa = new BO();
            csa.set("CONTRACT_ID", contract.get((Object)"ID"));
            csa.set("OBJECT_ID", service.get("OBJECT_ID"));
            csa.set("OBJECT_TYPE", service.get("OBJECT_TYPE"));
            csa.set("QUANTITY_CHANGE", service.get("QUANTITY"));
            csa.set("CONTRACT_SERVICE_ID", service.get("ID"));
            csa.set("EFFECTIVE_DATE", (Object)EFFECTIVE_DATE);
            csa.set("END_DATE", (Object)end);
            ADJUST_PERIOD = contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE) + "~" + contractService.LocalDateYYYYMMDD(end);
            csa.set("PRORATED_COST_CHANGE", service.get("ADJUSTED_PRICE"));
            contractServiceLogger.info("\u8ba1\u7b97-csa-ADJUST_PRORATED_PRICE_CHANGE");
            csa.set("ADJUST_PRORATED_PRICE_CHANGE", (Object)contractService.multiply(service.get("ADJUSTED_PRICE"), periodRate));
            csa.set("PRORATED_PRICE_CHANGE", csa.get("ADJUST_PRORATED_PRICE_CHANGE"));
            csa.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
            csa.setBindId(service.getString("BINDID"));
            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", csa, uc, conn);
            if (service.getString("OBJECT_TYPE").equals("2")) {
                String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                if (sbsList != null) {
                    for (String sbs : sbsList) {
                        BO csabs = new BO();
                        csabs.set("CONTRACT_SERVICE_ADJUST_ID", (Object)csa.getId());
                        csabs.set("SERVICE_ID", (Object)sbs);
                        csabs.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                        csabs.set("PRORATED_COST_CHANGE", (Object)prorated_cost_change);
                        csabs.setBindId(service.getString("BINDID"));
                        SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE", csabs, uc, conn);
                    }
                }
            }
            start = end.plusDays(1L);
        }
        PERIOD = null;
        if (start.isBefore(END_DATE)) {
            PERIOD = contractService.LocalDateYYYYMMDD(start);
            while (!start.isAfter(END_DATE)) {
                BigDecimal periodRate = BigDecimal.ONE;
                LocalDate periodEnd = contractService.getNextPeriodStart(start, String.valueOf(maxPeriod)).minusDays(1L);
                if (periodEnd.isAfter(END_DATE)) {
                    periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(start, END_DATE), contractService.GetPeriodDays(start, periodEnd));
                    periodEnd = END_DATE;
                }
                BO csp = new BO();
                csp.set("CONTRACT_ID", contract.get((Object)"ID"));
                csp.set("OBJECT_ID", service.get("OBJECT_ID"));
                csp.set("OBJECT_TYPE", service.get("OBJECT_TYPE"));
                csp.set("CONTRACT_SERVICE_ID", service.get("ID"));
                csp.set("PERIOD_BEGIN_DATE", (Object)start);
                csp.set("PERIOD_END_DATE", (Object)periodEnd);
                csp.set("QUANTITY", service.get("QUANTITY"));
                contractServiceLogger.info("\u8ba1\u7b97-csp-PERIOD_PRICE");
                BigDecimal period_price = contractService.multiply(service.get("UNIT_PRICE"), service.get("QUANTITY"));
                period_price = periodRate.multiply(period_price);
                csp.set("PERIOD_PRICE", (Object)period_price);
                contractServiceLogger.info("\u8ba1\u7b97-csp-PERIOD_COST");
                BigDecimal period_cost = contractService.multiply(service.get("PERIOD_COST"), service.get("QUANTITY"));
                period_cost = periodRate.multiply(period_cost);
                csp.set("PERIOD_COST", (Object)period_cost);
                csp.set("PERIOD_ADJUSTED_PRICE", csp.get("PERIOD_PRICE"));
                csp.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                csp.setBindId(service.getString("BINDID"));
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", csp, uc, conn);
                if (service.getString("OBJECT_TYPE").equals("2")) {
                    String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                    if (sbsList != null) {
                        for (String sbs : sbsList) {
                            BO cspbs = new BO();
                            cspbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)csp.getId());
                            cspbs.set("SERVICE_ID", (Object)sbs);
                            cspbs.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                            cspbs.set("PERIOD_COST", (Object)prorated_cost_change);
                            cspbs.setBindId(service.getString("BINDID"));
                            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", cspbs, uc, conn);
                        }
                    }
                }
                if (periodEnd == null) continue;
                start = periodEnd.plusDays(1L);
            }
            PERIOD = PERIOD + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
        }
        DBSql.update((Connection)conn, (String)"update BO_EU_DNCTT_CONTRACT_SERVICE set PERIOD=?,ADJUST_PERIOD=? where ID=? and BINDID=?", (Object[])new Object[]{PERIOD, ADJUST_PERIOD, service.get("ID"), service.get("BINDID")});
        return true;
    }

    public boolean EditServiceServiceBundle(Connection conn, UserContext uc, RowMap contract, RowMap service) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddContractServiceProduct(UserContext uc, RowMap contract) throws SQLException {
        contractServiceLogger.info("\u65b0\u589e\u670d\u52a1\u6216\u670d\u52a1\u5305");
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            ArrayList<BO> serviceList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").connection(conn)).addQuery("BINDID=", contract.get((Object)"BINDID"))).list();
            List serviceList2 = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").connection(conn)).addQuery("BINDID!=", contract.get((Object)"BINDID"))).addQuery("CONTRACT_ID=", contract.get((Object)"ID"))).list();
            if (serviceList == null) {
                serviceList = new ArrayList<BO>();
            }
            if (serviceList2 != null && serviceList2.size() > 0) {
                for (BO service : serviceList2) {
                    serviceList.add(service);
                }
            }
            for (BO service : serviceList) {
                String PRODUCT_ID = null;
                if (service.getString("OBJECT_TYPE").equals("2")) {
                    String serviceIDS = DBSql.getString((Connection)conn, (String)"select SERVICE_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                    for (String serviceID : serviceIDS.split(",")) {
                        String contractCostId = DBSql.getString((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_COST where CONTRACT_ID=? and SERVICE_ID=? and PRODUCT_ID in(select PRODUCT_ID from BO_EU_DNIVT_SERVICE where ID=?)", (Object[])new Object[]{contract.getString("ID"), service.getString("ID"), serviceID});
                        String NEED_PURCHASE = service.getString("NEED_PURCHASE");
                        if (NEED_PURCHASE.equals("1")) {
                            HashMap<String, String> contractCost = new HashMap<String, String>();
                            contractCost.put("ID", contractCostId);
                            contractCost.put("SERVICE_ID", service.getString("ID"));
                            contractCost.put("SERVICE_NAME", service.getString("NAME"));
                            contractCost.put("serviceID", serviceID);
                            contractCost.put("CONTRACT_ID", contract.getString("ID"));
                            contractCost.put("QUANTITY", service.getString("QUANTITY"));
                            PRODUCT_ID = this.AddContractServiceProduct(uc, conn, contractCost);
                            continue;
                        }
                        if (DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNCTT_CONTRACT_COST_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0 || DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNIVT_ORDER_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0) continue;
                        String contractCostBINDId = DBSql.getString((Connection)conn, (String)"select BINDID from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
                        SDK.getProcessAPI().deleteById(contractCostBINDId, uc.getUID());
                        DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
                    }
                    continue;
                }
                String contractCostId = DBSql.getString((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_COST where CONTRACT_ID=? and SERVICE_ID=?", (Object[])new Object[]{contract.getString("ID"), service.getString("ID")});
                String NEED_PURCHASE = service.getString("NEED_PURCHASE");
                if (NEED_PURCHASE.equals("1")) {
                    HashMap<String, String> contractCost = new HashMap<String, String>();
                    contractCost.put("ID", contractCostId);
                    contractCost.put("SERVICE_ID", service.getString("ID"));
                    contractCost.put("SERVICE_NAME", service.getString("NAME"));
                    contractCost.put("serviceID", service.getString("OBJECT_ID"));
                    contractCost.put("CONTRACT_ID", contract.getString("ID"));
                    contractCost.put("QUANTITY", service.getString("QUANTITY"));
                    PRODUCT_ID = this.AddContractServiceProduct(uc, conn, contractCost);
                    continue;
                }
                if (DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNCTT_CONTRACT_COST_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0 || DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNIVT_ORDER_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0) continue;
                String contractCostBINDId = DBSql.getString((Connection)conn, (String)"select BINDID from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
                SDK.getProcessAPI().deleteById(contractCostBINDId, uc.getUID());
                DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
            }
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            conn.rollback();
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        return false;
    }

    private String AddContractServiceProduct(UserContext uc, Connection conn, Map<String, String> service) {
        BO product;
        contractServiceLogger.info("\u65b0\u589e\u5408\u540c\u4ea7\u54c1");
        System.out.println(service);
        BO contractCost = null;
        if (service.get("ID") != null && StringUtils.isNotBlank((CharSequence)service.get("ID").toString())) {
            contractCost = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", service.get("ID"));
        }
        if (contractCost == null) {
            ProcessInstance contractInstance = SDK.getProcessAPI().createBOProcessInstance("obj_87c6ef75d18f44cc8e85d3d4e818c303", uc.getUID(), "\u65b0\u589e\u5408\u540c\u4ea7\u54c1");
            contractCost = new BO();
            contractCost.setBindId(contractInstance.getId());
        }
        contractCost.set("CONTRACT_ID", (Object)service.get("CONTRACT_ID"));
        contractCost.set("SERVICE_ID", (Object)service.get("SERVICE_ID"));
        contractCost.set("QUANTITY", (Object)service.get("QUANTITY"));
        contractCost.set("NAME", (Object)service.get("SERVICE_NAME"));
        contractCost.set("PRODUCT_ID", (Object)DBSql.getString((Connection)conn, (String)"select PRODUCT_ID from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.get("serviceID")}));
        if (StringUtils.isNotBlank((CharSequence)contractCost.getString("PRODUCT_ID")) && (product = SDK.getBOAPI().get("BO_EU_DNIVT_PRODUCT", contractCost.getString("PRODUCT_ID"))) != null) {
            contractCost.set("DESCRIPTION", (Object)product.getString("DESCRIPTION"));
            contractCost.set("COST_CODE_ID", (Object)product.getString("COST_CODE_ID"));
            contractCost.set("UNIT_COST", (Object)product.getString("UNIT_COST"));
            contractCost.set("UNIT_PRICE", (Object)product.getString("UNIT_PRICE"));
            contractCost.set("PRODUCT_NAME", (Object)product.getString("NAME"));
            contractCost.set("TAX_CATEGORY_ID", (Object)DBSql.getString((String)"select TAX_CATEGORY_ID from BO_EU_DND_COST_CODE where OID=?", (Object[])new Object[]{product.getString("COST_CODE_ID")}));
            contractCost.set("COST_CODE_NAME", (Object)DBSql.getString((String)"select NAME from BO_EU_DND_COST_CODE where OID=?", (Object[])new Object[]{product.getString("COST_CODE_ID")}));
        }
        if (contractCost.isNew()) {
            SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_COST", contractCost, contractCost.getBindId(), uc.getUID());
        } else {
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", contractCost);
        }
        return contractCost.getId();
    }

    private static String LocalDateYYYYMMDD(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static BigDecimal multiply(Object obj1, Object obj2) {
        try {
            if (obj1 == null || obj2 == null) {
                return BigDecimal.ZERO;
            }
            BigDecimal num1 = new BigDecimal(String.valueOf(obj1));
            BigDecimal num2 = new BigDecimal(String.valueOf(obj2));
            BigDecimal result = num1.multiply(num2).setScale(8, RoundingMode.HALF_UP);
            contractServiceLogger.info("Result: " + result);
            return result;
        }
        catch (Exception e) {
            contractServiceLogger.error("multiply--info--\u5931\u8d25\u3002\u3002\u3002" + obj1 + "*" + obj2);
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal GetPeriodRate(String contractPeriod, String servicePeriod) {
        if (Objects.equals(contractPeriod, servicePeriod)) {
            return BigDecimal.valueOf(1L);
        }
        if (contractPeriod.equals("609") || servicePeriod.equals("609")) {
            return BigDecimal.valueOf(0L);
        }
        int ctt = this.GetPeriodMonth(contractPeriod);
        int svc = this.GetPeriodMonth(servicePeriod);
        if (ctt == 0 || svc == 0) {
            return BigDecimal.valueOf(0L);
        }
        BigDecimal cttDecimal = BigDecimal.valueOf(ctt);
        BigDecimal svcDecimal = BigDecimal.valueOf(svc);
        return cttDecimal.divide(svcDecimal, 8, RoundingMode.HALF_UP);
    }

    public Map<String, Object> getFirstPeriodDate(LocalDate contractStart, LocalDate contractEnd, LocalDate serviceEffect, String contractPeriod, String servicePeriod) {
        HashMap<String, Object> dto = new HashMap<String, Object>();
        int cttPeriod = this.GetPeriodMonth(contractPeriod);
        int svcPeriod = this.GetPeriodMonth(servicePeriod);
        LocalDate start = contractStart;
        if (serviceEffect.isBefore(start)) {
            dto.put("periodStart", serviceEffect);
            dto.put("periodEnd", start.minusDays(1L));
            dto.put("isStartOfPeriod", false);
            return dto;
        }
        while (!start.isAfter(contractEnd)) {
            LocalDate end = contractService.getNextPeriodStart(start, contractPeriod).minusDays(1L);
            if (!serviceEffect.isBefore(start) && !serviceEffect.isAfter(end)) {
                if (end.isAfter(contractEnd)) {
                    end = contractEnd;
                }
                LocalDate periodEnd = svcPeriod > cttPeriod ? contractService.getNextPeriodStart(start, servicePeriod).minusDays(1L) : end;
                dto.put("periodStart", start);
                dto.put("periodEnd", periodEnd);
                dto.put("isStartOfPeriod", start.isEqual(serviceEffect));
                return dto;
            }
            start = end.plusDays(1L);
        }
        dto.put("periodStart", LocalDate.MIN);
        dto.put("periodEnd", LocalDate.MIN);
        dto.put("isStartOfPeriod", false);
        return dto;
    }

    private int GetPeriodMonth(String period) {
        switch (period) {
            case "610": {
                return 1;
            }
            case "611": {
                return 3;
            }
            case "612": {
                return 6;
            }
            case "613": {
                return 12;
            }
        }
        return 0;
    }

    public static LocalDate getNextPeriodStart(LocalDate start, String periodType) {
        switch (periodType) {
            case "610": {
                return start.plus(1L, ChronoUnit.MONTHS);
            }
            case "611": {
                return start.plus(3L, ChronoUnit.MONTHS);
            }
            case "612": {
                return start.plus(6L, ChronoUnit.MONTHS);
            }
            case "613": {
                return start.plus(1L, ChronoUnit.YEARS);
            }
        }
        return start;
    }

    public static LocalDate getLocalDate(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof LocalDate) {
                return (LocalDate)obj;
            }
            if (obj instanceof String) {
                if (StringUtils.isBlank((CharSequence)obj.toString())) {
                    return null;
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                contractServiceLogger.info("getLocalDate" + obj.toString());
                return LocalDate.parse(obj.toString(), formatter);
            }
            if (obj instanceof Date) {
                return ((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            contractServiceLogger.info("Invalid object type: " + obj.getClass().getName());
            return null;
        }
        catch (Exception e) {
            contractServiceLogger.info("getLocalDate" + e.getMessage());
            return null;
        }
    }

    public static int GetPeriodDays(LocalDate start, LocalDate end) {
        return (int)ChronoUnit.DAYS.between(start, end) + 1;
    }

    public static BigDecimal divideToBigDecimal(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("\u5206\u6bcd\u4e0d\u80fd\u4e3a\u96f6");
        }
        BigDecimal num = new BigDecimal(numerator);
        BigDecimal den = new BigDecimal(denominator);
        return num.divide(den, 10, RoundingMode.HALF_UP);
    }

    public boolean ContractExcManage(UserContext uc, String bindid) {
        BO bo;
        RowMap rowMap = DBSql.getMap((String)"SELECT ID,BINDID,EXCLUSION_CONTRACT_ID,EXCLUSION_COST_CODE,EXCLUSION_ROLE FROM BO_EU_DNCTT_CONTRACT WHERE BINDID= ?", (Object[])new Object[]{bindid});
        String exclusionContractId = rowMap.getString("EXCLUSION_CONTRACT_ID");
        String exclusionCostCode = rowMap.getString("EXCLUSION_COST_CODE");
        String exclusionRole = rowMap.getString("EXCLUSION_ROLE");
        if (StringUtils.isBlank((CharSequence)exclusionCostCode)) {
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_COST_CODE WHERE BINDID = ? OR CONTRACT_ID=?", (Object[])new Object[]{rowMap.getString("ID"), rowMap.getString("BINDID")});
        } else {
            String[] exclusionCostCodeArr;
            for (String costCode : exclusionCostCodeArr = exclusionCostCode.split(",")) {
                bo = new BO();
                bo.set("BINDID", (Object)rowMap.getString("BINDID"));
                bo.set("CONTRACT_ID", (Object)rowMap.getString("ID"));
                bo.set("COST_CODE_ID", (Object)costCode);
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_EXCLUSION_COST_CODE", bo, uc);
            }
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_COST_CODE WHERE (BINDID = ? OR CONTRACT_ID=?) AND COST_CODE_ID NOT IN (?)", (Object[])new Object[]{rowMap.getString("BINDID"), rowMap.getString("ID"), exclusionCostCode});
        }
        if (StringUtils.isBlank((CharSequence)exclusionRole)) {
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_ROLE WHERE BINDID = ? OR CONTRACT_ID=?", (Object[])new Object[]{rowMap.getString("BINDID"), rowMap.getString("ID")});
        } else {
            String[] exclusionRoleArr;
            for (String role : exclusionRoleArr = exclusionRole.split(",")) {
                bo = new BO();
                bo.set("BINDID", (Object)rowMap.getString("BINDID"));
                bo.set("CONTRACT_ID", (Object)rowMap.getString("ID"));
                bo.set("ROLE_ID", (Object)role);
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_EXCLUSION_ROLE", bo, uc);
            }
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_ROLE WHERE (BINDID = ? OR CONTRACT_ID=?) AND ROLE_ID NOT IN (?)", (Object[])new Object[]{rowMap.getString("BINDID"), rowMap.getString("ID"), exclusionRole});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postRecurringServices(UserContext uc, String approveDate, String approveIds) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String approveId : approveIds.split(",")) {
                BO cad = new BO();
                String TAX_CATEGORY_ID = null;
                String CONTRACT_SERVICE_ID = null;
                String CONTRACT_ID = null;
                BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", approveId);
                if (bo != null) {
                    CONTRACT_ID = bo.getId();
                    bo.set("APPROVE_AND_POST_DATE", (Object)approveDate);
                    bo.set("SETUP_FEE_APPROVE_POST_USER_ID", (Object)uc.getUID());
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", bo, connUpdate);
                    cad.set("TYPE_ID", (Object)1327);
                    cad.set("OBJECT_ID", (Object)approveId);
                    cad.set("CONTRACT_ID", (Object)approveId);
                    cad.set("QUANTITY", (Object)1);
                    cad.set("BILL_CREATE_USER_ID", (Object)bo.getCreateUser());
                    cad.set("ACCOUNT_ID", (Object)bo.getString("ACCOUNT_ID"));
                    cad.set("BILL_ACCOUNT_ID", (Object)bo.getString("BILL_TO_ACCOUNT_ID"));
                    cad.set("EXTENDED_PRICE", bo.get("ADJUST_SETUP_FEE"));
                    if (StringUtils.isNotBlank((CharSequence)bo.getString("SETUP_FEE_COST_CODE_ID"))) {
                        TAX_CATEGORY_ID = SDK.getBOAPI().get("BO_EU_DND_COST_CODE", bo.getString("SETUP_FEE_COST_CODE_ID"), "TAX_CATEGORY_ID").toString();
                    }
                } else {
                    String costCodeId;
                    bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", approveId);
                    if (bo != null) {
                        CONTRACT_SERVICE_ID = bo.getString("CONTRACT_SERVICE_ID");
                        CONTRACT_ID = bo.getString("CONTRACT_ID");
                        bo.set("APPROVE_AND_POST_DATE", (Object)approveDate);
                        bo.set("SETUP_FEE_APPROVE_POST_USER_ID", (Object)uc.getUID());
                        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", bo, connUpdate);
                        cad.set("TYPE_ID", (Object)1326);
                        cad.set("OBJECT_ID", (Object)approveId);
                        cad.set("CONTRACT_ID", (Object)bo.getString("CONTRACT_ID"));
                        cad.set("QUANTITY", bo.get("QUANTITY_CHANGE"));
                        cad.set("BILL_CREATE_USER_ID", (Object)bo.getCreateUser());
                        cad.set("ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                        cad.set("BILL_ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT BILL_TO_ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                        cad.set("EXTENDED_PRICE", bo.get("ADJUST_PRORATED_PRICE_CHANGE"));
                        costCodeId = null;
                        costCodeId = bo.getString("OBJECT_TYPE").equals("1") ? DBSql.getString((String)"SELECT COST_CODE_ID FROM BO_EU_DNIVT_SERVICE WHERE ID = ?", (Object[])new Object[]{bo.getString("OBJECT_ID")}) : DBSql.getString((String)"SELECT COST_CODE_ID FROM BO_EU_DNIVT_SERVICE_BUNDLE WHERE ID = ?", (Object[])new Object[]{bo.getString("OBJECT_ID")});
                        TAX_CATEGORY_ID = SDK.getBOAPI().get("BO_EU_DND_COST_CODE", costCodeId, "TAX_CATEGORY_ID").toString();
                    } else {
                        bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", approveId);
                        if (bo != null) {
                            CONTRACT_SERVICE_ID = bo.getString("CONTRACT_SERVICE_ID");
                            CONTRACT_ID = bo.getString("CONTRACT_ID");
                            bo.set("APPROVE_AND_POST_DATE", (Object)approveDate);
                            bo.set("SETUP_FEE_APPROVE_POST_USER_ID", (Object)uc.getUID());
                            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", bo, connUpdate);
                            cad.set("TYPE_ID", (Object)1325);
                            cad.set("OBJECT_ID", (Object)approveId);
                            cad.set("CONTRACT_ID", (Object)bo.getString("CONTRACT_ID"));
                            cad.set("QUANTITY", bo.get("QUANTITY"));
                            cad.set("BILL_CREATE_USER_ID", (Object)bo.getCreateUser());
                            cad.set("ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                            cad.set("BILL_ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT BILL_TO_ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                            cad.set("EXTENDED_PRICE", bo.get("PERIOD_ADJUSTED_PRICE"));
                            costCodeId = null;
                            costCodeId = bo.getString("OBJECT_TYPE").equals("1") ? DBSql.getString((String)"SELECT COST_CODE_ID FROM BO_EU_DNIVT_SERVICE WHERE ID = ?", (Object[])new Object[]{bo.getString("OBJECT_ID")}) : DBSql.getString((String)"SELECT COST_CODE_ID FROM BO_EU_DNIVT_SERVICE_BUNDLE WHERE ID = ?", (Object[])new Object[]{bo.getString("OBJECT_ID")});
                            TAX_CATEGORY_ID = SDK.getBOAPI().get("BO_EU_DND_COST_CODE", costCodeId, "TAX_CATEGORY_ID").toString();
                        }
                    }
                }
                if (SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE", CONTRACT_SERVICE_ID, "IS_CTRTAX_APPLIED").equals("1")) {
                    TAX_CATEGORY_ID = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", CONTRACT_ID, "TAX_CATEGORY_ID").toString();
                }
                RowMap ca = DBSql.getMap((String)"select TAX_REGION_ID,IS_TAX_EXEMPT from BO_EU_DNCRM_ACCOUNT where ID=?", (Object[])new Object[]{cad.get("ACCOUNT_ID")});
                String tax_category_name = null;
                String tax_region_name = null;
                double tax_rate = 0.0;
                if (StringUtils.isNotBlank((CharSequence)TAX_CATEGORY_ID)) {
                    tax_category_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{TAX_CATEGORY_ID, uc.getCompanyModel().getId()});
                }
                if (ca.containsKey((Object)"TAX_REGION_ID") && StringUtils.isNotBlank((CharSequence)ca.getString("TAX_REGION_ID"))) {
                    tax_region_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{ca.getString("TAX_REGION_ID"), uc.getCompanyModel().getId()});
                }
                if (tax_category_name != null && tax_region_name != null) {
                    tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID='" + ca.getString("TAX_REGION_ID") + "' AND TAX_CATE_ID='" + TAX_CATEGORY_ID + "' "), (String)"TOTAL_EFFECTIVE_TAX_RATE");
                }
                cad.set("POSTED_DATE", (Object)approveDate);
                cad.set("TAX_CATEGORY_NAME", (Object)tax_category_name);
                cad.set("TAX_CATEGORY_ID", (Object)TAX_CATEGORY_ID);
                cad.set("TAX_REGION_ID", (Object)ca.getString("TAX_REGION_ID"));
                cad.set("TAX_REGION_NAME", (Object)tax_region_name);
                cad.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                if (ca.getString("IS_TAX_EXEMPT").equals("1")) {
                    double tax_dollars = (Double)cad.get("EXTENDED_PRICE", Double.class) - (Double)cad.get("EXTENDED_PRICE", Double.class) / (1.0 + tax_rate);
                    cad.set("TAX_DOLLARS", (Object)tax_dollars);
                }
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", cad, uc, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postMilestone(UserContext uc, String approveDate, String approveIds) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String approveId : approveIds.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_MILESTONE", approveId);
                if (bo == null) continue;
                bo.set("STATUS_ID", (Object)1267);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_MILESTONE", bo, connUpdate);
                BO cad = new BO();
                cad.set("TYPE_ID", (Object)1323);
                String TAX_CATEGORY_ID = null;
                TAX_CATEGORY_ID = bo.getString("IS_CTRTAX_APPLIED").equals("1") ? SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", bo.getString("CONTRACT_ID"), "TAX_CATEGORY_ID").toString() : DBSql.getString((String)"SELECT TAX_CATEGORY_ID FROM BO_EU_DND_COST_CODE WHERE ID=?", (Object[])new Object[]{bo.getString("COST_CODE_ID")});
                cad.set("OBJECT_ID", (Object)approveId);
                cad.set("TAX_CATEGORY_ID", (Object)TAX_CATEGORY_ID);
                cad.set("TAX_CATEGORY_NAME", (Object)DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{TAX_CATEGORY_ID, uc.getCompanyModel().getId()}));
                cad.set("TAX_REGION_ID", (Object)DBSql.getString((String)"SELECT TAX_REGION_ID FROM BO_EU_DNCRM_ACCOUNT WHERE ID=(SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID=?)", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                cad.set("TAX_REGION_NAME", (Object)DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{cad.get("TAX_REGION_ID"), uc.getCompanyModel().getId()}));
                cad.set("ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID=?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                cad.set("BILL_ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT BILL_TO_ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                cad.set("POSTED_DATE", (Object)approveDate);
                cad.set("CONTRACT_ID", bo.get("CONTRACT_ID"));
                double tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID='" + cad.getString("TAX_REGION_ID") + "' AND TAX_CATE_ID='" + TAX_CATEGORY_ID + "' "), (String)"TOTAL_EFFECTIVE_TAX_RATE");
                cad.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                cad.set("EXTENDED_PRICE", bo.get("DOLLARS"));
                if (DBSql.getInt((String)"select COUNT(1) cnt from BO_EU_DNCRM_ACCOUNT WHERE ID=? AND IS_TAX_EXEMPT=1 ", (Object[])new Object[]{cad.getString("ACCOUNT_ID")}) > 0) {
                    double tax_dollars = (Double)cad.get("EXTENDED_PRICE", Double.class) - (Double)cad.get("EXTENDED_PRICE", Double.class) / (1.0 + tax_rate);
                    cad.set("TAX_DOLLARS", (Object)tax_dollars);
                }
                recordFormChanges.record((UserContext)uc, (BO)cad, (String)"\u5ba1\u6279\u63d0\u4ea4\u91cc\u7a0b\u7891");
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", cad, uc, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCost(UserContext uc, String approveDate, String approveIds) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String approveId : approveIds.split(",")) {
                BO ccc = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", approveId);
                BO cc = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", ccc.getString("CONTRACT_ID"));
                BO ca = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT", ccc.getString("ACCOUNT_ID"));
                String tax_category_name = null;
                String tax_region_name = null;
                double tax_rate = 0.0;
                String TAX_CATEGORY_ID = null;
                TAX_CATEGORY_ID = ccc.getString("IS_CTRTAX_APPLIED").equals("1") ? SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", ccc.getString("CONTRACT_ID"), "TAX_CATEGORY_ID").toString() : ccc.getString("TAX_CATEGORY_ID");
                if (StringUtils.isNotBlank((CharSequence)TAX_CATEGORY_ID)) {
                    tax_category_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{TAX_CATEGORY_ID, uc.getCompanyModel().getId()});
                }
                if (ca.get("TAX_REGION_ID") != null) {
                    tax_region_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{ca.get("TAX_REGION_ID"), uc.getCompanyModel().getId()});
                }
                if (StringUtils.isNotBlank((CharSequence)TAX_CATEGORY_ID) && ca.get("TAX_REGION_ID") != null) {
                    tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID='" + ca.getString("TAX_REGION_ID") + "' AND TAX_CATE_ID='" + TAX_CATEGORY_ID + "' "), (String)"TOTAL_EFFECTIVE_TAX_RATE");
                }
                BO cad = new BO();
                cad.set("OBJECT_ID", (Object)ccc.getString("ID"));
                cad.set("TYPE_ID", (Object)1321);
                cad.set("POSTED_DATE", (Object)contractService.getLocalDate(approveDate));
                cad.set("BILL_ACCOUNT_ID", (Object)cc.getString("BILL_ACCOUNT_ID"));
                cad.set("TASK_ID", (Object)ccc.getString("TASK_ID"));
                cad.set("CONTRACT_ID", (Object)ccc.getString("CONTRACT_ID"));
                cad.set("BILL_CREATE_USER_ID", (Object)ccc.getCreateUser());
                cad.set("ACCOUNT_ID", (Object)ca.getString("ID"));
                cad.set("QUANTITY", ccc.get("QUANTITY"));
                cad.set("TAX_CATEGORY_NAME", (Object)tax_category_name);
                cad.set("TAX_REGION_NAME", (Object)tax_region_name);
                cad.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                cad.set("PURCHASE_ORDER_NO", (Object)ccc.getString("PURCHASE_ORDER_NO"));
                cad.set("EXTENDED_COST", (Object)contractService.multiply(ccc.get("UNIT_COST"), ccc.get("QUANTITY")));
                cad.set("EXTENDED_PRICE", ccc.get("EXTENDED_PRICE"));
                if (!ca.getString("IS_TAX_EXEMPT").equals("1")) {
                    double tax_dollars = (Double)cad.get("EXTENDED_PRICE", Double.class) - (Double)cad.get("EXTENDED_PRICE", Double.class) / (1.0 + tax_rate);
                    cad.set("TAX_DOLLARS", (Object)tax_dollars);
                }
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", cad, uc, connUpdate);
                ccc.set("BILL_STATUS", (Object)"1");
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", ccc, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String revokeRecurringServices(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                if (StringUtils.isNotBlank((CharSequence)bo.getString("INVOICE_ID")) && DBSql.getString((String)"select IS_VOIDED from BO_EU_DNCTT_INVOICE where ID=?", (Object[])new Object[]{bo.getString("INVOICE_ID")}).equals("1")) {
                    throw new RuntimeException("\u8be5\u670d\u52a1\u5df2\u7ecf\u751f\u6210\u53d1\u7968\uff0c\u8bf7\u5148\u5220\u9664\u53d1\u7968");
                }
                if (bo.get("TYPE_ID").equals(1325)) {
                    BO ccsp = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").addQuery("CONTRACT_ID=", (Object)bo.getString("CONTRACT_ID"))).addQuery("ID=", (Object)bo.getString("OBJECT_ID"))).detail();
                    ccsp.set("APPROVE_AND_POST_DATE", null);
                    ccsp.set("APPROVE_AND_POST_USER_ID", null);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", ccsp, connUpdate);
                } else if (bo.get("TYPE_ID").equals(1326)) {
                    BO ccsa = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST").addQuery("CONTRACT_ID=", (Object)bo.getString("CONTRACT_ID"))).addQuery("ID=", (Object)bo.getString("OBJECT_ID"))).detail();
                    ccsa.set("APPROVE_AND_POST_DATE", null);
                    ccsa.set("APPROVE_AND_POST_USER_ID", null);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", ccsa, connUpdate);
                } else if (bo.get("TYPE_ID").equals(1327)) {
                    BO ccc = (BO)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT").addQuery("ID=", (Object)bo.getString("CONTRACT_ID"))).detail();
                    ccc.set("SETUP_FEE_APPROVE_AND_POST_USER_ID", null);
                    ccc.set("SETUP_FEE_APPROVE_AND_POST_DATE", null);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", ccc, connUpdate);
                }
                bo.set("CLOSED", (Object)1);
                SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String revokeMilestones(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                if (bo.get("TYPE_ID").equals(1323)) {
                    BO ccm = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_MILESTONES").addQuery("CONTRACT_ID=", (Object)bo.getString("CONTRACT_ID"))).addQuery("ID=", (Object)bo.getString("OBJECT_ID"))).detail();
                    ccm.set("STATUS_ID", (Object)1266);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_MILESTONES", ccm, connUpdate);
                }
                bo.set("CLOSED", (Object)1);
                SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String revokeCost(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                bo.set("CLOSED", (Object)1);
                SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo, connUpdate);
                BO ccc = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", bo.getString("OBJECT_ID"));
                ccc.set("BILL_STATUS", (Object)0);
                ccc.set("EXTENDED_PRICE", (Object)contractService.multiply(ccc.get("UNIT_PRICE"), ccc.get("QUANTITY")));
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", ccc, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return null;
    }

    public static Double GetRateByCodeAndRole(String cost_code_id, String role_id) {
        Double rate = null;
        RowMap thisCostCode = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_COST_CODE WHERE ID=?", (Object[])new Object[]{cost_code_id});
        RowMap thisRole = DBSql.getMap((String)"SELECT * FROM BO_EU_DNSYS_ROLE WHERE ID=?", (Object[])new Object[]{role_id});
        if (thisCostCode != null && thisRole != null) {
            switch (thisCostCode.getString("BILLING_METHOD_ID")) {
                case "2166": {
                    rate = thisRole.getDouble("hourly_rate");
                    break;
                }
                case "2167": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("RATE_ADJUSTMENT"))) break;
                    rate = thisRole.getDouble("hourly_rate") + thisCostCode.getDouble("RATE_ADJUSTMENT");
                    break;
                }
                case "2168": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("RATE_MULTIPLIER"))) break;
                    rate = thisRole.getDouble("hourly_rate") * thisCostCode.getDouble("RATE_MULTIPLIER");
                    break;
                }
                case "2169": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("CUSTOM_RATE"))) break;
                    rate = thisCostCode.getDouble("CUSTOM_RATE");
                    break;
                }
                case "2170": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("FLAT_RATE"))) break;
                    rate = thisCostCode.getDouble("FLAT_RATE");
                    break;
                }
            }
        }
        return rate;
    }

    public static Double GetEntryCost(String id) {
        return DBSql.getDouble((String)("SELECT( IFNULL(( SELECT rate FROM BO_EU_DNCTT_CONTRACT_INTERNAL_COST WHERE contract_id = p.contract_id AND resource_id = p.resource_id AND role_id = p.role_id LIMIT 1), ( SELECT hourly_rate FROM bo_eu_dnsys_resource_internal_cost WHERE resource_id = p.resource_id AND IFNULL(start_date, '1970-01-01') <= FROM_UNIXTIME(p.start_time / 1000) AND IFNULL(end_date, '9999-01-01') > FROM_UNIXTIME(p.start_time / 1000)) ) * p.hours_billed ) AS COST FROM bo_eu_dnsdk_work_entry p JOIN bo_eu_dnd_cost_code cc ON p.cost_code_id = cc.id JOIN bo_eu_dnsdk_task t ON p.task_id = t.id LEFT JOIN bo_eu_dnctt_contract c ON p.contract_id = c.id WHERE p.id = '" + id + "'"), (String)"COST");
    }

    static {
        SDK.getLogAPI();
        contractServiceLogger = LogAPI.getLogger(contractService.class);
    }
}

