/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.service;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import dn.recordFormChanges;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class contractService {
    private static final Logger contractServiceLogger;
    private final String[] excludesArray = new String[]{"ID", "ORGID", "BINDID", "CREATEDATE", "CREATEUSER", "UPDATEDATE", "UPDATEUSER", "PROCESSDEFID", "ISEND"};
    private static volatile contractService instance;
    private static final BigDecimal EPSILON;

    private contractService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static contractService getInstance() {
        if (instance != null) return instance;
        Class<contractService> clazz = contractService.class;
        synchronized (contractService.class) {
            if (instance != null) return instance;
            instance = new contractService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, Object> SaveContract(UserContext uc, String bindid, boolean isSubmit) {
        contractServiceLogger.info("\u5408\u540c\u63d0\u4ea4\u540e");
        HashMap<String, Object> resultDto = new HashMap<String, Object>();
        try {
            boolean idApply = true;
            BO contractBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT_APPLY", bindid);
            if (contractBO == null) {
                idApply = false;
                contractBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT", bindid);
            }
            if (contractBO.getString("IS_SUBMIT").equals("1")) {
                isSubmit = true;
            }
            String TYPE_ID = contractBO.getString("TYPE_ID");
            if (isSubmit) {
                contractBO.set("IS_SUBMIT", (Object)1);
            } else {
                contractBO.set("IS_SUBMIT", (Object)0);
            }
            if (TYPE_ID.equals("1199")) {
                DBSql.update((String)"UPDATE BO_EU_DNCTT_CONTRACT_SERVICE SET OLD_QUANTITY = QUANTITY, OLD_UNIT_PRICE = UNIT_PRICE, OLD_TOTAL_PRICE = TOTAL_PRICE, OLD_UNIT_COST=UNIT_COST, OLD_TOTAL_COST =TOTAL_COST WHERE BINDID=?", (Object[])new Object[]{bindid});
                String PERIOD_TYPE = contractBO.getString("PERIOD_TYPE");
                Integer OCCURRENCES = (Integer)contractBO.get("OCCURRENCES", Integer.class);
                Date START_DATE = (Date)contractBO.get("START_DATE", Date.class);
                Date END_DATE = (Date)contractBO.get("END_DATE", Date.class);
                if ((END_DATE == null || END_DATE.before(START_DATE)) && OCCURRENCES != null && OCCURRENCES > 0) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(START_DATE);
                    if (PERIOD_TYPE.equals("612")) {
                        calendar.add(2, OCCURRENCES * 6);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else if (PERIOD_TYPE.equals("610")) {
                        calendar.add(2, OCCURRENCES);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else if (PERIOD_TYPE.equals("611")) {
                        calendar.add(2, OCCURRENCES * 3);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else if (PERIOD_TYPE.equals("613")) {
                        calendar.add(2, OCCURRENCES * 12);
                        calendar.add(5, -1);
                        END_DATE = calendar.getTime();
                    } else {
                        resultDto.put("success", false);
                        resultDto.put("msg", "\u5468\u671f\u7c7b\u578b\u8f93\u5165\u9519\u8bef\uff01");
                        return resultDto;
                    }
                    contractBO.set("END_DATE", (Object)END_DATE);
                }
            }
            contractBO.set("ADJUST_SETUP_FEE", contractBO.get("SETUP_FEE"));
            if (StringUtils.isBlank((CharSequence)contractBO.getString("BILL_TO_ACCOUNT_ID"))) {
                contractBO.set("BILL_TO_ACCOUNT_ID", (Object)contractBO.getString("ACCOUNT_ID"));
                contractBO.set("BILL_TO_ACCOUNT_NAME", (Object)contractBO.getString("ACCOUNT_NAME"));
            }
            if (contractBO.getString("IS_SDT_DEFAULT").equals("1")) {
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT set IS_SDT_DEFAULT=0 where ACCOUNT_ID=?", (Object[])new Object[]{contractBO.getString("ACCOUNT_ID")});
            }
            if (idApply) {
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_APPLY", contractBO);
            } else {
                recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5408\u540c\u7f16\u8f91");
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", contractBO);
                this.ContractExcManage(uc, bindid);
            }
            contractServiceLogger.info("\u5408\u540c\u63d0\u4ea4\u540e\uff0c\u8fdb\u884c\u6570\u636e\u5904\u7406");
            RowMap dto = new RowMap(contractBO.asMap());
            if (idApply) {
                this.insertContract(uc, dto);
            } else {
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_RATE set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_MILESTONE set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_SERVICE set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_COST_DEFAULT set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
                DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_BLOCK set CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{dto.getString("ID"), dto.getString("BINDID")});
            }
            DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_COST set ACCOUNT_ID=?,BILL_ACCOUNT_ID=? where CONTRACT_ID=?", (Object[])new Object[]{dto.getString("ACCOUNT_ID"), dto.getString("BILL_ACCOUNT_ID"), dto.getString("ID")});
            if (TYPE_ID.equals("1199")) {
                try {
                    contractServiceLogger.info("\u670d\u52a1---\u670d\u52a1");
                    boolean flag = this.AddServiceServiceBundle(uc, dto);
                    contractServiceLogger.info("\u670d\u52a1\u4ea7\u54c1---\u670d\u52a1\u4ea7\u54c1");
                    this.AddContractServiceProduct(uc, dto);
                    if (!flag) {
                        resultDto.put("success", false);
                        resultDto.put("msg", "\u65b0\u589e\u670d\u52a1\u6216\u670d\u52a1\u5305\u5931\u8d25\uff01");
                        return resultDto;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    contractServiceLogger.info("info--\u5931\u8d25\u3002\u3002\u3002");
                    resultDto.put("success", false);
                    resultDto.put("msg", e.getMessage());
                    return resultDto;
                }
            }
            resultDto.put("success", true);
            return resultDto;
        }
        catch (Exception e) {
            e.printStackTrace();
            contractServiceLogger.info("info--\u5931\u8d25\u3002\u3002\u3002");
            resultDto.put("success", false);
            return resultDto;
        }
    }

    public void insertContract(UserContext uc, RowMap contract) throws SQLException {
        String contractBINDID = null;
        String APPLY_ID = contract.getString("ID");
        String APPLY_BINDID = contract.getString("BINDID");
        String exitsBOID = DBSql.getString((String)"select ID from BO_EU_DNCTT_CONTRACT where APPLY_ID=?", (Object[])new Object[]{APPLY_ID});
        String processDefId = "obj_4bac3fd23814406c8d224ef2094ac274";
        if (StringUtils.isNotBlank((CharSequence)exitsBOID)) {
            BO contractBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", exitsBOID);
            for (String key : this.excludesArray) {
                contract.remove((Object)key);
            }
            contractBO.setAll((Map)contract);
            contractBO.set("APPLY_ID", (Object)APPLY_ID);
            recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5408\u540c\u7f16\u8f91");
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", contractBO);
            contract.put("BINDID", (Object)contractBO.getBindId());
            contract.put("ID", (Object)contractBO.getId());
            contract.put("CONTRACT_ID", (Object)contractBO.getId());
            contractBINDID = contractBO.getBindId();
        } else {
            ProcessInstance contractInstance = SDK.getProcessAPI().createBOProcessInstance(processDefId, uc.getUID(), contract.getString("NAME"));
            BO contractBO = new BO();
            for (String key : this.excludesArray) {
                contract.remove((Object)key);
            }
            contractBO.setAll((Map)contract);
            contractBO.set("APPLY_ID", (Object)APPLY_ID);
            contractBO.setBindId(contractInstance.getId());
            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT", contractBO, uc);
            recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5408\u540c\u65b0\u589e");
            exitsBOID = contractBO.getId();
            contract.put("BINDID", (Object)contractInstance.getId());
            contract.put("ID", (Object)contractBO.getId());
            contract.put("CONTRACT_ID", (Object)contractBO.getId());
            contractBINDID = contractBO.getBindId();
        }
        contract.put("PROCESSDEFID", (Object)processDefId);
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_RATE set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_MILESTONE set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_SERVICE set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
        DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_BLOCK set PROCESSDEFID=?,BINDID=?,CONTRACT_ID=? where BINDID=?", (Object[])new Object[]{processDefId, contractBINDID, exitsBOID, APPLY_BINDID});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddServiceServiceBundle(UserContext uc, RowMap contract) throws SQLException {
        contractServiceLogger.info("\u65b0\u589e\u670d\u52a1\u6216\u670d\u52a1\u5305");
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            LocalDate START_DATE = contractService.getLocalDate(contract.get((Object)"START_DATE"));
            LocalDate END_DATE = contractService.getLocalDate(contract.get((Object)"END_DATE"));
            List serviceList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").connection(conn)).addQuery("CONTRACT_ID =", contract.get((Object)"ID"))).list();
            for (BO service : serviceList) {
                LocalDate period_end_date;
                LocalDate period_begin_date;
                BO servicePeriod;
                List servicePeriodList;
                LocalDate ADJUST_PERIOD_END;
                LocalDate PERIOD_END;
                this.AddServiceServiceBundleOne(uc, conn, contract, service);
                if (service.getString("PERIOD_TYPE").equals("609")) continue;
                contractServiceLogger.info("\u5224\u65ad\u5408\u540c\u7ed3\u675f\u65e5\u671f\u662f\u5426\u4fee\u6539");
                String PERIOD2 = service.getString("PERIOD");
                String ADJUST_PERIOD = service.getString("ADJUST_PERIOD");
                if (StringUtils.isNotBlank((CharSequence)PERIOD2)) {
                    PERIOD_END = contractService.getLocalDate(PERIOD2.split("~")[1]);
                    PERIOD2 = PERIOD2.split("~")[0] + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
                } else {
                    PERIOD_END = contractService.getLocalDate(ADJUST_PERIOD.split("~")[1]);
                    ADJUST_PERIOD = ADJUST_PERIOD.split("~")[0] + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
                }
                if (PERIOD_END.isAfter(END_DATE) && StringUtils.isNotBlank((CharSequence)ADJUST_PERIOD) && (ADJUST_PERIOD_END = contractService.getLocalDate(ADJUST_PERIOD.split("~")[1])).isAfter(END_DATE)) {
                    PERIOD2 = null;
                    ADJUST_PERIOD = ADJUST_PERIOD.split("~")[0] + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
                }
                contractServiceLogger.info("\u670d\u52a1\u5468\u671f\u7ed3\u675f\u65e5\u671f--" + contractService.LocalDateYYYYMMDD(PERIOD_END));
                contractServiceLogger.info("\u5408\u540c\u7ed3\u675f\u65e5\u671f--" + contractService.LocalDateYYYYMMDD(END_DATE));
                if (!PERIOD_END.isEqual(END_DATE)) continue;
                if (PERIOD_END.isBefore(END_DATE)) {
                    contractServiceLogger.info("\u670d\u52a1\u5468\u671f\u5ef6\u957f--" + service.getString("NAME"));
                    servicePeriodList = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").connection(conn)).addQuery("CONTRACT_SERVICE_ID =", (Object)service.getString("CONTRACT_SERVICE_ID"))).addQuery("PERIOD_END_DATE >=", (Object)PERIOD_END)).orderBy("PERIOD_BEGIN_DATE")).desc()).list();
                    servicePeriod = (BO)servicePeriodList.get(0);
                    period_begin_date = contractService.getLocalDate(servicePeriod.get("PERIOD_BEGIN_DATE"));
                    period_end_date = contractService.getLocalDate(servicePeriod.get("PERIOD_END_DATE"));
                    String maxPeriod = servicePeriod.getString("PERIOD_TYPE");
                    LocalDate firstPeriodEnd = contractService.getNextPeriodStart(period_begin_date, maxPeriod).minusDays(1L);
                    LocalDate SATRT_DATE = null;
                    if (period_end_date.isBefore(firstPeriodEnd)) {
                        LocalDate new_period_end_date;
                        if (END_DATE.isBefore(firstPeriodEnd)) {
                            new_period_end_date = END_DATE;
                        } else {
                            new_period_end_date = firstPeriodEnd;
                            SATRT_DATE = firstPeriodEnd.plusDays(1L);
                        }
                        servicePeriod.set("PERIOD_END_DATE", (Object)new_period_end_date);
                        BigDecimal periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(period_begin_date, new_period_end_date), contractService.GetPeriodDays(period_begin_date, period_end_date));
                        servicePeriod.set("PERIOD_PRICE", (Object)contractService.multiply(servicePeriod.get("PERIOD_PRICE"), periodRate));
                        servicePeriod.set("PERIOD_COST", (Object)contractService.multiply(servicePeriod.get("PERIOD_COST"), periodRate));
                        servicePeriod.set("PERIOD_ADJUSTED_PRICE", servicePeriod.get("PERIOD_PRICE"));
                        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriod, conn);
                    } else {
                        SATRT_DATE = period_end_date.plusDays(1L);
                    }
                    if (SATRT_DATE != null && SATRT_DATE.isBefore(END_DATE)) {
                        List<String> sbsList = null;
                        String serviceIds = DBSql.getString((String)"select SERVICE_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{service.get("OBJECT_ID")});
                        if (StringUtils.isNotBlank((CharSequence)serviceIds)) {
                            sbsList = Arrays.asList(serviceIds.split(","));
                        }
                        while (!SATRT_DATE.isAfter(END_DATE)) {
                            BigDecimal periodRate = BigDecimal.ONE;
                            LocalDate periodEnd = contractService.getNextPeriodStart(SATRT_DATE, maxPeriod).minusDays(1L);
                            if (periodEnd.isAfter(END_DATE)) {
                                periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(SATRT_DATE, END_DATE), contractService.GetPeriodDays(SATRT_DATE, periodEnd));
                                periodEnd = END_DATE;
                            }
                            BO csp = new BO();
                            csp.setAll(servicePeriod.asMap());
                            csp.set("PERIOD_BEGIN_DATE", (Object)SATRT_DATE);
                            csp.set("PERIOD_END_DATE", (Object)periodEnd);
                            BigDecimal period_price = contractService.multiply(service.get("UNIT_PRICE"), service.get("QUANTITY"));
                            period_price = periodRate.multiply(period_price);
                            csp.set("PERIOD_PRICE", (Object)period_price);
                            BigDecimal period_cost = contractService.multiply(service.get("UNIT_COST"), service.get("QUANTITY"));
                            period_cost = periodRate.multiply(period_cost);
                            csp.set("PERIOD_COST", (Object)period_cost);
                            csp.set("PERIOD_ADJUSTED_PRICE", csp.get("PERIOD_PRICE"));
                            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", csp, uc, conn);
                            if (service.getString("OBJECT_TYPE").equals("2")) {
                                String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                                if (sbsList != null) {
                                    for (String sbs : sbsList) {
                                        BO cspbs = new BO();
                                        cspbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)csp.getId());
                                        cspbs.set("SERVICE_ID", (Object)sbs);
                                        cspbs.set("VENDOR_ACCOUNT_ID", csp.get("VENDOR_ACCOUNT_ID"));
                                        cspbs.set("PERIOD_COST", (Object)prorated_cost_change);
                                        cspbs.setBindId(csp.getString("BINDID"));
                                        SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", cspbs, uc, conn);
                                    }
                                }
                            }
                            if (periodEnd == null) continue;
                            SATRT_DATE = periodEnd.plusDays(1L);
                        }
                    }
                } else {
                    contractServiceLogger.info("\u670d\u52a1\u5468\u671f\u7f29\u77ed--" + service.getString("NAME"));
                    servicePeriodList = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").connection(conn)).addQuery("CONTRACT_SERVICE_ID =", (Object)service.getString("CONTRACT_SERVICE_ID"))).addQuery("PERIOD_END_DATE >=", (Object)END_DATE)).orderBy("PERIOD_BEGIN_DATE")).asc()).list();
                    servicePeriod = (BO)servicePeriodList.get(0);
                    servicePeriod.set("PERIOD_END_DATE", (Object)END_DATE);
                    period_begin_date = contractService.getLocalDate(servicePeriod.get("PERIOD_BEGIN_DATE"));
                    period_end_date = contractService.getLocalDate(servicePeriod.get("PERIOD_END_DATE"));
                    BigDecimal periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(period_begin_date, END_DATE), contractService.GetPeriodDays(period_begin_date, period_end_date));
                    servicePeriod.set("PERIOD_PRICE", (Object)contractService.multiply(servicePeriod.get("PERIOD_PRICE"), periodRate));
                    servicePeriod.set("PERIOD_COST", (Object)contractService.multiply(servicePeriod.get("PERIOD_COST"), periodRate));
                    servicePeriod.set("PERIOD_ADJUSTED_PRICE", servicePeriod.get("PERIOD_PRICE"));
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriod, conn);
                    for (BO period : servicePeriodList) {
                        if (period.getString("ID").equals(servicePeriod.getString("ID"))) continue;
                        DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE WHERE CONTRACT_SERVICE_PERIOD_ID=?", (Object[])new Object[]{period.getString("ID")});
                        DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE ID=?", (Object[])new Object[]{period.getString("ID")});
                    }
                }
                DBSql.update((Connection)conn, (String)"update BO_EU_DNCTT_CONTRACT_SERVICE set PERIOD=?,ADJUST_PERIOD=? where ID=? and BINDID=?", (Object[])new Object[]{PERIOD2, ADJUST_PERIOD, service.get("ID"), service.get("BINDID")});
            }
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            conn.rollback();
            contractServiceLogger.error("AddServiceServiceBundle--error--\u5931\u8d25\u3002\u3002\u3002", (Throwable)e);
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        return false;
    }

    public boolean AddServiceServiceBundleOne(UserContext uc, Connection conn, RowMap contract, BO service) {
        BigDecimal periodRate;
        LocalDate currMontLastDay;
        if (service == null) {
            return false;
        }
        contractServiceLogger.info("AddServiceServiceBundleOne--\u5f00\u59cb");
        boolean isCreate = false;
        LocalDate START_DATE = contractService.getLocalDate(contract.get((Object)"START_DATE"));
        LocalDate END_DATE = contractService.getLocalDate(contract.get((Object)"END_DATE"));
        LocalDate EFFECTIVE_DATE = contractService.getLocalDate(service.get("EFFECTIVE_DATE"));
        String PERIOD2 = service.getString("PERIOD");
        String ADJUST_PERIOD = service.getString("ADJUST_PERIOD");
        if (EFFECTIVE_DATE == null || StringUtils.isBlank((CharSequence)PERIOD2) && StringUtils.isBlank((CharSequence)ADJUST_PERIOD)) {
            isCreate = true;
        }
        if (EFFECTIVE_DATE == null) {
            EFFECTIVE_DATE = START_DATE;
            isCreate = true;
        }
        if (StringUtils.isNotBlank((CharSequence)ADJUST_PERIOD)) {
            LocalDate ADJUST_PERIOD_END;
            LocalDate ADJUST_PERIOD_START = contractService.getLocalDate(ADJUST_PERIOD.split("~")[0]);
            if (!ADJUST_PERIOD_START.isEqual(EFFECTIVE_DATE)) {
                isCreate = true;
            }
            if (StringUtils.isBlank((CharSequence)PERIOD2) && !(ADJUST_PERIOD_END = contractService.getLocalDate(ADJUST_PERIOD.split("~")[1])).isEqual(END_DATE)) {
                isCreate = true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)PERIOD2)) {
            Iterator PERIOD_START;
            LocalDate PERIOD_END = contractService.getLocalDate(PERIOD2.split("~")[1]);
            if (!PERIOD_END.isEqual(END_DATE)) {
                isCreate = true;
            }
            if (StringUtils.isBlank((CharSequence)ADJUST_PERIOD) && !((LocalDate)((Object)(PERIOD_START = contractService.getLocalDate(PERIOD2.split("~")[0])))).isEqual(EFFECTIVE_DATE)) {
                isCreate = true;
            }
        }
        if (!isCreate) {
            return true;
        }
        if (DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE APPROVE_AND_POST_USER_ID IS NOT NULL AND LENGTH(APPROVE_AND_POST_USER_ID)>1 AND APPROVE_AND_POST_DATE IS NOT NULL AND  BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")}) > 0) {
            return true;
        }
        if (DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE APPROVE_AND_POST_USER_ID IS NOT NULL AND LENGTH(APPROVE_AND_POST_USER_ID)>1 AND APPROVE_AND_POST_DATE IS NOT NULL AND  BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")}) > 0) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)ADJUST_PERIOD)) {
            List csaIdList = DBSql.getList((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")});
            for (String csaId : csaIdList) {
                DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE where BINDID=? and CONTRACT_SERVICE_ADJUST_ID=? ", (Object[])new Object[]{service.get("BINDID"), csaId});
            }
            DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where BINDID=? and CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("ID")});
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_EDIT where  CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get("ID")});
        }
        if (StringUtils.isNotBlank((CharSequence)PERIOD2)) {
            List cspIdList = DBSql.getList((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where BINDID=? and CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("OBJECT_ID"), service.get("ID")});
            for (String cspId : cspIdList) {
                DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE where BINDID=? and CONTRACT_SERVICE_PERIOD_ID=? ", (Object[])new Object[]{service.get("BINDID"), cspId});
            }
            DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where BINDID=? and CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get("BINDID"), contract.get((Object)"ID"), service.get("OBJECT_ID"), service.get("ID")});
        }
        service.set("CONTRACT_ID", contract.get((Object)"ID"));
        service.set("EFFECTIVE_DATE", (Object)EFFECTIVE_DATE);
        if (service.getString("OBJECT_TYPE").equals("1")) {
            int NEED_PURCHASE = DBSql.getInt((Connection)conn, (String)"select NEED_PURCHASE from BO_EU_DNIVT_SERVICE where ID=? ", (Object[])new Object[]{service.getString("OBJECT_ID")});
            if (NEED_PURCHASE == 1) {
                service.set("STATUS_ID", (Object)"4461");
            } else {
                service.set("STATUS_ID", (Object)"4460");
            }
        }
        int maxPeriod = contract.getInt("PERIOD_TYPE") > (Integer)service.get("PERIOD_TYPE", Integer.class) ? contract.getInt("PERIOD_TYPE") : ((Integer)service.get("PERIOD_TYPE", Integer.class)).intValue();
        BigDecimal rate = this.GetPeriodRate(contract.getString("PERIOD_TYPE"), service.getString("PERIOD_TYPE"));
        BigDecimal unit_cost = (BigDecimal)service.get("UNIT_COST", BigDecimal.class);
        BigDecimal unit_price = (BigDecimal)service.get("UNIT_PRICE", BigDecimal.class);
        if (rate.compareTo(BigDecimal.ONE) > 0) {
            unit_cost = unit_cost.multiply(rate);
            service.set("UNIT_COST", (Object)unit_cost);
            unit_price = unit_price.multiply(rate);
            service.set("UNIT_PRICE", (Object)unit_price);
            service.set("PERIOD_TYPE", (Object)maxPeriod);
        }
        contractServiceLogger.info("\u8ba1\u7b97-service-ADJUSTED_PRICE");
        service.set("TOTAL_PRICE", (Object)contractService.multiply(service.get("QUANTITY"), service.get("UNIT_PRICE")));
        service.set("ADJUSTED_PRICE", (Object)contractService.multiply(service.get("QUANTITY"), service.get("UNIT_PRICE")));
        service.set("TOTAL_COST", (Object)contractService.multiply(service.get("QUANTITY"), service.get("UNIT_COST")));
        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE", service, conn);
        List<String> sbsList = null;
        String serviceIds = DBSql.getString((String)"select SERVICE_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{service.get("OBJECT_ID")});
        if (StringUtils.isNotBlank((CharSequence)serviceIds)) {
            sbsList = Arrays.asList(serviceIds.split(","));
        }
        String BILL_METHOD_ID = null;
        if (service.getString("OBJECT_TYPE").equals("2")) {
            BILL_METHOD_ID = DBSql.getString((Connection)conn, (String)"select BILL_METHOD_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
            if (sbsList != null) {
                for (String sbs : sbsList) {
                    if (DBSql.getInt((Connection)conn, (String)"select count(1) from BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE where SERVICE_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{sbs, service.get("ID")}) != 0) continue;
                    BO csbs = new BO();
                    csbs.set("SERVICE_ID", (Object)sbs);
                    csbs.set("CONTRACT_SERVICE_ID", service.get("ID"));
                    csbs.setBindId(service.getString("BINDID"));
                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE", csbs, uc, conn);
                }
            }
        } else {
            BILL_METHOD_ID = DBSql.getString((Connection)conn, (String)"select BILL_METHOD_ID from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
        }
        String vendor_account_id = DBSql.getString((Connection)conn, (String)"select VENDOR_ACCOUNT_ID from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
        if (StringUtils.isNotBlank((CharSequence)BILL_METHOD_ID) && BILL_METHOD_ID.equals("4601") && START_DATE.getDayOfMonth() != 1 && (currMontLastDay = START_DATE.with(TemporalAdjusters.lastDayOfMonth())).isBefore(END_DATE)) {
            START_DATE = currMontLastDay.plusDays(1L);
        }
        if (service.getString("PERIOD_TYPE").equals("609")) {
            BO csp = new BO();
            csp.set("CONTRACT_ID", contract.get((Object)"ID"));
            csp.set("OBJECT_ID", service.get("OBJECT_ID"));
            csp.set("OBJECT_TYPE", service.get("OBJECT_TYPE"));
            csp.set("CONTRACT_SERVICE_ID", service.get("ID"));
            csp.set("PERIOD_BEGIN_DATE", (Object)EFFECTIVE_DATE);
            csp.set("PERIOD_END_DATE", (Object)END_DATE);
            csp.set("QUANTITY", service.get("QUANTITY"));
            BigDecimal period_price = contractService.multiply(service.get("UNIT_PRICE"), service.get("QUANTITY"));
            csp.set("PERIOD_PRICE", (Object)period_price);
            BigDecimal period_cost = contractService.multiply(service.get("UNIT_COST"), service.get("QUANTITY"));
            csp.set("PERIOD_COST", (Object)period_cost);
            csp.set("PERIOD_ADJUSTED_PRICE", csp.get("PERIOD_PRICE"));
            csp.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
            csp.setBindId(service.getString("BINDID"));
            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", csp, uc, conn);
            if (service.getString("OBJECT_TYPE").equals("2")) {
                String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                if (sbsList != null) {
                    for (String sbs : sbsList) {
                        BO cspbs = new BO();
                        cspbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)csp.getId());
                        cspbs.set("SERVICE_ID", (Object)sbs);
                        cspbs.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                        cspbs.set("PERIOD_COST", (Object)prorated_cost_change);
                        cspbs.setBindId(service.getString("BINDID"));
                        SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", cspbs, uc, conn);
                    }
                }
            }
            return true;
        }
        Map<String, Object> firstPeriodDate = this.getFirstPeriodDate(START_DATE, END_DATE, EFFECTIVE_DATE, contract.getString("PERIOD_TYPE"), service.getString("PERIOD_TYPE"));
        boolean isStartOfPeriod = (Boolean)firstPeriodDate.get("isStartOfPeriod");
        LocalDate start = contractService.getLocalDate(firstPeriodDate.get("periodStart"));
        LocalDate end = contractService.getLocalDate(firstPeriodDate.get("periodEnd"));
        ADJUST_PERIOD = null;
        contractServiceLogger.info("getFirstPeriodDate" + firstPeriodDate.toString());
        if (!isStartOfPeriod) {
            if (EFFECTIVE_DATE.isBefore(START_DATE)) {
                int priodDays = contractService.GetPeriodDays(contractService.getPreviousPeriodStart(end.plusDays(1L), String.valueOf(maxPeriod)), end);
                periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(EFFECTIVE_DATE, end), priodDays);
            } else {
                periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(EFFECTIVE_DATE, end), contractService.GetPeriodDays(start, end));
            }
            BO csa = new BO();
            csa.set("CONTRACT_ID", contract.get((Object)"ID"));
            csa.set("OBJECT_ID", service.get("OBJECT_ID"));
            csa.set("OBJECT_TYPE", service.get("OBJECT_TYPE"));
            csa.set("QUANTITY", service.get("QUANTITY"));
            csa.set("CONTRACT_SERVICE_ID", service.get("ID"));
            csa.set("PERIOD_BEGIN_DATE", (Object)EFFECTIVE_DATE);
            csa.set("PERIOD_END_DATE", (Object)end);
            ADJUST_PERIOD = contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE) + "~" + contractService.LocalDateYYYYMMDD(end);
            csa.set("PERIOD_ADJUSTED_PRICE", (Object)contractService.multiply(service.get("ADJUSTED_PRICE"), periodRate));
            csa.set("PERIOD_PRICE", csa.get("PERIOD_ADJUSTED_PRICE"));
            csa.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
            csa.setBindId(service.getString("BINDID"));
            csa.set("PERIOD_COST", (Object)contractService.multiply(service.get("TOTAL_COST"), periodRate));
            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", csa, uc, conn);
            if (service.getString("OBJECT_TYPE").equals("2")) {
                String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                if (sbsList != null) {
                    for (String sbs : sbsList) {
                        BO csabs = new BO();
                        csabs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)csa.getId());
                        csabs.set("SERVICE_ID", (Object)sbs);
                        csabs.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                        csabs.set("PERIOD_COST", (Object)prorated_cost_change);
                        csabs.setBindId(service.getString("BINDID"));
                        SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", csabs, uc, conn);
                    }
                }
            }
            start = end.plusDays(1L);
        }
        PERIOD2 = null;
        if (start.isBefore(END_DATE)) {
            PERIOD2 = contractService.LocalDateYYYYMMDD(start);
            while (!start.isAfter(END_DATE)) {
                periodRate = BigDecimal.ONE;
                LocalDate periodEnd = contractService.getNextPeriodStart(start, String.valueOf(maxPeriod)).minusDays(1L);
                if (periodEnd.isAfter(END_DATE)) {
                    periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(start, END_DATE), contractService.GetPeriodDays(start, periodEnd));
                    periodEnd = END_DATE;
                }
                BO csp = new BO();
                csp.set("CONTRACT_ID", contract.get((Object)"ID"));
                csp.set("OBJECT_ID", service.get("OBJECT_ID"));
                csp.set("OBJECT_TYPE", service.get("OBJECT_TYPE"));
                csp.set("CONTRACT_SERVICE_ID", service.get("ID"));
                csp.set("PERIOD_BEGIN_DATE", (Object)start);
                csp.set("PERIOD_END_DATE", (Object)periodEnd);
                csp.set("QUANTITY", service.get("QUANTITY"));
                contractServiceLogger.info("\u8ba1\u7b97-csp-PERIOD_PRICE");
                BigDecimal period_price = contractService.multiply(service.get("UNIT_PRICE"), service.get("QUANTITY"));
                period_price = periodRate.multiply(period_price);
                csp.set("PERIOD_PRICE", (Object)period_price);
                contractServiceLogger.info("\u8ba1\u7b97-csp-PERIOD_COST");
                BigDecimal period_cost = contractService.multiply(service.get("UNIT_COST"), service.get("QUANTITY"));
                period_cost = periodRate.multiply(period_cost);
                csp.set("PERIOD_COST", (Object)period_cost);
                csp.set("PERIOD_ADJUSTED_PRICE", csp.get("PERIOD_PRICE"));
                csp.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                csp.setBindId(service.getString("BINDID"));
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", csp, uc, conn);
                if (service.getString("OBJECT_TYPE").equals("2")) {
                    String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                    if (sbsList != null) {
                        for (String sbs : sbsList) {
                            BO cspbs = new BO();
                            cspbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)csp.getId());
                            cspbs.set("SERVICE_ID", (Object)sbs);
                            cspbs.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                            cspbs.set("PERIOD_COST", (Object)prorated_cost_change);
                            cspbs.setBindId(service.getString("BINDID"));
                            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", cspbs, uc, conn);
                        }
                    }
                }
                if (periodEnd == null) continue;
                start = periodEnd.plusDays(1L);
            }
            PERIOD2 = PERIOD2 + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
        }
        DBSql.update((Connection)conn, (String)"update BO_EU_DNCTT_CONTRACT_SERVICE set PERIOD=?,ADJUST_PERIOD=? where ID=? and BINDID=?", (Object[])new Object[]{PERIOD2, ADJUST_PERIOD, service.get("ID"), service.get("BINDID")});
        return true;
    }

    public boolean EditServiceServiceBundle(UserContext uc, Connection conn, RowMap contract, BO editService) {
        contractServiceLogger.info("\u8c03\u6574\u670d\u52a1");
        String IS_EFFECTIVE = editService.getString("IS_EFFECTIVE");
        if (!IS_EFFECTIVE.equals("\u672a\u6267\u884c")) {
            return false;
        }
        LocalDate EFFECTIVE_DATE = contractService.getLocalDate(editService.get("EFFECTIVE_DATE"));
        String EFFECTIVE_DATE_STR = EFFECTIVE_DATE.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        if (editService.getString("PERIOD_TYPE").equals("609") ? DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE APPROVE_AND_POST_USER_ID IS NOT NULL AND LENGTH(APPROVE_AND_POST_USER_ID)>1 AND APPROVE_AND_POST_DATE IS NOT NULL and CONTRACT_ID=? and CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{contract.get((Object)"ID"), editService.get("CONTRACT_SERVICE_ID")}) > 0 : DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE APPROVE_AND_POST_USER_ID IS NOT NULL AND LENGTH(APPROVE_AND_POST_USER_ID)>1 AND APPROVE_AND_POST_DATE IS NOT NULL and CONTRACT_ID=? and CONTRACT_SERVICE_ID=? AND  PERIOD_END_DATE>=?", (Object[])new Object[]{contract.get((Object)"ID"), editService.get("CONTRACT_SERVICE_ID"), EFFECTIVE_DATE_STR}) > 0) {
            return false;
        }
        if (editService.getString("PERIOD_TYPE").equals("609")) {
            BO servicePeriod = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").connection(conn)).addQuery("CONTRACT_SERVICE_ID =", (Object)editService.getString("CONTRACT_SERVICE_ID"))).detail();
            servicePeriod.set("PERIOD_BEGIN_DATE", (Object)EFFECTIVE_DATE);
            servicePeriod.set("QUANTITY", editService.get("QUANTITY"));
            servicePeriod.set("PERIOD_PRICE", editService.get("TOTAL_PRICE"));
            servicePeriod.set("PERIOD_COST", editService.get("TOTAL_COST"));
            servicePeriod.set("PERIOD_ADJUSTED_PRICE", servicePeriod.get("PERIOD_PRICE"));
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriod, conn);
        } else {
            List servicePeriodList;
            List editServiceList = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_EDIT").connection(conn)).addQuery("CONTRACT_SERVICE_ID =", (Object)editService.getString("CONTRACT_SERVICE_ID"))).addQuery("IS_EFFECTIVE =", (Object)"\u5df2\u6267\u884c")).addQuery("EFFECTIVE_DATE >", (Object)EFFECTIVE_DATE_STR)).orderBy("EFFECTIVE_DATE")).asc()).list();
            boolean needDel = false;
            if (editServiceList != null && editServiceList.size() > 0) {
                needDel = true;
                for (Object editServiceOld : editServiceList) {
                    editServiceOld.set("IS_EFFECTIVE", (Object)"\u4f5c\u5e9f");
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_EDIT", (BO)editServiceOld, conn);
                }
            }
            if (!needDel) {
                contractServiceLogger.info("\u670d\u52a1\u8c03\u6574\u7684\u751f\u6548\u65e5\u671f\uff0c\u662f\u6309\u7167\u65e5\u671f\u987a\u5e8f\u521b\u5efa\u7684");
                servicePeriodList = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").connection(conn)).addQuery("CONTRACT_SERVICE_ID =", (Object)editService.getString("CONTRACT_SERVICE_ID"))).orderBy("PERIOD_BEGIN_DATE")).asc()).list();
                if (servicePeriodList != null && servicePeriodList.size() > 0) {
                    for (BO servicePeriod : servicePeriodList) {
                        LocalDate period_begin_date = contractService.getLocalDate(servicePeriod.get("PERIOD_BEGIN_DATE"));
                        LocalDate period_end_date = contractService.getLocalDate(servicePeriod.get("PERIOD_END_DATE"));
                        if (period_end_date.isBefore(EFFECTIVE_DATE)) continue;
                        if (period_begin_date.isBefore(EFFECTIVE_DATE) && !period_end_date.isBefore(EFFECTIVE_DATE)) {
                            BO servicePeriodAdj = new BO();
                            servicePeriodAdj.setAll(servicePeriod.asMap());
                            servicePeriodAdj.setId(null);
                            servicePeriodAdj.set("PERIOD_BEGIN_DATE", (Object)EFFECTIVE_DATE);
                            servicePeriodAdj.set("PERIOD_END_DATE", (Object)period_end_date);
                            servicePeriodAdj.set("QUANTITY", editService.get("QUANTITY"));
                            String ORG_PERIOD_ID = servicePeriod.getString("ORG_PERIOD_ID");
                            if (StringUtils.isBlank((CharSequence)ORG_PERIOD_ID)) {
                                ORG_PERIOD_ID = servicePeriod.getId();
                            }
                            servicePeriodAdj.set("ORG_PERIOD_ID", (Object)ORG_PERIOD_ID);
                            BigDecimal periodRateAdj = contractService.divideToBigDecimal(contractService.GetPeriodDays(EFFECTIVE_DATE, period_end_date), contractService.GetPeriodDays(period_begin_date, period_end_date));
                            BigDecimal priceRate = ((BigDecimal)editService.get("TOTAL_PRICE", BigDecimal.class)).divide((BigDecimal)editService.get("OLD_TOTAL_PRICE", BigDecimal.class), 10, RoundingMode.HALF_UP);
                            BigDecimal costRate = ((BigDecimal)editService.get("TOTAL_COST", BigDecimal.class)).divide((BigDecimal)editService.get("OLD_TOTAL_COST", BigDecimal.class), 10, RoundingMode.HALF_UP);
                            servicePeriodAdj.set("PERIOD_PRICE", (Object)contractService.multiply(servicePeriod.get("PERIOD_PRICE"), contractService.multiply(periodRateAdj, priceRate)));
                            servicePeriodAdj.set("PERIOD_COST", (Object)contractService.multiply(servicePeriod.get("PERIOD_COST"), contractService.multiply(periodRateAdj, costRate)));
                            servicePeriodAdj.set("PERIOD_ADJUSTED_PRICE", servicePeriodAdj.get("PERIOD_PRICE"));
                            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriodAdj, uc, conn);
                            List sbsList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE").connection(conn)).addQuery("CONTRACT_SERVICE_PERIOD_ID =", (Object)ORG_PERIOD_ID)).list();
                            if (sbsList != null && sbsList.size() > 0) {
                                for (BO sbs : sbsList) {
                                    BO newSbs = new BO();
                                    newSbs.setAll(sbs.asMap());
                                    newSbs.setId(null);
                                    newSbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)servicePeriodAdj.getId());
                                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", newSbs, uc, conn);
                                }
                            }
                            servicePeriod.set("PERIOD_END_DATE", (Object)EFFECTIVE_DATE.minusDays(1L));
                            BigDecimal periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(period_begin_date, EFFECTIVE_DATE.minusDays(1L)), contractService.GetPeriodDays(period_begin_date, period_end_date));
                            servicePeriod.set("PERIOD_PRICE", (Object)contractService.multiply(servicePeriod.get("PERIOD_PRICE"), periodRate));
                            servicePeriod.set("PERIOD_COST", (Object)contractService.multiply(servicePeriod.get("PERIOD_COST"), periodRate));
                            servicePeriod.set("PERIOD_ADJUSTED_PRICE", servicePeriod.get("PERIOD_PRICE"));
                            servicePeriod.set("ORG_PERIOD_ID", (Object)ORG_PERIOD_ID);
                            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriod, conn);
                            continue;
                        }
                        BigDecimal priceRate = ((BigDecimal)editService.get("TOTAL_PRICE", BigDecimal.class)).divide((BigDecimal)editService.get("OLD_TOTAL_PRICE", BigDecimal.class), 10, RoundingMode.HALF_UP);
                        BigDecimal costRate = ((BigDecimal)editService.get("TOTAL_COST", BigDecimal.class)).divide((BigDecimal)editService.get("OLD_TOTAL_COST", BigDecimal.class), 10, RoundingMode.HALF_UP);
                        servicePeriod.set("QUANTITY", editService.get("QUANTITY"));
                        servicePeriod.set("PERIOD_PRICE", (Object)contractService.multiply(servicePeriod.get("PERIOD_PRICE"), priceRate));
                        servicePeriod.set("PERIOD_COST", (Object)contractService.multiply(servicePeriod.get("PERIOD_COST"), costRate));
                        servicePeriod.set("PERIOD_ADJUSTED_PRICE", servicePeriod.get("PERIOD_PRICE"));
                        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriod, conn);
                    }
                }
            } else {
                LocalDate ADJUST_PERIOD_END;
                LocalDate PERIOD_END;
                LocalDate period_end_date;
                LocalDate period_begin_date;
                contractServiceLogger.info("\u672c\u6b21\u670d\u52a1\u8c03\u6574\u751f\u6548\u65e5\u671f\u4e4b\u540e\u7684\u670d\u52a1\u8c03\u6574\u5168\u90e8\u4f5c\u5e9f");
                servicePeriodList = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").connection(conn)).addQuery("CONTRACT_SERVICE_ID =", (Object)editService.getString("CONTRACT_SERVICE_ID"))).addQuery("PERIOD_END_DATE >=", (Object)EFFECTIVE_DATE_STR)).orderBy("PERIOD_BEGIN_DATE")).asc()).list();
                BO firstServicePeriod = (BO)servicePeriodList.get(0);
                String ORG_PERIOD_ID = firstServicePeriod.getString("ORG_PERIOD_ID");
                LocalDate SATRT_DATE = null;
                if (StringUtils.isBlank((CharSequence)ORG_PERIOD_ID)) {
                    ORG_PERIOD_ID = firstServicePeriod.getString("ORG_PERIOD_ID");
                    period_begin_date = contractService.getLocalDate(firstServicePeriod.get("PERIOD_BEGIN_DATE"));
                    period_end_date = contractService.getLocalDate(firstServicePeriod.get("PERIOD_END_DATE"));
                    BO servicePeriodAdj = new BO();
                    servicePeriodAdj.setAll(firstServicePeriod.asMap());
                    servicePeriodAdj.setId(null);
                    servicePeriodAdj.set("PERIOD_BEGIN_DATE", (Object)EFFECTIVE_DATE);
                    servicePeriodAdj.set("PERIOD_END_DATE", (Object)period_end_date);
                    servicePeriodAdj.set("QUANTITY", editService.get("QUANTITY"));
                    servicePeriodAdj.set("ORG_PERIOD_ID", (Object)ORG_PERIOD_ID);
                    BigDecimal periodRateAdj = contractService.divideToBigDecimal(contractService.GetPeriodDays(EFFECTIVE_DATE, period_end_date), contractService.GetPeriodDays(period_begin_date, period_end_date));
                    BigDecimal priceRate = ((BigDecimal)editService.get("TOTAL_PRICE", BigDecimal.class)).divide((BigDecimal)editService.get("OLD_TOTAL_PRICE", BigDecimal.class), 10, RoundingMode.HALF_UP);
                    BigDecimal costRate = ((BigDecimal)editService.get("TOTAL_COST", BigDecimal.class)).divide((BigDecimal)editService.get("OLD_TOTAL_COST", BigDecimal.class), 10, RoundingMode.HALF_UP);
                    servicePeriodAdj.set("PERIOD_PRICE", (Object)contractService.multiply(firstServicePeriod.get("PERIOD_PRICE"), contractService.multiply(periodRateAdj, priceRate)));
                    servicePeriodAdj.set("PERIOD_COST", (Object)contractService.multiply(firstServicePeriod.get("PERIOD_COST"), contractService.multiply(periodRateAdj, costRate)));
                    servicePeriodAdj.set("PERIOD_ADJUSTED_PRICE", servicePeriodAdj.get("PERIOD_PRICE"));
                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriodAdj, uc, conn);
                    List sbsList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE").connection(conn)).addQuery("CONTRACT_SERVICE_PERIOD_ID =", (Object)ORG_PERIOD_ID)).list();
                    if (sbsList != null && sbsList.size() > 0) {
                        for (BO sbs : sbsList) {
                            BO newSbs = new BO();
                            newSbs.setAll(sbs.asMap());
                            newSbs.setId(null);
                            newSbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)servicePeriodAdj.getId());
                            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", newSbs, uc, conn);
                        }
                    }
                    firstServicePeriod.set("PERIOD_END_DATE", (Object)EFFECTIVE_DATE.minusDays(1L));
                    BigDecimal periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(period_begin_date, EFFECTIVE_DATE.minusDays(1L)), contractService.GetPeriodDays(period_begin_date, period_end_date));
                    firstServicePeriod.set("PERIOD_PRICE", (Object)contractService.multiply(firstServicePeriod.get("PERIOD_PRICE"), periodRate));
                    firstServicePeriod.set("PERIOD_COST", (Object)contractService.multiply(firstServicePeriod.get("PERIOD_COST"), periodRate));
                    firstServicePeriod.set("PERIOD_ADJUSTED_PRICE", firstServicePeriod.get("PERIOD_PRICE"));
                    firstServicePeriod.set("ORG_PERIOD_ID", (Object)ORG_PERIOD_ID);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", firstServicePeriod, conn);
                    SATRT_DATE = period_end_date.plusDays(1L);
                } else {
                    period_begin_date = contractService.getLocalDate(firstServicePeriod.get("PERIOD_BEGIN_DATE"));
                    period_end_date = contractService.getLocalDate(firstServicePeriod.get("PERIOD_END_DATE"));
                    firstServicePeriod.set("PERIOD_END_DATE", (Object)EFFECTIVE_DATE.minusDays(1L));
                    BigDecimal periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(period_begin_date, EFFECTIVE_DATE.minusDays(1L)), contractService.GetPeriodDays(period_begin_date, period_end_date));
                    firstServicePeriod.set("PERIOD_PRICE", (Object)contractService.multiply(firstServicePeriod.get("PERIOD_PRICE"), periodRate));
                    firstServicePeriod.set("PERIOD_COST", (Object)contractService.multiply(firstServicePeriod.get("PERIOD_COST"), periodRate));
                    firstServicePeriod.set("PERIOD_ADJUSTED_PRICE", firstServicePeriod.get("PERIOD_PRICE"));
                    firstServicePeriod.set("ORG_PERIOD_ID", (Object)ORG_PERIOD_ID);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", firstServicePeriod, conn);
                    List servicePeriodList2 = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").connection(conn)).addQuery("CONTRACT_SERVICE_ID =", (Object)editService.getString("CONTRACT_SERVICE_ID"))).addQuery("ORG_PERIOD_ID =", (Object)ORG_PERIOD_ID)).orderBy("PERIOD_BEGIN_DATE")).desc()).list();
                    DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE WHERE CONTRACT_SERVICE_PERIOD_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE ORG_PERIOD_ID=? AND PERIOD_END_DATE>=?)", (Object[])new Object[]{ORG_PERIOD_ID, EFFECTIVE_DATE_STR});
                    DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE ORG_PERIOD_ID=? AND PERIOD_END_DATE>=?", (Object[])new Object[]{ORG_PERIOD_ID, EFFECTIVE_DATE_STR});
                    BO lastServicePeriod = (BO)servicePeriodList2.get(0);
                    LocalDate last_period_begin_date = contractService.getLocalDate(lastServicePeriod.get("PERIOD_BEGIN_DATE"));
                    LocalDate last_period_end_date = contractService.getLocalDate(lastServicePeriod.get("PERIOD_END_DATE"));
                    BO servicePeriodAdj = new BO();
                    servicePeriodAdj.setAll(firstServicePeriod.asMap());
                    servicePeriodAdj.setId(null);
                    servicePeriodAdj.set("PERIOD_BEGIN_DATE", (Object)EFFECTIVE_DATE);
                    servicePeriodAdj.set("PERIOD_END_DATE", (Object)last_period_end_date);
                    servicePeriodAdj.set("QUANTITY", editService.get("QUANTITY"));
                    servicePeriodAdj.set("ORG_PERIOD_ID", (Object)ORG_PERIOD_ID);
                    LocalDate start = contractService.getPreviousPeriodStart(last_period_end_date.plusDays(1L), editService.getString("PERIOD_TYPE"));
                    BigDecimal periodRateAdj = contractService.divideToBigDecimal(contractService.GetPeriodDays(EFFECTIVE_DATE, last_period_end_date), contractService.GetPeriodDays(start, last_period_end_date));
                    servicePeriodAdj.set("PERIOD_PRICE", (Object)contractService.multiply(editService.get("TOTAL_PRICE"), periodRateAdj));
                    servicePeriodAdj.set("PERIOD_COST", (Object)contractService.multiply(editService.get("TOTAL_COST"), periodRateAdj));
                    servicePeriodAdj.set("PERIOD_ADJUSTED_PRICE", servicePeriodAdj.get("PERIOD_PRICE"));
                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", servicePeriodAdj, uc, conn);
                    List sbsList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE").connection(conn)).addQuery("CONTRACT_SERVICE_PERIOD_ID =", (Object)ORG_PERIOD_ID)).list();
                    if (sbsList != null && sbsList.size() > 0) {
                        for (BO bO : sbsList) {
                            BO newSbs = new BO();
                            newSbs.setAll(bO.asMap());
                            newSbs.setId(null);
                            newSbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)servicePeriodAdj.getId());
                            SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", newSbs, uc, conn);
                        }
                    }
                    SATRT_DATE = last_period_end_date.plusDays(1L);
                }
                String SATRT_DATE_STR = SATRT_DATE.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
                DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE WHERE CONTRACT_SERVICE_PERIOD_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? AND PERIOD_END_DATE>=?)", (Object[])new Object[]{editService.getString("CONTRACT_SERVICE_ID"), SATRT_DATE_STR});
                DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? AND PERIOD_END_DATE>=?", (Object[])new Object[]{editService.getString("CONTRACT_SERVICE_ID"), SATRT_DATE_STR});
                LocalDate END_DATE = contractService.getLocalDate(contract.get((Object)"END_DATE"));
                String maxPeriod = editService.getString("PERIOD_TYPE");
                List<String> sbsList = null;
                String serviceIds = DBSql.getString((String)"select SERVICE_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{editService.get("OBJECT_ID")});
                if (StringUtils.isNotBlank((CharSequence)serviceIds)) {
                    sbsList = Arrays.asList(serviceIds.split(","));
                }
                if (SATRT_DATE.isBefore(END_DATE)) {
                    while (!SATRT_DATE.isAfter(END_DATE)) {
                        BigDecimal periodRate = BigDecimal.ONE;
                        LocalDate periodEnd = contractService.getNextPeriodStart(SATRT_DATE, maxPeriod).minusDays(1L);
                        if (periodEnd.isAfter(END_DATE)) {
                            periodRate = contractService.divideToBigDecimal(contractService.GetPeriodDays(SATRT_DATE, END_DATE), contractService.GetPeriodDays(SATRT_DATE, periodEnd));
                            periodEnd = END_DATE;
                        }
                        BO csp = new BO();
                        csp.setAll(firstServicePeriod.asMap());
                        csp.set("PERIOD_BEGIN_DATE", (Object)SATRT_DATE);
                        csp.set("PERIOD_END_DATE", (Object)periodEnd);
                        csp.set("QUANTITY", editService.get("QUANTITY"));
                        BigDecimal period_price = contractService.multiply(editService.get("UNIT_PRICE"), editService.get("QUANTITY"));
                        period_price = periodRate.multiply(period_price);
                        csp.set("PERIOD_PRICE", (Object)period_price);
                        contractServiceLogger.info("\u8ba1\u7b97-csp-PERIOD_COST");
                        BigDecimal period_cost = contractService.multiply(editService.get("UNIT_COST"), editService.get("QUANTITY"));
                        period_cost = periodRate.multiply(period_cost);
                        csp.set("PERIOD_COST", (Object)period_cost);
                        csp.set("PERIOD_ADJUSTED_PRICE", csp.get("PERIOD_PRICE"));
                        SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", csp, uc, conn);
                        if (editService.getString("OBJECT_TYPE").equals("2")) {
                            String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{editService.getString("OBJECT_ID")});
                            if (sbsList != null) {
                                for (String string : sbsList) {
                                    BO cspbs = new BO();
                                    cspbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)csp.getId());
                                    cspbs.set("SERVICE_ID", (Object)string);
                                    cspbs.set("VENDOR_ACCOUNT_ID", csp.get("VENDOR_ACCOUNT_ID"));
                                    cspbs.set("PERIOD_COST", (Object)prorated_cost_change);
                                    cspbs.setBindId(csp.getString("BINDID"));
                                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", cspbs, uc, conn);
                                }
                            }
                        }
                        if (periodEnd == null) continue;
                        SATRT_DATE = periodEnd.plusDays(1L);
                    }
                }
                String PERIOD2 = editService.getString("PERIOD");
                String ADJUST_PERIOD = editService.getString("ADJUST_PERIOD");
                if (StringUtils.isNotBlank((CharSequence)PERIOD2)) {
                    PERIOD_END = contractService.getLocalDate(PERIOD2.split("~")[1]);
                    PERIOD2 = PERIOD2.split("~")[0] + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
                } else {
                    PERIOD_END = contractService.getLocalDate(ADJUST_PERIOD.split("~")[1]);
                    ADJUST_PERIOD = ADJUST_PERIOD.split("~")[0] + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
                }
                if (PERIOD_END.isAfter(END_DATE) && StringUtils.isNotBlank((CharSequence)ADJUST_PERIOD) && (ADJUST_PERIOD_END = contractService.getLocalDate(ADJUST_PERIOD.split("~")[1])).isAfter(END_DATE)) {
                    PERIOD2 = null;
                    ADJUST_PERIOD = ADJUST_PERIOD.split("~")[0] + "~" + contractService.LocalDateYYYYMMDD(END_DATE);
                }
                DBSql.update((Connection)conn, (String)"update BO_EU_DNCTT_CONTRACT_SERVICE set PERIOD=?,ADJUST_PERIOD=? where ID=? and BINDID=?", (Object[])new Object[]{PERIOD2, ADJUST_PERIOD, editService.get("CONTRACT_SERVICE_ID"), editService.get("BINDID")});
            }
        }
        editService.set("IS_EFFECTIVE", (Object)"\u5df2\u6267\u884c");
        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_EDIT", editService, conn);
        BO contractServiceBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE", editService.getString("CONTRACT_SERVICE_ID"));
        contractServiceBO.set("OLD_QUANTITY", editService.get("OLD_QUANTITY"));
        contractServiceBO.set("OLD_UNIT_PRICE", editService.get("OLD_UNIT_PRICE"));
        contractServiceBO.set("OLD_TOTAL_PRICE", editService.get("OLD_TOTAL_PRICE"));
        contractServiceBO.set("OLD_UNIT_COST", editService.get("OLD_UNIT_COST"));
        contractServiceBO.set("OLD_TOTAL_COST", editService.get("OLD_TOTAL_COST"));
        contractServiceBO.set("QUANTITY", editService.get("QUANTITY"));
        contractServiceBO.set("UNIT_PRICE", editService.get("UNIT_PRICE"));
        contractServiceBO.set("TOTAL_PRICE", editService.get("TOTAL_PRICE"));
        contractServiceBO.set("UNIT_COST", editService.get("UNIT_COST"));
        contractServiceBO.set("TOTAL_COST", editService.get("TOTAL_COST"));
        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE", contractServiceBO, conn);
        contractServiceLogger.info("\u670d\u52a1\u8c03\u6574\u6210\u529f");
        return true;
    }

    public boolean AddContractServiceProduct(UserContext uc, RowMap contract, Connection conn) throws SQLException {
        ArrayList<BO> serviceList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").connection(conn)).addQuery("BINDID =", contract.get((Object)"BINDID"))).list();
        List serviceList2 = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").connection(conn)).addQuery("BINDID !=", contract.get((Object)"BINDID"))).addQuery("CONTRACT_ID =", contract.get((Object)"ID"))).list();
        if (serviceList == null) {
            serviceList = new ArrayList<BO>();
        }
        if (serviceList2 != null && serviceList2.size() > 0) {
            for (BO service : serviceList2) {
                serviceList.add(service);
            }
        }
        for (BO service : serviceList) {
            String PRODUCT_ID = null;
            if (service.getString("OBJECT_TYPE").equals("2")) {
                RowMap serviceBUNDLE = DBSql.getMap((Connection)conn, (String)"SELECT SERVICE_ID,UNIT_COST,UNIT_PRICE FROM BO_EU_DNIVT_SERVICE_BUNDLE WHERE ID=?", (Object[])new Object[]{service.getString("OBJECT_ID")});
                String serviceIDS = serviceBUNDLE.getString("SERVICE_ID");
                Double BUNDLE_UNIT_COST = serviceBUNDLE.getDouble("UNIT_COST");
                Double BUNDLE_UNIT_PRICE = serviceBUNDLE.getDouble("UNIT_PRICE");
                List ivtServiceList = DBSql.getMaps((Connection)conn, (String)"select ID,UNIT_COST,UNIT_PRICE from BO_EU_DNIVT_SERVICE where FIND_IN_SET(ID,?)", (Object[])new Object[]{serviceIDS});
                RowMap ivtServiceSum = DBSql.getMap((Connection)conn, (String)"SELECT SUM(UNIT_COST) AS SUM_COST,SUM(UNIT_PRICE) AS SUM_PRICE  FROM BO_EU_DNIVT_SERVICE where FIND_IN_SET(ID,?)", (Object[])new Object[]{serviceIDS});
                HashMap<String, Double> unitPriceMap = new HashMap<String, Double>();
                HashMap<String, Double> unitCostMap = new HashMap<String, Double>();
                for (RowMap ivtService : ivtServiceList) {
                    Double UNIT_PRICE = ivtService.getDouble("UNIT_PRICE");
                    Double UNIT_COST = ivtService.getDouble("UNIT_COST");
                    UNIT_PRICE = ivtServiceSum.getDouble("SUM_PRICE") == 0.0 ? 0.0 : BUNDLE_UNIT_PRICE * UNIT_PRICE / ivtServiceSum.getDouble("SUM_PRICE");
                    unitPriceMap.put(ivtService.getString("ID"), UNIT_PRICE);
                    UNIT_COST = ivtServiceSum.getDouble("SUM_COST") == 0.0 ? 0.0 : BUNDLE_UNIT_COST * UNIT_COST / ivtServiceSum.getDouble("SUM_COST");
                    unitCostMap.put(ivtService.getString("ID"), UNIT_COST);
                }
                for (String serviceID : serviceIDS.split(",")) {
                    String contractCostId = DBSql.getString((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_COST where IS_SERVICE_PRODUCT=1 AND  CONTRACT_ID=? and SERVICE_ID=? and PRODUCT_ID in(select PRODUCT_ID from BO_EU_DNIVT_SERVICE where ID=?)", (Object[])new Object[]{contract.getString("ID"), service.getString("ID"), serviceID});
                    String NEED_PURCHASE = service.getString("NEED_PURCHASE");
                    if (NEED_PURCHASE.equals("1")) {
                        HashMap<String, String> contractCost = new HashMap<String, String>();
                        contractCost.put("ID", contractCostId);
                        contractCost.put("SERVICE_ID", service.getString("ID"));
                        contractCost.put("SERVICE_NAME", service.getString("NAME"));
                        contractCost.put("serviceID", serviceID);
                        contractCost.put("CONTRACT_ID", contract.getString("ID"));
                        contractCost.put("QUANTITY", service.getString("QUANTITY"));
                        contractCost.put("UNIT_PRICE", String.valueOf(unitPriceMap.get(serviceID)));
                        contractCost.put("UNIT_COST", String.valueOf(unitCostMap.get(serviceID)));
                        PRODUCT_ID = this.AddContractServiceProduct(uc, conn, contractCost);
                        continue;
                    }
                    if (DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNCTT_CONTRACT_COST_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0 || DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNIVT_ORDER_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0) continue;
                    String contractCostBINDId = DBSql.getString((Connection)conn, (String)"select BINDID from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
                    SDK.getProcessAPI().deleteById(contractCostBINDId, uc.getUID());
                    DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
                }
                continue;
            }
            String contractCostId = DBSql.getString((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_COST where IS_SERVICE_PRODUCT=1 AND CONTRACT_ID=? and SERVICE_ID=?", (Object[])new Object[]{contract.getString("ID"), service.getString("ID")});
            String NEED_PURCHASE = service.getString("NEED_PURCHASE");
            if (NEED_PURCHASE.equals("1")) {
                HashMap<String, String> contractCost = new HashMap<String, String>();
                contractCost.put("ID", contractCostId);
                contractCost.put("SERVICE_ID", service.getString("ID"));
                contractCost.put("SERVICE_NAME", service.getString("NAME"));
                contractCost.put("serviceID", service.getString("OBJECT_ID"));
                contractCost.put("CONTRACT_ID", contract.getString("ID"));
                contractCost.put("QUANTITY", service.getString("QUANTITY"));
                contractCost.put("UNIT_PRICE", service.getString("UNIT_PRICE"));
                contractCost.put("UNIT_COST", service.getString("UNIT_COST"));
                PRODUCT_ID = this.AddContractServiceProduct(uc, conn, contractCost);
                continue;
            }
            if (DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNCTT_CONTRACT_COST_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0 || DBSql.getInt((Connection)conn, (String)"select count(*) from BO_EU_DNIVT_ORDER_PRODUCT where CONTRACT_COST_ID=?", (Object[])new Object[]{contractCostId}) != 0) continue;
            String contractCostBINDId = DBSql.getString((Connection)conn, (String)"select BINDID from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
            SDK.getProcessAPI().deleteById(contractCostBINDId, uc.getUID());
            DBSql.update((Connection)conn, (String)"delete from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{contractCostId});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddContractServiceProduct(UserContext uc, RowMap contract) throws SQLException {
        contractServiceLogger.info("\u4e00\u4e2a\u670d\u52a1\u5bf9\u5e94\u6dfb\u52a0\u4e00\u4e2a\u5408\u540c\u4ea7\u54c1");
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            this.AddContractServiceProduct(uc, contract, conn);
            conn.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            conn.rollback();
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        return false;
    }

    private String AddContractServiceProduct(UserContext uc, Connection conn, Map<String, String> service) {
        BO product;
        contractServiceLogger.info("\u65b0\u589e\u5408\u540c\u4ea7\u54c1");
        System.out.println(service);
        BO contractCost = null;
        if (service.get("ID") != null && StringUtils.isNotBlank((CharSequence)service.get("ID").toString())) {
            contractCost = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", service.get("ID"));
        }
        if (contractCost == null) {
            ProcessInstance contractInstance = SDK.getProcessAPI().createBOProcessInstance("obj_87c6ef75d18f44cc8e85d3d4e818c303", uc.getUID(), "\u65b0\u589e\u5408\u540c\u4ea7\u54c1");
            contractCost = new BO();
            contractCost.setBindId(contractInstance.getId());
        }
        contractCost.set("CONTRACT_ID", (Object)service.get("CONTRACT_ID"));
        contractCost.set("SERVICE_ID", (Object)service.get("SERVICE_ID"));
        contractCost.set("QUANTITY", (Object)service.get("QUANTITY"));
        contractCost.set("NAME", (Object)service.get("SERVICE_NAME"));
        contractCost.set("PRODUCT_ID", (Object)DBSql.getString((Connection)conn, (String)"select PRODUCT_ID from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{service.get("serviceID")}));
        if (StringUtils.isNotBlank((CharSequence)contractCost.getString("PRODUCT_ID")) && (product = SDK.getBOAPI().get("BO_EU_DNIVT_PRODUCT", contractCost.getString("PRODUCT_ID"))) != null) {
            contractCost.set("DESCRIPTION", (Object)product.getString("DESCRIPTION"));
            contractCost.set("COST_CODE_ID", (Object)product.getString("COST_CODE_ID"));
            contractCost.set("PRODUCT_NAME", (Object)product.getString("NAME"));
            contractCost.set("TAX_CATEGORY_ID", (Object)DBSql.getString((String)"select TAX_CATEGORY_ID from BO_EU_DND_COST_CODE where OID=?", (Object[])new Object[]{product.getString("COST_CODE_ID")}));
            contractCost.set("COST_CODE_NAME", (Object)DBSql.getString((String)"select NAME from BO_EU_DND_COST_CODE where OID=?", (Object[])new Object[]{product.getString("COST_CODE_ID")}));
        }
        contractCost.set("IS_SERVICE_PRODUCT", (Object)1);
        contractCost.set("UNIT_COST", (Object)service.get("UNIT_COST"));
        contractCost.set("UNIT_PRICE", (Object)service.get("UNIT_PRICE"));
        contractCost.set("QUANTITY", (Object)DBSql.getDouble((Connection)conn, (String)("SELECT COUNT(1) as CNT FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID='" + service.get("SERVICE_ID") + "'"), (String)"CNT"));
        contractCost.set("EXTENDED_COST", (Object)DBSql.getDouble((Connection)conn, (String)("SELECT SUM(PERIOD_COST) as COST FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID='" + service.get("SERVICE_ID") + "'"), (String)"COST"));
        contractCost.set("EXTENDED_PRICE", (Object)DBSql.getDouble((Connection)conn, (String)("SELECT SUM(PERIOD_ADJUSTED_PRICE) as PRICE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID='" + service.get("SERVICE_ID") + "'"), (String)"PRICE"));
        if (contractCost.isNew()) {
            contractCost.set("SUB_CATE_ID", (Object)"1314");
            SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_COST", contractCost, contractCost.getBindId(), uc.getUID(), conn);
        } else {
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", contractCost, conn);
        }
        return contractCost.getId();
    }

    private static String LocalDateYYYYMMDD(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static BigDecimal multiply(Object obj1, Object obj2) {
        try {
            if (obj1 == null || obj2 == null) {
                return BigDecimal.ZERO;
            }
            BigDecimal num1 = new BigDecimal(String.valueOf(obj1));
            BigDecimal num2 = new BigDecimal(String.valueOf(obj2));
            BigDecimal result = num1.multiply(num2).setScale(8, RoundingMode.HALF_UP);
            contractServiceLogger.info("Result: " + result);
            return result;
        }
        catch (Exception e) {
            contractServiceLogger.error("multiply--info--\u5931\u8d25\u3002\u3002\u3002" + obj1 + "*" + obj2);
            return BigDecimal.ZERO;
        }
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Number) {
            return new BigDecimal(obj.toString());
        }
        if (obj instanceof String) {
            try {
                return new BigDecimal((String)obj);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal: " + obj, e);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362: " + obj.getClass().getName());
    }

    public static boolean isApproximatelyEqual(Object obj1, Object obj2) {
        BigDecimal bd2;
        BigDecimal bd1 = contractService.toBigDecimal(obj1);
        BigDecimal difference = bd1.subtract(bd2 = contractService.toBigDecimal(obj2)).abs();
        return difference.compareTo(EPSILON) <= 0;
    }

    public BigDecimal GetPeriodRate(String contractPeriod, String servicePeriod) {
        if (Objects.equals(contractPeriod, servicePeriod)) {
            return BigDecimal.valueOf(1L);
        }
        if (contractPeriod.equals("609") || servicePeriod.equals("609")) {
            return BigDecimal.valueOf(0L);
        }
        int ctt = this.GetPeriodMonth(contractPeriod);
        int svc = this.GetPeriodMonth(servicePeriod);
        if (ctt == 0 || svc == 0) {
            return BigDecimal.valueOf(0L);
        }
        BigDecimal cttDecimal = BigDecimal.valueOf(ctt);
        BigDecimal svcDecimal = BigDecimal.valueOf(svc);
        return cttDecimal.divide(svcDecimal, 8, RoundingMode.HALF_UP);
    }

    public Map<String, Object> getFirstPeriodDate(LocalDate contractStart, LocalDate contractEnd, LocalDate serviceEffect, String contractPeriod, String servicePeriod) {
        HashMap<String, Object> dto = new HashMap<String, Object>();
        int cttPeriod = this.GetPeriodMonth(contractPeriod);
        int svcPeriod = this.GetPeriodMonth(servicePeriod);
        LocalDate start = contractStart;
        if (serviceEffect.isBefore(start)) {
            dto.put("periodStart", serviceEffect);
            dto.put("periodEnd", start.minusDays(1L));
            dto.put("isStartOfPeriod", false);
            return dto;
        }
        while (!start.isAfter(contractEnd)) {
            LocalDate end = contractService.getNextPeriodStart(start, contractPeriod).minusDays(1L);
            if (!serviceEffect.isBefore(start) && !serviceEffect.isAfter(end)) {
                LocalDate periodEnd;
                if (end.isAfter(contractEnd)) {
                    end = contractEnd;
                }
                if ((periodEnd = svcPeriod > cttPeriod ? contractService.getNextPeriodStart(start, servicePeriod).minusDays(1L) : end).isAfter(contractEnd)) {
                    periodEnd = contractEnd;
                }
                dto.put("periodStart", start);
                dto.put("periodEnd", periodEnd);
                dto.put("isStartOfPeriod", start.isEqual(serviceEffect));
                return dto;
            }
            start = end.plusDays(1L);
        }
        dto.put("periodStart", LocalDate.MIN);
        dto.put("periodEnd", LocalDate.MIN);
        dto.put("isStartOfPeriod", false);
        return dto;
    }

    private int GetPeriodMonth(String period) {
        switch (period) {
            case "610": {
                return 1;
            }
            case "611": {
                return 3;
            }
            case "612": {
                return 6;
            }
            case "613": {
                return 12;
            }
        }
        return 0;
    }

    public static LocalDate getNextPeriodStart(LocalDate start, String periodType) {
        switch (periodType) {
            case "610": {
                return start.plus(1L, ChronoUnit.MONTHS);
            }
            case "611": {
                return start.plus(3L, ChronoUnit.MONTHS);
            }
            case "612": {
                return start.plus(6L, ChronoUnit.MONTHS);
            }
            case "613": {
                return start.plus(1L, ChronoUnit.YEARS);
            }
        }
        return start;
    }

    public static LocalDate getPreviousPeriodStart(LocalDate end, String periodType) {
        switch (periodType) {
            case "610": {
                return end.minus(1L, ChronoUnit.MONTHS);
            }
            case "611": {
                return end.minus(3L, ChronoUnit.MONTHS);
            }
            case "612": {
                return end.minus(6L, ChronoUnit.MONTHS);
            }
            case "613": {
                return end.minus(1L, ChronoUnit.YEARS);
            }
        }
        return end;
    }

    public static LocalDate getLocalDate(Object obj) {
        try {
            if (obj == null) {
                return null;
            }
            if (obj instanceof LocalDate) {
                return (LocalDate)obj;
            }
            if (obj instanceof String) {
                if (StringUtils.isBlank((CharSequence)obj.toString())) {
                    return null;
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                contractServiceLogger.info("getLocalDate" + obj.toString());
                return LocalDate.parse(obj.toString(), formatter);
            }
            if (obj instanceof Date) {
                return ((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            }
            contractServiceLogger.info("Invalid object type: " + obj.getClass().getName());
            return null;
        }
        catch (Exception e) {
            contractServiceLogger.info("getLocalDate" + e.getMessage());
            return null;
        }
    }

    public static int GetPeriodDays(LocalDate start, LocalDate end) {
        return (int)ChronoUnit.DAYS.between(start, end) + 1;
    }

    public static BigDecimal divideToBigDecimal(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("\u5206\u6bcd\u4e0d\u80fd\u4e3a\u96f6");
        }
        BigDecimal num = new BigDecimal(numerator);
        BigDecimal den = new BigDecimal(denominator);
        return num.divide(den, 10, RoundingMode.HALF_UP);
    }

    public boolean ContractExcManage(UserContext uc, String bindid) {
        BO bo;
        RowMap rowMap = DBSql.getMap((String)"SELECT ID,BINDID,EXCLUSION_CONTRACT_ID,EXCLUSION_COST_CODE,EXCLUSION_ROLE FROM BO_EU_DNCTT_CONTRACT WHERE BINDID= ?", (Object[])new Object[]{bindid});
        String exclusionContractId = rowMap.getString("EXCLUSION_CONTRACT_ID");
        String exclusionCostCode = rowMap.getString("EXCLUSION_COST_CODE");
        String exclusionRole = rowMap.getString("EXCLUSION_ROLE");
        if (StringUtils.isBlank((CharSequence)exclusionCostCode)) {
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_COST_CODE WHERE BINDID = ? OR CONTRACT_ID=?", (Object[])new Object[]{rowMap.getString("ID"), rowMap.getString("BINDID")});
        } else {
            String[] exclusionCostCodeArr;
            for (String costCode : exclusionCostCodeArr = exclusionCostCode.split(",")) {
                bo = new BO();
                bo.set("BINDID", (Object)rowMap.getString("BINDID"));
                bo.set("CONTRACT_ID", (Object)rowMap.getString("ID"));
                bo.set("COST_CODE_ID", (Object)costCode);
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_EXCLUSION_COST_CODE", bo, uc);
            }
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_COST_CODE WHERE (BINDID = ? OR CONTRACT_ID=?) AND COST_CODE_ID NOT IN (?)", (Object[])new Object[]{rowMap.getString("BINDID"), rowMap.getString("ID"), exclusionCostCode});
        }
        if (StringUtils.isBlank((CharSequence)exclusionRole)) {
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_ROLE WHERE BINDID = ? OR CONTRACT_ID=?", (Object[])new Object[]{rowMap.getString("BINDID"), rowMap.getString("ID")});
        } else {
            String[] exclusionRoleArr;
            for (String role : exclusionRoleArr = exclusionRole.split(",")) {
                bo = new BO();
                bo.set("BINDID", (Object)rowMap.getString("BINDID"));
                bo.set("CONTRACT_ID", (Object)rowMap.getString("ID"));
                bo.set("ROLE_ID", (Object)role);
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_EXCLUSION_ROLE", bo, uc);
            }
            DBSql.update((String)"DELETE FROM BO_EU_DNCTT_CONTRACT_EXCLUSION_ROLE WHERE (BINDID = ? OR CONTRACT_ID=?) AND ROLE_ID NOT IN (?)", (Object[])new Object[]{rowMap.getString("BINDID"), rowMap.getString("ID"), exclusionRole});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postRecurringServices(UserContext uc, String approveDate, String approveIds) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String approveId : approveIds.split(",")) {
                BO cad = new BO();
                String TAX_CATEGORY_ID = null;
                String CONTRACT_SERVICE_ID = null;
                String CONTRACT_ID = null;
                String ORGID = uc.getCompanyModel().getId();
                BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", approveId);
                if (bo != null) {
                    CONTRACT_ID = bo.getId();
                    bo.set("APPROVE_AND_POST_DATE", (Object)approveDate);
                    bo.set("SETUP_FEE_APPROVE_POST_USER_ID", (Object)uc.getUID());
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", bo, connUpdate);
                    cad.set("TYPE_ID", (Object)1327);
                    cad.set("OBJECT_ID", (Object)approveId);
                    cad.set("CONTRACT_ID", (Object)approveId);
                    cad.set("QUANTITY", (Object)1);
                    cad.set("BILL_CREATE_USER_ID", (Object)bo.getCreateUser());
                    cad.set("ACCOUNT_ID", (Object)bo.getString("ACCOUNT_ID"));
                    cad.set("BILL_ACCOUNT_ID", (Object)bo.getString("BILL_TO_ACCOUNT_ID"));
                    cad.set("EXTENDED_PRICE", bo.get("ADJUST_SETUP_FEE"));
                    if (StringUtils.isNotBlank((CharSequence)bo.getString("SETUP_FEE_COST_CODE_ID"))) {
                        TAX_CATEGORY_ID = DBSql.getString((String)"select TAX_CATEGORY_ID from BO_EU_DND_COST_CODE where OID=? and ORGID=?", (Object[])new Object[]{bo.getString("SETUP_FEE_COST_CODE_ID"), ORGID});
                    }
                } else {
                    bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", approveId);
                    if (bo != null) {
                        CONTRACT_SERVICE_ID = bo.getString("CONTRACT_SERVICE_ID");
                        CONTRACT_ID = bo.getString("CONTRACT_ID");
                        bo.set("APPROVE_AND_POST_DATE", (Object)approveDate);
                        bo.set("SETUP_FEE_APPROVE_POST_USER_ID", (Object)uc.getUID());
                        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", bo, connUpdate);
                        cad.set("TYPE_ID", (Object)1325);
                        cad.set("OBJECT_ID", (Object)approveId);
                        cad.set("CONTRACT_ID", (Object)bo.getString("CONTRACT_ID"));
                        cad.set("QUANTITY", bo.get("QUANTITY"));
                        cad.set("BILL_CREATE_USER_ID", (Object)bo.getCreateUser());
                        cad.set("ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                        cad.set("BILL_ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT BILL_TO_ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                        cad.set("EXTENDED_PRICE", bo.get("PERIOD_ADJUSTED_PRICE"));
                        String costCodeId = null;
                        costCodeId = bo.getString("OBJECT_TYPE").equals("1") ? DBSql.getString((String)"SELECT COST_CODE_ID FROM BO_EU_DNIVT_SERVICE WHERE ID = ?", (Object[])new Object[]{bo.getString("OBJECT_ID")}) : DBSql.getString((String)"SELECT COST_CODE_ID FROM BO_EU_DNIVT_SERVICE_BUNDLE WHERE ID = ?", (Object[])new Object[]{bo.getString("OBJECT_ID")});
                        String taxCategoryId = DBSql.getString((String)"select TAX_CATEGORY_ID from BO_EU_DND_COST_CODE where OID=? and ORGID=?", (Object[])new Object[]{costCodeId, ORGID});
                        if (taxCategoryId != null) {
                            TAX_CATEGORY_ID = taxCategoryId.toString();
                        }
                    }
                }
                if (StringUtils.isNotBlank(CONTRACT_SERVICE_ID)) {
                    TAX_CATEGORY_ID = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE", CONTRACT_SERVICE_ID, "IS_CTRTAX_APPLIED").equals("1") ? SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", CONTRACT_ID, "TAX_CATEGORY_ID").toString() : SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE", CONTRACT_SERVICE_ID, "TAX_CATEGORY_ID").toString();
                }
                RowMap ca = DBSql.getMap((String)"select TAX_REGION_ID,IS_TAX_EXEMPT from BO_EU_DNCRM_ACCOUNT where ID=?", (Object[])new Object[]{cad.get("ACCOUNT_ID")});
                String tax_category_name = null;
                String tax_region_name = null;
                double tax_rate = 0.0;
                if (StringUtils.isNotBlank((CharSequence)TAX_CATEGORY_ID)) {
                    tax_category_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{TAX_CATEGORY_ID, uc.getCompanyModel().getId()});
                }
                if (ca.containsKey((Object)"TAX_REGION_ID") && StringUtils.isNotBlank((CharSequence)ca.getString("TAX_REGION_ID"))) {
                    tax_region_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{ca.getString("TAX_REGION_ID"), uc.getCompanyModel().getId()});
                }
                if (tax_category_name != null && tax_region_name != null) {
                    tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID='" + ca.getString("TAX_REGION_ID") + "' AND TAX_CATE_ID='" + TAX_CATEGORY_ID + "' AND ORGID='" + uc.getCompanyModel().getId() + "' "), (String)"TOTAL_EFFECTIVE_TAX_RATE");
                }
                cad.set("POSTED_DATE", (Object)approveDate);
                cad.set("TAX_CATEGORY_NAME", (Object)tax_category_name);
                cad.set("TAX_CATEGORY_ID", (Object)TAX_CATEGORY_ID);
                cad.set("TAX_REGION_ID", (Object)ca.getString("TAX_REGION_ID"));
                cad.set("TAX_REGION_NAME", (Object)tax_region_name);
                cad.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                if (!ca.getString("IS_TAX_EXEMPT").equals("1") && ca.get((Object)"EXTENDED_PRICE") != null && tax_rate > 0.0) {
                    double tax_dollars = (Double)cad.get("EXTENDED_PRICE", Double.class) * (1.0 - 1.0 / (1.0 + tax_rate));
                    cad.set("TAX_DOLLARS", (Object)tax_dollars);
                }
                if (StringUtils.isBlank((CharSequence)cad.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)cad.getString("ACCOUNT_ID"))) {
                    cad.set("BILL_ACCOUNT_ID", cad.get("ACCOUNT_ID"));
                }
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", cad, uc, connUpdate);
                recordFormChanges.record((UserContext)uc, (BO)cad, (String)"\u63d0\u4ea4\u670d\u52a1\u8d39\u8d39\u7528");
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postMilestone(UserContext uc, String approveDate, String approveIds) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String approveId : approveIds.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_MILESTONE", approveId);
                if (bo == null) continue;
                bo.set("STATUS_ID", (Object)1267);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_MILESTONE", bo, connUpdate);
                BO cad = new BO();
                cad.set("TYPE_ID", (Object)1323);
                String TAX_CATEGORY_ID = null;
                TAX_CATEGORY_ID = bo.getString("IS_CTRTAX_APPLIED").equals("1") ? SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", bo.getString("CONTRACT_ID"), "TAX_CATEGORY_ID").toString() : DBSql.getString((String)"SELECT TAX_CATEGORY_ID FROM BO_EU_DND_COST_CODE WHERE ID=?", (Object[])new Object[]{bo.getString("COST_CODE_ID")});
                cad.set("OBJECT_ID", (Object)approveId);
                cad.set("TAX_CATEGORY_ID", (Object)TAX_CATEGORY_ID);
                cad.set("TAX_CATEGORY_NAME", (Object)DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{TAX_CATEGORY_ID, uc.getCompanyModel().getId()}));
                cad.set("TAX_REGION_ID", (Object)DBSql.getString((String)"SELECT TAX_REGION_ID FROM BO_EU_DNCRM_ACCOUNT WHERE ID=(SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID=?)", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                cad.set("TAX_REGION_NAME", (Object)DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{cad.get("TAX_REGION_ID"), uc.getCompanyModel().getId()}));
                cad.set("ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID=?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                cad.set("BILL_ACCOUNT_ID", (Object)DBSql.getString((String)"SELECT BILL_TO_ACCOUNT_ID FROM BO_EU_DNCTT_CONTRACT WHERE ID = ?", (Object[])new Object[]{bo.getString("CONTRACT_ID")}));
                cad.set("POSTED_DATE", (Object)approveDate);
                cad.set("CONTRACT_ID", bo.get("CONTRACT_ID"));
                double tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID='" + cad.getString("TAX_REGION_ID") + "' AND TAX_CATE_ID='" + TAX_CATEGORY_ID + "' "), (String)"TOTAL_EFFECTIVE_TAX_RATE");
                cad.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                cad.set("EXTENDED_PRICE", bo.get("DOLLARS"));
                if (tax_rate > 0.0 && cad.get("EXTENDED_PRICE") != null && DBSql.getInt((String)"select COUNT(1) cnt from BO_EU_DNCRM_ACCOUNT WHERE ID=? AND IS_TAX_EXEMPT<>1 ", (Object[])new Object[]{cad.getString("ACCOUNT_ID")}) > 0) {
                    double tax_dollars = (Double)cad.get("EXTENDED_PRICE", Double.class) - (1.0 - 1.0 / (1.0 + tax_rate));
                    cad.set("TAX_DOLLARS", (Object)tax_dollars);
                }
                if (StringUtils.isBlank((CharSequence)cad.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)cad.getString("ACCOUNT_ID"))) {
                    cad.set("BILL_ACCOUNT_ID", cad.get("ACCOUNT_ID"));
                }
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", cad, uc, connUpdate);
                recordFormChanges.record((UserContext)uc, (BO)cad, (String)"\u5ba1\u6279\u63d0\u4ea4\u91cc\u7a0b\u7891");
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postCost(UserContext uc, String approveDate, String approveIds) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String approveId : approveIds.split(",")) {
                BO ccc = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", approveId);
                BO cc = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", ccc.getString("CONTRACT_ID"));
                BO ca = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT", ccc.getString("ACCOUNT_ID"));
                String tax_category_name = null;
                String tax_region_name = null;
                double tax_rate = 0.0;
                String TAX_CATEGORY_ID = null;
                TAX_CATEGORY_ID = ccc.getString("IS_CTRTAX_APPLIED").equals("1") ? SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", ccc.getString("CONTRACT_ID"), "TAX_CATEGORY_ID").toString() : ccc.getString("TAX_CATEGORY_ID");
                if (StringUtils.isNotBlank((CharSequence)TAX_CATEGORY_ID)) {
                    tax_category_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{TAX_CATEGORY_ID, uc.getCompanyModel().getId()});
                }
                if (ca.get("TAX_REGION_ID") != null) {
                    tax_region_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{ca.get("TAX_REGION_ID"), uc.getCompanyModel().getId()});
                }
                if (StringUtils.isNotBlank((CharSequence)TAX_CATEGORY_ID) && ca.get("TAX_REGION_ID") != null) {
                    tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID='" + ca.getString("TAX_REGION_ID") + "' AND TAX_CATE_ID='" + TAX_CATEGORY_ID + "' "), (String)"TOTAL_EFFECTIVE_TAX_RATE");
                }
                BO cad = new BO();
                cad.set("OBJECT_ID", (Object)ccc.getString("ID"));
                cad.set("TYPE_ID", (Object)1321);
                cad.set("POSTED_DATE", (Object)contractService.getLocalDate(approveDate));
                cad.set("BILL_ACCOUNT_ID", (Object)cc.getString("BILL_ACCOUNT_ID"));
                cad.set("TASK_ID", (Object)ccc.getString("TASK_ID"));
                cad.set("CONTRACT_ID", (Object)ccc.getString("CONTRACT_ID"));
                cad.set("BILL_CREATE_USER_ID", (Object)ccc.getCreateUser());
                cad.set("ACCOUNT_ID", (Object)ca.getString("ID"));
                cad.set("QUANTITY", ccc.get("QUANTITY"));
                cad.set("TAX_CATEGORY_NAME", (Object)tax_category_name);
                cad.set("TAX_REGION_NAME", (Object)tax_region_name);
                cad.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                cad.set("PURCHASE_ORDER_NO", (Object)ccc.getString("PURCHASE_ORDER_NO"));
                cad.set("EXTENDED_COST", (Object)contractService.multiply(ccc.get("UNIT_COST"), ccc.get("QUANTITY")));
                cad.set("EXTENDED_PRICE", ccc.get("EXTENDED_PRICE"));
                if (!ca.getString("IS_TAX_EXEMPT").equals("1") && tax_rate > 0.0 && cad.get("EXTENDED_PRICE") != null) {
                    double tax_dollars = (Double)cad.get("EXTENDED_PRICE", Double.class) - (1.0 - 1.0 / (1.0 + tax_rate));
                    cad.set("TAX_DOLLARS", (Object)tax_dollars);
                }
                if (StringUtils.isBlank((CharSequence)cad.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)cad.getString("ACCOUNT_ID"))) {
                    cad.set("BILL_ACCOUNT_ID", cad.get("ACCOUNT_ID"));
                }
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", cad, uc, connUpdate);
                recordFormChanges.record((UserContext)uc, (BO)cad, (String)"\u5ba1\u6279\u5e76\u63d0\u4ea4\u5408\u540c\u4ea7\u54c1");
                ccc.set("BILL_STATUS", (Object)"1");
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", ccc, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String revokeRecurringServices(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                if (StringUtils.isNotBlank((CharSequence)bo.getString("INVOICE_ID")) && DBSql.getString((String)"select IS_VOIDED from BO_EU_DNCTT_INVOICE where ID=?", (Object[])new Object[]{bo.getString("INVOICE_ID")}).equals("1")) {
                    throw new RuntimeException("\u8be5\u670d\u52a1\u5df2\u7ecf\u751f\u6210\u53d1\u7968\uff0c\u8bf7\u5148\u5220\u9664\u53d1\u7968");
                }
                if (bo.get("TYPE_ID").equals(1325)) {
                    BO ccsp = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").addQuery("CONTRACT_ID =", (Object)bo.getString("CONTRACT_ID"))).addQuery("ID =", (Object)bo.getString("OBJECT_ID"))).detail();
                    ccsp.set("APPROVE_AND_POST_DATE", null);
                    ccsp.set("APPROVE_AND_POST_USER_ID", null);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", ccsp, connUpdate);
                } else if (bo.get("TYPE_ID").equals(1327)) {
                    BO ccc = (BO)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT").addQuery("ID =", (Object)bo.getString("CONTRACT_ID"))).detail();
                    ccc.set("SETUP_FEE_APPROVE_AND_POST_USER_ID", null);
                    ccc.set("SETUP_FEE_APPROVE_AND_POST_DATE", null);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", ccc, connUpdate);
                }
                bo.set("CLOSED", (Object)1);
                recordFormChanges.record((UserContext)uc, (BO)bo, (String)"\u64a4\u9500\u5b9a\u671f\u670d\u52a1");
                SDK.getBOAPI().remove("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo.getId(), connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String revokeMilestones(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                if (bo.get("TYPE_ID").equals(1323)) {
                    BO ccm = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_MILESTONES").addQuery("CONTRACT_ID =", (Object)bo.getString("CONTRACT_ID"))).addQuery("ID =", (Object)bo.getString("OBJECT_ID"))).detail();
                    ccm.set("STATUS_ID", (Object)1266);
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_MILESTONES", ccm, connUpdate);
                }
                bo.set("CLOSED", (Object)1);
                recordFormChanges.record((UserContext)uc, (BO)bo, (String)"\u64a4\u9500\u91cc\u7a0b\u7891\u5ba1\u6279");
                SDK.getBOAPI().remove("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo.getId(), connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String revokeCost(UserContext uc, String ids) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String id : ids.split(",")) {
                BO bo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", id);
                bo.set("CLOSED", (Object)1);
                recordFormChanges.record((UserContext)uc, (BO)bo, (String)"\u64a4\u9500\u6210\u672c\u5ba1\u6279");
                SDK.getBOAPI().remove("BO_EU_DNCRM_ACCOUNT_DEDUCTION", bo.getId(), connUpdate);
                BO ccc = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", bo.getString("OBJECT_ID"));
                ccc.set("BILL_STATUS", (Object)0);
                ccc.set("EXTENDED_PRICE", (Object)contractService.multiply(ccc.get("UNIT_PRICE"), ccc.get("QUANTITY")));
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", ccc, connUpdate);
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            String string = e.getMessage();
            return string;
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return null;
    }

    public static Double GetRateByCodeAndRole(String cost_code_id, String role_id) {
        Double rate = null;
        RowMap thisCostCode = DBSql.getMap((String)"SELECT * FROM BO_EU_DND_COST_CODE WHERE ID=?", (Object[])new Object[]{cost_code_id});
        RowMap thisRole = DBSql.getMap((String)"SELECT * FROM BO_EU_DNSYS_ROLE WHERE ID=?", (Object[])new Object[]{role_id});
        if (thisCostCode != null && thisRole != null) {
            switch (thisCostCode.getString("BILLING_METHOD_ID")) {
                case "2166": {
                    rate = thisRole.getDouble("hourly_rate");
                    break;
                }
                case "2167": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("RATE_ADJUSTMENT"))) break;
                    rate = thisRole.getDouble("hourly_rate") + thisCostCode.getDouble("RATE_ADJUSTMENT");
                    break;
                }
                case "2168": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("RATE_MULTIPLIER"))) break;
                    rate = thisRole.getDouble("hourly_rate") * thisCostCode.getDouble("RATE_MULTIPLIER");
                    break;
                }
                case "2169": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("CUSTOM_RATE"))) break;
                    rate = thisCostCode.getDouble("CUSTOM_RATE");
                    break;
                }
                case "2170": {
                    if (!StringUtils.isNotBlank((CharSequence)thisCostCode.getString("FLAT_RATE"))) break;
                    rate = thisCostCode.getDouble("FLAT_RATE");
                    break;
                }
            }
        }
        return rate;
    }

    public static Double GetEntryCost(String id) {
        return DBSql.getDouble((String)("SELECT( IFNULL(( SELECT rate FROM BO_EU_DNCTT_CONTRACT_INTERNAL_COST WHERE contract_id = p.contract_id AND resource_id = p.resource_id AND role_id = p.role_id LIMIT 1), ( SELECT hourly_rate FROM bo_eu_dnsys_resource_internal_cost WHERE resource_id = p.resource_id AND IFNULL(start_date, '1970-01-01') <= FROM_UNIXTIME(p.start_time / 1000) AND IFNULL(end_date, '9999-01-01') > FROM_UNIXTIME(p.start_time / 1000)) ) * p.hours_billed ) AS COST FROM bo_eu_dnsdk_work_entry p JOIN bo_eu_dnd_cost_code cc ON p.cost_code_id = cc.id JOIN bo_eu_dnsdk_task t ON p.task_id = t.id LEFT JOIN bo_eu_dnctt_contract c ON p.contract_id = c.id WHERE p.id = '" + id + "'"), (String)"COST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean approveCommission(UserContext uc, String approveDate, String approveIds) throws SQLException {
        Connection connUpdate = null;
        try {
            connUpdate = DBSql.open();
            connUpdate.setAutoCommit(false);
            for (String approveId : approveIds.split(",")) {
                BO cad = new BO();
                String TAX_CATEGORY_ID = null;
                String ORGID = uc.getCompanyModel().getId();
                RowMap period = DBSql.getMap((String)"select * from BO_EU_DNCTT_COMMISSION_PERIOD where ID=?", (Object[])new Object[]{approveId});
                if (period != null) {
                    DBSql.update((Connection)connUpdate, (String)"update BO_EU_DNCTT_COMMISSION_PERIOD set APPROVE_AND_POST_DATE=?,APPROVE_AND_POST_USER_ID=? where ID=?", (Object[])new Object[]{approveDate, uc.getUID(), approveId});
                    cad.set("TYPE_ID", (Object)1328);
                    cad.set("OBJECT_ID", (Object)approveId);
                    cad.set("CONTRACT_ID", (Object)approveId);
                    cad.set("QUANTITY", (Object)1);
                    cad.set("BILL_CREATE_USER_ID", (Object)period.getString("CREATEUSER"));
                    String ISP = DBSql.getString((Connection)connUpdate, (String)"select ISP from BO_EU_DNCTT_COMMISSION where BINDID=?", (Object[])new Object[]{period.getString("BINDID")});
                    cad.set("ACCOUNT_ID", (Object)ISP);
                    cad.set("BILL_ACCOUNT_ID", (Object)ISP);
                    cad.set("EXTENDED_PRICE", period.get((Object)"PERIOD_ADJUSTED_PRICE"));
                    if (StringUtils.isNotBlank((CharSequence)period.getString("COST_CODE_ID"))) {
                        TAX_CATEGORY_ID = DBSql.getString((String)"select TAX_CATEGORY_ID from BO_EU_DND_COST_CODE where OID=? and ORGID=?", (Object[])new Object[]{period.getString("COST_CODE_ID"), ORGID});
                    }
                }
                RowMap ca = DBSql.getMap((String)"select TAX_REGION_ID,IS_TAX_EXEMPT from BO_EU_DNCRM_ACCOUNT where ID=?", (Object[])new Object[]{cad.get("ACCOUNT_ID")});
                String tax_category_name = null;
                String tax_region_name = null;
                double tax_rate = 0.0;
                if (StringUtils.isNotBlank(TAX_CATEGORY_ID)) {
                    tax_category_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{TAX_CATEGORY_ID, uc.getCompanyModel().getId()});
                }
                if (ca != null && ca.containsKey((Object)"TAX_REGION_ID") && StringUtils.isNotBlank((CharSequence)ca.getString("TAX_REGION_ID"))) {
                    tax_region_name = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{ca.getString("TAX_REGION_ID"), uc.getCompanyModel().getId()});
                }
                if (ca != null && tax_category_name != null && tax_region_name != null) {
                    tax_rate = DBSql.getDouble((String)("SELECT TOTAL_EFFECTIVE_TAX_RATE FROM BO_EU_DND_TAX_REGION_CATE WHERE TAX_REGION_ID='" + ca.getString("TAX_REGION_ID") + "' AND TAX_CATE_ID='" + TAX_CATEGORY_ID + "' AND ORGID='" + uc.getCompanyModel().getId() + "' "), (String)"TOTAL_EFFECTIVE_TAX_RATE");
                }
                cad.set("POSTED_DATE", (Object)approveDate);
                cad.set("TAX_CATEGORY_NAME", tax_category_name);
                cad.set("TAX_CATEGORY_ID", TAX_CATEGORY_ID);
                if (ca != null) {
                    cad.set("TAX_REGION_ID", (Object)ca.getString("TAX_REGION_ID"));
                }
                cad.set("TAX_REGION_NAME", tax_region_name);
                cad.set("EFFECTIVE_TAX_RATE", (Object)tax_rate);
                if (ca != null && !ca.getString("IS_TAX_EXEMPT").equals("1") && ca.get((Object)"EXTENDED_PRICE") != null && tax_rate > 0.0) {
                    double tax_dollars = (Double)cad.get("EXTENDED_PRICE", Double.class) * (1.0 - 1.0 / (1.0 + tax_rate));
                    cad.set("TAX_DOLLARS", (Object)tax_dollars);
                }
                if (StringUtils.isBlank((CharSequence)cad.getString("BILL_ACCOUNT_ID")) && StringUtils.isNotBlank((CharSequence)cad.getString("ACCOUNT_ID"))) {
                    cad.set("BILL_ACCOUNT_ID", cad.get("ACCOUNT_ID"));
                }
                SDK.getBOAPI().createDataBO("BO_EU_DNCRM_ACCOUNT_DEDUCTION", cad, uc, connUpdate);
                recordFormChanges.record((UserContext)uc, (BO)cad, (String)"\u63d0\u4ea4\u4f63\u91d1");
            }
            connUpdate.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (connUpdate != null && !connUpdate.isClosed()) {
                try {
                    connUpdate.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        finally {
            if (connUpdate != null && !connUpdate.isClosed()) {
                DBSql.close((Connection)connUpdate);
            }
        }
        return true;
    }

    static {
        SDK.getLogAPI();
        contractServiceLogger = LogAPI.getLogger(contractService.class);
        EPSILON = new BigDecimal("0.00001");
    }
}

