/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTeamsByNetwork
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryTeamsByNetwork.class);

    @Meta(parameter={"name: 'networkId', required: true, desc: '\u5de5\u4f5c\u7f51\u7edcID'", "name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            int limit;
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String networkId = (String)params.get("networkId");
            String userId = ctx.getUID();
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int n = limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            if (UtilString.isEmpty((String)networkId) && UtilString.isEmpty((String)userId)) {
                ro = ResponseObject.newErrResponse();
                ro.err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528");
                return ro;
            }
            if (!NetworkDataUtil.havingNetworkPermission(networkId, userId)) {
                ro.err("\u6743\u9650\u4e0d\u8db3");
                return ro;
            }
            List<NetworkTeamModel> teamList = NetworkTeamCache.loadNetworkTeamBy(networkId);
            UtilListSort listSort = new UtilListSort();
            listSort.sort(teamList, "teamName", "asc");
            if (limit > 0) {
                Page<NetworkTeamModel> page = new Page<NetworkTeamModel>(start, limit, teamList);
                teamList = page.getListModel();
                ro.put("start", (Object)page.getStart());
                ro.put("limit", (Object)page.getLimit());
                ro.put("pageCount", (Object)page.getPageCount());
            }
            JSONArray teams = NetworkDataUtil.team2JSON(teamList, ctx, true);
            ro.put("teams", (Object)teams);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

