/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStreamOfMyPraise
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStreamOfMyPraise.class);

    @Meta(parameter={"name: 'userId', required: true, desc: '\u88ab\u8868\u626c\u4eba'", "name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String userId = params.get("userId").toString();
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            List<NetworkStreamModel> streamList = NetworkStreamCache.loadStreamOfPraiseUser(userId);
            if (limit > 0) {
                Page<NetworkStreamModel> page = new Page<NetworkStreamModel>(start, limit, streamList);
                streamList = page.getListModel();
                ro.put("start", (Object)page.getStart());
                ro.put("limit", (Object)page.getLimit());
                ro.put("pageCount", (Object)page.getPageCount());
            }
            JSONArray teams = NetworkDataUtil.stream2JSONOfOriginal(streamList, ctx);
            ro.put("streams", (Object)teams);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

