/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTeamMemberDao
extends DaoObject<NetworkTeamMemberModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkTeamMemberDao.class);

    public List<NetworkTeamMemberModel> loadNetworkTeamMemberOfCache() {
        List<NetworkTeamMemberModel> list = new ArrayList<NetworkTeamMemberModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_TEAM_MEMBER");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamMemberModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public boolean clearTeamMember(String id) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append("APP_ACT_NETWORK_TEAM_MEMBER").append(" where id=:id");
        params.put("id", id);
        return DBSql.update((String)sql.toString(), params) > 0;
    }

    public List<NetworkTeamMemberModel> loadTeamMemberList(String teamId, String searchValue) throws SQLException {
        LinkedList<NetworkTeamMemberModel> list = new LinkedList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append("APP_ACT_NETWORK_TEAM_MEMBER").append(" where teamId = '").append(teamId).append("' and userId like '%").append(searchValue).append("%' order by createtime desc ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkTeamMemberModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public NetworkTeamMemberModel getTeamMemberById(String id) throws SQLException {
        NetworkTeamMemberModel model = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append("APP_ACT_NETWORK_TEAM_MEMBER").append(" where id = ? ");
            model = (NetworkTeamMemberModel)((Object)DBSql.getObject((String)sql.toString(), (RowMapper)new NetworkTeamMemberModelRowMapper(), (Object[])new Object[]{id}));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return model;
    }

    public String entityName() {
        return "APP_ACT_NETWORK_TEAM_MEMBER";
    }

    public int insert(NetworkTeamMemberModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("TEAMID", model.getTeamId());
        paramsMap.put("MEMBERTYPE", model.getMemberType());
        paramsMap.put("JOINTYPE", model.getJoinType());
        paramsMap.put("JOINSTATUS", model.getJoinStatus());
        paramsMap.put("MEMBERSTATUS", model.getMemberStatus());
        paramsMap.put("USERID", model.getUserId());
        paramsMap.put("CREATETIME", model.getCreateTime());
        paramsMap.put("CREATEUSERID", model.getCreateUserId());
        paramsMap.put("CREATEUSERNAME", model.getCreateUserName());
        if (model.getLastActive() != null) {
            paramsMap.put("LASTACTIVE", model.getLastActive());
        }
        int result = DBSql.update((String)DBSql.getInsertStatement((String)"APP_ACT_NETWORK_TEAM_MEMBER", paramsMap), paramsMap);
        return result;
    }

    public RowMapper<NetworkTeamMemberModel> rowMapper() {
        return null;
    }

    public int update(NetworkTeamMemberModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("MEMBERTYPE", model.getMemberType());
        paramsMap.put("JOINTYPE", model.getJoinType());
        paramsMap.put("JOINSTATUS", model.getJoinStatus());
        paramsMap.put("MEMBERSTATUS", model.getMemberStatus());
        paramsMap.put("USERID", model.getUserId());
        paramsMap.put("TEAMID", model.getTeamId());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        return super.update((Object)model.getId(), paramsMap);
    }

    private static class NetworkTeamMemberModelRowMapper
    implements RowMapper<NetworkTeamMemberModel> {
        private NetworkTeamMemberModelRowMapper() {
        }

        public NetworkTeamMemberModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkTeamMemberModel model = new NetworkTeamMemberModel();
            model.setId(rs.getString("ID"));
            model.setTeamId(rs.getString("TEAMID"));
            model.setUserId(rs.getString("USERID"));
            model.setMemberType(rs.getString("MEMBERTYPE"));
            model.setJoinType(rs.getString("JOINTYPE"));
            model.setJoinStatus(rs.getString("JOINSTATUS"));
            model.setMemberStatus(rs.getString("MEMBERSTATUS"));
            model.setCreateUserId(rs.getString("CREATEUSERID"));
            model.setCreateUserName(rs.getString("CREATEUSERNAME"));
            model.setCreateTime(rs.getTimestamp("CREATETIME"));
            model.setLastActive(rs.getTimestamp("LASTACTIVE"));
            return model;
        }
    }
}

