/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkTopicCache;
import com.actionsoft.apps.network.model.NetworkTopicModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilListSort;
import com.alibaba.fastjson.JSONArray;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMyTopics
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryMyTopics.class);

    @Meta(parameter={"name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            List<NetworkTopicModel> topicList = NetworkTopicCache.loadTopicOfUser(ctx.getUID());
            UtilListSort sortList = new UtilListSort();
            sortList.sort(topicList, "topicName", "asc");
            sortList.sort(topicList, "topicCount", "desc");
            if (limit > 0) {
                Page<NetworkTopicModel> page = new Page<NetworkTopicModel>(start, limit, topicList);
                topicList = page.getListModel();
                ro.put("start", (Object)page.getStart());
                ro.put("limit", (Object)page.getLimit());
                ro.put("pageCount", (Object)page.getPageCount());
            }
            JSONArray topics = NetworkDataUtil.topic2JSON(topicList, ctx);
            ro.put("topics", (Object)topics);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

