/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.cache.NetworkStreamCommentCache;
import com.actionsoft.apps.network.model.NetworkStreamCommentModel;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.notification.NetworkNotification;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.ORGAPI;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyStream
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplyStream.class);

    @Meta(parameter={"name: 'message', required: true, desc: '\u6d88\u606f\u5185\u5bb9'", "name: 'streamId', required: true, desc:'\u6d88\u606f\u6d41ID'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            AppContext app = (AppContext)params.get("caller");
            String sid = params.get("sid").toString();
            String message = params.get("message").toString();
            String streamId = params.get("streamId").toString();
            UserContext ctx = UserContext.fromSessionId((String)sid);
            ORGAPI orgApi = SDK.getORGAPI();
            NetworkStreamCommentModel model = new NetworkStreamCommentModel();
            model.setId(UUIDGener.getUUID());
            model.setStreamId(streamId);
            model.setCommentId("");
            model.setCommentContent(message);
            model.setCommentType("3");
            model.setAttached("0");
            model.setIpAddress(ctx.getClientIP());
            model.setDeviceType(app.getName());
            model.setCreateUserId(ctx.getUID());
            model.setCreateUserName(ctx.getUserName());
            model.setCreateTime(new Timestamp(System.currentTimeMillis()));
            NetworkStreamCommentCache.putModel(model);
            NetworkNotification networkNotification = new NetworkNotification();
            NetworkStreamModel stream = NetworkStreamCache.getModel(streamId);
            JSONObject json = JSONObject.parseObject((String)stream.getStreamContent());
            JSONObject contentJson = new JSONObject();
            contentJson.put("streamId", (Object)streamId);
            contentJson.put("streamCommentId", (Object)model.getId());
            contentJson.put("data", (Object)(orgApi.getUserAliasNames(ctx.getUID()) + "\u56de\u590d\u4e86\u4f60\u7684\u52a8\u6001\uff1a" + message + " //" + json.getString("content")));
            if (!stream.getCreateUserId().equals(ctx.getUID())) {
                networkNotification.dynamicNotification(ctx.getUID(), stream.getCreateUserId(), contentJson, "info", model.getId());
            }
            ro.put("streamCommentId", (Object)model.getId());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro;
    }
}

