/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Controller
public class caiController {
    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryCai")
    public ResponseObject queryOrderByOrderId(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select UNIT_COST_ADD_TAX, ORDER_ID from bo_eu_dnivt_order_product where ORDER_ID = ?";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{orderId});
        if (map == null) {
            return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u91c7\u8d2d\u9879"));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("UNIT_COST_ADD_TAX", map.getString("UNIT_COST_ADD_TAX"));
        result.put("ORDER_ID", map.getString("ORDER_ID"));
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryCount")
    public ResponseObject queryPurchaseItemCount(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select count(*) as item_count from bo_eu_dnivt_order_product where ORDER_ID = ?";
        int itemCount = DBSql.getInt((String)sql, (Object[])new Object[]{orderId});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orderId", orderId);
        result.put("itemCount", itemCount);
        result.put("isSingleItem", itemCount == 1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryPaymentPlan")
    public ResponseObject queryPaymentPlan(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select a.order_id \u91c7\u8d2d\u8ba2\u5355id ,b.PERIOD_END_DATE \u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4, b.PERIOD_COST \u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d from `BO_EU_DNIVT_ORDER_PRODUCT` a join `BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD` b on a.CONTRACT_SERVICE_ID = b.CONTRACT_SERVICE_ID where a.ORDER_ID = ?";
        List rowMaps = DBSql.getMaps((String)sql, (Object[])new Object[]{orderId});
        ArrayList resultList = new ArrayList();
        if (rowMaps != null && !rowMaps.isEmpty()) {
            for (RowMap row : rowMaps) {
                HashMap<String, Object> plan = new HashMap<String, Object>();
                plan.put("order_id", orderId);
                plan.put("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4", row.getString("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4"));
                plan.put("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d", row.getDouble("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d"));
                resultList.add(plan);
            }
        } else {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u8ba1\u5212\u4ed8\u6b3e\u4fe1\u606f\uff0c\u53ef\u5c1d\u8bd5\u65b0\u5efa"));
            responseObject.setData(Collections.emptyList());
            return responseObject;
        }
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryPayAmount")
    public ResponseObject queryPayAmount(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select ORDER_ID \u91c7\u8d2d\u8ba2\u5355id, PAY_AMOUNT \u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d from `BO_EU_DNIVT_ORDER_PAYMENT_PLAN` where ORDER_ID = ?";
        List rowMaps = DBSql.getMaps((String)sql, (Object[])new Object[]{orderId});
        ArrayList resultList = new ArrayList();
        if (rowMaps != null && !rowMaps.isEmpty()) {
            for (RowMap row : rowMaps) {
                HashMap<String, Object> amountInfo = new HashMap<String, Object>();
                amountInfo.put("order_id", orderId);
                amountInfo.put("\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d", row.getDouble("\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d"));
                resultList.add(amountInfo);
            }
        } else {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u5b9e\u9645\u91d1\u989d\u4fe1\u606f\uff0c\u53ef\u5c1d\u8bd5\u65b0\u5efa"));
            responseObject.setData(Collections.emptyList());
            return responseObject;
        }
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.deleteUnpaidPaymentPlan")
    public ResponseObject deleteUnpaidPaymentPlan(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "delete from `BO_EU_DNIVT_ORDER_PAYMENT_PLAN` where ORDER_ID = ? and (PAY_AMOUNT is null or PAY_AMOUNT = 0)";
        int deletedRows = DBSql.update((String)sql, (Object[])new Object[]{orderId});
        if (deletedRows <= 0) {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u5220\u9664\u4fe1\u606f\uff0c\u53ef\u5c1d\u8bd5\u65b0\u5efa"));
            responseObject.setData(Collections.emptyList());
        }
        ArrayList resultList = new ArrayList();
        HashMap<String, Object> deleteInfo = new HashMap<String, Object>();
        deleteInfo.put("order_id", orderId);
        deleteInfo.put("\u5220\u9664\u8bb0\u5f55\u6570", deletedRows);
        resultList.add(deleteInfo);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.createPaymentPlan")
    public ResponseObject createPaymentPlan(UserContext uc, String orderId, String planDate, Double planAmount) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)planDate)) {
            return ResponseObject.newErrResponse((String)"\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ProcessInstance processInstance = SDK.getProcessAPI().createProcessInstance("obj_5cb4ae4a42944fd0a9a284ff4c64c65d", uc.getUID(), "\u4ed8\u6b3e\u8ba1\u5212");
            BO bo = new BO();
            bo.setBindId(processInstance.getId());
            bo.set("ORDER_ID", (Object)orderId);
            bo.set("PLAN_DATE", (Object)planDate);
            bo.set("PLAN_AMOUNT", (Object)planAmount);
            SDK.getBOAPI().createDataBO("BO_EU_DNIVT_ORDER_PAYMENT_PLAN", bo, uc);
            ArrayList resultList = new ArrayList();
            HashMap<String, Object> plan = new HashMap<String, Object>();
            plan.put("order_id", orderId);
            plan.put("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4", planDate);
            plan.put("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d", planAmount);
            plan.put("bindId", processInstance.getId());
            resultList.add(plan);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(resultList);
            return responseObject;
        }
        catch (Exception e) {
            return ResponseObject.newErrResponse((String)("\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

