/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Controller
public class contractCostController {
    private static final Logger logger;

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.costpick")
    public ResponseObject costPick(UserContext uc, String contractCostId, String warehouseProductId) throws SQLException {
        BO newBO = new BO();
        newBO.set("CONTRACT_COST_ID", (Object)contractCostId);
        newBO.set("WAREHOUSE_PRODUCT_ID", (Object)warehouseProductId);
        BO warhouseProductBO = SDK.getBOAPI().get("BO_EU_DNIVT_WAREHOUSE_PRODUCT", warehouseProductId);
        newBO.set("PRODUCT_ID", warhouseProductBO.get("PRODUCT_ID"));
        newBO.set("WAREHOUSE_ID", warhouseProductBO.get("WAREHOUSE_ID"));
        int warehouseProductQuantity = this.ObjToInt(warhouseProductBO.getString("QUANTITY"));
        logger.info("\u5e93\u5b58\u6570\u91cf:" + warehouseProductQuantity);
        int warehouseProductAvailableQuantity = this.ObjToInt(DBSql.getString((String)"SELECT SUM(AVAILABLE) FROM VIEW_EU_DNINVT_PRODUCT_INVENTORY where ID=?", (Object[])new Object[]{warehouseProductId}));
        logger.info("\u53ef\u7528\u5e93\u5b58\u6570\u91cf:" + warehouseProductAvailableQuantity);
        if (warehouseProductAvailableQuantity <= 0) {
            return ResponseObject.newErrResponse((String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3");
        }
        if (warehouseProductQuantity <= 0) {
            return ResponseObject.newErrResponse((String)"\u5e93\u5b58\u6570\u91cf\u4e0d\u8db3");
        }
        if (warehouseProductAvailableQuantity <= warehouseProductQuantity) {
            warehouseProductQuantity = warehouseProductAvailableQuantity;
        }
        int contractCostQuantity = this.ObjToInt(SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", contractCostId, "QUANTITY"));
        logger.info("\u5408\u540c\u4ea7\u54c1\u6570\u91cf:" + contractCostQuantity);
        int contractProductPickQuantity = this.ObjToInt(DBSql.getString((String)"SELECT SUM(QUANTITY) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=?  AND CLOSED=0", (Object[])new Object[]{contractCostId}));
        logger.info("\u5df2\u62e3\u8d27\u6570\u91cf:" + contractProductPickQuantity);
        ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_5670df3b3d164682a9aded38bae2e1be", uc.getUID(), "\u5408\u540c\u4ea7\u54c1\u62e3\u8d27\u5355");
        String binidid = processInstance.getId();
        newBO.setBindId(processInstance.getId());
        int quantity = contractCostQuantity - contractProductPickQuantity;
        if (quantity <= 0) {
            return ResponseObject.newErrResponse((String)"\u65e0\u9700\u62e3\u8d27");
        }
        if (quantity > warehouseProductQuantity) {
            newBO.set("PICK_QUANTITY", (Object)warehouseProductQuantity);
        } else {
            newBO.set("PICK_QUANTITY", (Object)quantity);
        }
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_PRODUCT_PICK", newBO, processInstance, uc);
        ResponseObject ro = this.getPickSNList(uc, processInstance.getId(), warehouseProductId, (Integer)newBO.get("PICK_QUANTITY", Integer.TYPE));
        if (ro.isOk() && ro.getData() != null) {
            DBSql.update((String)"UPDATE BO_EU_DNCTT_CONTRACT_PRODUCT_PICK SET PICKED_SNS=? WHERE BINDID=?", (Object[])new Object[]{ro.getData().toString(), processInstance.getId()});
        }
        String url = SDK.getFormAPI().getFormURL("", uc.getSessionId(), binidid, "", 1, "", "", "");
        url = SDK.getPortalAPI().getPortalUrl() + "/r" + url.substring(1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)url);
        return responseObject;
    }

    private int ObjToInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        String objStr = obj.toString();
        if (objStr.equals("")) {
            return 0;
        }
        if (objStr.contains(".")) {
            objStr = objStr.substring(0, objStr.indexOf("."));
        }
        return Integer.parseInt(objStr);
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.costcanclepick")
    public ResponseObject costCanclePick(UserContext uc, String costProductId) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", costProductId);
        BO newBO = new BO();
        ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_a10ee583a11045d3b0f82f29b81ea1cd", uc.getUID(), "\u5408\u540c\u4ea7\u54c1\u53d6\u6d88\u62e3\u8d27\u5355");
        String binidid = processInstance.getId();
        newBO.setBindId(processInstance.getId());
        newBO.set("PICK_QUANTITY", bo.get("QUANTITY"));
        newBO.set("CONTRACT_COST_ID", bo.get("CONTRACT_COST_ID"));
        newBO.set("WAREHOUSE_ID", bo.get("WAREHOUSE_ID"));
        newBO.set("PRODUCT_ID", (Object)DBSql.getString((String)"SELECT PRODUCT_ID FROM BO_EU_DNCTT_CONTRACT_COST WHERE ID=?", (Object[])new Object[]{bo.get("CONTRACT_COST_ID")}));
        newBO.set("COST_PRODUCT_ID", (Object)bo.getId());
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_PRODUCT_CANCLEPICK", newBO, processInstance, uc);
        String url = SDK.getFormAPI().getFormURL("", uc.getSessionId(), binidid, "", 1, "", "", "");
        url = SDK.getPortalAPI().getPortalUrl() + "/r" + url.substring(1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)url);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.TransferPro")
    public ResponseObject transferPro(UserContext uc, String costProductId) throws SQLException {
        BO bo = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", costProductId);
        BO newBO = new BO();
        ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_855e0ecd2a0e42dfaf45b3d1fff0c710", uc.getUID(), "\u5408\u540c\u4ea7\u54c1\u79fb\u5e93\u5355");
        String binidid = processInstance.getId();
        newBO.setBindId(processInstance.getId());
        newBO.set("QUANTITY", bo.get("QUANTITY"));
        newBO.set("CONTRACT_COST_ID", bo.get("CONTRACT_COST_ID"));
        newBO.set("WAREHOUSE_ID", bo.get("WAREHOUSE_ID"));
        newBO.set("PRODUCT_ID", (Object)DBSql.getString((String)"SELECT PRODUCT_ID FROM BO_EU_DNCTT_CONTRACT_COST WHERE ID=?", (Object[])new Object[]{bo.get("CONTRACT_COST_ID")}));
        newBO.set("COST_PRODUCT_ID", (Object)bo.getId());
        SDK.getBOAPI().create("BO_EU_CTT_CONTRACT_PRODUCT_TRANSFER", newBO, processInstance, uc);
        String url = SDK.getFormAPI().getFormURL("", uc.getSessionId(), binidid, "", 1, "", "", "");
        url = SDK.getPortalAPI().getPortalUrl() + "/r" + url.substring(1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)url);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.getPickSNList")
    public ResponseObject getPickSNList(UserContext uc, String bindid, String warehouseProductId, Integer quantity) {
        SDK.getBOAPI().removeByBindId("BO_EU_DNCTT_CONTRACT_PRODUCT_PICKSN", bindid);
        RowMap stockMap = DBSql.getMap((String)"SELECT * FROM BO_EU_DNIVT_WAREHOUSE_PRODUCT WHERE ID=?", (Object[])new Object[]{warehouseProductId});
        String OUT_RULE = DBSql.getString((String)"SELECT OUT_RULE FROM BO_EU_DNIVT_PRODUCT WHERE ID=?", (Object[])new Object[]{stockMap.getString("PRODUCT_ID")});
        List lotList = DBSql.getMaps((String)("SELECT b.* FROM bo_eu_dnivt_warehouse_product a JOIN BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT b ON a.BINDID=b.BINDID WHERE b.QUANTITY>0 AND a.ID=? ORDER BY b.CREATEDATE " + (OUT_RULE.equals("1032") ? "DESC" : "ASC")), (Object[])new Object[]{warehouseProductId});
        List pickList = DBSql.getMaps((String)"SELECT a.* from BO_EU_DNCTT_CONTRACT_COST_PRODUCT a JOIN BO_EU_DNCTT_CONTRACT_COST b ON a.CONTRACT_COST_ID=b.ID WHERE a.WAREHOUSE_ID=? AND b.PRODUCT_ID=?", (Object[])new Object[]{stockMap.getString("WAREHOUSE_ID"), stockMap.getString("PRODUCT_ID")});
        ArrayList selectedSns = new ArrayList();
        for (RowMap lotMap : lotList) {
            String lotSNs = lotMap.getString("SN");
            if (StringUtils.isBlank((CharSequence)lotSNs)) continue;
            ArrayList<String> lotsns = new ArrayList<String>();
            for (String SN : lotSNs.split(",")) {
                boolean isPicked = false;
                for (RowMap pickMap : pickList) {
                    String pickSNs = pickMap.getString("SN");
                    if (StringUtils.isBlank((CharSequence)pickSNs)) continue;
                    for (String pickSN : pickSNs.split(",")) {
                        if (!SN.equals(pickSN)) continue;
                        isPicked = true;
                        break;
                    }
                    if (!isPicked) continue;
                    break;
                }
                if (isPicked) continue;
                lotsns.add(SN);
            }
            if (lotsns.size() > quantity) {
                for (String sn : lotsns) {
                    BO bo = new BO();
                    bo.set("SN", (Object)sn);
                    bo.setBindId(bindid);
                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_PRODUCT_PICKSN", bo, uc);
                }
                quantity = 0;
            } else {
                quantity = quantity - lotsns.size();
                selectedSns.addAll(lotsns);
            }
            if (quantity > 0) continue;
            break;
        }
        if (quantity > 0) {
            return ResponseObject.newErrResponse((String)"\u8d85\u8fc7\u6700\u5927\u62e3\u8d27\u6570\u91cf");
        }
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)StringUtils.join(selectedSns, (String)","));
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.reAssociatePurchaseOrder")
    public ResponseObject reAssociatePurchaseOrder(UserContext uc, String contractCostId) {
        BO orderProductBO = (BO)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_ORDER_PRODUCT").addQuery("CONTRACT_COST_ID=", (Object)contractCostId)).detail();
        if (orderProductBO == null) {
            return ResponseObject.newErrResponse((String)"\u672a\u627e\u5230\u91c7\u8d2d\u5355");
        }
        if (!DBSql.getString((String)"SELECT STATUS_ID FROM BO_EU_DNIVT_ORDER WHERE ID=?", (Object[])new Object[]{orderProductBO.getString("ORDER_ID")}).equals("2150")) {
            return ResponseObject.newErrResponse((String)"\u91c7\u8d2d\u5355\u672a\u63a5\u6536\uff0c\u8bf7\u5728\u5168\u90e8\u4ea7\u54c1\u63a5\u6536\u540e\u64cd\u4f5c");
        }
        String sns = "";
        int orderQuantity = 0;
        String movePro = "";
        List lots = DBSql.getMaps((String)"SELECT a.SN,a.QUANTITY,b.NAME,b.CATE_ID FROM BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT a JOIN BO_EU_DNIVT_WAREHOUSE b ON a.WAREHOUSE_ID=b.ID WHERE a.ORDER_PRODUCT_ID=?", (Object[])new Object[]{orderProductBO.getId()});
        if (lots.size() > 0) {
            for (Object lot : lots) {
                String SN = lot.getString("SN");
                String NAME = lot.getString("NAME");
                int QUANTITY = lot.getInt("QUANTITY");
                int CATE_ID = lot.getInt("CATE_ID");
                if (CATE_ID != 2) {
                    if (StringUtils.isNotBlank((CharSequence)SN)) {
                        movePro = movePro + "\u4ea7\u54c1\u5e8f\u5217\u53f7\uff1a" + SN + "\uff0c\u6570\u91cf\uff1a" + QUANTITY + "\u5df2\u88ab\u79fb\u52a8\u5230\u4ed3\u5e93" + NAME + "\uff0c";
                        continue;
                    }
                    movePro = movePro + "\u6570\u91cf\uff1a" + QUANTITY + "\u5df2\u88ab\u79fb\u52a8\u5230\u4ed3\u5e93" + NAME + "\uff0c";
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)SN)) {
                    sns = sns + "," + SN;
                }
                orderQuantity += QUANTITY;
            }
            if (StringUtils.isNotBlank((CharSequence)sns)) {
                sns = sns + ",";
            }
            if (orderQuantity <= 0) {
                return ResponseObject.newErrResponse((String)"\u91c7\u8d2d\u5355\u4ea7\u54c1\u5df2\u5168\u90e8\u5173\u8054\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
            }
        } else {
            return ResponseObject.newErrResponse((String)"\u91c7\u8d2d\u5355\u4ea7\u54c1\u5df2\u5168\u90e8\u5173\u8054\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        List costProductList = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_COST_PRODUCT").addQuery("ORDER_ID=", (Object)orderProductBO.getString("ORDER_ID"))).addQuery("CONTRACT_COST_ID=", (Object)orderProductBO.getString("CONTRACT_COST_ID"))).addQuery("CLOSED=", (Object)"0")).list();
        for (BO costProductBO : costProductList) {
            int quantity = Integer.parseInt(costProductBO.get("QUANTITY").toString());
            String sn = costProductBO.getString("SN");
            if (StringUtils.isNotBlank((CharSequence)sns) && StringUtils.isNotBlank((CharSequence)sn)) {
                for (String s : sn.split(",")) {
                    sns = sns.replace("," + s + ",", ",");
                }
            }
            orderQuantity -= quantity;
        }
        if (orderQuantity <= 0) {
            return ResponseObject.newErrResponse((String)"\u91c7\u8d2d\u5355\u4ea7\u54c1\u5df2\u5168\u90e8\u5173\u8054\uff0c\u672c\u6b21\u64cd\u4f5c\u65e0\u6548\uff01");
        }
        if (StringUtils.isNotBlank((CharSequence)sns)) {
            sns = sns.substring(1, sns.length() - 1);
        }
        BO newCostProductBO = (BO)costProductList.get(0);
        newCostProductBO.set("SN", (Object)sns);
        newCostProductBO.set("QUANTITY", (Object)orderQuantity);
        newCostProductBO.set("ID", (Object)"");
        ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_6bc913271069455abbd516c556b26d31", uc.getUID(), "\u5408\u540c\u4ea7\u54c1\u7269\u6d41\u7ba1\u7406");
        newCostProductBO.setBindId(processInstance.getId());
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", newCostProductBO, processInstance, uc);
        if (StringUtils.isNotBlank((CharSequence)movePro)) {
            return ResponseObject.newOkResponse((String)("\u91c7\u8d2d\u5355\u4ea7\u54c1\u5df2\u5168\u90e8\u5173\u8054\uff0c\u4f46\u5b58\u5728\u5df2\u79fb\u52a8\u7684\u4ed3\u5e93\u4ea7\u54c1\uff0c\u8bf7\u91cd\u65b0\u5173\u8054\uff01" + movePro));
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.costProductShip")
    public ResponseObject costProductShip(UserContext uc, String bindid) {
        BO costProductBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", bindid);
        if (costProductBO.getString("IS_SHIP").equals("2")) {
            return ResponseObject.newErrResponse((String)"\u8be5\u4ea7\u54c1\u5df2\u914d\u9001\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        if (!costProductBO.getString("STATUS_ID").equals("2157") && !costProductBO.getString("STATUS_ID").equals("2158")) {
            return ResponseObject.newErrResponse((String)"\u8be5\u4ea7\u54c1\u72b6\u6001\u4e0d\u662f\u5f85\u914d\u9001\u6216\u5df2\u62e3\u8d27\uff0c\u8bf7\u52ff\u64cd\u4f5c\uff01");
        }
        costProductBO.set("IS_SHIP", (Object)"1");
        costProductBO.set("OLD_QUANTITY", costProductBO.get("QUANTITY"));
        costProductBO.set("SHIPPING_TYPE_ID", null);
        costProductBO.set("SHIPPING_SN", costProductBO.get("SN"));
        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", costProductBO);
        String url = "./w?appId=com.awspaas.user.apps.donenow_ctt&msaAppId=com.awspaas.user.apps.donenow_ctt&sid=" + uc.getSessionId() + "&cmd=CLIENT_DW_FORM_OPENPAGE&bindid=" + bindid;
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)url);
        return responseObject;
    }

    static {
        SDK.getLogAPI();
        logger = LogAPI.getLogger(contractCostController.class);
    }
}

