/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.service;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.awspaas.user.apps.donenow_ctt.service.InvoiceDealDto;
import dn.recordFormChanges;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class InvoiceService {
    private static volatile InvoiceService instance;

    private InvoiceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InvoiceService getInstance() {
        if (instance != null) return instance;
        Class<InvoiceService> clazz = InvoiceService.class;
        synchronized (InvoiceService.class) {
            if (instance != null) return instance;
            instance = new InvoiceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<String> processInvoice(UserContext uc, String accDeduIds, InvoiceDealDto param, boolean isDeal) {
        System.out.println("\u5904\u7406\u53d1\u7968\u751f\u6210");
        System.out.println("accDeduIds:" + accDeduIds);
        if (StringUtils.isBlank((CharSequence)accDeduIds)) {
            return new ArrayList<String>();
        }
        Object[] dedIdArr = accDeduIds.split(",");
        StringBuilder where = new StringBuilder("(");
        for (int i = 0; i < dedIdArr.length; ++i) {
            where.append("?").append(i < dedIdArr.length - 1 ? "," : ")");
        }
        String sqlWhere = where.toString();
        List postedDataList = DBSql.getMaps((String)("SELECT * FROM VIEW_EU_DNV_POSTED_ALL d WHERE d.ID IN " + sqlWhere + " AND (d.invoice_id is null OR d.invoice_id='' OR NOT EXISTS(SELECT 1 FROM bo_eu_dnctt_invoice i WHERE i.id=d.invoice_id AND IS_VOIDED=0))  AND  d.bill_account_id is NOT NULL AND d.ORGID='" + uc.getCompanyModel().getId() + "' ORDER BY ACCOUNT_ID,BILL_ACCOUNT_ID"), (Object[])dedIdArr);
        postedDataList.forEach(row -> row.forEach((key, value) -> {
            if (key.toUpperCase().equals("BILL_ACCOUNT_ID")) {
                if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
                    row.put(key.toUpperCase(), row.get((Object)"ACCOUNT_ID"));
                } else {
                    row.put(key.toUpperCase(), value);
                }
            } else {
                row.put(key.toUpperCase(), value);
            }
        }));
        List accountDedList = DBSql.getMaps((String)("SELECT * FROM BO_EU_DNCRM_ACCOUNT_DEDUCTION WHERE ID IN " + sqlWhere + " ORDER BY ACCOUNT_ID,BILL_ACCOUNT_ID"), (Object[])dedIdArr);
        List itemTypeDict = DBSql.getMaps((String)"SELECT OID,NAME FROM BO_EU_DND_GENERAL WHERE GENERAL_TABLE_ID='121' AND ORGID=?", (Object[])new Object[]{uc.getCompanyModel().getId()});
        Map<String, List<RowMap>> customerDedMap = accountDedList.stream().filter(ded -> ded.get((Object)"BILL_ACCOUNT_ID") != null).collect(Collectors.groupingBy(ded -> ded.get((Object)"BILL_ACCOUNT_ID").toString()));
        if (customerDedMap.isEmpty()) {
            return null;
        }
        ArrayList<String> invoiceIds = new ArrayList<String>();
        for (Map.Entry<String, List<RowMap>> entry : customerDedMap.entrySet()) {
            List<RowMap> noPoPostedList;
            String noPoInvoiceId;
            String ACCOUNT_ID = entry.getKey();
            List<RowMap> customerDedList = entry.getValue();
            RowMap customer = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCRM_ACCOUNT WHERE ID = ?", (Object[])new Object[]{ACCOUNT_ID});
            if (customer == null || StringUtils.isBlank((CharSequence)customer.getString("RESOURCE_ID"))) continue;
            List<RowMap> noPoDedList = customerDedList.stream().filter(ded -> StringUtils.isBlank((CharSequence)ded.getString("PURCHASE_ORDER_NO"))).collect(Collectors.toList());
            if (!noPoDedList.isEmpty() && StringUtils.isNotBlank((CharSequence)(noPoInvoiceId = this.createInvoiceAndDetails(uc, customer, noPoPostedList = postedDataList.stream().filter(p -> StringUtils.isBlank((CharSequence)p.getString("PURCHASE_ORDER_NO"))).filter(p -> ACCOUNT_ID.equals(p.get((Object)"ACCOUNT_ID")) || ACCOUNT_ID.equals(p.get((Object)"BILL_ACCOUNT_ID"))).collect(Collectors.toList()), noPoDedList, itemTypeDict, param, isDeal, "")))) {
                invoiceIds.add(noPoInvoiceId);
            }
            Map<String, List<RowMap>> poDedMap = customerDedList.stream().filter(ded -> StringUtils.isNotBlank((CharSequence)ded.getString("PURCHASE_ORDER_NO"))).collect(Collectors.groupingBy(ded -> ded.getString("PURCHASE_ORDER_NO")));
            for (Map.Entry<String, List<RowMap>> poEntry : poDedMap.entrySet()) {
                String poNo = poEntry.getKey();
                List<RowMap> poDedList = poEntry.getValue();
                List<RowMap> poPostedList = postedDataList.stream().filter(p -> poNo.equals(p.getString("PURCHASE_ORDER_NO"))).filter(p -> ACCOUNT_ID.equals(p.get((Object)"ACCOUNT_ID")) || ACCOUNT_ID.equals(p.get((Object)"BILL_ACCOUNT_ID"))).collect(Collectors.toList());
                String poInvoiceId = this.createInvoiceAndDetails(uc, customer, poPostedList, poDedList, itemTypeDict, param, isDeal, poNo);
                if (!StringUtils.isNotBlank((CharSequence)poInvoiceId)) continue;
                invoiceIds.add(poInvoiceId);
            }
        }
        return invoiceIds;
    }

    private InvoiceSummary calculateSummary(List<RowMap> postedList) {
        InvoiceSummary summary = new InvoiceSummary();
        summary.totalMoney = postedList.stream().mapToDouble(p -> p.getDouble("DOLLARS")).sum();
        summary.totalTax = postedList.stream().mapToDouble(p -> p.getDouble("TAX_DOLLARS")).sum();
        summary.totalPrice = summary.totalMoney - summary.totalTax;
        summary.noBillHours = postedList.stream().filter(p -> StringUtils.isBlank((CharSequence)p.getString("BILLABLE"))).mapToDouble(p -> p.getDouble("BILLABLE_HOURS")).sum();
        summary.billHours = postedList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("BILLABLE"))).mapToDouble(p -> p.getDouble("BILLABLE_HOURS")).sum();
        summary.prepaidHours = postedList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("CONTRACT_BLOCK_ID"))).mapToDouble(p -> p.getDouble("BILLABLE_HOURS")).sum();
        return summary;
    }

    private String createInvoiceAndDetails(UserContext uc, RowMap customer, List<RowMap> postedList, List<RowMap> dedList, List<RowMap> itemTypeDict, InvoiceDealDto param, boolean isDeal, String poNo) {
        try {
            InvoiceSummary summary = this.calculateSummary(postedList);
            String invoiceNo = SDK.getRuleAPI().executeAtScript("B@left(@date,4)@mid(@date,6,2).@mid(@sequenceMonth(@companyId_invoice,4,0,1),7)", uc);
            ProcessInstance pi = SDK.getProcessAPI().createProcessInstance("obj_a7d46a9dd4df40b899ddcf02113fe0d2", uc.getUID(), "\u65b0\u589e\u8d26\u5355" + invoiceNo);
            BO invoice = new BO();
            invoice.set("INVOICE_NO", (Object)invoiceNo);
            invoice.set("ACCOUNT_ID", (Object)customer.getString("ID"));
            invoice.set("ACCOUNT_NAME", (Object)customer.getString("NAME"));
            invoice.set("OWNER_RESOURCE_NAME", (Object)DBSql.getString((String)"SELECT USERNAME FROM orguser WHERE USERID=?", (Object[])new Object[]{customer.getString("RESOURCE_ID")}));
            invoice.set("INVOICE_DATE", (Object)param.getInvoiceDate());
            invoice.set("TOTAL", (Object)summary.totalMoney);
            invoice.set("TAX_VALUE", (Object)summary.totalTax);
            invoice.set("TOTAL_PRICE", (Object)summary.totalPrice);
            invoice.set("NOBILL_HOURS", (Object)summary.noBillHours);
            invoice.set("BILL_HOURS", (Object)summary.billHours);
            invoice.set("PREPAID_HOURS", (Object)summary.prepaidHours);
            invoice.set("DATE_RANGE_FROM", (Object)param.getDateRangeFrom());
            invoice.set("DATE_RANGE_TO", (Object)param.getDateRangeTo());
            invoice.set("PAYMENT_TERM_ID", (Object)param.getPaymentTermId());
            invoice.set("PURCHASE_ORDER_NO", (Object)poNo);
            invoice.set("NOTES", (Object)param.getNotes());
            String taxRegionName = StringUtils.isBlank((CharSequence)customer.getString("TAX_REGION_ID")) ? "" : DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ?", (Object[])new Object[]{customer.getString("TAX_REGION_ID")});
            invoice.set("TAX_REGION_NAME", (Object)taxRegionName);
            invoice.setBindId(pi.getId());
            SDK.getBOAPI().create("BO_EU_DNCTT_INVOICE", invoice, pi, uc);
            recordFormChanges.record((UserContext)uc, (BO)invoice, (String)("\u4fdd\u5b58\u53d1\u7968\uff1a" + invoiceNo));
            Map<String, RowMap> dedIdMap = dedList.stream().collect(Collectors.toMap(ded -> ded.getString("ID"), ded -> ded));
            int lineNo = 1;
            for (RowMap posted : postedList) {
                String dedId = posted.getString("ID");
                RowMap ded2 = dedIdMap.get(dedId);
                BO detail = new BO();
                detail.setBindId(invoice.getBindId());
                detail.set("INVOICE_ID", (Object)invoice.getId());
                detail.set("ITEM_DATE", posted.get((Object)"ITEM_DATE"));
                detail.set("ITEM_DESC", StringUtils.isBlank((CharSequence)posted.getString("ITEM_DESC")) ? posted.get((Object)"ITEM_NAME") : posted.get((Object)"ITEM_DESC"));
                detail.set("RESOURCE_NAME", posted.get((Object)"RESOURCE_NAME"));
                detail.set("QUANTITY", posted.get((Object)"QUANTITY"));
                detail.set("RATE", posted.get((Object)"RATE"));
                detail.set("DOLLARS", posted.get((Object)"DOLLARS"));
                detail.set("HOURLY_RATE", posted.get((Object)"HOURLY_RATE"));
                detail.set("ROLE_NAME", posted.get((Object)"ROLE_NAME"));
                detail.set("WORK_TYPE", posted.get((Object)"WORK_TYPE"));
                detail.set("TAX_DOLLARS", posted.get((Object)"TAX_DOLLARS"));
                detail.set("BILL_ACCOUNT_ID", (Object)ded2.getString("BILL_ACCOUNT_ID"));
                detail.set("ACCOUNT_ID", (Object)ded2.getString("ACCOUNT_ID"));
                detail.set("ACCOUNT_DEDUCTION_ID", (Object)dedId);
                String contractTypeId = posted.getString("CONTRACT_TYPE_ID");
                String billableHours = posted.getString("BILLABLE_HOURS");
                if ("1199".equals(contractTypeId) || "1201".equals(contractTypeId)) {
                    billableHours = "\u5408\u540c\u5df2\u5305";
                } else if (("1202".equals(contractTypeId) || "1203".equals(contractTypeId)) && StringUtils.isNotBlank((CharSequence)posted.getString("BILLABLE"))) {
                    billableHours = "\u9884\u652f\u4ed8";
                }
                detail.set("BILLABLE_HOURS", (Object)billableHours);
                String itemTypeOid = posted.getString("ITEM_TYPE");
                String itemTypeName = itemTypeDict.stream().filter(type -> itemTypeOid.equals(type.getString("OID"))).findFirst().map(type -> type.getString("NAME")).orElse(null);
                if (itemTypeName == null) {
                    itemTypeName = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{itemTypeOid, uc.getCompanyModel().getId()});
                }
                detail.set("ITEM_TYPE", (Object)itemTypeName);
                detail.set("EFFECTIVE_TAX_RATE", (Object)(ded2.getDouble("EFFECTIVE_TAX_RATE") * 100.0));
                detail.set("TAX_CATEGORY_NAME", ded2.get((Object)"TAX_CATEGORY_NAME"));
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_INVOICE_DETAIL", detail, uc);
                recordFormChanges.record((UserContext)uc, (BO)detail, (String)("\u4fdd\u5b58\u8d26\u5355\u660e\u7ec6\uff1a" + detail.getId()));
                if (isDeal) {
                    BO dedBo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", dedId);
                    dedBo.set("INVOICE_ID", (Object)invoice.getId());
                    dedBo.set("INVOICE_LINE_ITEM_NO", (Object)lineNo);
                    recordFormChanges.record((UserContext)uc, (BO)dedBo, (String)"\u751f\u6210\u8d26\u5355");
                    SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", dedBo);
                }
                ++lineNo;
            }
            return invoice.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean invoiceUpdate(UserContext uc, String invoiceIds, String dealStatus) {
        for (String invoiceId : invoiceIds.split(",")) {
            BO invoice = SDK.getBOAPI().get("BO_EU_DNCTT_INVOICE", invoiceId);
            List invoiceDetails = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_INVOICE_DETAIL").bindId(invoice.getBindId()).addQuery("INVOICE_ID=", (Object)invoiceId)).orderBy("ACCOUNT_ID")).orderBy("BILL_ACCOUNT_ID")).list();
            boolean isDelete = true;
            int lineNo = 1;
            for (BO invoiceDetail : invoiceDetails) {
                String accountDeductionId = invoiceDetail.getString("ACCOUNT_DEDUCTION_ID");
                BO accountDeduction = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", accountDeductionId);
                if (dealStatus.equals("\u751f\u6210\u53d1\u7968")) {
                    isDelete = false;
                    if (!StringUtils.isBlank((CharSequence)accountDeduction.getString("INVOICE_ID"))) continue;
                    accountDeduction.set("INVOICE_ID", (Object)invoice.getId());
                    accountDeduction.set("INVOICE_LINE_ITEM_NO", (Object)lineNo);
                    recordFormChanges.record((UserContext)uc, (BO)accountDeduction, (String)"\u751f\u6210\u53d1\u7968");
                    SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", accountDeduction);
                    ++lineNo;
                    continue;
                }
                if (!dealStatus.equals("\u4f5c\u5e9f\u53d1\u7968") || !StringUtils.isNotBlank((CharSequence)accountDeduction.getString("INVOICE_ID"))) continue;
                isDelete = false;
                accountDeduction.set("INVOICE_ID", null);
                accountDeduction.set("INVOICE_LINE_ITEM_NO", (Object)0);
                recordFormChanges.record((UserContext)uc, (BO)accountDeduction, (String)"\u4f5c\u5e9f\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", accountDeduction);
                ++lineNo;
            }
            if (isDelete) {
                SDK.getProcessAPI().deleteById(invoice.getBindId(), uc.getUID());
                SDK.getBOAPI().remove("BO_EU_DNCTT_INVOICE", invoiceId);
                SDK.getBOAPI().removeByBindId("BO_EU_DNCTT_INVOICE_DETAIL", invoice.getBindId());
                DBSql.update((String)"DELETE FROM BO_EU_DNCTT_INVOICE_DETAIL WHERE BINDID=? OR INVOICE_ID=?", (Object[])new Object[]{invoice.getBindId(), invoiceId});
            } else if (dealStatus.equals("\u751f\u6210\u53d1\u7968")) {
                invoice.set("IS_VOIDED", (Object)0);
                invoice.set("VOIDED_TIME", null);
                invoice.set("VOIDED_RESOURCE_ID", null);
                recordFormChanges.record((UserContext)uc, (BO)invoice, (String)"\u751f\u6210\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCTT_INVOICE", invoice);
            } else if (dealStatus.equals("\u4f5c\u5e9f\u53d1\u7968")) {
                invoice.set("IS_VOIDED", (Object)1);
                invoice.set("VOIDED_TIME", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                invoice.set("VOIDED_RESOURCE_ID", (Object)uc.getUID());
                recordFormChanges.record((UserContext)uc, (BO)invoice, (String)"\u4f5c\u5e9f\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCTT_INVOICE", invoice);
            }
            if (!dealStatus.equals("\u4f5c\u5e9f\u53d1\u7968")) continue;
            List deductions = ((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCRM_ACCOUNT_DEDUCTION").addQuery("INVOICE_ID=", (Object)invoiceId)).list();
            for (BO deduction : deductions) {
                deduction.set("INVOICE_ID", null);
                deduction.set("INVOICE_LINE_ITEM_NO", (Object)0);
                recordFormChanges.record((UserContext)uc, (BO)deduction, (String)"\u4f5c\u5e9f\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", deduction);
            }
        }
        return true;
    }

    private static class InvoiceSummary {
        double totalMoney;
        double totalTax;
        double totalPrice;
        double noBillHours;
        double billHours;
        double prepaidHours;

        private InvoiceSummary() {
        }
    }
}

