/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.event;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.core.delegate.ProcessExecutionContext;
import com.actionsoft.bpms.bpmn.engine.listener.ExecuteListener;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ivtTransferFormSaveAfter
extends ExecuteListener {
    private static final Logger logger = LoggerFactory.getLogger(ivtTransferFormSaveAfter.class);
    private static final String PROCESS_DEF_ID = "obj_41f06b1e807647db8a69dd10d4be5764";
    private static final String TRANSFER_TYPE_WAREHOUSE = "1481";
    private static final String STATUS_PROCESSED = "1";

    public String getDescription() {
        return "\u8868\u5355\u4fdd\u5b58\u540e\uff0c\u5904\u7406\u5e93\u5b58\u8f6c\u79fb\u76f8\u5173\u7684\u6570\u636e\u66f4\u65b0";
    }

    public void execute(ProcessExecutionContext processExecutionContext) throws Exception {
        String processId = processExecutionContext.getProcessInstance().getId();
        RowMap rowMap = DBSql.getMap((String)"select * from BO_EU_DNIVT_TRANSFER where BINDID =?", (Object[])new Object[]{processId});
        if (STATUS_PROCESSED.equals(rowMap.getString("STATUS"))) {
            logger.info("\u8f6c\u79fb\u5355[{}]\u5df2\u5904\u7406\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c", (Object)processId);
            return;
        }
        String sns = rowMap.getString("SN");
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            String productId = rowMap.getString("PRODUCT_ID");
            String fromWarehouseId = rowMap.getString("FROM_WAREHOUSE_ID");
            String typeId = rowMap.getString("TYPE_ID");
            this.validateRequiredParams(productId, fromWarehouseId);
            if (StringUtils.isNotBlank((CharSequence)typeId) && !"0".equals(typeId)) {
                List<Map<String, Object>> outboundLots = this.processOutboundInventory(conn, productId, fromWarehouseId, rowMap, sns);
                if (TRANSFER_TYPE_WAREHOUSE.equals(typeId)) {
                    this.processInboundInventory(conn, processExecutionContext, productId, rowMap, outboundLots);
                }
            }
            DBSql.update((Connection)conn, (String)"update BO_EU_DNIVT_TRANSFER set STATUS=? where BINDID=?", (Object[])new Object[]{STATUS_PROCESSED, processId});
            conn.commit();
            logger.info("\u8f6c\u79fb\u5355[{}]\u5904\u7406\u6210\u529f\uff0c\u4e8b\u52a1\u5df2\u63d0\u4ea4", (Object)processId);
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    conn.rollback();
                    logger.error("\u8f6c\u79fb\u5355[{}]\u5904\u7406\u5931\u8d25\uff0c\u4e8b\u52a1\u5df2\u56de\u6eda", (Object)processId, (Object)e);
                }
                catch (SQLException rollbackEx) {
                    logger.error("\u8f6c\u79fb\u5355[{}]\u4e8b\u52a1\u56de\u6eda\u5931\u8d25", (Object)processId, (Object)rollbackEx);
                }
            }
            throw e;
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
    }

    private void validateRequiredParams(String productId, String fromWarehouseId) {
        if (StringUtils.isBlank((CharSequence)productId)) {
            throw new RuntimeException("\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)fromWarehouseId)) {
            throw new RuntimeException("\u8f6c\u51fa\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<Map<String, Object>> processOutboundInventory(Connection conn, String productId, String fromWarehouseId, RowMap rowMap, String sns) {
        BO fromBO = (BO)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_WAREHOUSE_PRODUCT").connection(conn)).addQuery("PRODUCT_ID=", (Object)productId)).addQuery("WAREHOUSE_ID=", (Object)fromWarehouseId)).detail();
        if (fromBO == null) {
            throw new RuntimeException("\u8f6c\u51fa\u4ed3\u5e93\u4e0d\u5b58\u5728\u8be5\u4ea7\u54c1\u7684\u5e93\u5b58\u8bb0\u5f55");
        }
        int transferQuantity = rowMap.getInt("QUANTITY");
        int currentStock = this.parseQuantity(fromBO.get("QUANTITY"));
        int afterOutboundStock = currentStock - transferQuantity;
        if (afterOutboundStock < 0) {
            throw new RuntimeException("\u8f6c\u51fa\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5e93\u5b58\u6570\u91cf\uff0c\u5f53\u524d\u5e93\u5b58\uff1a" + currentStock + "\uff0c\u8f6c\u51fa\uff1a" + transferQuantity);
        }
        fromBO.set("QUANTITY", (Object)afterOutboundStock);
        SDK.getBOAPI().update("BO_EU_DNIVT_WAREHOUSE_PRODUCT", fromBO, conn);
        logger.debug("\u4ea7\u54c1[{}]\u4ece\u4ed3\u5e93[{}]\u51fa\u5e93\uff0c\u51fa\u5e93\u6570\u91cf\uff1a{}\uff0c\u5269\u4f59\u5e93\u5b58\uff1a{}", new Object[]{productId, fromWarehouseId, transferQuantity, afterOutboundStock});
        return this.processOutboundLots(conn, fromBO, transferQuantity, sns);
    }

    private List<Map<String, Object>> processOutboundLots(Connection conn, BO fromBO, int transferQuantity, String sns) {
        List<Object> outboundLots = new ArrayList();
        List lots = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT").addQuery("BINDID=", (Object)fromBO.getBindId())).addQuery("QUANTITY>0", null)).orderByCreated().list();
        outboundLots = StringUtils.isNotBlank((CharSequence)sns) ? this.processSerializedOutboundLots(conn, lots, sns) : this.processNonSerializedOutboundLots(conn, lots, transferQuantity);
        return outboundLots;
    }

    private List<Map<String, Object>> processSerializedOutboundLots(Connection conn, List<BO> lots, String sns) {
        ArrayList<Map<String, Object>> outboundLots = new ArrayList<Map<String, Object>>();
        String[] snArray = sns.split(",");
        HashSet<String> snSet = new HashSet<String>(Arrays.asList(snArray));
        int processedSnCount = 0;
        for (BO lot : lots) {
            if (processedSnCount >= snArray.length) break;
            String lotSN = lot.getString("SN");
            if (StringUtils.isBlank((CharSequence)lotSN)) continue;
            HashSet<String> currentLotSnSet = new HashSet<String>(Arrays.asList(lotSN.split(",")));
            ArrayList<String> matchedSns = new ArrayList<String>();
            for (String sn : snArray) {
                if (!currentLotSnSet.contains(sn) || !snSet.contains(sn)) continue;
                matchedSns.add(sn);
                snSet.remove(sn);
                if (++processedSnCount >= snArray.length) break;
            }
            if (matchedSns.isEmpty()) continue;
            currentLotSnSet.removeAll(matchedSns);
            String updatedSn = StringUtils.join(currentLotSnSet, (String)",");
            lot.set("SN", (Object)updatedSn);
            lot.set("QUANTITY", (Object)currentLotSnSet.size());
            SDK.getBOAPI().update("BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT", lot, conn);
            HashMap<String, Object> lotMap = new HashMap<String, Object>(lot.asMap());
            lotMap.remove("ID");
            lotMap.remove("BINDID");
            lotMap.put("SN", StringUtils.join(matchedSns, (String)","));
            lotMap.put("QUANTITY", matchedSns.size());
            outboundLots.add(lotMap);
        }
        if (processedSnCount < snArray.length) {
            throw new RuntimeException("\u90e8\u5206SN\u672a\u627e\u5230\u5bf9\u5e94\u6279\u6b21\uff0c\u5df2\u5904\u7406\uff1a" + processedSnCount + "\uff0c\u603b\u9700\u5904\u7406\uff1a" + snArray.length);
        }
        return outboundLots;
    }

    private List<Map<String, Object>> processNonSerializedOutboundLots(Connection conn, List<BO> lots, int remainingTransferQuantity) {
        ArrayList<Map<String, Object>> outboundLots = new ArrayList<Map<String, Object>>();
        int transferLeft = remainingTransferQuantity;
        for (BO lot : lots) {
            if (transferLeft <= 0) break;
            int lotQuantity = this.parseQuantity(lot.get("QUANTITY"));
            if (lotQuantity <= 0) continue;
            int transferQty = Math.min(lotQuantity, transferLeft);
            int remainingQty = lotQuantity - transferQty;
            lot.set("QUANTITY", (Object)remainingQty);
            SDK.getBOAPI().update("BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT", lot, conn);
            HashMap<String, Object> lotMap = new HashMap<String, Object>(lot.asMap());
            lotMap.remove("ID");
            lotMap.remove("BINDID");
            lotMap.put("SN", "");
            lotMap.put("QUANTITY", transferQty);
            outboundLots.add(lotMap);
            transferLeft -= transferQty;
        }
        if (transferLeft > 0) {
            throw new RuntimeException("\u6279\u6b21\u5e93\u5b58\u4e0d\u8db3\uff0c\u5269\u4f59\u672a\u8f6c\u79fb\u6570\u91cf\uff1a" + transferLeft);
        }
        return outboundLots;
    }

    private void processInboundInventory(Connection conn, ProcessExecutionContext context, String productId, RowMap rowMap, List<Map<String, Object>> inboundLots) {
        String toWarehouseId = rowMap.getString("TO_WAREHOUSE_ID");
        if (StringUtils.isBlank((CharSequence)toWarehouseId)) {
            throw new RuntimeException("\u8f6c\u5165\u4ed3\u5e93\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BO toBO = (BO)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_WAREHOUSE_PRODUCT").connection(conn)).addQuery("PRODUCT_ID=", (Object)productId)).addQuery("WAREHOUSE_ID=", (Object)toWarehouseId)).detail();
        int transferQuantity = rowMap.getInt("QUANTITY");
        if (toBO == null) {
            ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance(PROCESS_DEF_ID, context.getUserContext().getUID(), "\u65b0\u589e\u5e93\u5b58\u4ea7\u54c1[" + productId + "]\u4ed3\u5e93\u95f4\u8f6c\u79fb\u81f3[" + toWarehouseId + "]");
            toBO = new BO();
            toBO.set("PRODUCT_ID", (Object)productId);
            toBO.set("WAREHOUSE_ID", (Object)toWarehouseId);
            toBO.set("QUANTITY", (Object)transferQuantity);
            toBO.setBindId(processInstance.getId());
            SDK.getBOAPI().create("BO_EU_DNIVT_WAREHOUSE_PRODUCT", toBO, processInstance.getId(), context.getUserContext().getUID(), conn);
            logger.debug("\u4ea7\u54c1[{}]\u5728\u8f6c\u5165\u4ed3\u5e93[{}]\u521b\u5efa\u65b0\u5e93\u5b58\u8bb0\u5f55\uff0c\u521d\u59cb\u6570\u91cf\uff1a{}", new Object[]{productId, toWarehouseId, transferQuantity});
        } else {
            int currentStock = this.parseQuantity(toBO.get("QUANTITY"));
            toBO.set("QUANTITY", (Object)(currentStock + transferQuantity));
            SDK.getBOAPI().update("BO_EU_DNIVT_WAREHOUSE_PRODUCT", toBO, conn);
            logger.debug("\u4ea7\u54c1[{}]\u5728\u8f6c\u5165\u4ed3\u5e93[{}]\u66f4\u65b0\u5e93\u5b58\uff0c\u539f\u5e93\u5b58\uff1a{}\uff0c\u65b0\u589e\uff1a{}\uff0c\u73b0\u5e93\u5b58\uff1a{}", new Object[]{productId, toWarehouseId, currentStock, transferQuantity, currentStock + transferQuantity});
        }
        this.processInboundLots(conn, context, toBO, inboundLots);
    }

    private void processInboundLots(Connection conn, ProcessExecutionContext context, BO toBO, List<Map<String, Object>> inboundLots) {
        for (Map<String, Object> lotData : inboundLots) {
            String lotNo = (String)lotData.get("LOT");
            String orderProductId = (String)lotData.get("ORDER_PRODUCT_ID");
            BO toLot = (BO)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT").addQuery("LOT=", (Object)lotNo)).addQuery("ORDER_PRODUCT_ID=", (Object)orderProductId)).addQuery("BINDID=", (Object)toBO.getBindId())).detail();
            if (toLot != null) {
                int currentQty = this.parseQuantity(toLot.get("QUANTITY"));
                int addQty = this.parseQuantity(lotData.get("QUANTITY"));
                toLot.set("QUANTITY", (Object)(currentQty + addQty));
                String existingSn = toLot.getString("SN");
                String newSn = (String)lotData.get("SN");
                if (StringUtils.isNotBlank((CharSequence)newSn)) {
                    toLot.set("SN", (Object)(StringUtils.isBlank((CharSequence)existingSn) ? newSn : existingSn + "," + newSn));
                }
                SDK.getBOAPI().update("BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT", toLot, conn);
                continue;
            }
            BO newLot = new BO();
            newLot.setAll(lotData);
            newLot.setBindId(toBO.getBindId());
            newLot.set("ORDER_PRODUCT_ID", lotData.get("ORDER_PRODUCT_ID"));
            newLot.set("WAREHOUSE_ID", toBO.get("WAREHOUSE_ID"));
            newLot.set("PRODUCT_ID", toBO.get("PRODUCT_ID"));
            SDK.getBOAPI().createDataBO("BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT", newLot, context.getUserContext(), conn);
        }
        logger.debug("\u8f6c\u5165\u4ed3\u5e93\u6279\u6b21\u5904\u7406\u5b8c\u6210\uff0c\u5171\u5904\u7406{}\u4e2a\u6279\u6b21", (Object)inboundLots.size());
    }

    private int parseQuantity(Object quantityObj) {
        if (quantityObj == null) {
            return 0;
        }
        if (quantityObj instanceof Number) {
            return ((Number)quantityObj).intValue();
        }
        try {
            return Integer.parseInt(quantityObj.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("\u6570\u91cf\u683c\u5f0f\u9519\u8bef\uff1a" + quantityObj, e);
        }
    }
}

