/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.utils;

import com.google.common.base.Optional;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class BigDecimalUtil {
    private BigDecimalUtil() {
    }

    public static String add(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).toPlainString();
    }

    public static String sub(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).toPlainString();
    }

    public static String sub(String v1, String v2, String v3) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v3)) {
            v3 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        BigDecimal b3 = new BigDecimal(v3);
        BigDecimal b4 = b1.subtract(b2);
        return b4.subtract(b3).toPlainString();
    }

    public static String mul(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).toPlainString();
    }

    public static String div(String v1, String v2) {
        if (StringUtils.isBlank((CharSequence)v1) || StringUtils.isBlank((CharSequence)v2) || v2.equals("0")) {
            return "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, 2, 4).toPlainString();
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        return b1.divide(b2, 2, 4).doubleValue();
    }

    public static String div(String v1, String v2, int decimalDigits) {
        if (StringUtils.isBlank((CharSequence)v1)) {
            v1 = "0";
        }
        if (StringUtils.isBlank((CharSequence)v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1);
        BigDecimal b2 = new BigDecimal(v2);
        BigDecimal noZeros = b1.divide(b2, decimalDigits, 4).stripTrailingZeros();
        String result = noZeros.toPlainString();
        return result;
    }

    public static double round(double d, int len) {
        BigDecimal b1 = new BigDecimal(d);
        BigDecimal b2 = new BigDecimal(1);
        return b1.divide(b2, len, 4).doubleValue();
    }

    public static BigDecimal safeAdd(BigDecimal b1, BigDecimal ... bn) {
        if (null == b1) {
            b1 = BigDecimal.ZERO;
        }
        if (null != bn) {
            for (BigDecimal b : bn) {
                b1 = b1.add(null == b ? BigDecimal.ZERO : b);
            }
        }
        return b1;
    }

    public static Integer safeAdd(Integer b1, Integer ... bn) {
        if (null == b1) {
            b1 = 0;
        }
        Integer r = b1;
        if (null != bn) {
            for (Integer b : bn) {
                r = r + (Integer)Optional.fromNullable((Object)b).or((Object)0);
            }
        }
        return r > 0 ? r : 0;
    }

    public static BigDecimal safeSubtract(BigDecimal b1, BigDecimal ... bn) {
        return BigDecimalUtil.safeSubtract(true, b1, bn);
    }

    public static BigDecimal safeSubtract(Boolean isZero, BigDecimal b1, BigDecimal ... bn) {
        if (null == b1) {
            b1 = BigDecimal.ZERO;
        }
        BigDecimal r = b1;
        if (null != bn) {
            for (BigDecimal b : bn) {
                r = r.subtract(null == b ? BigDecimal.ZERO : b);
            }
        }
        return isZero.booleanValue() ? (r.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : r) : r;
    }

    public static Integer safeSubtract(Integer b1, Integer ... bn) {
        if (null == b1) {
            b1 = 0;
        }
        Integer r = b1;
        if (null != bn) {
            for (Integer b : bn) {
                r = r - (Integer)Optional.fromNullable((Object)b).or((Object)0);
            }
        }
        return null != r && r > 0 ? r : 0;
    }

    public static <T extends Number> BigDecimal safeMultiply(T b1, T b2) {
        if (null == b1 || null == b2) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(b1.doubleValue()).multiply(BigDecimal.valueOf(b2.doubleValue())).setScale(2, 4);
    }

    public static <T extends Number> BigDecimal safeDivide(T b1, T b2) {
        return BigDecimalUtil.safeDivide(b1, b2, BigDecimal.ZERO);
    }

    public static <T extends Number> BigDecimal safeDivide(T b1, T b2, BigDecimal defaultValue) {
        if (null == b1 || null == b2) {
            return defaultValue;
        }
        try {
            return BigDecimal.valueOf(b1.doubleValue()).divide(BigDecimal.valueOf(b2.doubleValue()), 2, 4);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String isNull(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "0";
        }
        return value;
    }

    public static double getDouble(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0.0;
        }
        try {
            return Double.valueOf(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }
}

