/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.cache.NetworkTeamMember_NetworkIndex;
import com.actionsoft.apps.network.cache.NetworkTeamMember_TeamIndex;
import com.actionsoft.apps.network.cache.NetworkTeamMember_TeamUserIndex;
import com.actionsoft.apps.network.cache.NetworkTeamMember_UserIndex;
import com.actionsoft.apps.network.dao.NetworkTeamMemberDao;
import com.actionsoft.apps.network.model.NetworkTeamMemberDto;
import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.ConsolePrinter;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.PortalAPI;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class NetworkTeamMemberCache
extends Cache<String, NetworkTeamMemberModel> {
    public static final Comparator<NetworkTeamMemberModel> SORT_CREATETIME = new Comparator<NetworkTeamMemberModel>(){

        @Override
        public int compare(NetworkTeamMemberModel o1, NetworkTeamMemberModel o2) {
            if (o2.getCreateTime() != null && o1.getCreateTime() != null) {
                return o2.getCreateTime().compareTo(o1.getCreateTime());
            }
            return 0;
        }
    };

    public NetworkTeamMemberCache(CachePluginProfile profile) {
        super(profile);
        this.registeIndex(NetworkTeamMember_NetworkIndex.class, (CacheIndex)new NetworkTeamMember_NetworkIndex());
        this.registeIndex(NetworkTeamMember_TeamIndex.class, (CacheIndex)new NetworkTeamMember_TeamIndex());
        this.registeIndex(NetworkTeamMember_UserIndex.class, (CacheIndex)new NetworkTeamMember_UserIndex());
        this.registeIndex(NetworkTeamMember_TeamUserIndex.class, (CacheIndex)new NetworkTeamMember_TeamUserIndex());
    }

    public static void putModel(NetworkTeamMemberModel model) {
        NetworkTeamMemberModel old = NetworkTeamMemberCache.getModel(model.getId());
        int result = -1;
        if (old == null) {
            model.setCreateTime(new Timestamp(System.currentTimeMillis()));
            result = new NetworkTeamMemberDao().insert(model);
        } else {
            result = new NetworkTeamMemberDao().update(model);
        }
        if (result == 1) {
            NetworkTeamMemberCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkTeamMemberModel getModel(String id) {
        return (NetworkTeamMemberModel)((Object)NetworkTeamMemberCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkTeamMemberDao().delete(id);
        if (result == 1) {
            NetworkTeamMemberCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static NetworkTeamMemberModel getModel(String teamId, String userId) {
        Iterator iter = NetworkTeamMemberCache.getCache().getByIndex(NetworkTeamMember_TeamUserIndex.class, (Serializable)((Object)(teamId + "_" + userId)), SORT_CREATETIME);
        if (iter.hasNext()) {
            return (NetworkTeamMemberModel)((Object)iter.next());
        }
        return null;
    }

    public static List<NetworkTeamMemberModel> loadAllNetworkTeam() {
        Iterator iter = NetworkTeamMemberCache.getCache().iteratorSorted(SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkTeamMemberModel> loadNetworkTeamMemberByTeam(String teamId, String status) {
        List<NetworkTeamMemberModel> list = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId);
        ArrayList<NetworkTeamMemberModel> teamMemberList = new ArrayList<NetworkTeamMemberModel>();
        if (list.size() > 0) {
            for (NetworkTeamMemberModel model : list) {
                UserModel userModel;
                if (model.getUserId() == null || (userModel = UserCache.getModel((String)model.getUserId())) == null || userModel.isClosed() || !model.getMemberStatus().equals(status)) continue;
                teamMemberList.add(model);
            }
        }
        return teamMemberList;
    }

    public static List<NetworkTeamMemberDto> loadNetworkTeamMemberDtoByTeam(String teamId, String status, UserContext context) {
        ArrayList<NetworkTeamMemberDto> teamMemberList = new ArrayList<NetworkTeamMemberDto>();
        List<NetworkTeamMemberModel> list = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId);
        if (list.size() > 0) {
            PortalAPI portalApi = SDK.getPortalAPI();
            for (NetworkTeamMemberModel model : list) {
                UserModel userModel;
                if (model.getUserId() == null || (userModel = UserCache.getModel((String)model.getUserId())) == null || userModel.isClosed() || !model.getMemberStatus().equals(status)) continue;
                NetworkTeamMemberDto dto = new NetworkTeamMemberDto();
                dto.setId(model.getId());
                dto.setTeamId(model.getTeamId());
                dto.setUserId(model.getUserId());
                dto.setMemberType(model.getMemberType());
                dto.setMemberStatus(model.getMemberStatus());
                dto.setJoinType(model.getJoinType());
                dto.setJoinStatus(model.getJoinStatus());
                dto.setCreateUserId(model.getCreateUserId());
                dto.setCreateUserName(model.getCreateUserName());
                dto.setCreateTime(model.getCreateTime());
                dto.setLastActive(model.getLastActive());
                DepartmentModel dept = SDK.getORGAPI().getDepartmentById(userModel.getDepartmentId());
                dto.setUserName(userModel.getUserName());
                dto.setUserPhoto(portalApi.getUserPhoto(context, dto.getUserId()));
                dto.setDepartmentId(userModel.getDepartmentId());
                dto.setDepartmentName(NetworkDataUtil.getTwoLevelDeptName(dept.getPathNameOfCache()));
                dto.setEmail(userModel.getEmail());
                teamMemberList.add(dto);
            }
        }
        return teamMemberList;
    }

    public static List<String> loadNetworkTeamMemberBy(String teamId, String status) {
        List<NetworkTeamMemberModel> list = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId);
        ArrayList<String> teamMemberList = new ArrayList<String>();
        if (list.size() > 0) {
            for (NetworkTeamMemberModel model : list) {
                UserModel userModel;
                if (model.getUserId() == null || (userModel = UserCache.getModel((String)model.getUserId())) == null || userModel.isClosed() || !model.getMemberStatus().equals(status)) continue;
                teamMemberList.add(model.getUserId());
            }
        }
        return teamMemberList;
    }

    public static int getNetworkTeamMemberCountsByTeam(String teamId, String status) {
        List<NetworkTeamMemberModel> list = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId, status);
        return list == null ? 0 : list.size();
    }

    public static List<NetworkTeamMemberModel> loadNetworkTeamMemberByNetwork(String networkId) {
        Iterator iter = NetworkTeamMemberCache.getCache().getByIndex(NetworkTeamMember_UserIndex.class, (Serializable)((Object)networkId), SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkTeamMemberModel> loadNetworkTeamMemberByTeam(String teamId) {
        Iterator iter = NetworkTeamMemberCache.getCache().getByIndex(NetworkTeamMember_TeamIndex.class, (Serializable)((Object)teamId), SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkTeamMemberModel> loadNetworkTeamMemberByUser(String userId) {
        Iterator iter = NetworkTeamMemberCache.getCache().getByIndex(NetworkTeamMember_UserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<String> getTeamIdListByUser(String userId) {
        ArrayList<String> teamList = new ArrayList<String>();
        List<NetworkTeamMemberModel> teamMemberList = NetworkTeamMemberCache.loadNetworkTeamMemberByUser(userId);
        for (NetworkTeamMemberModel teamMember : teamMemberList) {
            UserModel userModel;
            if (teamMember.getUserId() == null || (userModel = UserCache.getModel((String)teamMember.getUserId())) == null || userModel.isClosed() || !"2".equals(teamMember.getJoinStatus()) || !"1".equals(teamMember.getMemberStatus())) continue;
            teamList.add(teamMember.getTeamId());
        }
        return teamList;
    }

    public static List<String> getTeamIdListById(String teamId) {
        ArrayList<String> teamList = new ArrayList<String>();
        List<NetworkTeamMemberModel> teamMemberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId);
        for (NetworkTeamMemberModel teamMember : teamMemberList) {
            UserModel userModel;
            if (teamMember.getUserId() == null || (userModel = UserCache.getModel((String)teamMember.getUserId())) == null || userModel.isClosed()) continue;
            teamList.add(teamMember.getUserId());
        }
        return teamList;
    }

    public void load() {
        List<NetworkTeamMemberModel> list = new NetworkTeamMemberDao().loadNetworkTeamMemberOfCache();
        for (NetworkTeamMemberModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u5c0f\u7ec4\u6210\u5458 [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkTeamMemberCache getCache() {
        return (NetworkTeamMemberCache)CacheManager.getCache(NetworkTeamMemberCache.class);
    }
}

