/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.jod;

import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JodTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(JodTool.class);

    public boolean isActive() {
        AppAPI appAPI = SDK.getAppAPI();
        AppContext jodApp = appAPI.getAppContext("com.actionsoft.apps.jod");
        return jodApp != null && SDK.getAppAPI().isActive(jodApp.getId());
    }

    public ResponseObject file2PdfImage(String sid, String srcFilePath, String pdfFilePath, String origImgFilePath, String thumImgFilePath, Integer thumWidth, Integer thumHeight) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        if (this.isActive()) {
            String aslp = "aslp://com.actionsoft.apps.jod/file2PdfImage";
            HashMap<String, Object> params = new HashMap<String, Object>();
            try {
                params.put("sid", sid);
                params.put("srcFilePath", srcFilePath);
                params.put("pdfFilePath", pdfFilePath);
                params.put("origImgFilePath", origImgFilePath);
                params.put("thumImgFilePath", thumImgFilePath);
                if (thumWidth != null) {
                    params.put("thumWidth", thumWidth);
                }
                if (thumHeight != null) {
                    params.put("thumHeight", thumHeight);
                }
                ro = appAPI.callASLP(appAPI.getAppContext("com.actionsoft.apps.network"), aslp, params);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        return ro;
    }

    public ResponseObject file2PdfImage(String sid, String srcFilePath, String pdfFilePath, String origImgFilePath, String thumImgFilePath) {
        return this.file2PdfImage(sid, srcFilePath, pdfFilePath, origImgFilePath, thumImgFilePath, null, null);
    }

    public ResponseObject pdf2Image(String sid, String pdfFilePath, String origImgFilePath, String thumImgFilePath, Integer thumWidth, Integer thumHeight) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        if (this.isActive()) {
            String aslp = "aslp://com.actionsoft.apps.jod/pdf2Image";
            HashMap<String, Object> params = new HashMap<String, Object>();
            try {
                params.put("sid", sid);
                params.put("pdfFilePath", pdfFilePath);
                params.put("origImgFilePath", origImgFilePath);
                params.put("thumImgFilePath", thumImgFilePath);
                if (thumWidth != null) {
                    params.put("thumWidth", thumWidth);
                }
                if (thumHeight != null) {
                    params.put("thumHeight", thumHeight);
                }
                ro = appAPI.callASLP(appAPI.getAppContext("com.actionsoft.apps.network"), aslp, params);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        return ro;
    }

    public ResponseObject pdf2Image(String sid, String pdfFilePath, String origImgFilePath, String thumImgFilePath) {
        return this.pdf2Image(sid, pdfFilePath, origImgFilePath, thumImgFilePath, null, null);
    }
}

