/*
 * Decompiled with CFR 0.152.
 */
package dn;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class ObjectEqualsOptimized {
    private static final List<DateTimeFormatter> FORMATTERS = Collections.unmodifiableList(Arrays.asList(DateTimeFormatter.ISO_LOCAL_DATE_TIME, DateTimeFormatter.ISO_LOCAL_DATE, DateTimeFormatter.ISO_LOCAL_TIME, DateTimeFormatter.ISO_ZONED_DATE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withResolverStyle(ResolverStyle.STRICT), DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"), DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss"), DateTimeFormatter.ofPattern("dd-MMM-yyyy HH:mm:ss", Locale.ENGLISH), DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm:ss", Locale.ENGLISH), DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2"), DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z uuuu", Locale.ENGLISH)));
    private static final DateTimeFormatter LEGACY_DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
    private static final ZoneId SYSTEM_ZONE = ZoneId.systemDefault();
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final int DEFAULT_SCALE = 2;
    private static final RoundingMode DEFAULT_ROUNDING = RoundingMode.HALF_UP;
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final DateTimeFormatter DATETIME_FORMATTER;

    public static boolean objectEquals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (ObjectEqualsOptimized.isNull(obj1) && ObjectEqualsOptimized.isNull(obj2)) {
            return true;
        }
        if (ObjectEqualsOptimized.isNumberOrStringNumber(obj1) && ObjectEqualsOptimized.isNumberOrStringNumber(obj2)) {
            return ObjectEqualsOptimized.compareNumbers(ObjectEqualsOptimized.parseNumber(obj1), ObjectEqualsOptimized.parseNumber(obj2));
        }
        LocalDateTime dt1 = ObjectEqualsOptimized.tryParseDateTime(obj1);
        LocalDateTime dt2 = ObjectEqualsOptimized.tryParseDateTime(obj2);
        if (dt1 != null && dt2 != null) {
            return ObjectEqualsOptimized.compareLocalDateTimes(dt1, dt2);
        }
        return Objects.toString(obj1, "").equals(Objects.toString(obj2, ""));
    }

    private static boolean isNull(Object obj) {
        return obj == null || obj.toString().trim().isEmpty();
    }

    private static boolean isNumberOrStringNumber(Object obj) {
        return obj instanceof Number || obj instanceof String && ObjectEqualsOptimized.isNumeric((String)obj);
    }

    private static boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static double parseNumber(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            return Double.parseDouble((String)obj);
        }
        throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u4e3a\u6570\u5b57: " + obj.getClass());
    }

    private static boolean compareNumbers(double num1, double num2) {
        return Math.abs(num1 - num2) < 1.0E-6;
    }

    private static LocalDateTime tryParseDateTime(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof LocalDateTime) {
            return (LocalDateTime)obj;
        }
        if (obj instanceof ZonedDateTime) {
            return ((ZonedDateTime)obj).toLocalDateTime();
        }
        if (obj instanceof OffsetDateTime) {
            return ((OffsetDateTime)obj).toLocalDateTime();
        }
        if (obj instanceof Instant) {
            return ((Instant)obj).atZone(SYSTEM_ZONE).toLocalDateTime();
        }
        if (obj instanceof Date) {
            return ((Date)obj).toInstant().atZone(SYSTEM_ZONE).toLocalDateTime();
        }
        if (obj instanceof String) {
            return ObjectEqualsOptimized.parseLocalDateTime((String)obj);
        }
        return null;
    }

    public static LocalDateTime parseLocalDateTime(String dateStr) {
        if (dateStr == null || dateStr.trim().isEmpty()) {
            return null;
        }
        dateStr = dateStr.trim();
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                if (formatter.getLocale() != null) {
                    return LocalDateTime.parse(dateStr, formatter);
                }
                return LocalDateTime.parse(dateStr, formatter.withLocale(Locale.ENGLISH));
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        try {
            LocalDate localDate = LocalDate.parse(dateStr, DateTimeFormatter.ISO_LOCAL_DATE);
            return localDate.atStartOfDay();
        }
        catch (DateTimeParseException localDate) {
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateStr, LEGACY_DATE_FORMATTER);
                return zonedDateTime.withZoneSameInstant(SYSTEM_ZONE).toLocalDateTime();
            }
            catch (DateTimeParseException zonedDateTime) {
                try {
                    OffsetDateTime offsetDateTime = OffsetDateTime.parse(dateStr);
                    return offsetDateTime.toLocalDateTime();
                }
                catch (DateTimeParseException dateTimeParseException) {
                    return null;
                }
            }
        }
    }

    private static boolean compareLocalDateTimes(LocalDateTime dt1, LocalDateTime dt2) {
        if (dt1 == null && dt2 == null) {
            return true;
        }
        if (dt1 == null || dt2 == null) {
            return false;
        }
        return dt1.truncatedTo(ChronoUnit.SECONDS).isEqual(dt2.truncatedTo(ChronoUnit.SECONDS));
    }

    public static String formatSmart(LocalDateTime dateTime) {
        boolean isMidnight;
        if (dateTime == null) {
            return null;
        }
        boolean bl = isMidnight = dateTime.getHour() == 0 && dateTime.getMinute() == 0 && dateTime.getSecond() == 0;
        if (isMidnight) {
            return dateTime.format(DATE_FORMATTER);
        }
        return dateTime.format(DATETIME_FORMATTER);
    }

    public static String formatForDisplay(String obj) {
        try {
            if (obj == null || obj.isEmpty()) {
                return null;
            }
            if (ObjectEqualsOptimized.isNumberOrStringNumber(obj)) {
                BigDecimal bd = BigDecimal.valueOf(ObjectEqualsOptimized.parseNumber(obj));
                String result = (bd = bd.setScale(2, DEFAULT_ROUNDING)).stripTrailingZeros().toPlainString();
                if (result.endsWith(".0")) {
                    result = result.substring(0, result.length() - 2);
                }
                return result;
            }
            LocalDateTime dateTime = ObjectEqualsOptimized.tryParseDateTime(obj);
            if (dateTime != null) {
                boolean isMidnight;
                boolean bl = isMidnight = dateTime.getHour() == 0 && dateTime.getMinute() == 0 && dateTime.getSecond() == 0;
                if (isMidnight) {
                    return dateTime.format(DATE_FORMATTER);
                }
                return dateTime.format(DATETIME_FORMATTER);
            }
            return obj.toString();
        }
        catch (Exception e) {
            return obj;
        }
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
        NUMBER_FORMAT.setMinimumFractionDigits(0);
        NUMBER_FORMAT.setMaximumFractionDigits(10);
        DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    }
}

