/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Controller
public class caiController {
    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryCai")
    public ResponseObject queryOrderByOrderId(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select UNIT_COST_ADD_TAX, ORDER_ID from bo_eu_dnivt_order_product where ORDER_ID = ?";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{orderId});
        if (map == null) {
            return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u91c7\u8d2d\u9879"));
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("UNIT_COST_ADD_TAX", map.getString("UNIT_COST_ADD_TAX"));
        result.put("ORDER_ID", map.getString("ORDER_ID"));
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryCount")
    public ResponseObject queryPurchaseItemCount(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select count(*) as item_count from bo_eu_dnivt_order_product where ORDER_ID = ?";
        int itemCount = DBSql.getInt((String)sql, (Object[])new Object[]{orderId});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orderId", orderId);
        result.put("itemCount", itemCount);
        result.put("isSingleItem", itemCount == 1);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryPaymentPlan")
    public ResponseObject queryPaymentPlan(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String mainSql = "SELECT a.order_id \u91c7\u8d2d\u8ba2\u5355id, a.CONTRACT_SERVICE_ID \u5408\u540c\u670d\u52a1ID, b.PERIOD_END_DATE \u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4, b.PERIOD_COST \u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d FROM `BO_EU_DNIVT_ORDER_PRODUCT` a JOIN `BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD` b ON a.CONTRACT_SERVICE_ID = b.CONTRACT_SERVICE_ID WHERE a.ORDER_ID = ?";
        List mainRowMaps = DBSql.getMaps((String)mainSql, (Object[])new Object[]{orderId});
        System.out.println("\u4e3b\u8868\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + (mainRowMaps != null ? mainRowMaps.size() : 0));
        ArrayList resultList = new ArrayList();
        HashSet<String> processedServiceIds = new HashSet<String>();
        if (mainRowMaps != null && !mainRowMaps.isEmpty()) {
            for (RowMap mainRow : mainRowMaps) {
                HashMap<String, Object> plan = new HashMap<String, Object>();
                plan.put("order_id", mainRow.getString("\u91c7\u8d2d\u8ba2\u5355id"));
                plan.put("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4", mainRow.getString("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4"));
                plan.put("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d", mainRow.getDouble("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d"));
                resultList.add(plan);
                Object contractServiceObj = mainRow.get((Object)"\u5408\u540c\u670d\u52a1ID");
                String contractServiceId = contractServiceObj != null ? contractServiceObj.toString() : null;
                System.out.println("\u5f53\u524d\u884cCONTRACT_SERVICE_ID\uff1a" + contractServiceId + "\uff08\u7c7b\u578b\uff1a" + (contractServiceObj != null ? contractServiceObj.getClass().getSimpleName() : "null") + "\uff09");
                if (!StringUtils.isNotBlank((CharSequence)contractServiceId) || processedServiceIds.contains(contractServiceId)) continue;
                processedServiceIds.add(contractServiceId);
                String adjustSql = "SELECT effective_date \u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4, prorated_cost_change \u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d FROM `BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST` WHERE CAST(CONTRACT_SERVICE_ID AS CHAR) = ?";
                System.out.println("\u6267\u884c\u670d\u52a1\u8c03\u6574\u8868\u67e5\u8be2SQL\uff1a" + adjustSql + "\uff0c\u53c2\u6570\uff1a" + contractServiceId);
                List adjustRowMaps = DBSql.getMaps((String)adjustSql, (Object[])new Object[]{contractServiceId});
                System.out.println("\u670d\u52a1\u8c03\u6574\u8868\u67e5\u8be2\u7ed3\u679c\u6570\u91cf\uff1a" + (adjustRowMaps != null ? adjustRowMaps.size() : 0));
                if (adjustRowMaps != null && !adjustRowMaps.isEmpty()) {
                    for (RowMap adjustRow : adjustRowMaps) {
                        HashMap<String, Object> adjustPlan = new HashMap<String, Object>();
                        adjustPlan.put("order_id", orderId);
                        adjustPlan.put("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4", adjustRow.getString("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4"));
                        adjustPlan.put("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d", adjustRow.getDouble("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d"));
                        resultList.add(adjustPlan);
                        System.out.println("\u5df2\u6dfb\u52a0\u670d\u52a1\u8c03\u6574\u6570\u636e\uff1a" + adjustPlan);
                    }
                    continue;
                }
                System.out.println("\u670d\u52a1\u8c03\u6574\u8868\u65e0\u6570\u636e\uff0cCONTRACT_SERVICE_ID\uff1a" + contractServiceId);
                String checkSql = "SELECT COUNT(1) AS cnt FROM `BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST` WHERE CAST(CONTRACT_SERVICE_ID AS CHAR) = ?";
                List checkMaps = DBSql.getMaps((String)checkSql, (Object[])new Object[]{contractServiceId});
                if (checkMaps == null || checkMaps.isEmpty()) continue;
                System.out.println("\u6570\u636e\u5e93\u4e2d\u5b9e\u9645\u5b58\u5728\u7684\u8bb0\u5f55\u6570\uff1a" + ((RowMap)checkMaps.get(0)).getInt("cnt"));
            }
        } else {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u8ba1\u5212\u4ed8\u6b3e\u4fe1\u606f\uff0c\u53ef\u5c1d\u8bd5\u65b0\u5efa"));
            responseObject.setData(Collections.emptyList());
            return responseObject;
        }
        System.out.println("\u6700\u7ec8\u7ed3\u679c\u603b\u6570\uff1a" + resultList.size() + "\uff08\u4e3b\u8868" + mainRowMaps.size() + "\u6761 + \u670d\u52a1\u8c03\u6574" + (resultList.size() - mainRowMaps.size()) + "\u6761\uff09");
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryPayAmount")
    public ResponseObject queryPayAmount(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select ORDER_ID \u91c7\u8d2d\u8ba2\u5355id, PAY_AMOUNT \u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d from `BO_EU_DNIVT_ORDER_PAYMENT_PLAN` where ORDER_ID = ?";
        List rowMaps = DBSql.getMaps((String)sql, (Object[])new Object[]{orderId});
        ArrayList resultList = new ArrayList();
        if (rowMaps != null && !rowMaps.isEmpty()) {
            for (RowMap row : rowMaps) {
                HashMap<String, Object> amountInfo = new HashMap<String, Object>();
                amountInfo.put("order_id", orderId);
                amountInfo.put("\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d", row.getDouble("\u5b9e\u9645\u4ed8\u6b3e\u91d1\u989d"));
                resultList.add(amountInfo);
            }
        } else {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u5b9e\u9645\u91d1\u989d\u4fe1\u606f\uff0c\u53ef\u5c1d\u8bd5\u65b0\u5efa"));
            responseObject.setData(Collections.emptyList());
            return responseObject;
        }
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.deleteUnpaidPaymentPlan")
    public ResponseObject deleteUnpaidPaymentPlan(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        System.out.println("\u4ee3\u7801\u4e2d\u63a5\u6536\u5230\u7684 orderId\uff1a" + orderId);
        String sql = "delete from `BO_EU_DNIVT_ORDER_PAYMENT_PLAN` where ORDER_ID = ? and (PAY_AMOUNT is null or PAY_AMOUNT = 0)";
        int deletedRows = DBSql.update((String)sql, (Object[])new Object[]{orderId});
        if (deletedRows <= 0) {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u5220\u9664\u4fe1\u606f\uff0c\u53ef\u5c1d\u8bd5\u65b0\u5efa"));
            responseObject.setData(Collections.emptyList());
        }
        ArrayList resultList = new ArrayList();
        HashMap<String, Object> deleteInfo = new HashMap<String, Object>();
        deleteInfo.put("order_id", orderId);
        deleteInfo.put("\u5220\u9664\u8bb0\u5f55\u6570", deletedRows);
        resultList.add(deleteInfo);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.createPaymentPlan")
    public ResponseObject createPaymentPlan(UserContext uc, String orderId, String planDate, Double planAmount) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)planDate)) {
            return ResponseObject.newErrResponse((String)"\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            ProcessInstance processInstance = SDK.getProcessAPI().createProcessInstance("obj_5cb4ae4a42944fd0a9a284ff4c64c65d", uc.getUID(), "\u4ed8\u6b3e\u8ba1\u5212");
            BO bo = new BO();
            bo.setBindId(processInstance.getId());
            bo.set("ORDER_ID", (Object)orderId);
            bo.set("PLAN_DATE", (Object)planDate);
            bo.set("PLAN_AMOUNT", (Object)planAmount);
            SDK.getBOAPI().createDataBO("BO_EU_DNIVT_ORDER_PAYMENT_PLAN", bo, uc);
            ArrayList resultList = new ArrayList();
            HashMap<String, Object> plan = new HashMap<String, Object>();
            plan.put("order_id", orderId);
            plan.put("\u8ba1\u5212\u4ed8\u6b3e\u65f6\u95f4", planDate);
            plan.put("\u8ba1\u5212\u4ed8\u6b3e\u91d1\u989d", planAmount);
            plan.put("bindId", processInstance.getId());
            resultList.add(plan);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(resultList);
            return responseObject;
        }
        catch (Exception e) {
            return ResponseObject.newErrResponse((String)("\u521b\u5efa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryNonServiceOrderDate")
    public ResponseObject queryNonServiceOrderDate(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select EXPECTED_SHIP_DATE from `BO_EU_DNIVT_ORDER` where id = ? ";
        String expectedShipDate = DBSql.getString((String)sql, (Object[])new Object[]{orderId});
        if (StringUtils.isBlank((CharSequence)expectedShipDate)) {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u9884\u671f\u53d1\u8d27\u65e5\u671f\uff08EXPECTED_SHIP_DATE\uff09"));
            responseObject.setData(Collections.emptyList());
            return responseObject;
        }
        ArrayList resultList = new ArrayList();
        HashMap<String, String> dateInfo = new HashMap<String, String>();
        dateInfo.put("order_id", orderId);
        dateInfo.put("EXPECTED_SHIP_DATE", expectedShipDate);
        resultList.add(dateInfo);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryNonServiceOrderPrice")
    public ResponseObject queryNonServiceOrderPrice(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select UNIT_COST_ADD_TAX from `BO_EU_DNIVT_ORDER_PRODUCT` where order_id = ? ";
        String priceStr = DBSql.getString((String)sql, (Object[])new Object[]{orderId});
        if (StringUtils.isBlank((CharSequence)priceStr)) {
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.put("message", (Object)("\u672a\u627e\u5230ORDER_ID\u4e3a\u3010" + orderId + "\u3011\u7684\u542b\u7a0e\u5355\u4ef7\uff08UNIT_COST_ADD_TAX\uff09"));
            responseObject.setData(Collections.emptyList());
            return responseObject;
        }
        Double unitCostAddTax = null;
        try {
            unitCostAddTax = Double.parseDouble(priceStr);
        }
        catch (NumberFormatException e) {
            return ResponseObject.newErrResponse((String)("\u542b\u7a0e\u5355\u4ef7\u683c\u5f0f\u9519\u8bef\uff1a" + priceStr));
        }
        ArrayList resultList = new ArrayList();
        HashMap<String, Object> priceInfo = new HashMap<String, Object>();
        priceInfo.put("order_id", orderId);
        priceInfo.put("UNIT_COST_ADD_TAX", unitCostAddTax);
        resultList.add(priceInfo);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(resultList);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryNonServicePaymentPlan")
    public ResponseObject queryNonServicePaymentPlan(UserContext uc, String orderId) {
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return ResponseObject.newErrResponse((String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select * from bo_eu_dnivt_order_payment_plan where ORDER_ID = ?";
        try {
            List rowMapList = DBSql.getMaps((String)sql, (Object[])new Object[]{orderId});
            ArrayList resultList = new ArrayList();
            for (RowMap map : rowMapList) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("ORDER_ID", map.getString("ORDER_ID"));
                result.put("PLAN_DATE", map.getString("PLAN_DATE"));
                result.put("PLAN_AMOUNT", map.getDouble("PLAN_AMOUNT"));
                resultList.add(result);
            }
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(resultList);
            return responseObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseObject.newErrResponse((String)("\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

