/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilImage;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.DCAPI;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveTeam
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveTeam.class);

    @Meta(parameter={"name: 'teamId', required: false, desc: '\u5c0f\u7ec4ID  \u53ef\u9009\uff0c\u5982\u679c\u672a\u7ed9\u5b9a\uff0c\u5219\u65b0\u5efa\u5c0f\u7ec4\u3002\u53cd\u4e4b\uff0c\u4fee\u6539\u5c0f\u7ec4\uff1b'", "name: 'teamName', required: true, desc: '\u5c0f\u7ec4\u540d'", "name: 'teamType', required: true, desc: '\u5c0f\u7ec4\u7c7b\u578b 1-\u516c\u5171\uff0c2-\u79c1\u6709\uff0c3-\u79d8\u5bc6'", "name: 'teamLogo', required: false, desc: '\u5c0f\u7ec4Logo\uff0c\u6587\u4ef6\u6d41\uff0c\u53ef\u9009'", "name: 'networkId', required: true, desc: '\u5de5\u4f5c\u7f51\u7edcID'", "name: 'teamDesc', required: false, desc: '\u5c0f\u7ec4\u7b80\u4ecb'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = params.get("sid").toString();
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String teamId = params.get("teamId") == null ? "" : params.get("teamId").toString();
            String teamName = params.get("teamName").toString();
            String teamType = params.get("teamType").toString();
            String teamLogo = params.get("teamLogo") == null ? "" : params.get("teamLogo").toString();
            String networkId = params.get("networkId").toString();
            String teamDesc = params.get("teamDesc") == null ? "" : params.get("teamDesc").toString();
            NetworkWeb web = new NetworkWeb(ctx);
            if (UtilString.isEmpty((String)networkId)) {
                networkId = NetworkCache.loadFirstNetworkId();
            }
            if (UtilString.isEmpty((String)networkId)) {
                return ResponseObject.newErrResponse((String)"\u8bf7\u5148\u521b\u5efa\u5de5\u4f5c\u7f51\u7edc");
            }
            NetworkTeamModel model = new NetworkTeamModel();
            model.setId(teamId);
            model.setNetworkId(networkId);
            model.setTeamDesc(teamDesc);
            model.setTeamName(teamName);
            model.setTeamType(teamType);
            model.setTeamLogo("");
            if (UtilString.isEmpty((String)teamId)) {
                model.setId(UUIDGener.getUUID());
                model.setTeamStatus("1");
                model = web.saveTeam(model);
            } else {
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(teamId);
                if (teamModel != null) {
                    teamModel.setTeamName(teamName);
                    teamModel.setTeamDesc(teamDesc);
                    teamModel.setTeamType(teamType);
                    model = web.updateTeam(teamModel);
                } else {
                    ro.err("\u5c0f\u7ec4\u4e0d\u5b58\u5728");
                    return ro;
                }
            }
            if (!UtilString.isEmpty((String)teamLogo)) {
                DCAPI dcApi = SDK.getDCAPI();
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((byte[])teamLogo.getBytes()));
                DataInputStream dataInputStream = new DataInputStream(bais);
                DCContext dc = new DCContext(ctx, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!network-logo"), "com.actionsoft.apps.network", "team", model.getId(), "logo_big.jpg");
                dcApi.write((InputStream)dataInputStream, dc);
                UtilImage.zoomCut((String)dc.getFilePath(), (String)(dc.getPath() + "logo.jpg"), (int)120, (int)120);
            }
            ro.put("stream", (Object)NetworkDataUtil.team2JSON(model, ctx));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro;
    }
}

