/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStreamBySource
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStreamBySource.class);

    @Meta(parameter={"name: 'sourceType', required: true, desc: '\u5bf9\u8c61\u7c7b\u578b\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00'", "name: 'sourceDeptId', required: false, desc: '\u5bf9\u8c61\u90e8\u95e8\u6240\u5c5e\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u9694\u5f00'", "name: 'userId', required: false, desc: '\u7528\u6237Id'", "name: 'isBoss', required: false, desc: '\u662f\u5426Boss\u8d26\u6237,\u9ed8\u8ba4false'", "name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            int limit;
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String sourceType = (String)params.get("sourceType");
            String sourceDeptId = (String)params.get("sourceDeptId");
            String userId = (String)params.get("userId");
            boolean isBoos = (Boolean)params.get("isBoos");
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int n = limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            if (UtilString.isEmpty((String)userId)) {
                userId = ctx.getUID();
            }
            List<Object> streamList = new ArrayList();
            List<Object> channelTypeList = new ArrayList();
            if (isBoos) {
                streamList = NetworkStreamCache.getStreamBySourceType(sourceType);
                channelTypeList = NetworkStreamCache.loadStreamChannelType();
            } else {
                streamList = NetworkStreamCache.loadStreamOfSourceType(sourceType, sourceDeptId, userId);
                if (streamList.size() > 0) {
                    for (NetworkStreamModel model : streamList) {
                        if (model == null || UtilString.isEmpty((String)model.getChannelType()) || channelTypeList.contains(model.getChannelType())) continue;
                        channelTypeList.add(model.getChannelType());
                    }
                }
            }
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamList, "createTime", "DESC");
            if (limit > 0) {
                Page<Object> page = new Page<Object>(start, limit, streamList);
                streamList = page.getListModel();
                ro.put("start", (Object)page.getStart());
                ro.put("limit", (Object)page.getLimit());
                ro.put("pageCount", (Object)page.getPageCount());
            }
            JSONArray streams = NetworkDataUtil.stream2JSON(streamList, ctx);
            ro.put("channelTypes", channelTypeList);
            ro.put("streams", (Object)streams);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

