/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.service;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class wareHouseProductService {
    private static final Logger serviceLogger;
    private static final String BO_WAREHOUSE_PRODUCT = "BO_EU_DNIVT_WAREHOUSE_PRODUCT";
    private static final String BO_WAREHOUSE_PRODUCT_LOT = "BO_EU_DNIVT_WAREHOUSE_PRODUCT_LOT";
    private static volatile wareHouseProductService instance;

    private wareHouseProductService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static wareHouseProductService getInstance() {
        if (instance != null) return instance;
        Class<wareHouseProductService> clazz = wareHouseProductService.class;
        synchronized (wareHouseProductService.class) {
            if (instance != null) return instance;
            instance = new wareHouseProductService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void transfer(UserContext uc, Connection conn, String productId, String fromWarehouseId, String toWarehouseId, int quantity, String serialNumbers, int type, Map<String, Object> params) throws SQLException {
        if (quantity <= 0) {
            serviceLogger.warn("\u8f6c\u79fb\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff0c\u5f53\u524d\u6570\u91cf\uff1a" + quantity);
            return;
        }
        if (fromWarehouseId.equals(toWarehouseId)) {
            serviceLogger.warn("\u6e90\u4ed3\u5e93\u4e0e\u76ee\u6807\u4ed3\u5e93\u76f8\u540c\uff0c\u65e0\u9700\u8f6c\u79fb\uff1a" + fromWarehouseId);
            return;
        }
        try {
            BO targetWarehouseBO = null;
            if (StringUtils.isNotBlank((CharSequence)toWarehouseId)) {
                targetWarehouseBO = this.updateWarehouseStock(uc, conn, productId, toWarehouseId, quantity, true);
            }
            BO sourceWarehouseBO = this.updateWarehouseStock(uc, conn, productId, fromWarehouseId, quantity, false);
            this.processLotAndSerialTransfer(uc, conn, sourceWarehouseBO, targetWarehouseBO, quantity, serialNumbers);
            serviceLogger.info("\u4ea7\u54c1\u8f6c\u79fb\u6210\u529f\uff0c\u4ea7\u54c1ID\uff1a" + productId + "\uff0c\u6570\u91cf\uff1a" + quantity + "\uff0c\u4ece\u4ed3\u5e93\uff1a" + fromWarehouseId + "\u5230\u4ed3\u5e93\uff1a" + toWarehouseId);
            ProcessInstance transfeProcessIns = SDK.getProcessAPI().createBOProcessInstance("obj_e15a8fedeaeb43dc85aa258a7e1cffcf", uc.getUID(), "\u5e93\u5b58\u8f6c\u79fb");
            BO ivtTransfer = new BO();
            ivtTransfer.setAll(params);
            ivtTransfer.setBindId(transfeProcessIns.getId());
            ivtTransfer.set("FROM_WAREHOUSE_ID", (Object)fromWarehouseId);
            ivtTransfer.set("TO_WAREHOUSE_ID", (Object)toWarehouseId);
            ivtTransfer.set("TYPE_ID", (Object)type);
            ivtTransfer.set("PRODUCT_ID", (Object)productId);
            ivtTransfer.set("QUANTITY", (Object)quantity);
            ivtTransfer.set("SN", (Object)serialNumbers);
            SDK.getBOAPI().create("BO_EU_DNIVT_TRANSFER", ivtTransfer, transfeProcessIns, uc, conn);
        }
        catch (Exception e) {
            serviceLogger.error("\u4ea7\u54c1\u8f6c\u79fb\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            throw new SQLException("\u4ea7\u54c1\u8f6c\u79fb\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
    }

    private BO updateWarehouseStock(UserContext uc, Connection conn, String productId, String warehouseId, int quantity, boolean isTarget) throws SQLException {
        BO warehouseBO = (BO)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query(BO_WAREHOUSE_PRODUCT).connection(conn)).addQuery("PRODUCT_ID=", (Object)productId)).addQuery("WAREHOUSE_ID=", (Object)warehouseId)).detail();
        if (warehouseBO != null) {
            int newQty;
            int currentQty = this.objToInt(warehouseBO.get("QUANTITY"));
            int n = newQty = isTarget ? currentQty + quantity : currentQty - quantity;
            if (!isTarget && newQty < 0) {
                throw new SQLException("\u4ed3\u5e93\u5e93\u5b58\u4e0d\u8db3\uff0c\u4ea7\u54c1ID\uff1a" + productId + "\uff0c\u5f53\u524d\u5e93\u5b58\uff1a" + currentQty + "\uff0c\u9700\u64cd\u4f5c\uff1a" + quantity);
            }
            warehouseBO.set("QUANTITY", (Object)newQty);
            SDK.getBOAPI().update(BO_WAREHOUSE_PRODUCT, warehouseBO, conn);
            serviceLogger.debug((isTarget ? "\u66f4\u65b0\u76ee\u6807\u4ed3\u5e93" : "\u66f4\u65b0\u6e90\u4ed3\u5e93") + "\u5e93\u5b58\uff0c\u4ea7\u54c1ID\uff1a" + productId + "\uff0c\u4ed3\u5e93\uff1a" + warehouseId + "\uff0c\u539f\u6570\u91cf\uff1a" + currentQty + (isTarget ? "\uff0c\u65b0\u589e\uff1a" : "\uff0c\u51cf\u5c11\uff1a") + quantity);
        } else if (isTarget) {
            ProcessInstance processIns = SDK.getProcessAPI().createBOProcessInstance("obj_e15a8fedeaeb43dc85aa258a7e1cffcf", uc.getUID(), "\u5e93\u5b58\u8f6c\u79fb");
            warehouseBO = new BO();
            warehouseBO.setBindId(processIns.getId());
            warehouseBO.set("WAREHOUSE_ID", (Object)warehouseId);
            warehouseBO.set("PRODUCT_ID", (Object)productId);
            warehouseBO.set("QUANTITY", (Object)quantity);
            SDK.getBOAPI().create(BO_WAREHOUSE_PRODUCT, warehouseBO, processIns, uc, conn);
            serviceLogger.debug("\u521b\u5efa\u76ee\u6807\u4ed3\u5e93\u5e93\u5b58\u8bb0\u5f55\uff0c\u4ea7\u54c1ID\uff1a" + productId + "\uff0c\u4ed3\u5e93\uff1a" + warehouseId + "\uff0c\u521d\u59cb\u6570\u91cf\uff1a" + quantity);
        } else {
            throw new SQLException("\u6e90\u4ed3\u5e93\u4e0d\u5b58\u5728\u8be5\u4ea7\u54c1\u5e93\u5b58\u8bb0\u5f55\uff0c\u4ea7\u54c1ID\uff1a" + productId + "\uff0c\u4ed3\u5e93\uff1a" + warehouseId);
        }
        return warehouseBO;
    }

    private void processLotAndSerialTransfer(UserContext uc, Connection conn, BO sourceWarehouseBO, BO targetWarehouseBO, int totalQuantity, String serialNumbers) throws SQLException {
        String sourceBindId = sourceWarehouseBO.getBindId();
        String targetBindId = targetWarehouseBO == null ? "" : targetWarehouseBO.getBindId();
        String productId = targetWarehouseBO.getString("PRODUCT_ID");
        String targetWarehouseId = targetWarehouseBO.getString("WAREHOUSE_ID");
        String[] snArray = StringUtils.isBlank((CharSequence)serialNumbers) ? new String[]{} : serialNumbers.split(",");
        HashSet<String> snSet = new HashSet<String>(Arrays.asList(snArray));
        List sourceLots = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query(BO_WAREHOUSE_PRODUCT_LOT).addQuery("BINDID=", (Object)sourceBindId)).addQuery("QUANTITY>", (Object)0)).orderByCreated().list();
        if (snArray.length > 0) {
            int processedCount = 0;
            int totalNeedProcess = snSet.size();
            for (BO lot : sourceLots) {
                if (processedCount >= totalNeedProcess) break;
                String lotSN = lot.getString("SN");
                if (StringUtils.isBlank((CharSequence)lotSN)) continue;
                HashSet<String> currentLotSNs = new HashSet<String>(Arrays.asList(lotSN.split(",")));
                currentLotSNs.retainAll(snSet);
                if (currentLotSNs.isEmpty()) continue;
                HashSet<String> remainingSNs = new HashSet<String>(Arrays.asList(lotSN.split(",")));
                remainingSNs.removeAll(currentLotSNs);
                lot.set("SN", (Object)StringUtils.join(remainingSNs, (String)","));
                lot.set("QUANTITY", (Object)remainingSNs.size());
                SDK.getBOAPI().update(BO_WAREHOUSE_PRODUCT_LOT, lot, conn);
                if (StringUtils.isNotBlank((CharSequence)targetBindId)) {
                    this.updateOrCreateTargetLot(uc, conn, lot, targetBindId, productId, targetWarehouseId, currentLotSNs.size(), StringUtils.join(currentLotSNs, (String)","), true);
                }
                processedCount += currentLotSNs.size();
                snSet.removeAll(currentLotSNs);
            }
            if (!snSet.isEmpty()) {
                serviceLogger.warn("\u90e8\u5206\u5e8f\u5217\u53f7\u672a\u627e\u5230\u5bf9\u5e94\u6279\u6b21\uff0c\u672a\u5904\u7406SN\uff1a" + StringUtils.join(snSet, (String)","));
            }
        } else {
            int remainingQuantity = totalQuantity;
            for (BO lot : sourceLots) {
                if (remainingQuantity <= 0) break;
                int lotQuantity = this.objToInt(lot.get("QUANTITY"));
                if (lotQuantity <= 0) continue;
                int transferQty = Math.min(lotQuantity, remainingQuantity);
                lot.set("QUANTITY", (Object)(lotQuantity - transferQty));
                SDK.getBOAPI().update(BO_WAREHOUSE_PRODUCT_LOT, lot, conn);
                if (StringUtils.isNotBlank((CharSequence)targetBindId)) {
                    this.updateOrCreateTargetLot(uc, conn, lot, targetBindId, productId, targetWarehouseId, transferQty, "", false);
                }
                remainingQuantity -= transferQty;
            }
            if (remainingQuantity > 0) {
                throw new SQLException("\u6e90\u6279\u6b21\u5e93\u5b58\u4e0d\u8db3\uff0c\u5269\u4f59\u672a\u8f6c\u79fb\u6570\u91cf\uff1a" + remainingQuantity);
            }
        }
    }

    private void updateOrCreateTargetLot(UserContext uc, Connection conn, BO sourceLot, String targetBindId, String productId, String targetWarehouseId, int transferQty, String snStr, boolean isSerialized) throws SQLException {
        BO targetLot = (BO)((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query(BO_WAREHOUSE_PRODUCT_LOT).addQuery("LOT=", sourceLot.get("LOT"))).addQuery("ORDER_PRODUCT_ID=", sourceLot.get("ORDER_PRODUCT_ID"))).addQuery("BINDID=", (Object)targetBindId)).detail();
        if (targetLot != null) {
            int newQty = this.objToInt(targetLot.get("QUANTITY")) + transferQty;
            targetLot.set("QUANTITY", (Object)newQty);
            if (isSerialized) {
                String currentSN = targetLot.getString("SN");
                targetLot.set("SN", (Object)(StringUtils.isBlank((CharSequence)currentSN) ? snStr : currentSN + "," + snStr));
            }
            SDK.getBOAPI().update(BO_WAREHOUSE_PRODUCT_LOT, targetLot, conn);
        } else {
            BO newLot = new BO();
            newLot.setAll(sourceLot.asMap());
            newLot.setId(null);
            newLot.setBindId(targetBindId);
            newLot.set("WAREHOUSE_ID", (Object)targetWarehouseId);
            newLot.set("PRODUCT_ID", (Object)productId);
            newLot.set("QUANTITY", (Object)transferQty);
            newLot.set("SN", (Object)snStr);
            SDK.getBOAPI().createDataBO(BO_WAREHOUSE_PRODUCT_LOT, newLot, uc, conn);
        }
    }

    private int objToInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        try {
            String objStr = obj.toString().trim();
            if (objStr.isEmpty()) {
                return 0;
            }
            if (objStr.contains(".")) {
                objStr = objStr.substring(0, objStr.indexOf("."));
            }
            return Integer.parseInt(objStr);
        }
        catch (NumberFormatException e) {
            serviceLogger.error("\u5bf9\u8c61\u8f6c\u6362\u4e3aint\u5931\u8d25\uff0c\u503c\uff1a" + obj, (Throwable)e);
            return 0;
        }
    }

    static {
        SDK.getLogAPI();
        serviceLogger = LogAPI.getLogger(wareHouseProductService.class);
    }
}

