/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTopicsOfNetwork
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchTopicsOfNetwork.class);

    @Meta(parameter={"name: 'networkId', required: true, desc: '\u5de5\u4f5c\u7f51\u7edcID'", "name: 'key', required: false, desc: '\u641c\u7d22\u5173\u952e\u5b57'", "name: 'limit', required: false, desc: '\u6700\u591a\u83b7\u53d6\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String networkId = (String)params.get("networkId");
            String key = params.get("key") == null ? "" : (String)params.get("key");
            int limit = params.get("limit") == null ? 10 : (Integer)params.get("limit");
            NetworkWeb web = new NetworkWeb(ctx);
            JSONArray list = web.findNetworkTopic(key, limit, networkId, "");
            ro.put("list", (Object)list);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }

    private List<NetworkTeamModel> loadTeamByNetwork(String networkId, String userId, String curUserId) {
        List<String> teamIds;
        ArrayList<NetworkTeamModel> tmpList;
        List<Object> teamList = new ArrayList();
        boolean isManager = NetworkDataUtil.isNetworkManager(networkId, curUserId);
        if (isManager) {
            teamList = NetworkTeamCache.loadNetworkTeamBy(networkId);
        } else {
            teamList = NetworkTeamCache.loadNetworkTeamBy(networkId);
            tmpList = new ArrayList<NetworkTeamModel>();
            teamIds = NetworkTeamMemberCache.getTeamIdListByUser(curUserId);
            for (NetworkTeamModel networkTeamModel : teamList) {
                if (!teamIds.contains(networkTeamModel.getId())) continue;
                tmpList.add(networkTeamModel);
            }
            teamList = tmpList;
        }
        if (!UtilString.isEmpty((String)userId) && isManager) {
            teamList = NetworkTeamCache.loadNetworkTeamBy(networkId);
            tmpList = new ArrayList();
            teamIds = NetworkTeamMemberCache.getTeamIdListByUser(userId);
            for (NetworkTeamModel networkTeamModel : teamList) {
                if (!teamIds.contains(networkTeamModel.getId())) continue;
                tmpList.add(networkTeamModel);
            }
            teamList = tmpList;
        }
        return teamList;
    }
}

