/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.TaskInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Controller
public class ivtOrderController {
    @Mapping(value="com.awspaas.user.apps.donenow_ivt.addVendorProduct")
    public ResponseObject addVendorProduct(UserContext uc, String vendorAccountId, String bindId, String processDefId, String warehouseProductIds, int type) {
        String sql = "select * from bo_eu_dnivt_product where id in(select product_id from bo_eu_dnivt_product_vendor where vendor_account_id=?";
        if (type == 1) {
            sql = sql + " and is_default=1 ";
        } else if (type == 2) {
            // empty if block
        }
        sql = sql + " ) and CLOSED=0";
        List list = DBSql.getMaps((String)sql, (Object[])new Object[]{vendorAccountId});
        if (list.isEmpty()) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        ArrayList<JSONObject> warehouseProductIdsMap = new ArrayList<JSONObject>();
        if (warehouseProductIds != null && !warehouseProductIds.isEmpty() && !warehouseProductIds.equals("[]")) {
            JSONArray warehouseProductIdsArray = JSONArray.parseArray((String)warehouseProductIds);
            for (int i = 0; i < warehouseProductIdsArray.size(); ++i) {
                warehouseProductIdsMap.add(warehouseProductIdsArray.getJSONObject(i));
            }
        }
        int cnt = 0;
        for (RowMap map : list) {
            List lctList = DBSql.getMaps((String)"select id,warehouse_id,product_id,quantity,quantity_minimum,quantity_maximum,(select name from bo_eu_dnivt_warehouse where id=warehouse_id) as bin from bo_eu_dnivt_warehouse_product where product_id=? ", (Object[])new Object[]{map.getString("ID")});
            if (lctList == null || lctList.isEmpty()) continue;
            boolean isExist = false;
            if (!warehouseProductIdsMap.isEmpty()) {
                for (int j = 0; j < warehouseProductIdsMap.size(); ++j) {
                    if (!((JSONObject)warehouseProductIdsMap.get(j)).getString("PRODUCT_ID").equals(map.getString("ID")) || !((JSONObject)warehouseProductIdsMap.get(j)).getString("WAREHOUSE_ID").equals(((RowMap)lctList.get(j)).getString("WAREHOUSE_ID"))) continue;
                    isExist = true;
                }
            }
            if (isExist) continue;
            for (RowMap rowMap : lctList) {
                ++cnt;
                BO bo = new BO();
                bo.setBindId(bindId);
                bo.setProcessDefId(processDefId);
                bo.set("PRODUCT_ID", (Object)map.getString("ID"));
                bo.set("NAME", (Object)map.getString("NAME"));
                bo.set("PRODUCT_NAME", (Object)map.getString("NAME"));
                bo.set("WAREHOUSE_ID", (Object)rowMap.getString("WAREHOUSE_ID"));
                bo.set("QUANTITY", (Object)(rowMap.getInt("QUANTITY_MAXIMUM") - rowMap.getInt("QUANTITY")));
                bo.set("UNIT_COST", (Object)map.getString("UNIT_COST"));
                bo.set("WAS_AUTO_FILLED", (Object)1);
                SDK.getBOAPI().createDataBO("BO_EU_DNIVT_ORDER_PRODUCT", bo, uc);
            }
        }
        if (cnt == 0) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.getProductInfo")
    public ResponseObject getProductInfo(UserContext uc, String productId) {
        String sql = "select * from bo_eu_dnivt_product where id=?";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{productId});
        if (map == null) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("NAME", map.getString("NAME"));
        result.put("UNIT_COST", map.getString("UNIT_COST"));
        result.put("UNIT_PRICE", map.getString("UNIT_PRICE"));
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.getTaxInfo")
    public ResponseObject getTaxInfo(UserContext uc, String taxId) {
        String sql = "select OID,NAME,EXT1 from bo_eu_dnd_general where is_active=1 and closed=0  and general_table_id=44 and orgid=? and oid=?";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{uc.getCompanyModel().getId(), taxId});
        if (map == null) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("taxId", map.getString("OID"));
        result.put("NAME", map.getString("NAME"));
        result.put("TAX_RATE", map.getString("EXT1"));
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ivt.purchaseShip")
    public ResponseObject purchaseShip(UserContext uc, String costPdtIds) throws SQLException {
        if (StringUtils.isBlank((CharSequence)costPdtIds)) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        List pdtList = DBSql.getMaps((String)"select ID,STATUS_ID from bo_eu_dnctt_contract_cost_product where id in(?)", (Object[])new Object[]{costPdtIds});
        if (pdtList.isEmpty()) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        for (Object pdtMap : pdtList) {
            if (pdtMap.getString("STATUS_ID").equals("2158")) continue;
            return ResponseObject.newErrResponse((String)"\u8be5\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u914d\u9001");
        }
        try (Connection conn = null;){
            conn = DBSql.open();
            conn.setAutoCommit(false);
            for (RowMap pdtMap : pdtList) {
                pdtMap.put("STATUS_ID", (Object)"2159");
                BO pdtBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", pdtMap.getString("ID"));
                pdtBO.set("SHIPPING_TIME", (Object)new Date());
                pdtBO.set("STATUS_ID", (Object)"2159");
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", pdtBO, conn);
                pdtMap.putAll(pdtBO.asMap());
                String PRODUCT_ID = DBSql.getString((String)"select PRODUCT_ID from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{pdtBO.getString("CONTRACT_COST_ID")});
                pdtMap.put("PRODUCT_ID", (Object)PRODUCT_ID);
                BO costBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", pdtMap.getString("CONTRACT_COST_ID"));
                if (DBSql.getInt((String)"select count(1) from bo_eu_dnctt_contract_cost_product where contract_cost_id=? and status_id<>2159", (Object[])new Object[]{pdtMap.getString("CONTRACT_COST_ID")}) == 0) {
                    costBO.set("STATUS_ID", (Object)"1237");
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", costBO, conn);
                }
                ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_e15a8fedeaeb43dc85aa258a7e1cffcf", uc.getUID(), "\u4ea7\u54c1\u914d\u9001\u8f6c\u79fb\u5e93\u5b58");
                BO transfer = new BO();
                transfer.setBindId(processInstance.getId());
                transfer.set("PRODUCT_ID", (Object)costBO.getString("PRODUCT_ID"));
                transfer.set("TYPE_ID", (Object)"1482");
                transfer.set("QUANTITY", (Object)pdtMap.getInt("QUANTITY"));
                transfer.set("FROM_WAREHOUSE_ID", (Object)pdtMap.getString("WAREHOUSE_ID"));
                if (StringUtils.isNotBlank((CharSequence)costBO.getString("CONTRACT_ID"))) {
                    transfer.set("TO_ACCOUNT_ID", (Object)DBSql.getString((String)"select account_id from bo_eu_dnctt_contract where id=?", (Object[])new Object[]{costBO.getString("CONTRACT_ID")}));
                }
                transfer.set("TO_CONTRACT_ID", (Object)costBO.getString("CONTRACT_ID"));
                SDK.getBOAPI().create("BO_EU_DNIVT_TRANSFER", transfer, processInstance, uc, conn);
                BO lctPdtBO = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_WAREHOUSE_PRODUCT").addQuery("PRODUCT_ID=", (Object)costBO.getString("PRODUCT_ID"))).addQuery("WAREHOUSE_ID=", (Object)pdtMap.getString("WAREHOUSE_ID"))).detail();
                if (lctPdtBO == null) continue;
                lctPdtBO.set("QUANTITY", (Object)((Integer)lctPdtBO.get("QUANTITY", Integer.class) - pdtMap.getInt("QUANTITY")));
                SDK.getBOAPI().update("BO_EU_DNIVT_WAREHOUSE_PRODUCT", lctPdtBO, conn);
                List sns = DBSql.getList((String)"select sn from bo_eu_dnctt_contract_cost_product_sn where contract_cost_product_id=?", String.class, (Object[])new Object[]{pdtMap.getString("ID")});
                if (sns == null || sns.isEmpty()) continue;
                for (String sn : sns) {
                    BO lctPdtSnBO = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_WAREHOUSE_PRODUCT_SN").addQuery("sn=", (Object)sn)).addQuery("warehouse_product_id=", (Object)lctPdtBO.getId())).detail();
                    if (lctPdtSnBO != null) {
                        SDK.getBOAPI().remove("BO_EU_DNIVT_WAREHOUSE_PRODUCT_SN", lctPdtSnBO.getId(), conn);
                    }
                    BO tsfSnBO = new BO();
                    tsfSnBO.setBindId(processInstance.getId());
                    tsfSnBO.set("SN", (Object)sn);
                    tsfSnBO.set("TRANSFER_ID", (Object)transfer.getId());
                    SDK.getBOAPI().create("BO_EU_DNIVT_TRANSFER_SN", tsfSnBO, processInstance, uc, conn);
                }
            }
            conn.commit();
        }
        return ResponseObject.newOkResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ivt.purchaseUnShip")
    public ResponseObject purchaseUnShip(UserContext uc, String costPdtIds) throws SQLException {
        if (StringUtils.isBlank((CharSequence)costPdtIds)) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        List pdtList = DBSql.getMaps((String)"select ID,STATUS_ID,CONTRACT_COST_ID,QUANTITY,WAREHOUSE_ID from bo_eu_dnctt_contract_cost_product where id in(?)", (Object[])new Object[]{costPdtIds});
        if (pdtList.isEmpty()) {
            return ResponseObject.newErrResponse((String)"\u65e0\u6570\u636e");
        }
        try (Connection conn = null;){
            conn = DBSql.open();
            conn.setAutoCommit(false);
            for (RowMap pdtMap : pdtList) {
                List sns;
                BO pdtBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", pdtMap.getString("ID"));
                String PRODUCT_ID = DBSql.getString((String)"select PRODUCT_ID from BO_EU_DNCTT_CONTRACT_COST where ID=?", (Object[])new Object[]{pdtBO.getString("CONTRACT_COST_ID")});
                pdtBO.set("STATUS_ID", (Object)"2158");
                pdtBO.set("SHIPPING_TIME", null);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", pdtBO, conn);
                BO costBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_COST", pdtBO.getString("CONTRACT_COST_ID"));
                if (costBO.getString("STATUS_ID").equals("1237")) {
                    costBO.set("STATUS_ID", (Object)"1236");
                    SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_COST", costBO, conn);
                }
                ProcessInstance processInstance = SDK.getProcessAPI().createBOProcessInstance("obj_e15a8fedeaeb43dc85aa258a7e1cffcf", uc.getUID(), "\u53d6\u6d88\u914d\u9001\u65b0\u5efa\u5e93\u5b58\u8f6c\u79fb");
                BO tsf = new BO();
                tsf.setBindId(processInstance.getId());
                tsf.set("PRODUCT_ID", (Object)PRODUCT_ID);
                tsf.set("TYPE_ID", (Object)"1482");
                tsf.set("QUANTITY", pdtBO.get("QUANTITY"));
                tsf.set("FROM_WAREHOUSE_ID", (Object)pdtBO.getString("WAREHOUSE_ID"));
                if (StringUtils.isNotBlank((CharSequence)costBO.getString("CONTRACT_ID"))) {
                    tsf.set("TO_ACCOUNT_ID", (Object)DBSql.getString((String)"select account_id from bo_eu_dnctt_contract where id=?", (Object[])new Object[]{costBO.getString("CONTRACT_ID")}));
                }
                tsf.set("TO_CONTRACT_ID", (Object)costBO.getString("CONTRACT_ID"));
                SDK.getBOAPI().create("BO_EU_DNIVT_TRANSFER", tsf, processInstance, uc, conn);
                BO lctPdtBO = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNIVT_WAREHOUSE_PRODUCT").addQuery("PRODUCT_ID=", (Object)PRODUCT_ID)).addQuery("WAREHOUSE_ID=", (Object)pdtBO.getString("WAREHOUSE_ID"))).detail();
                if (lctPdtBO != null) {
                    lctPdtBO.set("QUANTITY", (Object)((Integer)lctPdtBO.get("QUANTITY", Integer.class) + (Integer)pdtBO.get("QUANTITY", Integer.class)));
                    SDK.getBOAPI().update("BO_EU_DNIVT_WAREHOUSE_PRODUCT", lctPdtBO, conn);
                }
                if ((sns = DBSql.getList((String)"select sn from bo_eu_dnctt_contract_cost_product_sn where contract_cost_product_id=?", String.class, (Object[])new Object[]{pdtMap.getString("ID")})) == null || sns.isEmpty()) continue;
                for (String sn : sns) {
                    BO lctPdtSn = new BO();
                    lctPdtSn.set("SN", (Object)sn);
                    lctPdtSn.set("WAREHOUSE_PRODUCT_ID", (Object)lctPdtBO.getId());
                    SDK.getBOAPI().create("BO_EU_DNIVT_WAREHOUSE_PRODUCT_SN", lctPdtSn, lctPdtBO.getBindId(), uc.getUID(), conn);
                    BO tsfSn = new BO();
                    tsfSn.set("SN", (Object)sn);
                    tsfSn.set("TRANSFER_ID", (Object)tsf.getId());
                    SDK.getBOAPI().create("BO_EU_DNIVT_TRANSFER_SN", tsfSn, tsf.getBindId(), uc.getUID(), conn);
                }
            }
            conn.commit();
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.printPackingList")
    public String printPackingList(UserContext uc, String costPdtIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uid", uc.getUID());
        map.put("sid", uc.getSessionId());
        map.put("costPdtIds", costPdtIds);
        List accountList = DBSql.getMaps((String)"select DISTINCT a.ACCOUNT_ID,c.NAME as ACCOUNT_NAME from  bo_eu_dnctt_contract_cost a join bo_eu_dnctt_contract_cost_product b on a.id=b.contract_cost_id JOIN bo_eu_dncrm_account c ON a.ACCOUNT_ID=c.ID where  FIND_IN_SET(b.id,?)", (Object[])new Object[]{costPdtIds});
        map.put("accountList", JSON.toJSONString((Object)accountList));
        return HtmlPageTemplate.merge((String)"PrintPackingList.html", map);
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.printPickingList")
    public String printPickingList(UserContext uc, String costPdtIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uid", uc.getUID());
        map.put("sid", uc.getSessionId());
        map.put("costPdtIds", costPdtIds);
        List accountList = DBSql.getMaps((String)"select DISTINCT a.ACCOUNT_ID,c.NAME as ACCOUNT_NAME from  bo_eu_dnctt_contract_cost a join bo_eu_dnctt_contract_cost_product b on a.id=b.contract_cost_id JOIN bo_eu_dncrm_account c ON a.ACCOUNT_ID=c.ID where  FIND_IN_SET(b.id,?)", (Object[])new Object[]{costPdtIds});
        map.put("accountList", JSON.toJSONString((Object)accountList));
        return HtmlPageTemplate.merge((String)"PrintPickingList.html", map);
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.getCostProductPackList")
    public ResponseObject getCostProductPackList(UserContext uc, String costPdtIds, String accountId) {
        String sql = "SELECT T.ACCOUNT_NAME,( SELECT CONCAT( IFNULL(( SELECT CNNAME FROM BO_ACT_DICT_KV_ITEM WHERE ITEMNO = X.DISTRICT_ID AND DICTKEY = 'GB.ADDR'), '' ), IFNULL( X.ADDRESS, '' ), IFNULL( X.ADDITIONAL_ADDRESS, '' ), ' ', IFNULL( X.POSTAL_CODE, '' )) FROM BO_EU_DNCRM_LOCATION X WHERE X.ID = T.SHIP_TO ) AS SHIP_TO_ADDRESS, T.ACCOUNT_ID, T.SHIP_TO, GROUP_CONCAT( T.ID ) AS CONTRACT_COST_IDS FROM ( SELECT OP.ID, IFNULL( C.ACCOUNT_ID, IFNULL( P.ACCOUNT_ID, T.ACCOUNT_ID )) AS ACCOUNT_ID, ( SELECT NAME FROM CRM_ACCOUNT WHERE ID = IFNULL( C.ACCOUNT_ID, IFNULL( P.ACCOUNT_ID, T.ACCOUNT_ID ))) ACCOUNT_NAME, IFNULL(( SELECT LOCATION_ID FROM BO_EU_DNIVT_ORDER WHERE ID = OP.ORDER_ID ),( CASE WHEN SO.SHIP_TO_USE_ACCOUNT_ADDRESS = 1 OR SO.SHIP_TO_USE_BILL_TO_ADDRESS = 1 AND SO.BILL_TO_USE_ACCOUNT_ADDRESS = 1 THEN ( SELECT ID FROM CRM_LOCATION WHERE IS_DEFAULT = 1 AND ACCOUNT_ID = IFNULL( C.ACCOUNT_ID, IFNULL( P.ACCOUNT_ID, T.ACCOUNT_ID ))) WHEN SO.SHIP_TO_USE_BILL_TO_ADDRESS = 1 AND SO.BILL_TO_USE_ACCOUNT_ADDRESS = 0 THEN SO.BILL_TO_LOCATION_ID ELSE SO.SHIP_TO_LOCATION_ID END )) SHIP_TO FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT OP JOIN BO_EU_DNCTT_CONTRACT_COST B ON OP.CONTRACT_COST_ID = B.ID JOIN BO_EU_DNIVT_PRODUCT A ON B.PRODUCT_ID = A.ID LEFT JOIN BO_EU_DNCTT_CONTRACT C ON C.ID = B.CONTRACT_ID LEFT JOIN BO_EU_DNPRO_PROJECT P ON P.ID = B.PROJECT_ID LEFT JOIN BO_EU_DNSDK_TASK T ON T.ID = B.TASK_ID LEFT JOIN BO_EU_DNCRM_SALES_ORDER SO ON B.OPPORTUNITY_ID = SO.OPPORTUNITY_ID WHERE FIND_IN_SET(OP.ID,?) AND  (C.ACCOUNT_ID=? OR P.ACCOUNT_ID=? OR T.ACCOUNT_ID=?) ) T GROUP BY T.ACCOUNT_ID, T.SHIP_TO";
        List maps = DBSql.getMaps((String)sql, (Object[])new Object[]{costPdtIds, accountId, accountId, accountId});
        for (RowMap map : maps) {
            String SALES_ADDRESS = DBSql.getString((String)"SELECT CONCAT( IFNULL(( SELECT CNNAME FROM BO_ACT_DICT_KV_ITEM WHERE ITEMNO = X.DISTRICT_ID AND DICTKEY = 'GB.ADDR'), '' ), IFNULL( X.ADDRESS, '' ), IFNULL( X.ADDITIONAL_ADDRESS, '' ), ' ', IFNULL( X.POSTAL_CODE, '' )) AS ADDRESS FROM BO_EU_DNCRM_LOCATION X WHERE X.ID =( SELECT B.LOCATION_ID FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT A JOIN BO_EU_DNIVT_ORDER B ON A.ORDER_ID = B.ID WHERE FIND_IN_SET(A.ID,?)  AND B.LOCATION_ID IS NOT NULL LIMIT 1 )", (Object[])new Object[]{map.get((Object)"CONTRACT_COST_IDS")});
            map.put("SALES_ADDRESS", (Object)SALES_ADDRESS);
            List accountCosts = DBSql.getMaps((String)"SELECT A.ID,A.CONTRACT_ID,A.PROJECT_ID,A.TASK_ID FROM  BO_EU_DNCTT_CONTRACT_COST  A JOIN BO_EU_DNCTT_CONTRACT_COST_PRODUCT B ON A.ID=B.CONTRACT_COST_ID WHERE FIND_IN_SET(B.ID,?) ", (Object[])new Object[]{map.get((Object)"CONTRACT_COST_IDS")});
            String CONTRACT_INFO = null;
            String PROJECT_INFO = null;
            String TASK_INFO = null;
            if (!accountCosts.isEmpty()) {
                ArrayList<String> contractIds = new ArrayList<String>();
                ArrayList<String> projectIds = new ArrayList<String>();
                ArrayList<String> taskIds = new ArrayList<String>();
                for (RowMap accountCost : accountCosts) {
                    if (accountCost.get((Object)"CONTRACT_ID") != null && StringUtils.isNotBlank((CharSequence)accountCost.getString("CONTRACT_ID"))) {
                        contractIds.add(accountCost.getString("CONTRACT_ID"));
                    }
                    if (accountCost.get((Object)"PROJECT_ID") != null && StringUtils.isNotBlank((CharSequence)accountCost.getString("PROJECT_ID"))) {
                        projectIds.add(accountCost.getString("PROJECT_ID"));
                    }
                    if (accountCost.get((Object)"TASK_ID") == null || !StringUtils.isNotBlank((CharSequence)accountCost.getString("TASK_ID"))) continue;
                    taskIds.add(accountCost.getString("TASK_ID"));
                }
                if (!contractIds.isEmpty()) {
                    CONTRACT_INFO = DBSql.getString((String)"SELECT GROUP_CONCAT(`name`  SEPARATOR '<br/>'  ) FROM BO_EU_DNCTT_CONTRACT WHERE FIND_IN_SET(ID,?) ", (Object[])new Object[]{StringUtils.join(contractIds, (String)",")});
                }
                if (!projectIds.isEmpty()) {
                    PROJECT_INFO = DBSql.getString((String)"SELECT GROUP_CONCAT(`name`  SEPARATOR '<br/>'  ) FROM BO_EU_DNPRO_PROJECT WHERE FIND_IN_SET(ID,?) ", (Object[])new Object[]{StringUtils.join(projectIds, (String)",")});
                }
                if (!taskIds.isEmpty()) {
                    TASK_INFO = DBSql.getString((String)"SELECT GROUP_CONCAT(`name`  SEPARATOR '<br/>'  ) FROM BO_EU_DNSDK_TASK WHERE FIND_IN_SET(ID,?) ", (Object[])new Object[]{StringUtils.join(taskIds, (String)",")});
                }
            }
            map.put("CONTRACT_INFO", CONTRACT_INFO);
            map.put("PROJECT_INFO", PROJECT_INFO);
            map.put("TASK_INFO", TASK_INFO);
            map.put("PACKINGS", (Object)DBSql.getMaps((String)"SELECT DISTINCT A.CONTRACT_COST_ID AS CONTRACTCOSTID, A.QUANTITY, ( SELECT GROUP_CONCAT( SN ) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT_SN WHERE CONTRACT_COST_PRODUCT_ID = A.ID ) AS SERIALNUMBER , C.`NAME` AS 'PRODUCTNAME' FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT A JOIN BO_EU_DNCTT_CONTRACT_COST B ON A.CONTRACT_COST_ID=B.ID JOIN BO_EU_DNIVT_PRODUCT C ON B.PRODUCT_ID=C.ID WHERE  FIND_IN_SET(A.ID,?) ", (Object[])new Object[]{map.get((Object)"CONTRACT_COST_IDS")}));
        }
        System.out.println(maps);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)maps);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.getCostProductPickList")
    public ResponseObject getCostProductPickList(UserContext uc, String costPdtIds, String accountId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List costs = DBSql.getMaps((String)"select a.* from  bo_eu_dnctt_contract_cost a join bo_eu_dnctt_contract_cost_product b on a.id=b.contract_cost_id JOIN bo_eu_dncrm_account c ON a.ACCOUNT_ID=c.ID where  FIND_IN_SET(b.id,?) AND a.ACCOUNT_ID=?", (Object[])new Object[]{costPdtIds, accountId});
        List pickingProducts = DBSql.getMaps((String)"SELECT DISTINCT C.ID AS 'CONTRACTCOSTID', A.QUANTITY, B.REFERENCE_NUMBER AS 'REFERENCENUMBER', B.BIN AS 'LOCATION', D.`NAME` AS 'WAREHOUSE', C.DESCRIPTION AS 'PRODUCTREMARK', P.`NAME` AS 'PRODUCTNAME' FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT A JOIN BO_EU_DNIVT_WAREHOUSE_PRODUCT B ON A.WAREHOUSE_ID = B.WAREHOUSE_ID JOIN BO_EU_DNCTT_CONTRACT_COST C ON C.PRODUCT_ID = B.PRODUCT_ID AND A.CONTRACT_COST_ID = C.ID JOIN BO_EU_DNIVT_WAREHOUSE D ON A.WAREHOUSE_ID = D.ID JOIN BO_EU_DNIVT_PRODUCT P ON P.ID = C.PRODUCT_ID WHERE FIND_IN_SET(A.ID,?) AND C.ACCOUNT_ID=? ", (Object[])new Object[]{costPdtIds, accountId});
        String CONTRACT_INFO = null;
        String PROJECT_INFO = null;
        String TASK_INFO = null;
        if (!costs.isEmpty()) {
            ArrayList<String> contractIds = new ArrayList<String>();
            ArrayList<String> projectIds = new ArrayList<String>();
            ArrayList<String> taskIds = new ArrayList<String>();
            for (RowMap accountCost : costs) {
                if (accountCost.get((Object)"CONTRACT_ID") != null && StringUtils.isNotBlank((CharSequence)accountCost.getString("CONTRACT_ID"))) {
                    contractIds.add(accountCost.getString("CONTRACT_ID"));
                }
                if (accountCost.get((Object)"PROJECT_ID") != null && StringUtils.isNotBlank((CharSequence)accountCost.getString("PROJECT_ID"))) {
                    projectIds.add(accountCost.getString("PROJECT_ID"));
                }
                if (accountCost.get((Object)"TASK_ID") == null || !StringUtils.isNotBlank((CharSequence)accountCost.getString("TASK_ID"))) continue;
                taskIds.add(accountCost.getString("TASK_ID"));
            }
            if (!contractIds.isEmpty()) {
                CONTRACT_INFO = DBSql.getString((String)"SELECT GROUP_CONCAT(`name`  SEPARATOR '<br/>'  ) FROM BO_EU_DNCTT_CONTRACT WHERE FIND_IN_SET(ID,?) ", (Object[])new Object[]{StringUtils.join(contractIds, (String)",")});
            }
            if (!projectIds.isEmpty()) {
                PROJECT_INFO = DBSql.getString((String)"SELECT GROUP_CONCAT(`name`  SEPARATOR '<br/>'  ) FROM BO_EU_DNPRO_PROJECT WHERE FIND_IN_SET(ID,?) ", (Object[])new Object[]{StringUtils.join(projectIds, (String)",")});
            }
            if (!taskIds.isEmpty()) {
                TASK_INFO = DBSql.getString((String)"SELECT GROUP_CONCAT(`name`  SEPARATOR '<br/>'  ) FROM BO_EU_DNSDK_TASK WHERE FIND_IN_SET(ID,?) ", (Object[])new Object[]{StringUtils.join(taskIds, (String)",")});
            }
        }
        result.put("CONTRACT_INFO", CONTRACT_INFO);
        result.put("PROJECT_INFO", PROJECT_INFO);
        result.put("TASK_INFO", TASK_INFO);
        result.put("PICKINGS", pickingProducts);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.viewPurchaseOrder")
    public String viewPurchaseOrder(UserContext uc, String ID) {
        UserModel accountModel;
        UserModel vendorModel;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uid", uc.getUID());
        map.put("sid", uc.getSessionId());
        RowMap purchaseOrder = DBSql.getMap((String)"SELECT * FROM BO_EU_DNIVT_ORDER WHERE ID = ?", (Object[])new Object[]{ID});
        List purchaseOrderProducts = DBSql.getMaps((String)"SELECT * FROM bo_eu_dnivt_order_product WHERE ORDER_ID = ?", (Object[])new Object[]{ID});
        map.put("purchase_order_no", purchaseOrder.getString("PURCHASE_ORDER_NO"));
        map.put("create_user_name", UserCache.getModel((String)purchaseOrder.getString("CREATEUSER")).getUserName());
        map.put("create_time", purchaseOrder.getString("CREATEDATE"));
        map.put("external_purchase_order_no", purchaseOrder.getString("EXTERNAL_PURCHASE_ORDER_NO"));
        String vendor_name = "";
        String vendor_phone = "";
        if (StringUtils.isNotBlank((CharSequence)purchaseOrder.getString("VENDOR_ACCOUNT_ID")) && (vendorModel = UserCache.getModel((String)purchaseOrder.getString("VENDOR_ACCOUNT_ID"))) != null) {
            vendor_name = vendorModel.getUserName();
            vendor_phone = vendorModel.getMobile();
        }
        map.put("vendor_name", vendor_name);
        map.put("vendor_phone", vendor_phone);
        String account_name = "";
        String account_phone = "";
        if (StringUtils.isNotBlank((CharSequence)purchaseOrder.getString("PURCHASE_ACCOUNT_ID")) && (accountModel = UserCache.getModel((String)purchaseOrder.getString("PURCHASE_ACCOUNT_ID"))) != null) {
            account_name = accountModel.getUserName();
            account_phone = accountModel.getMobile();
        }
        map.put("account_name", account_name);
        map.put("account_phone", account_phone);
        map.put("contract", DBSql.getString((String)"select GROUP_CONCAT(concat(name,' ',ifnull(description,'')) SEPARATOR '//') from bo_eu_dnctt_contract  where id in(select contract_id from bo_eu_dnctt_contract_cost where id in(select contract_cost_id from bo_eu_dnivt_order_product where closed=0 and order_id=?))", (Object[])new Object[]{ID}));
        map.put("other_info", DBSql.getString((String)"select concat( ifnull( (select concat('\u5546\u673a\u53f7:',GROUP_CONCAT(oid)) from bo_eu_dncrm_opportunity where id in(select opportunity_id from bo_eu_dnctt_contract_cost where id in(select contract_cost_id from bo_eu_dnivt_order_product where closed=0 and order_id=? )) ),''),' ', ifnull( (select concat('\u9879\u76ee:',GROUP_CONCAT(name SEPARATOR '//')) from bo_eu_dnpro_project where id in(select project_id from bo_eu_dnctt_contract_cost where id in(select contract_cost_id from bo_eu_dnivt_order_product where closed=0 and order_id=? )) ),''), ' ', ifnull( (select concat('\u5de5\u5355:',GROUP_CONCAT(no SEPARATOR '//') )from bo_eu_dnsdk_task where id in(select task_id from bo_eu_dnctt_contract_cost where id in(select contract_cost_id from bo_eu_dnivt_order_product where closed=0 and order_id=? )) ),'') )", (Object[])new Object[]{ID, ID, ID}));
        map.put("order_phone", purchaseOrder.getString("PHONE"));
        map.put("payment_term", DBSql.getString((String)"SELECT NAME FROM bo_eu_dnd_general WHERE OID = ? AND CLOSED=0 AND ORGID=?", (Object[])new Object[]{purchaseOrder.getString("PAYMENT_TERM_ID"), uc.getCompanyModel().getId()}));
        map.put("shipping_type", DBSql.getString((String)"SELECT NAME FROM bo_eu_dnd_general WHERE OID = ? AND CLOSED=0 AND ORGID=?", (Object[])new Object[]{purchaseOrder.getString("SHIPPING_TYPE_ID"), uc.getCompanyModel().getId()}));
        map.put("expected_ship_date", purchaseOrder.getString("EXPECTED_SHIP_DATE"));
        map.put("note", purchaseOrder.getString("NOTE"));
        List taxCateList = DBSql.getMaps((String)"SELECT * FROM bo_eu_dnd_general WHERE ORGID=? AND CLOSED=0 AND GENERAL_TABLE_ID=44", (Object[])new Object[]{uc.getCompanyModel().getId()});
        double total_cost = 0.0;
        ArrayList items = new ArrayList();
        for (RowMap item : purchaseOrderProducts) {
            RowMap taxCat;
            HashMap<String, String> itemMap = new HashMap<String, String>();
            itemMap.put("name", item.getString("NAME"));
            itemMap.put("note", item.getString("NOTE"));
            double unit_cost = item.getDouble("UNIT_COST");
            total_cost += unit_cost;
            itemMap.put("unit_cost", String.format("%.2f", unit_cost));
            double tax_cost = 0.0;
            String tax_category_id = item.getString("TAX_CATEGORY_ID");
            if (StringUtils.isNotBlank((CharSequence)tax_category_id) && (taxCat = (RowMap)taxCateList.stream().filter(taxCate -> taxCate.getString("ID").equals(tax_category_id)).findAny().orElse(null)) != null) {
                tax_cost = unit_cost * (taxCat.getDouble("EXT1") + 1.0);
            }
            itemMap.put("tax_cost", String.format("%.2f", tax_cost));
            itemMap.put("quantity", item.getString("QUANTITY"));
            itemMap.put("total_cost", String.format("%.2f", unit_cost * item.getDouble("QUANTITY")));
            items.add(itemMap);
        }
        map.put("total_cost", total_cost);
        map.put("items", JSONObject.toJSONString(items));
        for (String key : map.keySet()) {
            map.putIfAbsent(key, "");
        }
        return HtmlPageTemplate.merge((String)"ViewPurchaseOrder.html", map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ivt.createPurchaseOrder")
    public ResponseObject createPurchaseOrder(UserContext uc, String costIds) throws SQLException {
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            String[] costIdArr = costIds.split(",");
            String sql = "SELECT * FROM BO_EU_DNCTT_CONTRACT_COST WHERE ID IN(";
            for (int i = 0; costIdArr.length > i; ++i) {
                sql = sql + "?,";
            }
            sql = sql.substring(0, sql.length() - 1) + ")";
            List costList = DBSql.getMaps((String)sql, (Object[])Arrays.stream(costIdArr).toArray());
            ProcessInstance processInstance = SDK.getProcessAPI().createProcessInstance("obj_795cb3601f3a4b919b5896cf5b076a3a", uc.getUID(), "\u91c7\u8d2d\u8ba2\u5355");
            BO purchaseOrder = new BO();
            purchaseOrder.setBindId(processInstance.getId());
            purchaseOrder.set("SUBMIT_TIME", (Object)ivtOrderController.getCurrentDateTime());
            purchaseOrder.set("SUBMITTED_RESOURCE_ID", (Object)uc.getUID());
            SDK.getBOAPI().createDataBO("BO_EU_DNIVT_ORDER", purchaseOrder, uc, conn);
            for (RowMap cost : costList) {
                BO purchaseOrderProduct = new BO();
                purchaseOrderProduct.setBindId(processInstance.getId());
                purchaseOrderProduct.set("PURCHASE_ACCOUNT_ID", (Object)cost.getString("ACCOUNT_ID"));
                purchaseOrderProduct.set("NAME", (Object)cost.getString("NAME"));
                purchaseOrderProduct.set("PRODUCT_ID", (Object)cost.getString("PRODUCT_ID"));
                purchaseOrderProduct.set("QUANTITY", (Object)cost.getString("QUANTITY"));
                purchaseOrderProduct.set("UNIT_COST", (Object)cost.getString("UNIT_COST"));
                purchaseOrderProduct.set("TAX_CATEGORY_ID", (Object)cost.getString("TAX_CATEGORY_ID"));
                purchaseOrderProduct.set("COST_TOTAL", (Object)cost.getString("EXTENDED_COST"));
                purchaseOrderProduct.set("CONTRACT_ID", (Object)cost.getString("CONTRACT_ID"));
                purchaseOrderProduct.set("PROJECT_ID", (Object)cost.getString("PROJECT_ID"));
                purchaseOrderProduct.set("TASK_ID", (Object)cost.getString("TASK_ID"));
                purchaseOrderProduct.set("CONTRACT_COST_ID", (Object)cost.getString("ID"));
                purchaseOrderProduct.set("CONTRACT_SERVICE_ID", (Object)cost.getString("SERVICE_ID"));
                purchaseOrderProduct.set("ORDER_ID", (Object)purchaseOrder.getId());
                SDK.getBOAPI().createDataBO("BO_EU_DNIVT_ORDER_PRODUCT", purchaseOrderProduct, uc, conn);
                BO costProduct = new BO();
                costProduct.setBindId(cost.getString("BINDID"));
                costProduct.set("ORDER_ID", (Object)purchaseOrder.getId());
                costProduct.set("CONTRACT_COST_ID", (Object)cost.getString("ID"));
                costProduct.set("STATUS_ID", (Object)"2156");
                costProduct.set("QUANTITY", (Object)cost.getString("QUANTITY"));
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_COST_PRODUCT", costProduct, uc, conn);
            }
            List taskInstances = SDK.getProcessAPI().start(processInstance).fetchActiveTasks();
            conn.commit();
            TaskInstance taskInstance = (TaskInstance)taskInstances.get(0);
            String processUrl = SDK.getFormAPI().getFormURL(SDK.getPortalAPI().getPortalUrl(), uc.getSessionId(), processInstance.getId(), taskInstance.getId(), taskInstance.getState(), null, null, null, true);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData((Object)processUrl);
            ResponseObject responseObject2 = responseObject;
            return responseObject2;
        }
        catch (Exception e) {
            conn.rollback();
        }
        finally {
            DBSql.close((Connection)conn);
        }
        return ResponseObject.newErrResponse((String)"\u521b\u5efa\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25");
    }

    private static String getCurrentDateTime() {
        String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        return sdf.format(new Date());
    }
}

