/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_sys.controller;

import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

@Controller
public class testController {
    private static final int KEY_SIZE = 128;
    private static final int IV_SIZE = 16;
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private static final String AES_ECB = "AES/ECB/PKCS5Padding";

    @Mapping(value="donenow_sys.jiuye_index", session=false, noSessionEvaluate="\u65e0\u5b89\u5168\u9690\u60a3", noSessionReason="\u7528\u4e8eMVC\u6846\u67b6\u7a33\u5b9a\u6027\u6d4b\u8bd5")
    public String jiuye_index() {
        System.out.println("jiuye_index");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uid", "jiuye_test1");
        String sid = "";
        try {
            String ses = SDK.getPortalAPI().createClientSessionByPC("jiuye_test1", "Aa1", "cn", "", "");
            System.out.println(ses);
            JSONObject obj = JSONObject.parseObject((String)ses);
            sid = obj.getJSONObject("data").getString("sid");
            map.put("sid", sid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(sid);
        map.put("url", SDK.getPortalAPI().getPortalUrl() + "/r/w?sid=" + sid + "&cmd=CLIENT_P_PORTAL_HOME&id=com.awspaas.user.apps.portal.1751251354216&msaAppId=com.awspaas.user.apps.portal.175125135421");
        System.out.println(map);
        return HtmlPageTemplate.merge((String)"jiuye_index.html", map);
    }

    @Mapping(value="donenow_sys.jiuye_index2", session=false, noSessionEvaluate="\u65e0\u5b89\u5168\u9690\u60a3", noSessionReason="\u7528\u4e8eMVC\u6846\u67b6\u7a33\u5b9a\u6027\u6d4b\u8bd5")
    public String jiuye_index2() throws Exception {
        System.out.println("jiuye_index");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("uid", "jiuye_test1");
        String sid = "ck_21232f297a57a5a743894a0e4a801fc3_ck";
        map.put("sid", sid);
        JSONObject obj = JSONObject.parseObject((String)SDK.getPortalAPI().createClientSessionByPC("jiuye_test1", "Aa1", "cn", null));
        JSONObject obj2 = JSONObject.parseObject((String)obj.getString("data"));
        String createSid = obj2.getString("sid");
        map.put("url", SDK.getPortalAPI().getPortalUrl() + "/r/w?sid=" + sid + "&cmd=CLIENT_P_PORTAL_HOME&id=com.awspaas.user.apps.portal.1751251354216&msaAppId=com.awspaas.user.apps.portal.175125135421");
        String url = SDK.getPortalAPI().getPortalUrl() + "/r/w?sid=" + sid + "&cmd=CLIENT_P_PORTAL_HOME&id=com.awspaas.user.apps.portal.1751251354216&msaAppId=com.awspaas.user.apps.portal.175125135421";
        String modifiedHtml = testController.getModifiedContent(url);
        return modifiedHtml;
    }

    public static String getModifiedContent(String url) {
        try {
            Element navUl;
            Document doc = Jsoup.connect((String)url).userAgent("Mozilla/5.0").timeout(10000).ignoreContentType(true).followRedirects(true).execute().parse();
            Element topElement = doc.select("#app > div > div.aws-portal.top-nav > section > section > header.el-header.public-header-border > div > div").first();
            if (topElement != null) {
                topElement.remove();
            }
            if ((navUl = doc.select("#app > div > div.aws-portal.top-nav > section > section > header.el-header.top-nav-border > div > div > div > div.menu-box > ul").first()) != null) {
                for (int i = navUl.childrenSize() - 1; i >= 1; --i) {
                    navUl.child(i).remove();
                }
                testController.addMenuItem(navUl, "\u5b66\u6821", "school");
                testController.addMenuItem(navUl, "\u5355\u4f4d", "company");
                testController.addMenuItem(navUl, "\u5b66\u751f", "student");
            }
            return doc.outerHtml();
        }
        catch (IOException e) {
            System.err.println("\u5904\u7406HTML\u65f6\u51fa\u9519: " + e.getMessage());
            return null;
        }
    }

    private static void addMenuItem(Element parent, String text, String id) {
        Element li = parent.ownerDocument().createElement("li");
        li.attr("class", "el-sub-menu");
        li.attr("role", "menuitem");
        li.attr("id", "custom-" + id);
        Element a = parent.ownerDocument().createElement("a");
        a.attr("href", "javascript:void(0);");
        a.attr("class", "el-menu-item");
        a.text(text);
        li.appendChild((Node)a);
        parent.appendChild((Node)li);
    }

    @Mapping(value="donenow_sys.test", session=false, noSessionEvaluate="\u65e0\u5b89\u5168\u9690\u60a3", noSessionReason="\u7528\u4e8eMVC\u6846\u67b6\u7a33\u5b9a\u6027\u6d4b\u8bd5")
    public String test(String plainText, int keySize) throws Exception {
        return this.aesKeyGeneration(plainText, keySize);
    }

    @Mapping(value="donenow_sys.test1", session=false, noSessionEvaluate="\u65e0\u5b89\u5168\u9690\u60a3", noSessionReason="\u7528\u4e8eMVC\u6846\u67b6\u7a33\u5b9a\u6027\u6d4b\u8bd5")
    public String test1(String plainText, String aesKey) throws Exception {
        String result = "\r\n \u52a0\u5bc6\u539f\u6587:" + plainText;
        result = result + "\r\n \u52a0\u5bc6\u5bc6\u94a5:" + aesKey;
        try {
            String encryptedTextECB = testController.encryptWithECB(plainText, aesKey);
            result = result + "\r\n ECB \u52a0\u5bc6\u5bc6\u6587encodeURIComponent:" + encryptedTextECB;
            result = result + "\r\n ECB \u52a0\u5bc6\u5bc6\u6587:" + testController.encodeURIComponent(encryptedTextECB);
            String encryptedTextCBC = testController.encryptWithCBC(plainText, aesKey);
            result = result + "\r\n CBC \u52a0\u5bc6\u540eencodeURIComponent:" + encryptedTextCBC;
            result = result + "\r\n CBC \u52a0\u5bc6\u540e:" + testController.encodeURIComponent(encryptedTextCBC);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Mapping(value="donenow_sys.test2", session=false, noSessionEvaluate="\u65e0\u5b89\u5168\u9690\u60a3", noSessionReason="\u7528\u4e8eMVC\u6846\u67b6\u7a33\u5b9a\u6027\u6d4b\u8bd5")
    public String test2(String encryptedText, String aesKey) throws Exception {
        String result = "\r\n \u52a0\u5bc6\u539f\u6587:" + encryptedText;
        result = result + "\r\n \u52a0\u5bc6\u5bc6\u94a5:" + aesKey;
        try {
            String tokenResultCBC = testController.decryptAuto(encryptedText, aesKey);
            result = result + "\r\n AES  CBC \u89e3\u5bc6\u7ed3\u679c:" + tokenResultCBC;
            String tokenResultECB = testController.decryptAuto(encryptedText, aesKey);
            result = result + "\r\n AES EBC \u89e3\u5bc6\u7ed3\u679c:" + tokenResultECB;
        }
        catch (Exception e) {
            result = result + "\u5f02\u5e38:" + e.getMessage();
        }
        return result;
    }

    @Mapping(value="donenow_sys.test3", session=false, noSessionEvaluate="\u65e0\u5b89\u5168\u9690\u60a3", noSessionReason="\u7528\u4e8eMVC\u6846\u67b6\u7a33\u5b9a\u6027\u6d4b\u8bd5")
    public String test3(String encryptedText, String aesKey) throws Exception {
        String result = "\r\n \u52a0\u5bc6\u539f\u6587:" + encryptedText;
        result = result + "\r\n \u52a0\u5bc6\u5bc6\u94a5:" + aesKey;
        try {
            String tokenResultCBC = testController.AESDecrypt(encryptedText, aesKey);
            result = result + "\r\n AES  CBC \u89e3\u5bc6\u7ed3\u679c:" + tokenResultCBC;
            String tokenResultECB = testController.AESDecrypt(encryptedText, aesKey);
            result = result + "\r\n AES EBC \u89e3\u5bc6\u7ed3\u679c:" + tokenResultECB;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String aesKeyGeneration(String plainText, int keySize) throws Exception {
        SecretKey secretKey = null;
        try {
            secretKey = keySize == 128 || keySize == 192 || keySize == 256 ? testController.generateAESKey(keySize) : testController.generateAESKey(128);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String base64Key = Base64.getEncoder().encodeToString(secretKey.getEncoded());
        String hexKey = testController.bytesToHex(secretKey.getEncoded());
        String aesKey = "AES \u5bc6\u94a5 (Base64): " + base64Key;
        aesKey = aesKey + "\r\n \u52a0\u5bc6\u539f\u6587:" + plainText;
        String encryptedTextECB = testController.encryptWithECB(plainText, base64Key);
        aesKey = aesKey + "\r\n ECB \u52a0\u5bc6\u5bc6\u6587:" + encryptedTextECB;
        String encryptedTextCBC = testController.encryptWithCBC(plainText, base64Key);
        aesKey = aesKey + "\r\n CBC \u52a0\u5bc6\u540e:" + encryptedTextCBC;
        String tokenResultECB = testController.decryptAuto(encryptedTextECB, base64Key);
        aesKey = aesKey + "\r\n AES EBC \u89e3\u5bc6\u7ed3\u679c:" + tokenResultECB;
        String tokenResultCBC = testController.decryptAuto(encryptedTextCBC, base64Key);
        aesKey = aesKey + "\r\n AES  CBC \u89e3\u5bc6\u7ed3\u679c:" + tokenResultCBC;
        return aesKey;
    }

    public static SecretKey generateAESKey(int keySizeInBits) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(keySizeInBits);
        return kg.generateKey();
    }

    public static byte[] generateIV() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String encrypt(String plainText, SecretKey secretKey, IvParameterSpec iv) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_CBC);
        cipher.init(1, (Key)secretKey, iv);
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String encrypt(String plainText, SecretKey secretKey) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_ECB);
        cipher.init(1, secretKey);
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String AESDecrypt(String encryptedToken, String secretKey) throws Exception {
        try {
            String result = testController.AESDecrypt(encryptedToken, secretKey, "CBC");
            if (StringUtils.isBlank((CharSequence)result)) {
                result = testController.AESDecrypt(encryptedToken, secretKey, "ECB");
            }
            return result;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                return testController.AESDecrypt(encryptedToken, secretKey, "ECB");
            }
            catch (Exception e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static String AESDecrypt(String encryptedToken, String secretKey, String mode) throws Exception {
        String transformation;
        if (encryptedToken == null || encryptedToken.isEmpty()) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (secretKey == null || secretKey.isEmpty()) {
            throw new IllegalArgumentException("\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int keyLength = secretKey.getBytes(StandardCharsets.UTF_8).length * 8;
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new IllegalArgumentException("\u5bc6\u94a5\u957f\u5ea6\u5fc5\u987b\u662f16\u300124\u621632\u5b57\u8282 (\u5206\u522b\u5bf9\u5e94128\u3001192\u6216256\u4f4d)");
        }
        IvParameterSpec ivParameterSpec = null;
        switch (mode.toUpperCase()) {
            case "ECB": {
                transformation = AES_ECB;
                break;
            }
            case "CBC": {
                transformation = AES_CBC;
                byte[] encryptedBytes = Base64.getDecoder().decode(encryptedToken);
                if (encryptedBytes.length < 16) {
                    throw new IllegalArgumentException("CBC\u6a21\u5f0f\u4e0b\u52a0\u5bc6\u6570\u636e\u957f\u5ea6\u5fc5\u987b\u81f3\u5c11\u4e3a16\u5b57\u8282");
                }
                byte[] ivBytes = new byte[16];
                System.arraycopy(encryptedBytes, 0, ivBytes, 0, 16);
                ivParameterSpec = new IvParameterSpec(ivBytes);
                byte[] cipherTextBytes = new byte[encryptedBytes.length - 16];
                System.arraycopy(encryptedBytes, 16, cipherTextBytes, 0, cipherTextBytes.length);
                encryptedToken = Base64.getEncoder().encodeToString(cipherTextBytes);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u6a21\u5f0f: " + mode);
            }
        }
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance(transformation);
            if (ivParameterSpec != null) {
                cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            } else {
                cipher.init(2, secretKeySpec);
            }
            byte[] decryptedBytes = cipher.doFinal(Base64.getDecoder().decode(encryptedToken));
            return new String(decryptedBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            System.err.println("AES\u89e3\u5bc6\u5931\u8d25: " + e.getMessage());
            throw new Exception("\u89e3\u5bc6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef", e);
        }
    }

    public static String encryptWithCBC(String plainText, String base64Key) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(base64Key);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        Cipher cipher = Cipher.getInstance(AES_CBC);
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        byte[] encrypted = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        byte[] combined = new byte[iv.length + encrypted.length];
        System.arraycopy(iv, 0, combined, 0, iv.length);
        System.arraycopy(encrypted, 0, combined, iv.length, encrypted.length);
        return Base64.getEncoder().encodeToString(combined);
    }

    public static String encryptWithECB(String plainText, String base64Key) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(base64Key);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        Cipher cipher = Cipher.getInstance(AES_ECB);
        cipher.init(1, key);
        byte[] encrypted = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public static String decryptAuto(String encryptedBase64, String base64Key) throws Exception {
        try {
            String result = testController.decryptWithCBC(encryptedBase64, base64Key);
            if (StringUtils.isBlank((CharSequence)result)) {
                result = testController.decryptWithECB(encryptedBase64, base64Key);
            }
            return result;
        }
        catch (Exception e) {
            try {
                return testController.decryptWithECB(encryptedBase64, base64Key);
            }
            catch (Exception ex) {
                throw new RuntimeException("\u65e0\u6cd5\u89e3\u5bc6\uff0c\u8bf7\u786e\u8ba4\u5bc6\u94a5\u548c\u52a0\u5bc6\u6a21\u5f0f\u662f\u5426\u6b63\u786e");
            }
        }
    }

    public static String decryptWithCBC(String encryptedBase64, String base64Key) throws Exception {
        byte[] combined = Base64.getDecoder().decode(encryptedBase64);
        if (combined.length < 16) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u6570\u636e\u957f\u5ea6\u4e0d\u8db3");
        }
        byte[] iv = new byte[16];
        byte[] cipherText = new byte[combined.length - 16];
        System.arraycopy(combined, 0, iv, 0, 16);
        System.arraycopy(combined, 16, cipherText, 0, cipherText.length);
        byte[] keyBytes = Base64.getDecoder().decode(base64Key);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        Cipher cipher = Cipher.getInstance(AES_CBC);
        cipher.init(2, (Key)key, new IvParameterSpec(iv));
        byte[] decrypted = cipher.doFinal(cipherText);
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    public static String decryptWithECB(String encryptedBase64, String base64Key) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(base64Key);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        Cipher cipher = Cipher.getInstance(AES_ECB);
        cipher.init(2, key);
        byte[] decrypted = cipher.doFinal(Base64.getDecoder().decode(encryptedBase64));
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    public static String encodeURIComponent(String s) {
        if (s == null) {
            return null;
        }
        try {
            String encoded = URLEncoder.encode(s, "UTF-8");
            encoded = encoded.replaceAll("\\+", "%20");
            encoded = encoded.replaceAll("\\%21", "!").replaceAll("\\%27", "'").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\%7E", "~").replaceAll("\\%2A", "\\*").replaceAll("\\%2D", "-").replaceAll("\\%5F", "_");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

