/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkTopicModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopicDao
extends DaoObject<NetworkTopicModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkTopicDao.class);

    public List<NetworkTopicModel> loadNetworkTopicOfCache() {
        List<NetworkTopicModel> list = new ArrayList<NetworkTopicModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append(this.entityName());
            list = DBSql.query((String)sql.toString(), this.rowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public int insert(NetworkTopicModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        model.setId(UUIDGener.getUUID());
        paramsMap.put("ID", model.getId());
        paramsMap.put("NETWORKID", model.getNetworkId());
        paramsMap.put("TEAMID", model.getTeamId());
        paramsMap.put("TOPICNAME", model.getTopicName());
        paramsMap.put("TOPICCOUNT", model.getTopicCount());
        paramsMap.put("CREATETIME", model.getCreateTime());
        paramsMap.put("CREATEUSERID", model.getCreateUserId());
        paramsMap.put("CREATEUSERNAME", model.getCreateUserName());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        int result = DBSql.update((String)DBSql.getInsertStatement((String)"APP_ACT_NETWORK_TOPIC", paramsMap), paramsMap);
        return result;
    }

    public int update(NetworkTopicModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("NETWORKID", model.getNetworkId());
        paramsMap.put("TEAMID", model.getTeamId());
        paramsMap.put("TOPICNAME", model.getTopicName());
        paramsMap.put("TOPICCOUNT", model.getTopicCount());
        paramsMap.put("LASTACTIVE", model.getLastActive());
        return super.update((Object)model.getId(), paramsMap);
    }

    public String entityName() {
        return "APP_ACT_NETWORK_TOPIC";
    }

    public RowMapper<NetworkTopicModel> rowMapper() {
        return new ModelRowMapper();
    }

    private static class ModelRowMapper
    implements RowMapper<NetworkTopicModel> {
        private ModelRowMapper() {
        }

        public NetworkTopicModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkTopicModel model = new NetworkTopicModel();
            model.setId(rs.getString("ID"));
            model.setNetworkId(rs.getString("NETWORKID"));
            model.setTeamId(rs.getString("TEAMID"));
            model.setTopicName(rs.getString("TOPICNAME"));
            model.setTopicCount(rs.getInt("TOPICCOUNT"));
            model.setCreateUserId(rs.getString("CREATEUSERID"));
            model.setCreateUserName(rs.getString("CREATEUSERNAME"));
            model.setCreateTime(rs.getTimestamp("CREATETIME"));
            model.setLastActive(rs.getTimestamp("LASTACTIVE"));
            return model;
        }
    }
}

