/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStream
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStream.class);

    @Meta(parameter={"name: 'streamId', required: true, desc: '\u4fe1\u606f\u6d41ID'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String streamId = params.get("streamId").toString();
            NetworkStreamModel model = NetworkStreamCache.getModel(streamId);
            if (model != null) {
                JSONObject stream = NetworkDataUtil.stream2JSONOfOriginal(model, ctx);
                ro.put("stream", (Object)stream);
            } else {
                ro.err("\u8be5\u52a8\u6001\u5df2\u88ab\u5220\u9664!");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

