/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.service.contractService;
import dn.recordFormChanges;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Controller
public class contractCreateController {
    private static final Logger contractLogger;

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_submit")
    public ResponseObject contractSubmit(UserContext uc, String bindid) {
        contractLogger.info("contractLogger.info \u5408\u540c\u63d0\u4ea4\u540e---------------" + bindid);
        Map<String, Object> result = contractService.getInstance().SaveContract(uc, bindid, true);
        if (!result.getOrDefault("success", false).equals(true)) {
            return ResponseObject.newErrResponse((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ResponseObject.newOkResponse((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.get_contractapply")
    public ResponseObject getContractApply(UserContext uc, String bindid) {
        RowMap contractDetail = DBSql.getMap((String)"SELECT ID,BINDID,PROCESSDEFID FROM BO_EU_DNCTT_CONTRACT WHERE BINDID=? ", (Object[])new Object[]{bindid});
        if (contractDetail == null || contractDetail.isEmpty()) {
            contractDetail = DBSql.getMap((String)"SELECT ID,BINDID,PROCESSDEFID FROM BO_EU_DNCTT_CONTRACT_APPLY WHERE BINDID=? ", (Object[])new Object[]{bindid});
        }
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)contractDetail);
        return responseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_delete")
    public ResponseObject contractDelete(UserContext uc, String bindid, String id) throws SQLException {
        int cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNPRO_PROJECT WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u9879\u76ee\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNSDK_TASK WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u4efb\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCRM_INSTALLED_PRODUCT WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u4ea7\u54c1\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT_COST WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u5408\u540c\u6210\u672c\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCRM_ACCOUNT_DEDUCTION WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u5df2\u8ba1\u8d39\u6761\u76ee\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNSDK_WORK_ENTRY WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u5de5\u65f6\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT WHERE (ID=? OR BINDID=?) AND SETUP_FEE!=0 AND SETUP_FEE IS NOT NULL AND CLOSED=0", (Object[])new Object[]{id, bindid});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)"\u8be5\u5408\u540c\u5408\u540c\u521d\u59cb\u8d39\u7528\u5df2\u5ba1\u6279\u5e76\u63d0\u4ea4\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE (CONTRACT_ID=? OR BINDID=?) AND APPROVE_AND_POST_DATE IS NOT NULL AND CLOSED=0", (Object[])new Object[]{id, bindid});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)"\u8be5\u5408\u540c\u670d\u52a1\u5df2\u5ba1\u6279\u5e76\u63d0\u4ea4\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE (CONTRACT_ID=? OR BINDID=?) AND APPROVE_AND_POST_DATE IS NOT NULL AND CLOSED=0", (Object[])new Object[]{id, bindid});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)"\u8be5\u5408\u540c\u670d\u52a1\u5df2\u5ba1\u6279\u5e76\u63d0\u4ea4\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("CONTRACT_ID", id);
            params.put("BINDID", bindid);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_RATE", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_MILESTONE", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_COST_DEFAULT", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", params, conn);
            List SBSboList = ((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE").addQuerySqlWhere(" CONTRACT_SERVICE_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID))  AND CLOSED=0", params)).list();
            for (Object bo : SBSboList) {
                bo.set("CLOSED", (Object)1);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE", (BO)bo, conn);
            }
            List SABSboList = ((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE").addQuerySqlWhere(" CONTRACT_SERVICE_ADJUST_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID))  AND CLOSED=0", params)).list();
            for (BO bo : SABSboList) {
                bo.set("CLOSED", (Object)1);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE", bo, conn);
            }
            List SPBSboList = ((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE").addQuerySqlWhere(" CONTRACT_SERVICE_PERIOD_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID))  AND CLOSED=0", params)).list();
            for (BO bo : SPBSboList) {
                bo.set("CLOSED", (Object)1);
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE", bo, conn);
            }
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (conn != null && !conn.isClosed()) {
                conn.rollback();
            }
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        return ResponseObject.newOkResponse();
    }

    private void updateContractCLOSED(UserContext uc, String boName, Map<String, Object> params, Connection conn) {
        List boList = ((BOQueryAPI)SDK.getBOAPI().query(boName).addQuerySqlWhere(" (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID) AND CLOSED=0", params)).list();
        for (BO bo : boList) {
            recordFormChanges.deleteBeforeRecord((UserContext)uc, (String)boName, (String)bo.getId(), (String)"\u5220\u9664", (Connection)conn);
            SDK.getBOAPI().remove(boName, bo.getId(), conn);
        }
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_cost_delete", desc="\u5408\u540c\u4ea7\u54c1\u5220\u9664")
    public ResponseObject deleteContractProduct(UserContext uc, String costIds) {
        if (StringUtils.isBlank((CharSequence)costIds)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6761\u76ee\uff01");
        }
        String[] costIdArr = costIds.split(",");
        String sql = "SELECT * FROM BO_EU_DNCTT_CONTRACT_COST WHERE ID IN(";
        for (int i = 0; costIdArr.length > i; ++i) {
            sql = sql + "?,";
        }
        sql = sql.substring(0, sql.length() - 1) + ")";
        List costList = DBSql.getMaps((String)sql, (Object[])Arrays.stream(costIdArr).toArray());
        ArrayList<String> errorList = new ArrayList<String>();
        for (RowMap cost : costList) {
            if (DBSql.getInt((String)"SELECT COUNT(ID) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=?", (Object[])new Object[]{cost.getString("ID")}) > 0) {
                errorList.add(cost.getString("NAME") + "\u5df2\u62e3\u8d27");
            }
            if (DBSql.getInt((String)"SELECT COUNT(ID) FROM BO_EU_DNIVT_ORDER_PRODUCT WHERE CONTRACT_COST_ID=?", (Object[])new Object[]{cost.getString("ID")}) <= 0) continue;
            errorList.add(cost.getString("NAME") + "\u5df2\u521b\u5efa\u91c7\u8d2d\u5355");
        }
        if (errorList.size() > 0) {
            return ResponseObject.newErrResponse((String)(StringUtils.join(errorList, (String)"\u3001") + "\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        for (RowMap cost : costList) {
            SDK.getProcessAPI().deleteById(cost.getString("BINDID"), uc.getUID());
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_service_delete", desc="\u5220\u9664\u5408\u540c\u670d\u52a1")
    public ResponseObject deleteContractService(UserContext uc, String serviceIds) {
        String[] costIdArr = serviceIds.split(",");
        String selSql = "DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE ID IN(";
        for (int i = 0; costIdArr.length > i; ++i) {
            selSql = selSql + "?,";
        }
        selSql = selSql.substring(0, selSql.length() - 1) + ")";
        List serviceList = DBSql.getMaps((String)selSql, (Object[])Arrays.stream(costIdArr).toArray());
        for (RowMap service : serviceList) {
            List csaIdList = DBSql.getList((String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"ID")});
            for (String csaId : csaIdList) {
                DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE where CONTRACT_SERVICE_ADJUST_ID=? ", (Object[])new Object[]{csaId});
            }
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where  CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"ID")});
            List cspIdList = DBSql.getList((String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where  CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"OBJECT_ID"), service.get((Object)"ID")});
            for (String cspId : cspIdList) {
                DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE where CONTRACT_SERVICE_PERIOD_ID=? ", (Object[])new Object[]{cspId});
            }
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"OBJECT_ID"), service.get((Object)"ID")});
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE where CONTRACT_ID=? and OBJECT_ID=? and ID=?", (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"OBJECT_ID"), service.get((Object)"ID")});
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_service_edit")
    public ResponseObject editContractService(UserContext uc, String serviceId) {
        RowMap contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE ID=?", (Object[])new Object[]{serviceId});
        contractService2.remove((Object)"ID");
        contractService2.remove((Object)"BINDID");
        ProcessInstance contractInstance = SDK.getProcessAPI().createBOProcessInstance("obj_e4b0c7ae587c406b808f3a4785f05e23", uc.getUID(), "\u670d\u52a1\u8c03\u6574-" + contractService2.getString("NAME") + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        BO editBO = new BO();
        editBO.setAll((Map)contractService2);
        editBO.set("CONTRACT_SERVICE_ID", (Object)serviceId);
        editBO.set("OLD_UNIT_PRICE", contractService2.get((Object)"UNIT_PRICE"));
        editBO.set("OLD_TOTAL_PRICE", contractService2.get((Object)"TOTAL_PRICE"));
        editBO.set("OLD_UNIT_COST", contractService2.get((Object)"UNIT_COST"));
        editBO.set("OLD_QUANTITY", contractService2.get((Object)"QUANTITY"));
        editBO.set("OLD_TOTAL_COST", contractService2.get((Object)"TOTAL_COST"));
        editBO.setBindId(contractInstance.getId());
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_SERVICE_EDIT", editBO, contractInstance, uc);
        String processUrl = SDK.getFormAPI().getFormURL(SDK.getPortalAPI().getPortalUrl(), uc.getSessionId(), contractInstance.getId(), null, 1, null, editBO.getId(), null, true);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)processUrl);
        return responseObject;
    }

    static {
        SDK.getLogAPI();
        contractLogger = LogAPI.getLogger(contractCreateController.class);
    }
}

