/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class QrCodeReaderUtil {
    public static String readQrCode(File file) {
        if (!file.exists()) {
            return "\u9519\u8bef\uff1a\u6587\u4ef6\u4e0d\u5b58\u5728\u3002";
        }
        String fileName = file.getName().toLowerCase();
        try {
            if (fileName.endsWith(".pdf")) {
                return QrCodeReaderUtil.readQrFromPdf(file);
            }
            if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg") || fileName.endsWith(".png") || fileName.endsWith(".gif")) {
                return QrCodeReaderUtil.readQrFromImage(file);
            }
            return "\u9519\u8bef\uff1a\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u683c\u5f0f\u3002\u8bf7\u63d0\u4f9b\u56fe\u7247(.jpg, .png\u7b49)\u6216PDF(.pdf)\u6587\u4ef6\u3002";
        }
        catch (Exception e) {
            return "\u5904\u7406\u6587\u4ef6\u65f6\u53d1\u751f\u672a\u77e5\u9519\u8bef: " + e.getMessage();
        }
    }

    private static String readQrFromImage(File imageFile) throws IOException {
        BufferedImage image = ImageIO.read(imageFile);
        if (image == null) {
            return "\u65e0\u6cd5\u52a0\u8f7d\u56fe\u7247\u6216\u56fe\u7247\u683c\u5f0f\u4e0d\u652f\u6301\u3002";
        }
        return QrCodeReaderUtil.decodeImage(image);
    }

    private static String readQrFromPdf(File pdfFile) throws IOException {
        try (PDDocument document = PDDocument.load((File)pdfFile);){
            if (document.isEncrypted()) {
                String string = "\u9519\u8bef\uff1a\u65e0\u6cd5\u5904\u7406\u52a0\u5bc6\u7684PDF\u6587\u4ef6\u3002";
                return string;
            }
            PDFRenderer renderer = new PDFRenderer(document);
            int numPages = document.getNumberOfPages();
            System.out.println("\u5f00\u59cb\u626b\u63cfPDF\u6587\u4ef6\uff0c\u5171 " + numPages + " \u9875...");
            for (int i = 0; i < numPages; ++i) {
                BufferedImage image = renderer.renderImageWithDPI(i, 300.0f);
                String result = QrCodeReaderUtil.decodeImage(image);
                if (result.startsWith("\u5728\u56fe\u7247\u4e2d\u672a\u627e\u5230\u4e8c\u7ef4\u7801") || result.startsWith("\u8bc6\u522b\u4e8c\u7ef4\u7801\u65f6\u53d1\u751f\u672a\u77e5\u9519\u8bef")) continue;
                System.out.println("\u5728\u7b2c " + (i + 1) + " \u9875\u6210\u529f\u8bc6\u522b\u5230\u4e8c\u7ef4\u7801\u3002");
                String string = result;
                return string;
            }
            String string = "\u5728PDF\u6587\u4ef6\u7684\u6240\u6709\u9875\u9762\u4e2d\u5747\u672a\u627e\u5230\u4e8c\u7ef4\u7801\u3002";
            return string;
        }
    }

    private static String decodeImage(BufferedImage image) {
        try {
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
            hints.put(DecodeHintType.POSSIBLE_FORMATS, EnumSet.of(BarcodeFormat.QR_CODE));
            hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
            MultiFormatReader reader = new MultiFormatReader();
            Result result = reader.decode(bitmap, hints);
            return "\u5185\u5bb9: " + result.getText() + "; \u683c\u5f0f: " + result.getBarcodeFormat();
        }
        catch (NotFoundException e) {
            return "\u5728\u56fe\u7247\u4e2d\u672a\u627e\u5230\u4e8c\u7ef4\u7801\u3002";
        }
        catch (Exception e) {
            return "\u8bc6\u522b\u4e8c\u7ef4\u7801\u65f6\u53d1\u751f\u672a\u77e5\u9519\u8bef: " + e.getMessage();
        }
    }
}

