/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.job;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.service.contractService;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class AutoRenewJob
implements Job {
    private static final Logger jobLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String nowDate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        LocalDate next2Year = LocalDate.now().plusYears(2L);
        List list = DBSql.getMaps((String)("SELECT a.ID, a.BINDID, a.START_DATE, a.END_DATE, b.EFFECTIVE_DATE, c.CONTRACT_SERVICE_ID, MIN(c.PERIOD_BEGIN_DATE) AS PERIOD_BEGIN_DATE, MIN(c.PERIOD_END_DATE) AS PERIOD_END_DATE, COUNT(c.ID) AS CNT FROM bo_eu_dnctt_contract a JOIN bo_eu_dnctt_contract_service b ON a.ID = b.CONTRACT_ID JOIN bo_eu_dnctt_contract_service_period c ON b.ID = c.CONTRACT_SERVICE_ID WHERE a.AUTO_RENEW=1 AND c.PERIOD_END_DATE>='" + nowDate + "' GROUP BY a.ID, a.BINDID, a.START_DATE, a.END_DATE, b.EFFECTIVE_DATE, c.CONTRACT_SERVICE_ID HAVING COUNT(c.ID)<=1 ORDER BY PERIOD_BEGIN_DATE DESC"), (Object[])new Object[0]);
        UserContext uc = UserContext.fromUID((String)"admin");
        contractService serviceOp = contractService.getInstance();
        for (RowMap rowMap : list) {
            String contractId = rowMap.getString("ID");
            String bindId = rowMap.getString("BINDID");
            String startDate = rowMap.getString("START_DATE");
            String endDate = rowMap.getString("END_DATE");
            String effectiveDate = rowMap.getString("EFFECTIVE_DATE");
            String contractServiceId = rowMap.getString("CONTRACT_SERVICE_ID");
            String periodBeginDate = rowMap.getString("PERIOD_BEGIN_DATE");
            String periodEndDate = rowMap.getString("PERIOD_END_DATE");
            int cnt = rowMap.getInt("CNT");
            System.out.println("contractId:" + contractId);
            BO contract = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", contractId);
            if (contract == null) continue;
            LocalDate START_DATE = contractService.getLocalDate(contract.get("START_DATE"));
            LocalDate END_DATE = contractService.getLocalDate(contract.get("END_DATE"));
            if (!(END_DATE = END_DATE.plusYears(1L)).isBefore(next2Year)) continue;
            contract.set("END_DATE", (Object)contractService.LocalDateYYYYMMDD(END_DATE));
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", contract);
            jobLogger.info("\u5408\u540c:" + contract.getString("NAME") + "[" + contract.getString("NO") + "]\u5f00\u59cb\u7eed\u7ea6");
            jobLogger.info("\u539f\u7ed3\u675f\u65e5\u671f\uff1a" + endDate + "----\u65b0\u7ed3\u675f\u65e5\u671f\uff1a" + contractService.LocalDateYYYYMMDD(END_DATE));
            Connection conn = null;
            try {
                conn = DBSql.open();
                conn.setAutoCommit(false);
                List serviceList = ((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").connection(conn)).addQuery("CONTRACT_ID =", contract.get("ID"))).list();
                for (BO service : serviceList) {
                    serviceOp.ServiceAdjustEndDate(uc, service, END_DATE, conn);
                }
                conn.commit();
            }
            catch (SQLException e) {
                jobLogger.info("AddServiceServiceBundle--error--\u5931\u8d25\u3002\u3002\u3002" + e.getMessage());
                e.printStackTrace();
                try {
                    conn.rollback();
                }
                catch (SQLException ex) {
                    throw new RuntimeException(ex);
                }
            }
            finally {
                if (conn != null) {
                    DBSql.close((Connection)conn);
                }
            }
            jobLogger.info("\u5408\u540c:" + contract.getString("NAME") + "[" + contract.getString("NO") + "]\u7ed3\u675f\u7eed\u7ea6");
        }
    }

    static {
        SDK.getLogAPI();
        jobLogger = LogAPI.getLogger(AutoRenewJob.class);
    }
}

