/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.job;

import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.TypeUtil;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.service.contractServiceAdj;
import java.time.LocalDate;
import java.util.List;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ServiceAutoRenewJob
implements Job {
    private static final Logger jobLogger;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        UserContext uc = UserContext.fromUID((String)"admin");
        List sales = DBSql.getMaps((String)"SELECT c.CONTRACT_SERVICE_ID, MAX( c.PERIOD_BEGIN_DATE) AS PERIOD_BEGIN_DATE, MAX( c.PERIOD_END_DATE) AS  PERIOD_END_DATE FROM bo_eu_dnctt_contract a JOIN bo_eu_dnctt_contract_service b ON a.ID = b.CONTRACT_ID JOIN bo_eu_dnctt_contract_service_period c ON b.ID = c.CONTRACT_SERVICE_ID WHERE a.AUTO_RENEW = 1  AND b.PERIOD_TYPE<>'609'  GROUP BY c.CONTRACT_SERVICE_ID HAVING MAX( c.PERIOD_BEGIN_DATE)<=DATE_ADD(NOW(), INTERVAL 1 MONTH)", (Object[])new Object[0]);
        for (RowMap sale : sales) {
            String contractServiceId = sale.getString("CONTRACT_SERVICE_ID");
            LocalDate EFFECTIVE_DATE = (LocalDate)TypeUtil.convert((Object)sale.getDate("PERIOD_END_DATE"), LocalDate.class);
            contractServiceAdj.getInstance().editServiceSaleEndDate(uc, contractServiceId, EFFECTIVE_DATE.plusYears(1L).plusDays(1L));
        }
        List purchs = DBSql.getMaps((String)"SELECT c.CONTRACT_SERVICE_ID, MAX( c.PERIOD_BEGIN_DATE) AS PERIOD_BEGIN_DATE, MAX( c.PERIOD_END_DATE) AS  PERIOD_END_DATE FROM bo_eu_dnctt_contract a JOIN bo_eu_dnctt_contract_service b ON a.ID = b.CONTRACT_ID JOIN BO_EU_DNIVT_ORDER_PAYMENT_PLAN c ON b.ID = c.CONTRACT_SERVICE_ID WHERE a.AUTO_RENEW = 1   AND b.PURCHASE_PERIOD_TYPE<>'609' GROUP BY c.CONTRACT_SERVICE_ID HAVING MAX( c.PERIOD_BEGIN_DATE)<=DATE_ADD(NOW(), INTERVAL 1 MONTH)", (Object[])new Object[0]);
        for (RowMap purch : purchs) {
            String contractServiceId = purch.getString("CONTRACT_SERVICE_ID");
            LocalDate EFFECTIVE_DATE = (LocalDate)TypeUtil.convert((Object)purch.getDate("PERIOD_END_DATE"), LocalDate.class);
            contractServiceAdj.getInstance().editServicePurchaseEndDate(uc, contractServiceId, EFFECTIVE_DATE.plusYears(1L).plusDays(1L));
        }
    }

    static {
        SDK.getLogAPI();
        jobLogger = LogAPI.getLogger(ServiceAutoRenewJob.class);
    }
}

