/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.service;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.TypeUtil;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.PeriodCalculationUtil;
import com.awspaas.user.apps.donenow_ctt.service.contractService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class contractServiceAdj {
    private static final Logger contractServiceLogger;
    private final String[] excludesArray = new String[]{"ID", "ORGID", "BINDID", "CREATEDATE", "CREATEUSER", "UPDATEDATE", "UPDATEUSER", "PROCESSDEFID", "ISEND"};
    private static volatile contractServiceAdj instance;

    private contractServiceAdj() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static contractServiceAdj getInstance() {
        if (instance != null) return instance;
        Class<contractServiceAdj> clazz = contractServiceAdj.class;
        synchronized (contractServiceAdj.class) {
            if (instance != null) return instance;
            instance = new contractServiceAdj();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String editServiceSale(UserContext uc, String serviceId, String remark) {
        BO editBO;
        ProcessInstance contractInstance;
        RowMap contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST WHERE CONTRACT_SERVICE_ID=? AND IS_EFFECTIVE='\u672a\u6267\u884c' ", (Object[])new Object[]{serviceId});
        if (contractService2 != null) {
            return contractService2.getString("BINDID");
        }
        contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST WHERE CONTRACT_SERVICE_ID=? AND IS_EFFECTIVE='\u5df2\u6267\u884c' ORDER BY  CREATEDATE DESC ", (Object[])new Object[]{serviceId});
        String processDefId = "obj_e65c7e68c00544afb66a27848a5cba14";
        if (contractService2 == null) {
            contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE ID=?", (Object[])new Object[]{serviceId});
            contractService2.remove((Object)"ID");
            contractService2.remove((Object)"BINDID");
            contractInstance = SDK.getProcessAPI().createBOProcessInstance(processDefId, uc.getUID(), "\u670d\u52a1\u8c03\u6574-" + contractService2.getString("NAME") + "-\u521d\u59cb");
            editBO = new BO();
            contractService2.remove((Object)"CREATEDATE");
            contractService2.remove((Object)"CREATEUSER");
            editBO.setAll((Map)contractService2);
            editBO.setBindId(contractInstance.getId());
            editBO.set("CONTRACT_SERVICE_ID", (Object)serviceId);
            editBO.set("IS_EFFECTIVE", (Object)"\u5df2\u6267\u884c");
            SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST", editBO, contractInstance, uc);
        }
        contractService2.remove((Object)"ID");
        contractService2.remove((Object)"BINDID");
        contractInstance = SDK.getProcessAPI().createBOProcessInstance(processDefId, uc.getUID(), "\u670d\u52a1\u8c03\u6574-" + contractService2.getString("NAME") + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        editBO = new BO();
        contractService2.remove((Object)"CREATEDATE");
        contractService2.remove((Object)"CREATEUSER");
        editBO.setAll((Map)contractService2);
        editBO.set("CONTRACT_SERVICE_ID", (Object)serviceId);
        editBO.setBindId(contractInstance.getId());
        editBO.set("IS_EFFECTIVE", (Object)"\u672a\u6267\u884c");
        editBO.set("REMARK", (Object)remark);
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST", editBO, contractInstance, uc);
        if (editBO.get("END_DATE") == null) {
            DBSql.update((String)"UPDATE BO_EU_DNCTT_CONTRACT_SERVICE a JOIN BO_EU_DNCTT_CONTRACT b ON a.CONTRACT_ID=b.ID set a.END_DATE=b.END_DATE WHERE a.END_DATE IS NULL AND a.ID=?", (Object[])new Object[]{serviceId});
            DBSql.update((String)"UPDATE BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST a JOIN BO_EU_DNCTT_CONTRACT b ON a.CONTRACT_ID=b.ID set a.END_DATE=b.END_DATE WHERE a.END_DATE IS NULL a.CONTRACT_SERVICE_ID=?", (Object[])new Object[]{serviceId});
        }
        return contractInstance.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execServiceSaleAdj(UserContext uc, String boId) {
        BO contractService2 = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST", boId);
        LocalDate EFFECTIVE_DATE = contractService.getLocalDate(contractService2.get("EFFECTIVE_DATE"));
        LocalDate EFFECTIVE_END_DATE = contractService.getLocalDate(contractService2.get("END_DATE"));
        BO orgContractService = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE", contractService2.getString("CONTRACT_SERVICE_ID"));
        RowMap lastContractService = DBSql.getMap((String)"select * from BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST where  CONTRACT_SERVICE_ID=? and EFFECTIVE_DATE <=? and IS_EFFECTIVE='\u5df2\u6267\u884c' order by EFFECTIVE_DATE desc", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
        String PERIOD_TYPE = contractService2.getString("PERIOD_TYPE");
        if (PERIOD_TYPE.equals("609")) {
            BO periodBO = (BO)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD").addQuery("CONTRACT_SERVICE_ID =", (Object)orgContractService.getId())).detail();
            periodBO.set("PERIOD_PRICE", contractService2.get("UNIT_PRICE"));
            periodBO.set("PARTYA_PERIOD_PRICE", contractService2.get("TOTAL_PRICE"));
            periodBO.set("PERIOD_ADJUSTED_PRICE", contractService2.get("QUANTITY"));
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", periodBO);
            orgContractService.set("UNIT_PRICE", contractService2.get("UNIT_PRICE"));
            orgContractService.set("TOTAL_PRICE", contractService2.get("TOTAL_PRICE"));
            orgContractService.set("QUANTITY", contractService2.get("QUANTITY"));
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE", orgContractService);
            DBSql.update((String)"UPDATE bo_eu_dnctt_contract_service_period a SET a.PERIOD_COST =( SELECT SUM(b.PLAN_AMOUNT) FROM BO_EU_DNIVT_ORDER_PAYMENT_PLAN b WHERE a.CONTRACT_SERVICE_ID=? AND b.CONTRACT_SERVICE_ID = a.CONTRACT_SERVICE_ID) WHERE a.CONTRACT_SERVICE_ID=? AND EXISTS ( SELECT 1 FROM BO_EU_DNIVT_ORDER_PAYMENT_PLAN b JOIN bo_eu_dnctt_contract_service c ON b.CONTRACT_SERVICE_ID = c.ID WHERE b.CONTRACT_SERVICE_ID = a.CONTRACT_SERVICE_ID AND c.PERIOD_TYPE = 609 AND c.ID=?)", (Object[])new Object[]{orgContractService.getId(), orgContractService.getId(), orgContractService.getId()});
            return true;
        }
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE WHERE CONTRACT_SERVICE_PERIOD_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID =? AND PERIOD_BEGIN_DATE >=?)", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
            DBSql.update((Connection)conn, (String)"DELETE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? AND PERIOD_BEGIN_DATE>=?", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
            String lastPeriodId = DBSql.getString((Connection)conn, (String)"SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? AND PERIOD_END_DATE >=? ORDER BY PERIOD_BEGIN_DATE ASC ", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
            BigDecimal SERVICE_UNIT_PRICE = null;
            BigDecimal SERVICE_TOTAL_PRICE = null;
            BigDecimal SERVICE_UNIT_COST = BigDecimal.ZERO;
            BigDecimal SERVICE_TOTAL_COST = BigDecimal.ZERO;
            if (StringUtils.isNotBlank((CharSequence)lastPeriodId)) {
                SERVICE_UNIT_PRICE = (BigDecimal)TypeUtil.convert((Object)lastContractService.get((Object)"UNIT_PRICE"), BigDecimal.class);
                SERVICE_TOTAL_PRICE = contractService.multiply(SERVICE_UNIT_PRICE, lastContractService.get((Object)"QUANTITY"));
                if (!orgContractService.getString("NEED_PURCHASE").equals("1")) {
                    SERVICE_UNIT_COST = (BigDecimal)TypeUtil.convert((Object)lastContractService.get((Object)"UNIT_COST"), BigDecimal.class);
                    SERVICE_TOTAL_COST = contractService.multiply(SERVICE_UNIT_COST, lastContractService.get((Object)"QUANTITY"));
                }
                BO lastServicePeriod = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", lastPeriodId);
                LocalDate last_period_begin_date = contractService.getLocalDate(lastServicePeriod.get("PERIOD_BEGIN_DATE"));
                lastServicePeriod.set("PERIOD_END_DATE", (Object)EFFECTIVE_DATE.minusDays(1L));
                BigDecimal periodRate = PeriodCalculationUtil.divideToBigDecimal(PeriodCalculationUtil.getDateRate(last_period_begin_date, EFFECTIVE_DATE.minusDays(1L), false), (Object)PeriodCalculationUtil.GetPeriodMonth(lastContractService.getString("PERIOD_TYPE")));
                lastServicePeriod.set("PERIOD_PRICE", (Object)contractService.multiply(SERVICE_TOTAL_PRICE, periodRate));
                lastServicePeriod.set("PARTYA_PERIOD_PRICE", (Object)contractService.multiply(lastContractService.get((Object)"PARTYA_TOTAL_PRICE"), periodRate));
                lastServicePeriod.set("PERIOD_ADJUSTED_PRICE", lastServicePeriod.get("PERIOD_PRICE"));
                lastServicePeriod.set("PERIOD_COST", (Object)contractService.multiply(SERVICE_TOTAL_COST, periodRate));
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", lastServicePeriod, conn);
            }
            String CALC_METHOD_1STPERIOD = contractService2.getString("CALC_METHOD_1STPERIOD");
            List<PeriodCalculationUtil.Period> periodList = PeriodCalculationUtil.getPeriodListByConfig(PERIOD_TYPE, EFFECTIVE_DATE, EFFECTIVE_DATE, EFFECTIVE_END_DATE, CALC_METHOD_1STPERIOD, "4638", contractService2.getString("MONTH_1STQUARTER"));
            contractServiceLogger.info("\u670d\u52a1\u5468\u671f\u4e2a\u6570-------" + periodList.size());
            contractServiceLogger.info(periodList.toString());
            SERVICE_UNIT_PRICE = (BigDecimal)TypeUtil.convert((Object)contractService2.get("UNIT_PRICE"), BigDecimal.class);
            SERVICE_TOTAL_PRICE = contractService.multiply(SERVICE_UNIT_PRICE, contractService2.get("QUANTITY"));
            if (!orgContractService.getString("NEED_PURCHASE").equals("1")) {
                SERVICE_UNIT_COST = (BigDecimal)contractService2.get("UNIT_COST", BigDecimal.class);
                SERVICE_TOTAL_COST = contractService.multiply(SERVICE_UNIT_COST, contractService2.get("QUANTITY"));
            }
            String vendor_account_id = DBSql.getString((Connection)conn, (String)"select VENDOR_ACCOUNT_ID from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{orgContractService.getString("OBJECT_ID")});
            if (periodList != null && periodList.size() > 0) {
                List<String> sbsList = null;
                String serviceIds = DBSql.getString((String)"select SERVICE_ID from BO_EU_DNIVT_SERVICE_BUNDLE where ID=?", (Object[])new Object[]{orgContractService.get("OBJECT_ID")});
                if (StringUtils.isNotBlank((CharSequence)serviceIds)) {
                    sbsList = Arrays.asList(serviceIds.split(","));
                }
                if (periodList.size() > 1 && (CALC_METHOD_1STPERIOD.equals("4597") || CALC_METHOD_1STPERIOD.equals("4594") || CALC_METHOD_1STPERIOD.equals("4591"))) {
                    PeriodCalculationUtil.Period period1 = periodList.get(0);
                    PeriodCalculationUtil.Period period2 = periodList.get(1);
                    if (period1.getRate().compareTo(BigDecimal.ONE) < 0) {
                        period2.setRate(period1.getRate().add(period2.getRate()));
                        period2.setPeriodBeginDate(period1.getPeriodBeginDate());
                        periodList.remove(0);
                    }
                }
                for (PeriodCalculationUtil.Period period : periodList) {
                    BO csp = new BO();
                    csp.set("CONTRACT_ID", orgContractService.get("CONTRACT_ID"));
                    csp.set("OBJECT_ID", orgContractService.get("OBJECT_ID"));
                    csp.set("OBJECT_TYPE", orgContractService.get("OBJECT_TYPE"));
                    csp.set("CONTRACT_SERVICE_ID", orgContractService.get("ID"));
                    csp.set("PERIOD_BEGIN_DATE", (Object)period.getPeriodBeginDateStr());
                    csp.set("PERIOD_END_DATE", (Object)period.getPeriodEndDateStr());
                    csp.set("QUANTITY", contractService2.get("QUANTITY"));
                    csp.set("PERIOD_PRICE", (Object)period.getRate().multiply(SERVICE_TOTAL_PRICE));
                    csp.set("PERIOD_ADJUSTED_PRICE", csp.get("PERIOD_PRICE"));
                    csp.set("PARTYA_PERIOD_PRICE", (Object)contractService.multiply(contractService2.get("PARTYA_TOTAL_PRICE"), period.getRate()));
                    csp.set("PERIOD_COST", (Object)period.getRate().multiply(SERVICE_TOTAL_COST));
                    csp.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                    csp.setBindId(orgContractService.getString("BINDID"));
                    SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", csp, uc, conn);
                    if (!orgContractService.getString("OBJECT_TYPE").equals("2")) continue;
                    String prorated_cost_change = DBSql.getString((Connection)conn, (String)"select UNIT_COST from BO_EU_DNIVT_SERVICE where ID=?", (Object[])new Object[]{orgContractService.getString("OBJECT_ID")});
                    if (sbsList == null) continue;
                    for (String sbs : sbsList) {
                        BO cspbs = new BO();
                        cspbs.set("CONTRACT_SERVICE_PERIOD_ID", (Object)csp.getId());
                        cspbs.set("SERVICE_ID", (Object)sbs);
                        cspbs.set("VENDOR_ACCOUNT_ID", (Object)vendor_account_id);
                        cspbs.set("PERIOD_COST", (Object)prorated_cost_change);
                        cspbs.setBindId(orgContractService.getString("BINDID"));
                        SDK.getBOAPI().createDataBO("BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", cspbs, uc, conn);
                    }
                }
            }
            contractService2.set("IS_EFFECTIVE", (Object)"\u5df2\u6267\u884c");
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST", contractService2, conn);
            DBSql.update((Connection)conn, (String)"update BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST set IS_EFFECTIVE='\u4f5c\u5e9f' where CONTRACT_SERVICE_ID=? and EFFECTIVE_DATE >?", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
            orgContractService.set("END_DATE", contractService2.get("END_DATE"));
            orgContractService.set("UNIT_PRICE", contractService2.get("UNIT_PRICE"));
            orgContractService.set("TOTAL_PRICE", contractService2.get("TOTAL_PRICE"));
            orgContractService.set("QUANTITY", contractService2.get("QUANTITY"));
            orgContractService.set("PERIOD_TYPE", contractService2.get("PERIOD_TYPE"));
            orgContractService.set("CALC_METHOD_1STPERIOD", contractService2.get("CALC_METHOD_1STPERIOD"));
            orgContractService.set("MONTH_1STQUARTER", contractService2.get("MONTH_1STQUARTER"));
            int periodMonths = 1;
            switch (contractService2.getString("PERIOD_TYPE")) {
                case "610": {
                    periodMonths = 1;
                    break;
                }
                case "611": {
                    periodMonths = 3;
                    break;
                }
                case "612": {
                    periodMonths = 6;
                    break;
                }
                case "613": {
                    periodMonths = 12;
                    break;
                }
                default: {
                    periodMonths = 1;
                }
            }
            BigDecimal result = SERVICE_UNIT_PRICE.divide(BigDecimal.valueOf(periodMonths), 4, RoundingMode.HALF_UP);
            orgContractService.set("SERVICE_UNIT_PRICE", (Object)result);
            RowMap taxCate = DBSql.getMap((String)"SELECT OID,NAME,ORGID,GENERAL_TABLE_ID,EXT1,CLOSED,IS_ACTIVE FROM BO_EU_DND_GENERAL WHERE  GENERAL_TABLE_ID=44 AND ORGID=? AND OID=?", (Object[])new Object[]{uc.getCompanyModel().getId(), orgContractService.getString("TAX_CATEGORY_ID")});
            if (taxCate != null) {
                BigDecimal taxRate = new BigDecimal(taxCate.getString("EXT1"));
                BigDecimal taxExcluded = SERVICE_UNIT_PRICE.divide(BigDecimal.valueOf(periodMonths), 4, 4).divide(BigDecimal.ONE.add(taxRate), 4, 4);
                orgContractService.set("SERVICE_UNIT_PRICE_NOTAX", (Object)taxExcluded);
                orgContractService.set("UNIT_PRICE_NOTAX", (Object)SERVICE_UNIT_PRICE.divide(BigDecimal.ONE.add(taxRate), 4, 4));
                orgContractService.set("TOTAL_PRICE_NOTAX", (Object)SERVICE_TOTAL_PRICE.divide(BigDecimal.ONE.add(taxRate), 4, 4));
            } else {
                orgContractService.set("SERVICE_UNIT_PRICE_NOTAX", null);
                orgContractService.set("UNIT_PRICE_NOTAX", null);
                orgContractService.set("TOTAL_PRICE_NOTAX", null);
            }
            if (((LocalDate)orgContractService.get("EFFECTIVE_DATE", LocalDate.class)).compareTo((ChronoLocalDate)contractService2.get("EFFECTIVE_DATE", LocalDate.class)) < 0) {
                orgContractService.set("EFFECTIVE_DATE", contractService2.get("EFFECTIVE_DATE"));
            }
            SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE", orgContractService, conn);
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        this.paySplitServiceMonth(uc, orgContractService.getId());
        return true;
    }

    public String editServiceSaleEndDate(UserContext uc, String serviceId, LocalDate newEndDate) {
        if (DBSql.getString((String)"select PERIOD_TYPE from BO_EU_DNCTT_CONTRACT_SERVICE where CONTRACT_SERVICE_ID=?", (Object[])new Object[]{serviceId}).equals("609")) {
            return "\u65e0\u9700\u4fee\u6539";
        }
        RowMap lastServicePeriod = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? ORDER BY PERIOD_BEGIN_DATE DESC", (Object[])new Object[]{serviceId});
        LocalDate PERIOD_BEGIN_DATE = (LocalDate)TypeUtil.convert((Object)lastServicePeriod.get((Object)"PERIOD_BEGIN_DATE"), LocalDate.class);
        LocalDate PERIOD_END_DATE = (LocalDate)TypeUtil.convert((Object)lastServicePeriod.get((Object)"PERIOD_END_DATE"), LocalDate.class);
        if (PERIOD_END_DATE.equals(newEndDate)) {
            return "\u65e0\u9700\u4fee\u6539";
        }
        String EFFECTIVE_DATE = DBSql.getString((String)"SELECT max(PERIOD_BEGIN_DATE) as PERIOD_BEGIN_DATE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE APPROVE_AND_POST_DATE IS NOT NULL and CONTRACT_SERVICE_ID=? AND  PERIOD_END_DATE >=?", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(newEndDate)});
        if (StringUtils.isBlank((CharSequence)EFFECTIVE_DATE)) {
            return "\u5df2\u5ba1\u6279\u4e0d\u80fd\u4fee\u6539\u4e86";
        }
        String bindId = this.editServiceSale(uc, serviceId, "\u4fee\u6539\u7ed3\u675f\u65e5\u671f");
        BO adjBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST", bindId);
        if (PERIOD_END_DATE.isAfter(newEndDate)) {
            if (PERIOD_BEGIN_DATE.isBefore(newEndDate)) {
                adjBO.set("EFFECTIVE_DATE", (Object)PERIOD_BEGIN_DATE);
            } else {
                EFFECTIVE_DATE = DBSql.getString((String)"SELECT max(PERIOD_BEGIN_DATE) as PERIOD_BEGIN_DATE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE APPROVE_AND_POST_DATE IS NULL and CONTRACT_SERVICE_ID=? AND  PERIOD_BEGIN_DATE <=?", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(newEndDate)});
                LocalDate EFFECTIVE_DATE1 = null;
                if (StringUtils.isBlank((CharSequence)EFFECTIVE_DATE)) {
                    EFFECTIVE_DATE = DBSql.getString((String)"SELECT max(PERIOD_END_DATE) as PERIOD_END_DATE FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE  CONTRACT_SERVICE_ID=? AND  PERIOD_BEGIN_DATE <=?", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(newEndDate)});
                    EFFECTIVE_DATE1 = (LocalDate)TypeUtil.convert((Object)EFFECTIVE_DATE, LocalDate.class);
                    EFFECTIVE_DATE1 = EFFECTIVE_DATE1.plusDays(1L);
                } else {
                    EFFECTIVE_DATE1 = (LocalDate)TypeUtil.convert((Object)EFFECTIVE_DATE, LocalDate.class);
                }
                adjBO.set("EFFECTIVE_DATE", (Object)EFFECTIVE_DATE1);
                RowMap lastContractServiceAdj = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST WHERE CONTRACT_SERVICE_ID=? AND IS_EFFECTIVE='\u5df2\u6267\u884c' AND EFFECTIVE_DATE <=? ORDER BY EFFECTIVE_DATE DESC", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE1)});
                adjBO.set("UNIT_PRICE", (Object)lastContractServiceAdj.getString("UNIT_PRICE"));
                adjBO.set("TOTAL_PRICE", (Object)lastContractServiceAdj.getString("TOTAL_PRICE"));
                adjBO.set("QUANTITY", (Object)lastContractServiceAdj.getString("QUANTITY"));
                adjBO.set("PERIOD_TYPE", (Object)lastContractServiceAdj.getString("PERIOD_TYPE"));
                adjBO.set("CALC_METHOD_1STPERIOD", (Object)lastContractServiceAdj.getString("CALC_METHOD_1STPERIOD"));
                adjBO.set("MONTH_1STQUARTER", (Object)lastContractServiceAdj.getString("MONTH_1STQUARTER"));
                adjBO.set("PARTYA_TOTAL_PRICE", (Object)lastContractServiceAdj.getString("PARTYA_TOTAL_PRICE"));
                adjBO.set("UNIT_PRICE_1STMONTH", (Object)lastContractServiceAdj.getString("UNIT_PRICE_1STMONTH"));
            }
        } else if (lastServicePeriod.get((Object)"APPROVE_AND_POST_DATE") != null && StringUtils.isNotBlank((CharSequence)lastServicePeriod.getString("APPROVE_AND_POST_USER_ID"))) {
            adjBO.set("EFFECTIVE_DATE", (Object)PERIOD_END_DATE.plusDays(1L));
        } else {
            adjBO.set("EFFECTIVE_DATE", (Object)PERIOD_BEGIN_DATE);
        }
        adjBO.set("REMARK", (Object)("\u670d\u52a1\u5ef6\u671f\uff1a" + contractService.LocalDateYYYYMMDD(PERIOD_END_DATE) + "->" + contractService.LocalDateYYYYMMDD(newEndDate)));
        adjBO.set("END_DATE", (Object)newEndDate);
        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST", adjBO);
        if (!this.execServiceSaleAdj(uc, adjBO.getId())) {
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST where ID=? AND IS_EFFECTIVE<>'\u5df2\u6267\u884c'", (Object[])new Object[]{adjBO.getId()});
        } else {
            DBSql.update((String)"update bo_eu_dnctt_contract_service set END_DATE=? where ID=?", (Object[])new Object[]{contractService.LocalDateYYYYMMDD(newEndDate), serviceId});
        }
        return "ok";
    }

    public String editServicePurchase(UserContext uc, String serviceId, String remark) {
        BO editBO;
        ProcessInstance contractInstance;
        RowMap contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST WHERE CONTRACT_SERVICE_ID=? AND IS_EFFECTIVE='\u672a\u6267\u884c' ", (Object[])new Object[]{serviceId});
        if (contractService2 != null) {
            return contractService2.getString("BINDID");
        }
        contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST WHERE CONTRACT_SERVICE_ID=? AND IS_EFFECTIVE='\u5df2\u6267\u884c' ORDER BY  CREATEDATE DESC ", (Object[])new Object[]{serviceId});
        String processDefId = "obj_b147ad05008546058736a06bc6205313";
        if (contractService2 == null) {
            contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE ID=?", (Object[])new Object[]{serviceId});
            contractService2.remove((Object)"ID");
            contractService2.remove((Object)"BINDID");
            contractInstance = SDK.getProcessAPI().createBOProcessInstance(processDefId, uc.getUID(), "\u670d\u52a1\u8c03\u6574-" + contractService2.getString("NAME") + "-\u521d\u59cb");
            editBO = new BO();
            contractService2.remove((Object)"CREATEDATE");
            contractService2.remove((Object)"CREATEUSER");
            editBO.setAll((Map)contractService2);
            editBO.setBindId(contractInstance.getId());
            editBO.set("CONTRACT_SERVICE_ID", (Object)serviceId);
            editBO.set("IS_EFFECTIVE", (Object)"\u5df2\u6267\u884c");
            SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST", editBO, contractInstance, uc);
        }
        contractService2.remove((Object)"ID");
        contractService2.remove((Object)"BINDID");
        contractInstance = SDK.getProcessAPI().createBOProcessInstance(processDefId, uc.getUID(), "\u670d\u52a1\u8c03\u6574-" + contractService2.getString("NAME") + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        editBO = new BO();
        contractService2.remove((Object)"CREATEDATE");
        contractService2.remove((Object)"CREATEUSER");
        editBO.setAll((Map)contractService2);
        editBO.set("CONTRACT_SERVICE_ID", (Object)serviceId);
        editBO.setBindId(contractInstance.getId());
        editBO.set("IS_EFFECTIVE", (Object)"\u672a\u6267\u884c");
        editBO.set("REMARK", (Object)remark);
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST", editBO, contractInstance, uc);
        return contractInstance.getId();
    }

    public String editServicePurchaseEndDate(UserContext uc, String serviceId, LocalDate newEndDate) {
        RowMap lastServicePeriod = DBSql.getMap((String)"SELECT * FROM BO_EU_DNIVT_ORDER_PAYMENT_PLAN WHERE CONTRACT_SERVICE_ID=? ORDER BY PERIOD_BEGIN_DATE DESC", (Object[])new Object[]{serviceId});
        if (DBSql.getString((String)"select PURCHASE_PERIOD_TYPE from BO_EU_DNCTT_CONTRACT_SERVICE where CONTRACT_SERVICE_ID=?", (Object[])new Object[]{serviceId}).equals("609")) {
            return "\u65e0\u9700\u4fee\u6539";
        }
        LocalDate PERIOD_BEGIN_DATE = (LocalDate)TypeUtil.convert((Object)lastServicePeriod.get((Object)"PERIOD_BEGIN_DATE"), LocalDate.class);
        LocalDate PERIOD_END_DATE = (LocalDate)TypeUtil.convert((Object)lastServicePeriod.get((Object)"PERIOD_END_DATE"), LocalDate.class);
        if (PERIOD_END_DATE.equals(newEndDate)) {
            return "\u65e0\u9700\u4fee\u6539";
        }
        String EFFECTIVE_DATE = DBSql.getString((String)"SELECT max(PERIOD_BEGIN_DATE) as PERIOD_BEGIN_DATE FROM BO_EU_DNIVT_ORDER_PAYMENT_PLAN WHERE  PAY_AMOUNT<>0 and PAY_AMOUNT is not NULL  and CONTRACT_SERVICE_ID=? AND  PERIOD_BEGIN_DATE >=?", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(newEndDate)});
        if (StringUtils.isNotBlank((CharSequence)EFFECTIVE_DATE)) {
            return "\u5df2\u5ba1\u6279\u4e0d\u80fd\u4fee\u6539\u4e86";
        }
        String bindId = this.editServicePurchase(uc, serviceId, "\u4fee\u6539\u7ed3\u675f\u65e5\u671f");
        BO adjBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST", bindId);
        if (PERIOD_END_DATE.isAfter(newEndDate)) {
            if (PERIOD_BEGIN_DATE.isBefore(newEndDate)) {
                adjBO.set("PURCHASE_START_DATE", (Object)PERIOD_BEGIN_DATE);
            } else {
                EFFECTIVE_DATE = DBSql.getString((String)"SELECT max(PERIOD_BEGIN_DATE) as PERIOD_BEGIN_DATE FROM BO_EU_DNIVT_ORDER_PAYMENT_PLAN WHERE PAY_AMOUNT<>0 and PAY_AMOUNT is not NULL and CONTRACT_SERVICE_ID=? AND  PERIOD_BEGIN_DATE <=?", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(newEndDate)});
                LocalDate EFFECTIVE_DATE1 = null;
                if (StringUtils.isBlank((CharSequence)EFFECTIVE_DATE)) {
                    EFFECTIVE_DATE = DBSql.getString((String)"SELECT max(PERIOD_END_DATE) as PERIOD_END_DATE FROM BO_EU_DNIVT_ORDER_PAYMENT_PLAN WHERE  CONTRACT_SERVICE_ID=? AND  PERIOD_BEGIN_DATE <=?", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(newEndDate)});
                    EFFECTIVE_DATE1 = (LocalDate)TypeUtil.convert((Object)EFFECTIVE_DATE, LocalDate.class);
                    EFFECTIVE_DATE1 = EFFECTIVE_DATE1.plusDays(1L);
                } else {
                    EFFECTIVE_DATE1 = (LocalDate)TypeUtil.convert((Object)EFFECTIVE_DATE, LocalDate.class);
                }
                adjBO.set("PURCHASE_START_DATE", (Object)EFFECTIVE_DATE1);
                RowMap lastContractServiceAdj = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST WHERE CONTRACT_SERVICE_ID=? AND IS_EFFECTIVE='\u5df2\u6267\u884c' AND PURCHASE_START_DATE <=? ORDER BY PURCHASE_START_DATE DESC", (Object[])new Object[]{serviceId, contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE1)});
                adjBO.set("UNIT_COST", (Object)lastContractServiceAdj.getString("UNIT_COST"));
                adjBO.set("TOTAL_COST", (Object)lastContractServiceAdj.getString("TOTAL_COST"));
                adjBO.set("QUANTITY", (Object)lastContractServiceAdj.getString("QUANTITY"));
                adjBO.set("PURCHASE_PERIOD_TYPE", (Object)lastContractServiceAdj.getString("PURCHASE_PERIOD_TYPE"));
                adjBO.set("PURCHASE_CALC_METHOD_1STPERIOD", (Object)lastContractServiceAdj.getString("PURCHASE_CALC_METHOD_1STPERIOD"));
                adjBO.set("MONTH_1STQUARTER", (Object)lastContractServiceAdj.getString("MONTH_1STQUARTER"));
                adjBO.set("UNIT_COST_1STMONTH", (Object)lastContractServiceAdj.getString("UNIT_COST_1STMONTH"));
            }
        } else if (lastServicePeriod.get((Object)"PAY_AMOUNT") != null && lastServicePeriod.getDouble("PAY_AMOUNT") != 0.0) {
            adjBO.set("PURCHASE_START_DATE", (Object)PERIOD_END_DATE.plusDays(1L));
        } else {
            adjBO.set("PURCHASE_START_DATE", (Object)PERIOD_BEGIN_DATE);
        }
        adjBO.set("REMARK", (Object)("\u670d\u52a1\u5ef6\u671f\uff1a" + contractService.LocalDateYYYYMMDD(PERIOD_END_DATE) + "->" + contractService.LocalDateYYYYMMDD(newEndDate)));
        adjBO.set("PURCHASE_END_DATE", (Object)newEndDate);
        SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST", adjBO);
        if (!this.execServicePurchaseAdj(uc, adjBO.getId(), null)) {
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST where ID=? AND IS_EFFECTIVE<>'\u5df2\u6267\u884c'", (Object[])new Object[]{adjBO.getId()});
        } else {
            DBSql.update((String)"update bo_eu_dnctt_contract_service set PURCHASE_END_DATE=? where ID=?", (Object[])new Object[]{contractService.LocalDateYYYYMMDD(newEndDate), serviceId});
        }
        return "ok";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execServicePurchaseAdj(UserContext uc, String boId, String boName) {
        int periodMonths;
        BO contractService2 = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST", boId);
        if (StringUtils.isNotBlank((CharSequence)boName) && !boName.equals("BO_EU_DNIVT_ORDER_PAYMENT_PLAN_MONTH")) {
            return false;
        }
        String PERIOD_TYPE = contractService2.getString("PURCHASE_PERIOD_TYPE");
        String PURCHASE_CALC_METHOD_1STPERIOD = contractService2.getString("PURCHASE_CALC_METHOD_1STPERIOD");
        switch (contractService2.getString("PURCHASE_PERIOD_TYPE")) {
            case "610": {
                periodMonths = 1;
                break;
            }
            case "611": {
                periodMonths = 3;
                break;
            }
            case "612": {
                periodMonths = 6;
                break;
            }
            case "613": {
                periodMonths = 12;
                break;
            }
            default: {
                periodMonths = 1;
            }
        }
        if (StringUtils.isBlank((CharSequence)boName)) {
            boName = "BO_EU_DNIVT_ORDER_PAYMENT_PLAN";
        } else if (!PERIOD_TYPE.equals("609")) {
            PERIOD_TYPE = "610";
        }
        LocalDate EFFECTIVE_DATE = contractService.getLocalDate(contractService2.get("PURCHASE_START_DATE"));
        LocalDate EFFECTIVE_END_DATE = contractService.getLocalDate(contractService2.get("PURCHASE_END_DATE"));
        BO orgContractService = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT_SERVICE", contractService2.getString("CONTRACT_SERVICE_ID"));
        RowMap lastContractService = DBSql.getMap((String)"select * from BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST where  CONTRACT_SERVICE_ID=? and PURCHASE_START_DATE <=? and IS_EFFECTIVE='\u5df2\u6267\u884c' order by PURCHASE_START_DATE desc", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
        RowMap costProduct = DBSql.getMap((String)"select * from BO_EU_DNIVT_ORDER_PRODUCT where CONTRACT_SERVICE_ID=?", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID")});
        String orderId = costProduct.getString("ORDER_ID");
        String CONTRACT_COST_ID = costProduct.getString("CONTRACT_COST_ID");
        String VENDOR_ACCOUNT_ID = DBSql.getString((String)"select VENDOR_ACCOUNT_ID from BO_EU_DNIVT_ORDER where ID=?", (Object[])new Object[]{orderId});
        Connection conn = null;
        try {
            RowMap firstContractService;
            LocalDate firstEFFECTIVE_DATE;
            conn = DBSql.open();
            conn.setAutoCommit(false);
            if (PERIOD_TYPE.equals("609")) {
                DBSql.update((Connection)conn, (String)("DELETE FROM " + boName + " WHERE  CONTRACT_SERVICE_ID=? "), (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID")});
            } else {
                DBSql.update((Connection)conn, (String)("DELETE FROM " + boName + " WHERE  CONTRACT_SERVICE_ID=? and PERIOD_BEGIN_DATE >=? and (PAY_AMOUNT=0 or PAY_AMOUNT is NULL)"), (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
            }
            String lastPeriodId = DBSql.getString((Connection)conn, (String)("select ID from " + boName + " where CONTRACT_SERVICE_ID=? and PERIOD_END_DATE >=? order by PERIOD_BEGIN_DATE asc"), (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
            BigDecimal SERVICE_UNIT_COST = null;
            BigDecimal SERVICE_TOTAL_COST = null;
            boolean teshuchuli = false;
            String teshuchuliBeginDate = null;
            BigDecimal COST_1STMONTH = null;
            LocalDate START_DATE = EFFECTIVE_DATE;
            if (!(PURCHASE_CALC_METHOD_1STPERIOD.equals("4598") || PURCHASE_CALC_METHOD_1STPERIOD.equals("4595") || PURCHASE_CALC_METHOD_1STPERIOD.equals("4592") || (firstEFFECTIVE_DATE = contractService.getLocalDate((firstContractService = DBSql.getMap((String)"select * from BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST where  CONTRACT_SERVICE_ID=?  and IS_EFFECTIVE='\u5df2\u6267\u884c' order by PURCHASE_START_DATE ASC", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID")})).get((Object)"PURCHASE_START_DATE"))).getYear() != EFFECTIVE_DATE.getYear() || firstEFFECTIVE_DATE.getMonth() != EFFECTIVE_DATE.getMonth())) {
                teshuchuli = true;
                teshuchuliBeginDate = contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE);
                SERVICE_UNIT_COST = (BigDecimal)TypeUtil.convert((Object)contractService2.get("UNIT_COST_1STMONTH"), BigDecimal.class);
                SERVICE_TOTAL_COST = contractService.multiply(SERVICE_UNIT_COST, contractService2.get("QUANTITY"));
                BigDecimal ratio = new BigDecimal(EFFECTIVE_DATE.lengthOfMonth() - EFFECTIVE_DATE.getDayOfMonth() + 1).divide(new BigDecimal(EFFECTIVE_DATE.lengthOfMonth()), 10, 4);
                COST_1STMONTH = SERVICE_TOTAL_COST.multiply(ratio);
                EFFECTIVE_DATE = EFFECTIVE_DATE.plusMonths(1L).withDayOfMonth(1);
                if (boName.equals("BO_EU_DNIVT_ORDER_PAYMENT_PLAN_MONTH") && !PERIOD_TYPE.equals("609")) {
                    BO paymentPlan = new BO();
                    paymentPlan.set("ORDER_ID", (Object)orderId);
                    paymentPlan.set("PLAN_AMOUNT", (Object)COST_1STMONTH);
                    paymentPlan.set("PLAN_DATE", (Object)teshuchuliBeginDate);
                    paymentPlan.set("PERIOD_BEGIN_DATE", (Object)teshuchuliBeginDate);
                    paymentPlan.set("PERIOD_END_DATE", (Object)EFFECTIVE_DATE.minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
                    paymentPlan.set("REMAIN_AMOUNT", paymentPlan.get("PLAN_AMOUNT"));
                    paymentPlan.set("CONTRACT_COST_ID", (Object)CONTRACT_COST_ID);
                    paymentPlan.set("CONTRACT_SERVICE_ID", (Object)orgContractService.getId());
                    paymentPlan.set("PAY_DESC", (Object)orgContractService.getString("NAME"));
                    paymentPlan.set("ACCOUNT_PAYEE", (Object)VENDOR_ACCOUNT_ID);
                    SDK.getBOAPI().createDataBO(boName, paymentPlan, uc, conn);
                    COST_1STMONTH = BigDecimal.ZERO;
                    teshuchuli = false;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)lastPeriodId)) {
                if (teshuchuli) {
                    SERVICE_UNIT_COST = (BigDecimal)TypeUtil.convert((Object)lastContractService.get((Object)"UNIT_COST_1STMONTH"), BigDecimal.class);
                    SERVICE_TOTAL_COST = contractService.multiply(SERVICE_UNIT_COST, lastContractService.get((Object)"QUANTITY"));
                } else {
                    SERVICE_UNIT_COST = (BigDecimal)TypeUtil.convert((Object)lastContractService.get((Object)"UNIT_COST"), BigDecimal.class);
                    if (boName.equals("BO_EU_DNIVT_ORDER_PAYMENT_PLAN_MONTH")) {
                        SERVICE_UNIT_COST = SERVICE_UNIT_COST.divide(new BigDecimal(periodMonths), 10, 4);
                    }
                    SERVICE_TOTAL_COST = contractService.multiply(SERVICE_UNIT_COST, lastContractService.get((Object)"QUANTITY"));
                }
                BO lastServicePeriod = SDK.getBOAPI().get(boName, lastPeriodId);
                LocalDate last_period_begin_date = contractService.getLocalDate(lastServicePeriod.get("PERIOD_BEGIN_DATE"));
                BigDecimal periodRate = PeriodCalculationUtil.getDateRate(last_period_begin_date, EFFECTIVE_DATE.minusDays(1L), false);
                if (periodRate.compareTo(BigDecimal.ZERO) > 0) {
                    lastServicePeriod.set("PERIOD_END_DATE", (Object)EFFECTIVE_DATE.minusDays(1L));
                    lastServicePeriod.set("PLAN_AMOUNT", (Object)contractService.multiply(SERVICE_TOTAL_COST, periodRate));
                    lastServicePeriod.set("REMAIN_AMOUNT", lastServicePeriod.get("PLAN_AMOUNT"));
                    SDK.getBOAPI().update(boName, lastServicePeriod, conn);
                } else {
                    SDK.getBOAPI().remove(boName, lastPeriodId, conn);
                }
            }
            List<PeriodCalculationUtil.Period> periodList = PeriodCalculationUtil.getPeriodListByConfig(PERIOD_TYPE, START_DATE, EFFECTIVE_DATE, EFFECTIVE_END_DATE, contractService2.getString("PURCHASE_CALC_METHOD_1STPERIOD"), "4638", contractService2.getString("MONTH_1STQUARTER"));
            SERVICE_UNIT_COST = (BigDecimal)TypeUtil.convert((Object)contractService2.get("UNIT_COST"), BigDecimal.class);
            if (boName.equals("BO_EU_DNIVT_ORDER_PAYMENT_PLAN_MONTH")) {
                SERVICE_UNIT_COST = SERVICE_UNIT_COST.divide(new BigDecimal(periodMonths), 10, 4);
            }
            SERVICE_TOTAL_COST = contractService.multiply(SERVICE_UNIT_COST, contractService2.get("QUANTITY"));
            if (periodList != null && periodList.size() > 0) {
                int i = 0;
                for (PeriodCalculationUtil.Period period : periodList) {
                    ++i;
                    BO paymentPlan = new BO();
                    paymentPlan.set("ORDER_ID", (Object)orderId);
                    paymentPlan.set("PLAN_DATE", (Object)period.getPeriodBeginDateStr());
                    paymentPlan.set("PERIOD_BEGIN_DATE", (Object)period.getPeriodBeginDateStr());
                    paymentPlan.set("PERIOD_END_DATE", (Object)period.getPeriodEndDateStr());
                    if (teshuchuli && i == 1) {
                        paymentPlan.set("PLAN_AMOUNT", (Object)SERVICE_TOTAL_COST.multiply(period.getRate()).add(COST_1STMONTH));
                        paymentPlan.set("PLAN_DATE", (Object)teshuchuliBeginDate);
                        paymentPlan.set("PERIOD_BEGIN_DATE", (Object)teshuchuliBeginDate);
                    } else {
                        paymentPlan.set("PLAN_AMOUNT", (Object)SERVICE_TOTAL_COST.multiply(period.getRate()));
                    }
                    paymentPlan.set("REMAIN_AMOUNT", paymentPlan.get("PLAN_AMOUNT"));
                    paymentPlan.set("CONTRACT_COST_ID", (Object)CONTRACT_COST_ID);
                    paymentPlan.set("CONTRACT_SERVICE_ID", (Object)orgContractService.getId());
                    paymentPlan.set("PAY_DESC", (Object)orgContractService.getString("NAME"));
                    paymentPlan.set("ACCOUNT_PAYEE", (Object)VENDOR_ACCOUNT_ID);
                    if (boName.equals("BO_EU_DNIVT_ORDER_PAYMENT_PLAN")) {
                        ProcessInstance processInstance = SDK.getProcessAPI().createProcessInstance("obj_5cb4ae4a42944fd0a9a284ff4c64c65d", uc.getUID(), "\u4ed8\u6b3e\u8ba1\u5212");
                        paymentPlan.setBindId(processInstance.getId());
                        SDK.getBOAPI().create(boName, paymentPlan, processInstance, uc, conn);
                    } else {
                        SDK.getBOAPI().createDataBO(boName, paymentPlan, uc, conn);
                    }
                    System.out.println("==== \u521b\u5efa\u4ed8\u6b3e\u8ba1\u5212\uff1a" + paymentPlan.get("PLAN_DATE") + "\uff0c\u91d1\u989d\uff1a" + paymentPlan.get("PLAN_AMOUNT") + " ====");
                }
            }
            if (boName.equals("BO_EU_DNIVT_ORDER_PAYMENT_PLAN")) {
                contractService2.set("IS_EFFECTIVE", (Object)"\u5df2\u6267\u884c");
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST", contractService2, conn);
                DBSql.update((Connection)conn, (String)"update BO_EU_DNCTT_CONTRACT_SERVICE_PURCHASE_ADJUST set IS_EFFECTIVE='\u4f5c\u5e9f' where CONTRACT_SERVICE_ID=? and PURCHASE_START_DATE >?", (Object[])new Object[]{contractService2.get("CONTRACT_SERVICE_ID"), contractService.LocalDateYYYYMMDD(EFFECTIVE_DATE)});
                orgContractService.set("UNIT_COST", contractService2.get("UNIT_COST"));
                orgContractService.set("TOTAL_COST", contractService2.get("TOTAL_COST"));
                orgContractService.set("QUANTITY", contractService2.get("QUANTITY"));
                orgContractService.set("PURCHASE_CALC_METHOD_1STPERIOD", contractService2.get("PURCHASE_CALC_METHOD_1STPERIOD"));
                orgContractService.set("MONTH_1STQUARTER", contractService2.get("MONTH_1STQUARTER"));
                orgContractService.set("PURCHASE_PERIOD_TYPE", contractService2.get("PURCHASE_PERIOD_TYPE"));
                orgContractService.set("PURCHASE_END_DATE", contractService2.get("PURCHASE_END_DATE"));
                if (((LocalDate)orgContractService.get("PURCHASE_START_DATE", LocalDate.class)).compareTo((ChronoLocalDate)contractService2.get("PURCHASE_START_DATE", LocalDate.class)) < 0) {
                    orgContractService.set("PURCHASE_START_DATE", contractService2.get("PURCHASE_START_DATE"));
                }
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT_SERVICE", orgContractService, conn);
            }
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        if (boName.equals("BO_EU_DNIVT_ORDER_PAYMENT_PLAN")) {
            this.execServicePurchaseAdj(uc, boId, "BO_EU_DNIVT_ORDER_PAYMENT_PLAN_MONTH");
            this.paySplitServiceMonth(uc, contractService2.getString("CONTRACT_SERVICE_ID"));
        }
        return true;
    }

    public void paySplitServiceMonth(UserContext uc, String contractServiceId) {
        RowMap service = DBSql.getMap((String)"select * from BO_EU_DNCTT_CONTRACT_SERVICE where ID=?", (Object[])new Object[]{contractServiceId});
        List payPlanList = DBSql.getMaps((String)"select * from BO_EU_DNIVT_ORDER_PAYMENT_PLAN_MONTH where CONTRACT_SERVICE_ID=? ORDER BY PERIOD_BEGIN_DATE", (Object[])new Object[]{contractServiceId});
        if (payPlanList.isEmpty() || payPlanList.size() == 0) {
            return;
        }
        List contractServicePeriodList = DBSql.getMaps((String)"select * from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where CONTRACT_SERVICE_ID=? ORDER BY PERIOD_BEGIN_DATE", (Object[])new Object[]{contractServiceId});
        if (contractServicePeriodList.isEmpty() || contractServicePeriodList.size() == 0) {
            return;
        }
        if (service.getString("PERIOD_TYPE").equals("609")) {
            BigDecimal SUM_PLAN_AMOUNT = BigDecimal.ZERO;
            for (RowMap payPlan : payPlanList) {
                SUM_PLAN_AMOUNT = SUM_PLAN_AMOUNT.add((BigDecimal)TypeUtil.convert((Object)payPlan.get((Object)"PLAN_AMOUNT"), BigDecimal.class));
            }
            DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD set PERIOD_COST=? where ID=? ", (Object[])new Object[]{SUM_PLAN_AMOUNT, ((RowMap)contractServicePeriodList.get(0)).getString("ID")});
            return;
        }
        LocalDate LAST_DATE = null;
        for (RowMap servicePeriod : contractServicePeriodList) {
            LocalDate PERIOD_END_DATE = (LocalDate)TypeUtil.convert((Object)servicePeriod.get((Object)"PERIOD_END_DATE"), LocalDate.class);
            SDK.getLogAPI().consoleInfo("PERIOD_END_DATE\uff1a" + PERIOD_END_DATE.toString());
            BigDecimal SUM_PLAN_AMOUNT = BigDecimal.ZERO;
            for (RowMap payPlan : payPlanList) {
                LocalDate PAY_PERIOD_BEGIN_DATE = (LocalDate)TypeUtil.convert((Object)payPlan.get((Object)"PERIOD_BEGIN_DATE"), LocalDate.class);
                SDK.getLogAPI().consoleInfo("PAY_PERIOD_BEGIN_DATE\uff1a" + PAY_PERIOD_BEGIN_DATE.toString());
                if (LAST_DATE != null && PAY_PERIOD_BEGIN_DATE.isBefore(LAST_DATE) || PERIOD_END_DATE.isBefore(PAY_PERIOD_BEGIN_DATE)) continue;
                SDK.getLogAPI().consoleInfo("PLAN_AMOUNT \uff1a " + payPlan.getString("PLAN_AMOUNT"));
                SUM_PLAN_AMOUNT = SUM_PLAN_AMOUNT.add((BigDecimal)TypeUtil.convert((Object)payPlan.get((Object)"PLAN_AMOUNT"), BigDecimal.class));
            }
            DBSql.update((String)"update BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD set PERIOD_COST=? where ID=? ", (Object[])new Object[]{SUM_PLAN_AMOUNT, servicePeriod.getString("ID")});
            SDK.getLogAPI().consoleInfo("\u670d\u52a1\u5468\u671f\uff1a" + servicePeriod.getString("ID") + ":" + SUM_PLAN_AMOUNT);
            LAST_DATE = PERIOD_END_DATE.plusDays(1L);
        }
    }

    static {
        SDK.getLogAPI();
        contractServiceLogger = LogAPI.getLogger(contractServiceAdj.class);
    }
}

