/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.cache.NetworkTopicCache;
import com.actionsoft.apps.network.helper.AttachementFile;
import com.actionsoft.apps.network.helper.StreamContentHelper;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.model.NetworkTopicModel;
import com.actionsoft.apps.network.notification.NetworkNotification;
import com.actionsoft.apps.network.util.HttpUtil;
import com.actionsoft.apps.network.util.PatternUtil;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCMessage;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSForbiddenException;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.DCAPI;
import com.actionsoft.sdk.local.api.ORGAPI;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateStream
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateStream.class);

    @Meta(parameter={"name: 'message', required: true, desc: '\u6d88\u606f\u5185\u5bb9'", "name: 'streamType', required: false, desc: '\u52a8\u6001\u7c7b\u578b'", "name: 'attachement', required: false, desc: '\u9644\u4ef6'", "name: 'link', required: false, desc: '\u94fe\u63a5'", "name: 'tags', required: false, desc: '\u6807\u7b7e'", "name: 'notifier', required: false, desc: '\u901a\u77e5\u4eba'", "name: 'notifierTeam', required: false, desc: '\u662f\u5426\u901a\u77e5\u5c0f\u7ec4\u6210\u5458'", "name: 'title', required: false, desc: '\u516c\u544a\u6807\u9898'", "name: 'praisePeople', required: false, desc: '\u8868\u626c\u4eba'", "name: 'praiseBadge', required: false, desc: '\u8868\u626c\u5fbd\u7ae0'", "name: 'pariseDefinition', required: false, desc: '\u8868\u626c\u5b9a\u4e49'", "name: 'createTime', required: false, desc:'\u521b\u5efa\u65f6\u95f4,\u5b57\u7b26\u4e32\u683c\u5f0f\uff0c\u5982 2011-05-09 11:49:45'", "name: 'teamId', required: false, desc:'\u5c0f\u7ec4ID'", "name: 'networkId', required: false, desc:'\u5de5\u4f5c\u7f51\u7edcID'", "name: 'sourceAppId', required: false, desc:'\u4fe1\u606f\u6d41\u6765\u81ea\uff0c\u5982com.actionsoft.apps.coe.pal'", "name: 'sourceType', required: false, desc:'\u4fe1\u606f\u6d41\u6765\u6e90\uff0c\u5982CoE.PAL.Designer\u3001CoE.BPA'", "name: 'sourceId', required: false, desc:'\u6765\u6e90ID\uff0c\u5982\u6d41\u7a0b\u56feId\u5e76\u652f\u6301@\u516c\u5f0f'", "name: 'ipAddress', required: false, desc:'IP\u5730\u5740'", "name: 'deviceType', required: false, desc:'\u8bbe\u5907\u540d\u79f0'", "name: 'userId', required: false, desc:'\u521b\u5efa\u4eba'", "name: 'channelType', required: false, desc:' \u9891\u9053\u7c7b\u578b\uff0c\u5982\u7535\u8bdd \u62dc\u8bbf'", "name: 'parentSourceId', required: false, desc:'\u7236\u7ea7\u5bf9\u8c61,\u5bf9\u8c61\u53ef\u4ee5\u6709\u7236\u5b50\u5173\u7cfb\uff08\u4e00\u7ea7\uff09\uff0c\u5b50\u5bf9\u8c61\u7684\u4fe1\u606f\u6d41\u53ef\u4ee5\u88ab\u5408\u5e76\u5230\u7236\u5bf9\u8c61\u5e76\u4e14\u652f\u6301@\u516c\u5f0f'", "name: 'sourceDeptId', required: false, desc:'\u5bf9\u8c61\u90e8\u95e8\u6240\u5c5e\uff0c\u6307\u7684\u662f\u5bf9\u8be5\u4e1a\u52a1\u5bf9\u8c61\u6240\u5728\u7684\u90e8\u95e8ID\uff0c\u4e00\u4e9b\u90e8\u95e8\u4e3b\u7ba1\u8eab\u4efd\u7684\u4eba\u53ef\u4ee5\u6d4f\u89c8\u8be5\u90e8\u95e8\u7684\u5168\u90e8\u52a8\u6001\u5e76\u4e14\u652f\u6301@\u516c\u5f0f'", "name: 'srcObjectContent', required: false, desc:'\u5173\u8054\u5bf9\u8c61\uff0c\u4e00\u4e2a\u72ec\u7acb\u7684\u4e1a\u52a1\u5bf9\u8c61\uff0cJSON\u683c\u5f0f\u4e3b\u8981\u5305\u62ec\uff1a1.SrcObjIcon-24*24\u663e\u793a\u56fe\u6807\u30012.SrcObjType-\u4e1a\u52a1\u5bf9\u8c61\u7c7b\u578b\u30013.SrcObjTitle-\u663e\u793a\u6807\u9898\u30014.SrcObjUrl-\u6307\u5b9aURL\u94fe\u63a5\u5730\u5740\uff1b\u5176\u4e2d\u6807\u9898\u548c\u94fe\u63a5\u5730\u5740\u652f\u6301@\u516c\u5f0f'"})
    public ResponseObject call(Map<String, Object> params) {
        if (params == null) {
            return ResponseObject.newErrResponse().err("\u4e0d\u63a5\u53d7\u53c2\u6570\u4e3a\u7a7a\u7684\u8c03\u7528!");
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            ResponseObject execResult;
            String _content;
            NetworkNotification networkNotification;
            String networkId;
            String createTimeStr;
            Timestamp createTime = new Timestamp(System.currentTimeMillis());
            String userId = (String)params.get("userId");
            String sid = params.get("sid").toString();
            UserContext ctx = null;
            if (UtilString.isEmpty((String)userId) && UtilString.isEmpty((String)sid)) {
                throw new AWSForbiddenException("\u53c2\u6570uid\u548csid\u5fc5\u987b\u7ed9\u5b9a\u4e00\u4e2a");
            }
            if (!UtilString.isEmpty((String)userId)) {
                try {
                    ctx = UserContext.fromUID((String)userId);
                }
                catch (Exception e) {
                    ctx = UserContext.fromUID((String)"admin");
                }
            } else {
                ctx = UserContext.fromSessionId((String)sid);
                userId = ctx.getUID();
            }
            String message = params.get("message").toString();
            message = URLDecoder.decode(message, "UTF-8");
            String streamType = params.get("streamType") == null ? "1" : params.get("streamType").toString();
            DCAPI dcApi = SDK.getDCAPI();
            List attachementList = params.get("attachement") == null ? new ArrayList() : (List)params.get("attachement");
            String string = createTimeStr = params.containsKey("createTime") ? params.get("createTime").toString() : "";
            if (!UtilString.isEmpty((String)createTimeStr)) {
                createTime = Timestamp.valueOf(createTimeStr);
            }
            String yearMonth = UtilDate.yearFormat((Timestamp)createTime) + UtilDate.monthFormat((Timestamp)createTime);
            JSONArray array = new JSONArray();
            for (int i = 0; i < attachementList.size(); ++i) {
                Map attachment = (Map)attachementList.get(i);
                String fileName = (String)attachment.get("fileName");
                String fileType = null;
                int index = fileName.lastIndexOf(".");
                if (index > -1) {
                    fileType = fileName.substring(index + 1, fileName.length());
                }
                fileType = fileType.toLowerCase();
                String data = (String)attachment.get("data");
                ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((byte[])data.getBytes()));
                DataInputStream dataInputStream = new DataInputStream(bais);
                DCContext dc = new DCContext(ctx, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", yearMonth, ctx.getUID(), fileName);
                dcApi.write((InputStream)dataInputStream, dc);
                DCMessage dcMessage = dc.getDCMessage();
                if (dcMessage == null) continue;
                AttachementFile file = new AttachementFile();
                file.setCreateUser(userId);
                file.setFileActName(fileName);
                file.setFileName((String)dcMessage.getAttrs().get("fileName"));
                file.setFileSize((Integer)dcMessage.getAttrs().get("fileSize"));
                file.setFileType(fileType);
                file.setFileUUID((String)dcMessage.getAttrs().get("fileUUID"));
                JSONObject json = JSONObject.parseObject((String)JSON.toJSONString((Object)file));
                array.add((Object)json);
            }
            String link = params.get("link") == null ? "" : params.get("link").toString();
            String tags = params.get("tags") == null ? "" : params.get("tags").toString();
            String notifier = params.get("notifier") == null ? "" : params.get("notifier").toString();
            String notifierTeam = params.get("notifierTeam") == null ? "0" : params.get("notifierTeam").toString();
            String title = params.get("title") == null ? "" : params.get("title").toString();
            String praisePeople = params.get("praisePeople") == null ? "" : params.get("praisePeople").toString();
            String praiseBadge = params.get("praiseBadge") == null ? "" : params.get("praiseBadge").toString();
            String pariseDefinition = params.get("pariseDefinition") == null ? "" : params.get("pariseDefinition").toString();
            String sourceAppId = params.get("sourceAppId") == null ? "_bpm.platform.stream.ui" : params.get("sourceAppId").toString();
            String sourceType = params.get("sourceType") == null ? "" : params.get("sourceType").toString();
            String sourceId = params.get("sourceId") == null ? "" : params.get("sourceId").toString();
            String channelType = params.get("channelType") == null ? "" : params.get("channelType").toString();
            String parentSourceId = params.get("parentSourceId") == null ? "" : params.get("parentSourceId").toString();
            String sourceDeptId = params.get("sourceDeptId") == null ? "" : params.get("sourceDeptId").toString();
            String srcObjectContent = params.get("srcObjectContent") == null ? "" : params.get("srcObjectContent").toString();
            String ipAddress = params.get("ipAddress") == null ? ctx.getClientIP() : params.get("ipAddress").toString();
            String deviceType = params.get("deviceType") == null ? ctx.getDeviceType() : params.get("deviceType").toString();
            String teamId = params.get("teamId") == null ? "" : params.get("teamId").toString();
            String string2 = networkId = params.get("networkId") == null ? "" : params.get("networkId").toString();
            if (!UtilString.isEmpty((String)teamId) && UtilString.isEmpty((String)networkId)) {
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(teamId);
                if (teamModel == null) {
                    ro.err("\u5c0f\u7ec4\u4e0d\u5b58\u5728");
                    return ro;
                }
                networkId = teamModel.getNetworkId();
            }
            NetworkStreamModel model = new NetworkStreamModel();
            model.setId(UUIDGener.getUUID());
            String StreamContent2 = StreamContentHelper.format(Integer.parseInt(streamType), message, array.toString(), link, tags, notifier, notifierTeam, title, praisePeople, praiseBadge, pariseDefinition, ctx);
            model.setStreamContent(StreamContent2);
            if (attachementList.size() > 0) {
                model.setAttached("1");
            } else {
                model.setAttached("0");
            }
            model.setStreamType(streamType);
            model.setIpAddress(ipAddress);
            model.setDeviceType(deviceType);
            model.setCreateUserId(userId);
            ORGAPI orgApi = SDK.getORGAPI();
            model.setCreateUserName(orgApi.getUserNames(userId));
            model.setOrgId(ctx.getCompanyModel().getId());
            model.setCreateTime(createTime);
            model.setSourceAppId(sourceAppId);
            model.setSourceType(sourceType);
            model.setSourceId(sourceId);
            model.setChannelType(channelType);
            model.setParentSourceId(parentSourceId);
            model.setSourceDeptId(sourceDeptId);
            model.setTeamId(teamId);
            model.setNetworkId(networkId);
            if (!UtilString.isEmpty((String)srcObjectContent)) {
                try {
                    JSONObject srcJson = JSONObject.parseObject((String)srcObjectContent);
                    if (srcJson != null && srcJson.containsKey((Object)"srcObjType")) {
                        model.setSrcObjectContent(srcObjectContent);
                    }
                }
                catch (Exception e) {
                    ro.err("\u53c2\u6570srcObjectContent\u7684\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e");
                    return ro;
                }
            }
            model.setCacheed("1");
            NetworkStreamCache.putModel(model);
            List<String> topics = PatternUtil.matcherTopic(message);
            Map<String, NetworkTopicModel> topicMaps = NetworkTopicCache.vailModelByName(topics, networkId, teamId);
            Set<String> keySet = topicMaps.keySet();
            for (String topicName : keySet) {
                NetworkTopicModel topic = topicMaps.get(topicName);
                if (topic == null) {
                    topic = new NetworkTopicModel();
                    topic.setId(UUIDGener.getUUID());
                    topic.setTopicName(topicName);
                    topic.setTopicCount(1);
                    topic.setNetworkId(networkId);
                    topic.setTeamId(teamId);
                    topic.setCreateUserId(userId);
                    topic.setCreateUserName(ctx.getUserName());
                    topic.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                } else {
                    topic.setTopicCount(topic.getTopicCount() + 1);
                    topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                }
                NetworkTopicCache.putModel(topic);
            }
            String userAlisName = PatternUtil.matcherAtUserAliasNameStr(message);
            String userIds = orgApi.getUserIds(userAlisName) + " ";
            if (!UtilString.isEmpty((String)notifier)) {
                String[] uids = notifier.split(",");
                for (String uid : uids) {
                    if (userIds.contains((String)uid + " ") || ctx.getUID().equals(uid)) continue;
                    userIds = userIds + (String)uid + " ";
                }
            }
            if ("1".equals(notifierTeam)) {
                List<NetworkTeamMemberModel> memberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId);
                for (NetworkTeamMemberModel member : memberList) {
                    if (userIds.contains(member.getUserId() + " ") || ctx.getUID().equals(member.getUserId())) continue;
                    userIds = userIds + member.getUserId() + " ";
                }
            }
            if (!UtilString.isEmpty((String)userIds)) {
                networkNotification = new NetworkNotification();
                _content = HttpUtil.getSubString(message, 150, "...");
                String notificationContent = orgApi.getUserAliasNames(ctx.getUID()) + "\u63d0\u5230\u6211\uff1a   " + _content;
                JSONObject contentJson = new JSONObject();
                contentJson.put("data", (Object)notificationContent);
                contentJson.put("streamId", (Object)model.getId());
                execResult = networkNotification.dynamicNotification(ctx.getUID(), userIds, contentJson, "info", model.getId());
                if (execResult.isErr()) {
                    LOGGER.info(execResult.getMsg());
                }
            }
            if (!UtilString.isEmpty((String)praisePeople)) {
                networkNotification = new NetworkNotification();
                _content = HttpUtil.getSubString(message, 150, "...");
                praisePeople = praisePeople.replace(",", " ");
                String notificationContent = ctx.getUserModel().getUserNameAlias() + "\u8868\u626c\u4e86\u6211\uff1a   " + _content;
                JSONObject contentJson = new JSONObject();
                contentJson.put("data", (Object)notificationContent);
                contentJson.put("streamId", (Object)model.getId());
                execResult = networkNotification.dynamicNotification(ctx.getUID(), praisePeople, contentJson, "info", model.getId());
                if (execResult.isErr()) {
                    LOGGER.info(execResult.getMsg());
                }
            }
            ro.put("streamId", (Object)model.getId());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro;
    }
}

