/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.notification;

import com.actionsoft.apps.network.web.NetworkWeb;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.client.notification.NotificationMessageFormatter;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;

public class NetworkTeamVoteFormatter
implements NotificationMessageFormatter {
    public ResponseObject parser(UserContext user, String content) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject json = JSONObject.parseObject((String)content);
        String voteText = "\u6211\u6765\u6295\u4e00\u7968";
        String voteId = json.getString("voteId");
        String sid = json.getString("sid");
        boolean isPostVote = false;
        if (!UtilString.isEmpty((String)voteId)) {
            try {
                UserContext ctx = UserContext.fromSessionId((String)sid);
                NetworkWeb web = new NetworkWeb(ctx);
                isPostVote = web.checkPostVote(voteId);
            }
            catch (Exception e) {
                ro.err();
                ro.msg("\u6295\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
                return ro;
            }
        }
        if (isPostVote) {
            voteText = "\u67e5\u770b\u6295\u7968\u7ed3\u679c";
        }
        String data = json.getString("data");
        ro.put("content", (Object)data);
        ArrayList buttons = new ArrayList();
        HashMap<String, Object> button1 = new HashMap<String, Object>();
        button1.put("name", voteText);
        AppContext appContext = SDK.getAppAPI().getAppContext("com.actionsoft.apps.vote");
        String appName = "\u6295\u7968";
        if (appContext != null) {
            appName = appContext.getName();
        }
        if (user.isMobileClient()) {
            String userAgent = DispatcherRequest.getContext().getUserAgent();
            if (userAgent.contains("Android")) {
                ro.put("mobileAppId", (Object)"com.actionsoft.apps.vote.android");
                button1.put("action", "com.actionsoft.apps.vote.android:voteId=" + voteId + "&postVote=" + isPostVote);
            } else if (userAgent.contains("iPhone") || userAgent.contains("AWSMobilePortalPhone")) {
                button1.put("action", "com.actionsoft.apps.vote.ios://voteId=" + voteId + "&postVote=" + isPostVote);
                ro.put("mobileAppId", (Object)"com.actionsoft.apps.vote.ios");
            }
            button1.put("target", "app");
            button1.put("actionError", "\u8bf7\u5b89\u88c5" + appName + "\u5e94\u7528");
        } else {
            button1.put("action", SDK.getConfAPI().getPortalUrl() + "/r/w?sid=@sid&cmd=com.actionsoft.apps.vote_home&teamId=" + voteId);
            button1.put("target", "mainFrame");
        }
        button1.put("functionId", "network.dynamic.vote");
        button1.put("functionName", appName);
        button1.put("color", "blue");
        buttons.add(button1);
        ro.put("buttons", buttons);
        return ro;
    }

    public String testAjaxButton(UserContext user, String type, String msg) {
        return ResponseObject.newOkResponse().ok("\u7533\u8bf7\u88ab\u6279\u51c6\uff01type=" + type + ",msg=" + msg).toString();
    }
}

