/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkStreamDao
extends DaoObject<NetworkStreamModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkStreamDao.class);

    public List<NetworkStreamModel> loadNetworkStream(String networkId, String teamId) throws SQLException {
        ArrayList<NetworkStreamModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            LinkedList<String> params = new LinkedList<String>();
            sql.append("SELECT * FROM ").append("APP_ACT_NETWORK_STREAM").append(" where 1=1 ");
            if (!UtilString.isEmpty((String)networkId)) {
                sql.append(" and networkId = ? ");
                params.add(networkId);
            }
            if (!UtilString.isEmpty((String)teamId)) {
                sql.append(" and teamId = ? ");
                params.add(teamId);
            }
            list = DBSql.query((String)sql.toString(), this.rowMapper(), (Object[])params.toArray());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public List<NetworkStreamModel> loadNetworkStreamOfCache() {
        List<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT * FROM ").append("APP_ACT_NETWORK_STREAM").append(" where CACHEED = ? ");
            list = DBSql.query((String)sql.toString(), this.rowMapper(), (Object[])new Object[]{"1"});
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public String entityName() {
        return "APP_ACT_NETWORK_STREAM";
    }

    public int insert(NetworkStreamModel model) throws AWSDataAccessException {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("STREAMTYPE", model.getStreamType());
        paramsMap.put("STREAMCONTENT", model.getStreamContent());
        if (model.getIpAddress() != null) {
            paramsMap.put("IPADDRESS", model.getIpAddress());
        }
        if (model.getDeviceType() != null) {
            paramsMap.put("DEVICETYPE", model.getDeviceType());
        }
        if (model.getNetworkId() != null) {
            paramsMap.put("NETWORKID", model.getNetworkId());
        }
        if (model.getTeamId() != null) {
            paramsMap.put("TEAMID", model.getTeamId());
        }
        if (model.getStreamId() != null) {
            paramsMap.put("STREAMID", model.getStreamId());
        }
        if (model.getSourceAppId() != null) {
            paramsMap.put("SOURCEAPPID", model.getSourceAppId());
        }
        if (model.getSourceType() != null) {
            paramsMap.put("SOURCETYPE", model.getSourceType());
        }
        if (model.getSourceId() != null) {
            paramsMap.put("SOURCEID", model.getSourceId());
        }
        if (model.getChannelType() != null) {
            paramsMap.put("CHANNELTYPE", model.getChannelType());
        }
        if (model.getParentSourceId() != null) {
            paramsMap.put("PARENTSOURCEID", model.getParentSourceId());
        }
        if (model.getSourceDeptId() != null) {
            paramsMap.put("SOURCEDEPTID", model.getSourceDeptId());
        }
        if (model.getSrcObjectContent() != null) {
            paramsMap.put("SRCOBJECTCONTENT", model.getSrcObjectContent());
        }
        if (model.getAddress() != null) {
            paramsMap.put("ADDRESS", model.getAddress());
        }
        paramsMap.put("CACHEED", model.getCacheed());
        paramsMap.put("ATTACHED", model.getAttached());
        paramsMap.put("CREATEUSERID", model.getCreateUserId());
        paramsMap.put("CREATEUSERNAME", model.getCreateUserName());
        paramsMap.put("ORGID", model.getOrgId());
        paramsMap.put("CREATETIME", model.getCreateTime());
        paramsMap.put("ISANONYMITY", model.getIsAnonymity());
        return DBSql.update((String)DBSql.getInsertStatement((String)this.entityName(), paramsMap), paramsMap);
    }

    public RowMapper<NetworkStreamModel> rowMapper() {
        return new NetworkStreamModelRowMapper();
    }

    public int update(NetworkStreamModel model) throws AWSDataAccessException {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("STREAMTYPE", model.getStreamType());
        paramsMap.put("STREAMCONTENT", model.getStreamContent());
        if (model.getIpAddress() != null) {
            paramsMap.put("IPADDRESS", model.getIpAddress());
        }
        paramsMap.put("DEVICETYPE", model.getDeviceType());
        if (model.getNetworkId() != null) {
            paramsMap.put("NETWORKID", model.getNetworkId());
        }
        if (model.getTeamId() != null) {
            paramsMap.put("TEAMID", model.getTeamId());
        }
        if (model.getStreamId() != null) {
            paramsMap.put("STREAMID", model.getStreamId());
        }
        if (model.getSourceAppId() != null) {
            paramsMap.put("SOURCEAPPID", model.getSourceAppId());
        }
        if (model.getSourceType() != null) {
            paramsMap.put("SOURCETYPE", model.getSourceType());
        }
        if (model.getSourceId() != null) {
            paramsMap.put("SOURCEID", model.getSourceId());
        }
        if (model.getChannelType() != null) {
            paramsMap.put("CHANNELTYPE", model.getChannelType());
        }
        if (model.getParentSourceId() != null) {
            paramsMap.put("PARENTSOURCEID", model.getParentSourceId());
        }
        if (model.getSourceDeptId() != null) {
            paramsMap.put("SOURCEDEPTID", model.getSourceDeptId());
        }
        if (model.getSrcObjectContent() != null) {
            paramsMap.put("SRCOBJECTCONTENT", model.getSrcObjectContent());
        }
        if (model.getAddress() != null) {
            paramsMap.put("ADDRESS", model.getAddress());
        }
        paramsMap.put("CACHEED", model.getCacheed());
        if (model.getAttached() == null) {
            paramsMap.put("ATTACHED", "0");
        } else {
            paramsMap.put("ATTACHED", model.getAttached());
        }
        paramsMap.put("ISANONYMITY", model.getIsAnonymity());
        return super.update((Object)model.getId(), paramsMap);
    }

    private static class NetworkStreamModelRowMapper
    implements RowMapper<NetworkStreamModel> {
        private NetworkStreamModelRowMapper() {
        }

        public NetworkStreamModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkStreamModel model = new NetworkStreamModel();
            model.setId(rs.getString("ID"));
            model.setStreamType(rs.getString("STREAMTYPE"));
            model.setStreamContent(rs.getString("STREAMCONTENT"));
            model.setIpAddress(rs.getString("IPADDRESS"));
            model.setDeviceType(rs.getString("DEVICETYPE"));
            model.setNetworkId(rs.getString("NETWORKID"));
            model.setTeamId(rs.getString("TEAMID"));
            model.setStreamId(rs.getString("STREAMID"));
            model.setSourceAppId(rs.getString("SOURCEAPPID"));
            model.setSourceType(rs.getString("SOURCETYPE"));
            model.setSourceId(rs.getString("SOURCEID"));
            model.setCacheed(rs.getString("CACHEED"));
            model.setCreateUserId(rs.getString("CREATEUSERID"));
            model.setCreateUserName(rs.getString("CREATEUSERNAME"));
            model.setOrgId(rs.getString("ORGID"));
            model.setChannelType(rs.getString("CHANNELTYPE") == null ? " " : rs.getString("CHANNELTYPE"));
            model.setParentSourceId(rs.getString("PARENTSOURCEID"));
            model.setSourceDeptId(rs.getString("SOURCEDEPTID"));
            model.setCreateTime(rs.getTimestamp("CREATETIME"));
            model.setSrcObjectContent(rs.getString("SRCOBJECTCONTENT"));
            model.setAddress(rs.getString("ADDRESS"));
            model.setIsAnonymity(rs.getString("ISANONYMITY"));
            return model;
        }
    }
}

