/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.util;

import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.cache.NetworkStreamCommentCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.dc.PictureProcessor;
import com.actionsoft.apps.network.extend.TeamAppManager;
import com.actionsoft.apps.network.extend.TeamAppProfile;
import com.actionsoft.apps.network.helper.AttachementFile;
import com.actionsoft.apps.network.helper.StreamContent;
import com.actionsoft.apps.network.helper.StreamContentHelper;
import com.actionsoft.apps.network.model.NetworkAppAccessModel;
import com.actionsoft.apps.network.model.NetworkAppListModel;
import com.actionsoft.apps.network.model.NetworkAppToolBarModel;
import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.apps.network.model.NetworkStreamCommentModel;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.model.NetworkTeamMemberDto;
import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.model.NetworkTopicModel;
import com.actionsoft.apps.network.onlinedoc.OnlineDocTool;
import com.actionsoft.apps.network.util.DateUtils;
import com.actionsoft.apps.network.util.HttpUtil;
import com.actionsoft.apps.network.util.PatternUtil;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.security.ac.model.AccessControlModel;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.CompanyModel;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilDoc;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSException;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.ORGAPI;
import com.actionsoft.sdk.local.api.PermAPI;
import com.actionsoft.sdk.local.api.PortalAPI;
import com.actionsoft.sdk.local.api.RuleAPI;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDataUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkDataUtil.class);

    public static JSONArray network2JSON(List<NetworkModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkModel model : list) {
            JSONObject json = NetworkDataUtil.network2JSON(model, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject network2JSON(NetworkModel model, UserContext context) {
        JSONObject json = JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)model)));
        json.put("createTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd"));
        if (model.getUpdateTime() != null) {
            json.put("updateTime", (Object)DateUtils.format(model.getUpdateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (model.getLastActive() != null) {
            json.put("lastActive", (Object)DateUtils.format(model.getLastActive().getTime(), "yyyy-MM-dd"));
        }
        DCContext dc = null;
        try {
            dc = PictureProcessor.getDCContext(context, "com.actionsoft.apps.network", "!network-logo", "network", model.getId(), "logo.jpg");
        }
        catch (Exception e) {
            json.put("networkLogo", (Object)"../apps/com.actionsoft.apps.network/img/network.png");
            json.put("networkTmpLogo", (Object)"../apps/com.actionsoft.apps.network/img/network.png");
        }
        if (dc == null) {
            json.put("networkLogo", (Object)"../apps/com.actionsoft.apps.network/img/network.png");
            json.put("networkTmpLogo", (Object)"../apps/com.actionsoft.apps.network/img/network.png");
        } else {
            if (dc.existFile()) {
                json.put("networkLogo", (Object)(dc.getStremURL() + "&vt=" + System.currentTimeMillis()));
            } else {
                json.put("networkLogo", (Object)"../apps/com.actionsoft.apps.network/img/network.png");
            }
            File folder = new File(dc.getPath());
            if (folder.exists() && folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles()) {
                    if (!file.getName().contains("_big.")) continue;
                    dc.setFileName(file.getName());
                    break;
                }
            }
            if (dc.existFile()) {
                json.put("networkTmpLogo", (Object)(dc.getStremURL() + "&vt=" + System.currentTimeMillis()));
                json.put("networkTmpLogoFileName", (Object)dc.getFileName());
                json.put("haveNetworkLogo", (Object)true);
            } else {
                json.put("networkTmpLogo", (Object)"../apps/com.actionsoft.apps.network/img/network.png");
                json.put("networkTmpLogoFileName", (Object)"");
                json.put("haveNetworkLogo", (Object)false);
            }
        }
        json.put("teamManager", (Object)NetworkDataUtil.loadAllNetworkTeamMembermanagerName(model.getId()));
        boolean flag = NetworkDataUtil.isNetworkManager(model.getId(), context.getUID()) || model.getCreateUserId().equals(context.getUID()) || SDK.getPermAPI().isSystemAdministrator(context.getUID());
        json.put("isManager", (Object)flag);
        json.put("networkManager", (Object)NetworkDataUtil.getNetworkManagerUserName(model.getId()));
        return json;
    }

    public static String loadAllNetworkTeamMembermanagerName(String teamId) {
        StringBuffer content = new StringBuffer();
        try {
            List<NetworkTeamMemberModel> networkTeamMemberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId, "1");
            if (networkTeamMemberList.size() > 0) {
                for (int i = 0; i < networkTeamMemberList.size(); ++i) {
                    UserModel user;
                    NetworkTeamMemberModel model = networkTeamMemberList.get(i);
                    if (!model.getTeamId().equals(teamId) || !model.getMemberType().equals("1") || (user = UserCache.getModel((String)model.getUserId())) == null) continue;
                    if (i < networkTeamMemberList.size()) {
                        content.append(user.getUserName() + " ");
                        continue;
                    }
                    content.append(user.getUserName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return content.toString();
    }

    public static String getNetworkManagerUserName(String networkId) {
        String result = "";
        try {
            PortalAPI portalApi = SDK.getPortalAPI();
            JSONObject json = portalApi.queryUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username");
            JSONArray networkArray = (JSONArray)json.get((Object)"networkManage") == null ? new JSONArray() : (JSONArray)json.get((Object)"networkManage");
            int len = 0;
            if (networkArray != null) {
                len = networkArray.size();
                for (int i = 0; i < len; ++i) {
                    JSONObject record = networkArray.getJSONObject(i);
                    if (UtilString.isEmpty((String)networkId) || record.get((Object)"networkId") == null || !record.getString("networkId").equals(networkId) || UtilString.isEmpty((String)record.getString("userId"))) continue;
                    result = record.getString("userId");
                    result = SDK.getORGAPI().getUserNames(record.getString("userId"), ",");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result;
    }

    public static boolean isNetworkManager(String networkId, String uid) {
        boolean flag;
        block3: {
            flag = false;
            try {
                PortalAPI portalApi = SDK.getPortalAPI();
                JSONObject json = portalApi.queryUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username");
                JSONArray teamArray = (JSONArray)json.get((Object)"networkManage") == null ? new JSONArray() : (JSONArray)json.get((Object)"networkManage");
                int len = 0;
                if (teamArray == null) break block3;
                len = teamArray.size();
                for (int i = 0; i < len; ++i) {
                    JSONObject record = teamArray.getJSONObject(i);
                    if (record.get((Object)"userId") == null) continue;
                    List<String> rangeList = NetworkDataUtil.getRangeList(record.get((Object)"userId").toString());
                    if (!networkId.equals(record.getString("networkId")) || !rangeList.contains(uid)) continue;
                    flag = true;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        return flag;
    }

    public static boolean isTeamManager(String teamId, String userId) {
        boolean isManager = false;
        NetworkTeamModel team = NetworkTeamCache.getModel(teamId);
        if (team != null) {
            if (userId.equals(team.getCreateUserId())) {
                isManager = true;
            } else {
                NetworkTeamMemberModel member = NetworkTeamMemberCache.getModel(teamId, userId);
                if (member != null) {
                    isManager = "1".equals(member.getMemberType());
                }
            }
        }
        return isManager;
    }

    public static boolean havingNetworkPermission(String networkId, String userId) {
        boolean isAdmin = SDK.getPermAPI().isSystemAdministrator(userId);
        boolean isManager = NetworkDataUtil.isNetworkManager(networkId, userId);
        boolean flag = SDK.getPermAPI().havingACPermission(userId, "network.myAcTypeManage", networkId, 0);
        NetworkModel model = NetworkCache.getModel(networkId);
        List acList = SDK.getPermAPI().getACListByResource("network.myAcTypeManage", networkId, 0);
        return flag || acList.size() < 1 || isAdmin || isManager || model.getCreateUserId().equals(userId);
    }

    public static List<String> getRangeList(String range) {
        String[] principalStr = range.toString().split(",");
        ArrayList<String> principalList = new ArrayList<String>();
        if (principalStr.length > 0) {
            for (int j = 0; j < principalStr.length; ++j) {
                principalList.add(principalStr[j]);
            }
        }
        return principalList;
    }

    public static JSONArray team2JSON(List<NetworkTeamModel> list, UserContext context, boolean joinStatus) {
        JSONArray array = new JSONArray();
        for (NetworkTeamModel model : list) {
            JSONObject json = NetworkDataUtil.team2JSON(model, context);
            if (joinStatus) {
                NetworkTeamMemberModel member = NetworkTeamMemberCache.getModel(model.getId(), context.getUID());
                if (member == null) {
                    json.put("joinStatus", (Object)1);
                } else if ("1".equals(member.getJoinStatus())) {
                    json.put("joinStatus", (Object)2);
                } else if ("2".equals(member.getJoinStatus()) && "1".equals(member.getMemberStatus())) {
                    json.put("joinStatus", (Object)3);
                }
            }
            array.add((Object)json);
        }
        return array;
    }

    public static JSONArray team2JSON(List<NetworkTeamModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkTeamModel model : list) {
            JSONObject json = NetworkDataUtil.team2JSON(model, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject team2JSON(NetworkTeamModel model, UserContext context) {
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        json.put("createTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd"));
        if (model.getUpdateTime() != null) {
            json.put("updateTime", (Object)DateUtils.format(model.getUpdateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (model.getLastActive() != null) {
            json.put("lastActive", (Object)DateUtils.format(model.getLastActive().getTime(), "yyyy-MM-dd"));
        }
        DCContext dc = null;
        try {
            dc = PictureProcessor.getDCContext(context, "com.actionsoft.apps.network", "!network-logo", "team", model.getId(), "logo.jpg");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dc == null) {
            json.put("teamLogo", (Object)"../apps/com.actionsoft.apps.network/img/team.png");
            json.put("teamTmpLogo", (Object)"../apps/com.actionsoft.apps.network/img/team.png");
            json.put("haveTeamLogo", (Object)false);
        } else {
            if (dc.existFile()) {
                json.put("teamLogo", (Object)(dc.getStremURL() + "&vt=" + dc.getFileLastModified()));
            } else {
                json.put("teamLogo", (Object)"../apps/com.actionsoft.apps.network/img/team.png");
            }
            boolean existTempLogo = false;
            File folder = new File(dc.getPath());
            if (folder.exists() && folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles()) {
                    if (!file.getName().contains("_big.")) continue;
                    dc.setFileName(file.getName());
                    existTempLogo = true;
                    break;
                }
            }
            if (existTempLogo) {
                json.put("teamTmpLogo", (Object)(dc.getStremURL() + "&vt=" + dc.getFileLastModified()));
                json.put("teamTmpLogoFileName", (Object)dc.getFileName());
            }
            json.put("haveTeamLogo", (Object)existTempLogo);
        }
        json.put("teamManager", (Object)NetworkDataUtil.loadAllNetworkTeamMembermanagerName(model.getId()));
        boolean isManager = NetworkDataUtil.isNetworkManager(model.getNetworkId(), context.getUID());
        if (!isManager) {
            isManager = NetworkDataUtil.isTeamManager(model.getId(), context.getUID());
        }
        json.put("isManager", (Object)isManager);
        json.put("isCreator", (Object)model.getCreateUserId().equals(context.getUID()));
        List<String> memberUserList = NetworkTeamMemberCache.loadNetworkTeamMemberBy(model.getId(), "1");
        json.put("isMember", (Object)memberUserList.contains(context.getUID()));
        json.put("memberAmount", (Object)NetworkTeamMemberCache.getNetworkTeamMemberCountsByTeam(model.getId(), "1"));
        if (model.getTeamType() != null) {
            json.put("typeName", (Object)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)NetworkDataUtil.valiTeamType(model.getTeamType())));
        }
        return json;
    }

    public static String valiTeamType(String teamType) {
        String result = null;
        if (!UtilString.isEmpty((String)teamType)) {
            int number = Integer.parseInt(teamType);
            switch (number) {
                case 1: {
                    result = "\u516c\u5171\u5c0f\u7ec4";
                    break;
                }
                case 2: {
                    result = "\u79c1\u6709\u5c0f\u7ec4";
                    break;
                }
                case 3: {
                    result = "\u79d8\u5bc6\u5c0f\u7ec4";
                }
            }
        }
        return result;
    }

    public static JSONArray teamMemberDto2JSON(List<NetworkTeamMemberDto> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkTeamMemberDto dto : list) {
            JSONObject json = NetworkDataUtil.teamMemberDto2JSON(dto, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject teamMemberDto2JSON(NetworkTeamMemberDto dto, UserContext context) {
        NetworkTeamModel team;
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)dto)));
        if (!UtilString.isEmpty((String)dto.getTeamId()) && (team = NetworkTeamCache.getModel(dto.getTeamId())) != null) {
            boolean flag = team.getCreateUserId().equals(context.getUID());
            json.put("teamCreateUser", (Object)flag);
            json.put("teamCreateUserName", (Object)team.getCreateUserId());
        }
        json.put("createTime", (Object)DateUtils.format(dto.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        if (dto.getLastActive() != null) {
            json.put("lastActive", (Object)DateUtils.format(dto.getLastActive().getTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        return json;
    }

    public static JSONArray teamMember2JSON(List<NetworkTeamMemberModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkTeamMemberModel model : list) {
            JSONObject json = NetworkDataUtil.teamMember2JSON(model, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject teamMember2JSON(NetworkTeamMemberModel model, UserContext context) {
        NetworkTeamModel team;
        UserModel userModel;
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        PortalAPI portalApi = SDK.getPortalAPI();
        if (!UtilString.isEmpty((String)model.getUserId()) && (userModel = UserCache.getModel((String)model.getUserId())) != null) {
            DepartmentModel dept = DepartmentCache.getModel((String)userModel.getDepartmentId());
            NetworkTeamModel team2 = NetworkTeamCache.getModel(model.getTeamId());
            try {
                json.put("userPhoto", (Object)portalApi.getUserPhoto(context, model.getUserId()));
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
            json.put("teamName", (Object)team2.getTeamName());
            json.put("userName", (Object)userModel.getUserName());
            json.put("departmentId", (Object)userModel.getDepartmentId());
            json.put("departmentName", (Object)NetworkDataUtil.getTwoLevelDeptName(dept.getPathNameOfCache()));
            json.put("email", (Object)userModel.getEmail());
        }
        if (!UtilString.isEmpty((String)model.getTeamId()) && (team = NetworkTeamCache.getModel(model.getTeamId())) != null) {
            boolean flag = team.getCreateUserId().equals(context.getUID());
            json.put("teamCreateUser", (Object)flag);
            json.put("teamCreateUserName", (Object)team.getCreateUserId());
        }
        json.put("createTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        if (model.getLastActive() != null) {
            json.put("lastActive", (Object)DateUtils.format(model.getLastActive().getTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        return json;
    }

    public static JSONArray stream2JSON(List<NetworkStreamModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkStreamModel model : list) {
            if (model == null) continue;
            JSONObject json = NetworkDataUtil.stream2JSON(model, context);
            array.add((Object)json);
        }
        return array;
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject stream2JSON(NetworkStreamModel model, UserContext context) {
        void var15_53;
        String srcObjectContent;
        AppContext voteApp;
        RuleAPI ruleApi;
        AppContext app;
        NetworkTeamModel teamModel;
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        PortalAPI portalApi = SDK.getPortalAPI();
        ORGAPI orgApi = SDK.getORGAPI();
        String isAnonymous = model.getIsAnonymity();
        if (UtilString.isNotEmpty((String)isAnonymous) && "1".equals(isAnonymous)) {
            json.put("createUserName", (Object)"\u533f\u540d\u7528\u6237");
            json.put("userPhoto", (Object)"../commons/img/photo.png");
        } else {
            try {
                json.put("userPhoto", (Object)portalApi.getUserPhoto(context, model.getCreateUserId()));
            }
            catch (AWSException e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
            if (!UtilString.isEmpty((String)model.getCreateUserId())) {
                UserModel userModel = UserCache.getModel((String)model.getCreateUserId());
                if (userModel != null) {
                    json.put("createUserName", (Object)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)userModel.getUserName()));
                } else {
                    json.put("createUserName", (Object)"");
                }
            }
        }
        json.put("createTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        if (!UtilString.isEmpty((String)model.getTeamId()) && (teamModel = NetworkTeamCache.getModel(model.getTeamId())) != null) {
            json.put("teamName", (Object)teamModel.getTeamName());
        }
        if (!UtilString.isEmpty((String)model.getDeviceType())) {
            json.put("deviceType", (Object)model.getDeviceType().toUpperCase());
        }
        if (!UtilString.isEmpty((String)model.getSourceAppId()) && (app = SDK.getAppAPI().getAppContext(model.getSourceAppId())) != null && SDK.getAppAPI().isActive(app)) {
            json.put("sourceAppIcon", (Object)app.getIcon96FilePath());
            json.put("sourceAppName", (Object)app.getName());
        }
        JSONObject streamContent = JSONObject.parseObject((String)json.getString("streamContent"));
        StreamContent sc = StreamContentHelper.format(model.getStreamContent(), Integer.parseInt(model.getStreamType()), context);
        if (UtilString.isEmpty((String)sc.getLink())) {
            ruleApi = SDK.getRuleAPI();
            streamContent.put("linkTitle", (Object)ruleApi.executeAtScript(sc.getLinkTitle()));
            streamContent.put("link", (Object)ruleApi.executeAtScript(sc.getLink()));
        } else if (!UtilString.isEmpty((String)sc.getLink())) {
            ruleApi = SDK.getRuleAPI();
            String link = sc.getLink();
            String linkTitle = sc.getLinkTitle();
            try {
                link = ruleApi.executeAtScript(link, context);
                streamContent.put("link", (Object)link);
                streamContent.put("linkTitle", (Object)Html.htmlEscape((String)linkTitle));
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                streamContent.put("linkTitle", (Object)Html.htmlEscape((String)linkTitle));
                streamContent.put("link", (Object)link);
            }
        }
        List<AttachementFile> attachementList = sc.getAttachement();
        String groupValue = UtilDate.yearFormat((Timestamp)model.getCreateTime()) + UtilDate.monthFormat((Timestamp)model.getCreateTime());
        json.put("groupValue", (Object)groupValue);
        if (attachementList.size() > 0) {
            ArrayList<AttachementFile> afterAttachementList = new ArrayList<AttachementFile>();
            for (AttachementFile attachementFile : attachementList) {
                DCContext dc = new DCContext(context, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", groupValue, attachementFile.getCreateUser(), attachementFile.getFileName());
                dc.setFileNameShow(attachementFile.getFileActName());
                attachementFile.setUrl(dc.getDownloadURL());
                if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(attachementFile.getFileType() + ",")) {
                    attachementFile.setImage(dc.getStremURL());
                    dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                    if (dc.existFile()) {
                        attachementFile.setImageThum(dc.getStremURL());
                    } else {
                        attachementFile.setImageThum("");
                    }
                } else if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(attachementFile.getFileType() + ",") || "pdf".equals(attachementFile.getFileType())) {
                    dc.setFileName(attachementFile.getFileUUID() + ".jpg");
                    if (dc.existFile()) {
                        attachementFile.setImage(dc.getStremURL());
                    } else {
                        attachementFile.setImage("");
                    }
                    dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                    if (dc.existFile()) {
                        attachementFile.setImageThum(dc.getStremURL());
                    } else {
                        attachementFile.setImageThum("");
                    }
                } else {
                    attachementFile.setImage("");
                    attachementFile.setImageThum("");
                }
                afterAttachementList.add(attachementFile);
            }
            streamContent.put("attachement", afterAttachementList);
        }
        String content = streamContent.getString("content");
        content = content.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        content = NetworkDataUtil.formaterAtSomeone(content);
        content = content.replace(Html.escape((String)"\n"), "</br>");
        List<String> topics = PatternUtil.matcherTopic(streamContent.getString("content"));
        for (String str : topics) {
            str = Html.escape((String)str);
            content = content.replace(str, "<span class=\"network-topic\">" + str + "</span>");
        }
        streamContent.put("content", (Object)content);
        if (streamContent.containsKey((Object)"praisePeople")) {
            String string = streamContent.getString("praisePeople");
            String pariseDefinition = streamContent.getString("pariseDefinition");
            if (!UtilString.isEmpty((String)pariseDefinition)) {
                streamContent.put("pariseDefinition", (Object)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)pariseDefinition));
            }
            if (!UtilString.isEmpty((String)string)) {
                StringBuffer praisePeopleName = new StringBuffer();
                List list = orgApi.getUsersByUIDs(string.replace(",", " "));
                for (UserModel user : list) {
                    praisePeopleName.append("<span class=\"network-at-someone awsui-user-profile\" userId=\"" + user.getUID() + "\">" + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)user.getUserName()) + "</span>&nbsp;&nbsp;");
                }
                streamContent.put("praisePeopleName", (Object)praisePeopleName.toString());
            }
            String praiseBadge = streamContent.getString("praiseBadge");
            streamContent.put("praiseBadge", (Object)("/apps/com.actionsoft.apps.network/img/praise/" + (String)praiseBadge + ".png"));
        }
        json.put("streamContent", (Object)streamContent);
        if (!UtilString.isEmpty((String)model.getStreamId())) {
            NetworkStreamModel networkStreamModel = NetworkStreamCache.getModel(model.getStreamId());
            if (networkStreamModel == null) {
                json.put("originalStream", null);
            } else {
                json.put("originalStream", (Object)NetworkDataUtil.stream2JSON(networkStreamModel, context));
            }
        }
        ArrayList arrayList = new ArrayList();
        boolean flag = false;
        try {
            List<NetworkStreamCommentModel> list = NetworkStreamCommentCache.loadStreamComment(model.getId(), "2");
            json.put("favoritesSize", (Object)list.size());
            if (list.size() > 0) {
                for (NetworkStreamCommentModel networkStreamCommentModel : list) {
                    if (!networkStreamCommentModel.getCreateUserId().equals(context.getUID())) continue;
                    flag = true;
                    break;
                }
            }
            json.put("isFavoritesPost", (Object)flag);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        try {
            ArrayList arrayList2 = new ArrayList();
            List<NetworkStreamCommentModel> list = NetworkStreamCommentCache.loadStreamComment(model.getId(), "1");
            json.put("praiseSize", (Object)list.size());
            flag = false;
            if (list.size() > 0) {
                for (NetworkStreamCommentModel networkStreamCommentModel : list) {
                    if (!networkStreamCommentModel.getCreateUserId().equals(context.getUID())) continue;
                    flag = true;
                    break;
                }
            }
            json.put("isPraisePost", (Object)flag);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        try {
            ArrayList arrayList3 = new ArrayList();
            List<NetworkStreamCommentModel> list = NetworkStreamCommentCache.loadStreamComment(model.getId(), "3");
            json.put("replysSize", (Object)list.size());
            UtilListSort sortList = new UtilListSort();
            sortList.sort(list, "createTime", "DESC");
            json.put("commentList", (Object)NetworkDataUtil.streamComment2JSON(list, context));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        try {
            ArrayList arrayList4 = new ArrayList();
            List<NetworkStreamCommentModel> list = NetworkStreamCommentCache.loadStreamComment(model.getId(), "4");
            json.put("transpondSize", (Object)list.size());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        if (model.getStreamType().equals("5") && !UtilString.isEmpty((String)model.getId()) && (voteApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.vote")) != null && SDK.getAppAPI().isActive(voteApp.getId())) {
            String string = "aslp://com.actionsoft.apps.vote/queryVote";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sid", context.getSessionId());
            params.put("voteId", model.getId());
            ResponseObject ro = SDK.getAppAPI().callASLP(voteApp, string, params);
            if (!ro.isOk()) {
                SDK.getAppAPI().err(voteApp, ro.getMsg());
            } else {
                JSONObject voteModel = (JSONObject)ro.get("model");
                if (voteModel != null) {
                    json.put("voteModel", (Object)voteModel);
                }
            }
            String aslp2 = "aslp://com.actionsoft.apps.vote/checkPostVote";
            HashMap<String, String> params2 = new HashMap<String, String>();
            params2.put("sid", context.getSessionId());
            params2.put("voteId", model.getId());
            ResponseObject re = SDK.getAppAPI().callASLP(voteApp, aslp2, params2);
            if (!re.isOk()) {
                SDK.getAppAPI().err(voteApp, re.getMsg());
            } else {
                boolean isVotePost = (Boolean)re.get("isVote");
                json.put("isVotePost", (Object)isVotePost);
            }
        }
        if (!UtilString.isEmpty((String)(srcObjectContent = model.getSrcObjectContent()))) {
            JSONObject jSONObject = JSONObject.parseObject((String)srcObjectContent);
            String srcObjTitle = jSONObject.getString("srcObjTitle");
            if (srcObjTitle.indexOf("@") > -1) {
                srcObjTitle = SDK.getRuleAPI().executeAtScript(srcObjTitle, context);
            }
            jSONObject.put("srcObjTitle", (Object)srcObjTitle);
            String srcObjUrl = jSONObject.getString("srcObjUrl");
            if (srcObjUrl.indexOf("@") > -1) {
                srcObjUrl = SDK.getRuleAPI().executeAtScript(srcObjUrl, context);
            }
            jSONObject.put("srcObjUrl", (Object)srcObjUrl);
            model.setSrcObjectContent(jSONObject.toString());
        }
        boolean bl = false;
        if (!UtilString.isEmpty((String)model.getNetworkId())) {
            boolean isNetworkManager = NetworkDataUtil.isNetworkManager(model.getNetworkId(), context.getUID());
            if (model.getCreateUserId().equals(context.getUID()) || isNetworkManager || SDK.getPermAPI().isSystemAdministrator(context.getUID())) {
                boolean bl2 = true;
            } else if (!UtilString.isEmpty((String)model.getTeamId())) {
                List<String> userManagerList = NetworkDataUtil.loadAllNetworkTeamMemberManagerList(model.getTeamId());
                if (userManagerList.contains(context.getUID()) || model.getCreateUserId().equals(context.getUID()) || SDK.getPermAPI().isSystemAdministrator(context.getUID())) {
                    boolean bl3 = true;
                }
            } else if (model.getCreateUserId().equals(context.getUID())) {
                boolean bl4 = true;
            }
        } else if (model.getCreateUserId().equals(context.getUID())) {
            boolean bl5 = true;
        }
        json.put("isDelete", (Object)((boolean)var15_53));
        return json;
    }

    public static JSONArray stream2JSONOfOriginal(List<NetworkStreamModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkStreamModel model : list) {
            JSONObject json = NetworkDataUtil.stream2JSONOfOriginal(model, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject stream2JSONOfOriginal(NetworkStreamModel model, UserContext context) {
        AppContext voteApp;
        RuleAPI ruleApi;
        NetworkTeamModel teamModel;
        JSONObject json = JSONObject.parseObject((String)JSON.toJSON((Object)((Object)model)).toString());
        ORGAPI orgApi = SDK.getORGAPI();
        String isAnonymous = model.getIsAnonymity();
        if (UtilString.isNotEmpty((String)isAnonymous) && "1".equals(isAnonymous)) {
            json.put("createUserName", (Object)"\u533f\u540d\u7528\u6237");
            json.put("userPhoto", (Object)"../commons/img/photo.png");
            json.put("photoUrl", (Object)"../commons/img/photo.png");
        } else {
            try {
                Object photoUrl = SDK.getPortalAPI().getUserPhoto(context, model.getCreateUserId());
                json.put("userPhoto", photoUrl);
                photoUrl = ((String)photoUrl).substring(1, ((String)photoUrl).length());
                if (((String)photoUrl).startsWith("/df")) {
                    photoUrl = SDK.getConfAPI().getMobileUrl() + "/r" + (String)photoUrl;
                } else if (((String)photoUrl).startsWith("./")) {
                    photoUrl = ((String)photoUrl).substring(1, ((String)photoUrl).length());
                    photoUrl = SDK.getConfAPI().getMobileUrl() + (String)photoUrl;
                }
                json.put("photoUrl", photoUrl);
            }
            catch (AWSException e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        json.put("createTime", (Object)DateUtils.getAliasDate(model.getCreateTime()));
        json.put("createTimeLong", (Object)model.getCreateTime().getTime());
        json.put("friendlyCreateTime", (Object)DateUtils.getFriendlytime(model.getCreateTime()));
        if (!UtilString.isEmpty((String)model.getTeamId()) && (teamModel = NetworkTeamCache.getModel(model.getTeamId())) != null) {
            json.put("teamName", (Object)teamModel.getTeamName());
        }
        JSONObject streamContent = JSONObject.parseObject((String)json.getString("streamContent"));
        StreamContent sc = StreamContentHelper.format(model.getStreamContent(), Integer.parseInt(model.getStreamType()), context);
        if (UtilString.isEmpty((String)sc.getLink())) {
            ruleApi = SDK.getRuleAPI();
            streamContent.put("linkTitle", (Object)ruleApi.executeAtScript(sc.getLink()));
        } else if (!UtilString.isEmpty((String)sc.getLink()) && UtilString.isEmpty((String)sc.getLinkDescription())) {
            ruleApi = SDK.getRuleAPI();
            String link = ruleApi.executeAtScript(sc.getLink());
            try {
                HtmlPage page = HttpUtil.getHtmlPage(link);
                Iterator<NetworkStreamCommentModel> title = page.getTitleText();
                String description = null;
                DomNodeList metas = page.getElementsByTagName("meta");
                for (HtmlElement meta : metas) {
                    String name = meta.getAttribute("name");
                    if (!name.toLowerCase().equals("description")) continue;
                    description = meta.getAttribute("content");
                    break;
                }
                if (description == null) {
                    description = page.getBody().asText();
                }
                description = HttpUtil.getSubString(description, 300, "...");
                streamContent.put("linkTitle", title);
                streamContent.put("linkDescription", (Object)description);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                streamContent.put("linkTitle", (Object)link);
            }
            model.setStreamContent(streamContent.toString());
            NetworkStreamCache.putModel(model);
        }
        List<AttachementFile> attachementList = sc.getAttachement();
        if (attachementList.size() > 0) {
            String groupValue = UtilDate.yearFormat((Timestamp)model.getCreateTime()) + UtilDate.monthFormat((Timestamp)model.getCreateTime());
            ArrayList<AttachementFile> afterAttachementList = new ArrayList<AttachementFile>();
            for (AttachementFile file : attachementList) {
                DCContext dc = new DCContext(context, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", groupValue, file.getCreateUser(), file.getFileName());
                dc.setFileNameShow(file.getFileActName());
                file.setGroupValue(groupValue);
                file.setUrl(dc.getDownloadURL());
                String fileType = file.getFileType() == null ? "" : file.getFileType().toLowerCase();
                OnlineDocTool tool = new OnlineDocTool();
                String supportType = tool.returnSupportType(context);
                if (supportType.contains(fileType)) {
                    file.setPreview(true);
                } else {
                    file.setPreview(false);
                }
                if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(fileType + ",")) {
                    file.setImage(dc.getStremURL());
                    dc.setFileName(file.getFileUUID() + "_thum.jpg");
                    if (dc.existFile()) {
                        file.setImageThum(dc.getStremURL());
                    } else {
                        file.setImageThum("");
                    }
                } else if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(fileType + ",") || "pdf".equals(fileType)) {
                    dc.setFileName(file.getFileUUID() + ".jpg");
                    if (dc.existFile()) {
                        file.setImage(dc.getStremURL());
                    } else {
                        file.setImage("");
                    }
                    dc.setFileName(file.getFileUUID() + "_thum.jpg");
                    if (dc.existFile()) {
                        file.setImageThum(dc.getStremURL());
                    } else {
                        file.setImageThum("");
                    }
                } else {
                    file.setImage("");
                    file.setImageThum("");
                }
                afterAttachementList.add(file);
            }
            streamContent.put("attachement", afterAttachementList);
        }
        if (streamContent.containsKey((Object)"praisePeople")) {
            String praisePeople = streamContent.getString("praisePeople");
            if (!UtilString.isEmpty((String)praisePeople)) {
                String praisePeopleName = orgApi.getUserNames(praisePeople.replace(",", " "));
                streamContent.put("praisePeopleName", (Object)praisePeopleName);
            }
            String praiseBadge = streamContent.getString("praiseBadge");
            streamContent.put("praiseBadge", (Object)("/apps/com.actionsoft.apps.network/img/praise/" + praiseBadge + ".png"));
        }
        json.put("streamContent", (Object)streamContent);
        if (!UtilString.isEmpty((String)model.getStreamId())) {
            NetworkStreamModel transpondStream = NetworkStreamCache.getModel(model.getStreamId());
            if (transpondStream == null) {
                json.put("originalStream", null);
                json.put("originalStreamDeleted", (Object)true);
            } else {
                json.put("originalStreamDeleted", (Object)false);
                json.put("originalStream", (Object)NetworkDataUtil.stream2JSONOfOriginal(transpondStream, context));
            }
        }
        String commentId = "";
        try {
            List<NetworkStreamCommentModel> favoriteList = NetworkStreamCommentCache.loadStreamComment(model.getId(), "2");
            json.put("favoritesSize", (Object)favoriteList.size());
            if (favoriteList.size() > 0) {
                for (Object comment : favoriteList) {
                    if (!comment.getCreateUserId().equals(context.getUID())) continue;
                    commentId = comment.getId();
                    break;
                }
            }
            json.put("favoritesId", (Object)(commentId == null ? " " : commentId));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        try {
            List<NetworkStreamCommentModel> praiseList = NetworkStreamCommentCache.loadStreamComment(model.getId(), "1");
            JSONArray praises = NetworkDataUtil.streamComment2JSONOfOriginal(praiseList, context);
            json.put("praises", (Object)praises);
            json.put("praiseSize", (Object)praiseList.size());
            commentId = "";
            if (praiseList.size() > 0) {
                for (NetworkStreamCommentModel comment : praiseList) {
                    if (!comment.getCreateUserId().equals(context.getUID())) continue;
                    commentId = comment.getId();
                    break;
                }
            }
            json.put("praiseId", (Object)(commentId == null ? " " : commentId));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        try {
            List<NetworkStreamCommentModel> commentList = NetworkStreamCommentCache.loadStreamComment(model.getId(), "3");
            JSONArray comments = NetworkDataUtil.streamComment2JSONOfOriginal(commentList, context);
            json.put("comments", (Object)comments);
            json.put("replysSize", (Object)commentList.size());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        try {
            List<NetworkStreamCommentModel> streamList = NetworkStreamCommentCache.loadStreamComment(model.getId(), "4");
            json.put("transpondSize", (Object)streamList.size());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        if (model.getStreamType().equals("5") && !UtilString.isEmpty((String)model.getId()) && (voteApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.vote")) != null && SDK.getAppAPI().isActive(voteApp.getId())) {
            json.put("voteId", (Object)model.getId());
            String aslp2 = "aslp://com.actionsoft.apps.vote/checkPostVote";
            HashMap<String, String> params2 = new HashMap<String, String>();
            params2.put("sid", context.getSessionId());
            params2.put("voteId", model.getId());
            ResponseObject re = SDK.getAppAPI().callASLP(voteApp, aslp2, params2);
            if (!re.isOk()) {
                SDK.getAppAPI().err(voteApp, re.getMsg());
            } else {
                boolean isVotePost = (Boolean)re.get("isVote");
                json.put("postVote", (Object)isVotePost);
            }
        }
        boolean isManager = false;
        if (!UtilString.isEmpty((String)model.getNetworkId())) {
            List<String> userManagerList;
            boolean isNetworkManager = NetworkDataUtil.isNetworkManager(model.getNetworkId(), context.getUID());
            if (model.getCreateUserId().equals(context.getUID()) || isNetworkManager || SDK.getPermAPI().isSystemAdministrator(context.getUID())) {
                isManager = true;
            } else if (!UtilString.isEmpty((String)model.getTeamId()) && (userManagerList = NetworkDataUtil.loadAllNetworkTeamMemberManagerList(model.getTeamId())).contains(context.getUID())) {
                isManager = true;
            }
        }
        json.put("isDelete", (Object)isManager);
        return json;
    }

    public static List<String> loadAllNetworkTeamMemberManagerList(String teamId) {
        ArrayList<String> userList = new ArrayList<String>();
        try {
            NetworkTeamModel team;
            List<NetworkTeamMemberModel> networkTeamMemberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId, "1");
            if (networkTeamMemberList.size() > 0) {
                for (NetworkTeamMemberModel model : networkTeamMemberList) {
                    if (!"1".equals(model.getMemberType())) continue;
                    userList.add(model.getUserId());
                }
            }
            if (!userList.contains((team = NetworkTeamCache.getModel(teamId)).getCreateUserId())) {
                userList.add(team.getCreateUserId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return userList;
    }

    public static JSONArray streamComment2JSON(List<NetworkStreamCommentModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkStreamCommentModel model : list) {
            JSONObject json = NetworkDataUtil.streamComment2JSON(model, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject streamComment2JSON(NetworkStreamCommentModel model, UserContext context) {
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        json.put("createTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        json.put("replyTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        String isAnonymous = model.getIsAnonymity();
        if (UtilString.isNotEmpty((String)isAnonymous) && "1".equals(isAnonymous)) {
            json.put("replyUser", (Object)"\u533f\u540d\u7528\u6237");
            json.put("userPhoto", (Object)"../commons/img/photo.png");
        } else {
            json.put("replyUser", (Object)model.getCreateUserName());
            try {
                PortalAPI portalApi = SDK.getPortalAPI();
                json.put("userPhoto", (Object)portalApi.getUserPhoto(context, model.getCreateUserId()));
            }
            catch (AWSException e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        String commentContent = model.getCommentContent();
        commentContent = commentContent.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        json.put("commentContent", (Object)NetworkDataUtil.formaterAtSomeone(commentContent));
        return json;
    }

    public static JSONArray streamComment2JSONOfOriginal(List<NetworkStreamCommentModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkStreamCommentModel model : list) {
            JSONObject json = NetworkDataUtil.streamComment2JSONOfOriginal(model, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject streamComment2JSONOfOriginal(NetworkStreamCommentModel model, UserContext context) {
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        json.put("createTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        json.put("replyTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        json.put("replyTimeLong", (Object)model.getCreateTime().getTime());
        json.put("isCreator", (Object)context.getUID().equals(model.getCreateUserId()));
        String isAnonymous = model.getIsAnonymity();
        if (UtilString.isNotEmpty((String)isAnonymous) && "1".equals(isAnonymous)) {
            json.put("replyUser", (Object)"\u533f\u540d\u7528\u6237");
            json.put("createUserName", (Object)"\u533f\u540d\u7528\u6237");
            json.put("userPhoto", (Object)"../commons/img/photo.png");
        } else {
            json.put("replyUser", (Object)model.getCreateUserName());
            try {
                Object photoUrl = SDK.getPortalAPI().getUserPhoto(context, model.getCreateUserId());
                json.put("userPhoto", photoUrl);
                photoUrl = ((String)photoUrl).substring(1, ((String)photoUrl).length());
                if (((String)photoUrl).startsWith("/df")) {
                    photoUrl = SDK.getConfAPI().getMobileUrl() + "/r" + (String)photoUrl;
                } else if (((String)photoUrl).startsWith("./")) {
                    photoUrl = ((String)photoUrl).substring(1, ((String)photoUrl).length());
                    photoUrl = SDK.getConfAPI().getMobileUrl() + (String)photoUrl;
                }
                json.put("photoUrl", photoUrl);
            }
            catch (AWSException e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        return json;
    }

    public static JSONArray topic2JSON(List<NetworkTopicModel> list, UserContext context) {
        JSONArray array = new JSONArray();
        for (NetworkTopicModel model : list) {
            JSONObject json = NetworkDataUtil.topic2JSON(model, context);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject topic2JSON(NetworkTopicModel model, UserContext context) {
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        json.put("createTime", (Object)DateUtils.format(model.getCreateTime().getTime(), "yyyy-MM-dd HH:mm:ss"));
        NetworkModel network = NetworkCache.getModel(model.getNetworkId());
        if (network != null) {
            json.put("networkName", (Object)network.getNetworkName());
        } else {
            json.put("networkName", (Object)"");
        }
        try {
            PortalAPI portalApi = SDK.getPortalAPI();
            json.put("userPhoto", (Object)portalApi.getUserPhoto(context, model.getCreateUserId()));
        }
        catch (AWSException e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return json;
    }

    public static JSONArray appToolBar2JSON(List<NetworkAppToolBarModel> list) {
        JSONArray array = new JSONArray();
        for (NetworkAppToolBarModel model : list) {
            JSONObject json = NetworkDataUtil.appToolBar2JSON(model);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject appToolBar2JSON(NetworkAppToolBarModel model) {
        TeamAppProfile appProfile;
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        if (!UtilString.isEmpty((String)model.getAppId()) && (appProfile = TeamAppManager.getProfile(model.getAppId())) != null) {
            json.put("appContentId", (Object)appProfile.getAppContext().getId());
            json.put("appProfileId", (Object)appProfile.getId());
            json.put("appProfileName", (Object)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)appProfile.getTitle()));
        }
        return json;
    }

    public static JSONArray appAccess2JSON(List<NetworkAppAccessModel> list) {
        JSONArray array = new JSONArray();
        for (NetworkAppAccessModel model : list) {
            JSONObject json = NetworkDataUtil.appAccess2JSON(model);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject appAccess2JSON(NetworkAppAccessModel model) {
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        if (!UtilString.isEmpty((String)model.getTeamId())) {
            NetworkTeamModel teamModel = NetworkTeamCache.getModel(model.getTeamId());
            json.put("teamId", (Object)teamModel.getId());
            json.put("teamName", (Object)teamModel.getTeamName());
        }
        return json;
    }

    public static JSONArray appList2JSONAppList(List<NetworkAppListModel> list) {
        JSONArray array = new JSONArray();
        for (NetworkAppListModel model : list) {
            JSONObject json = NetworkDataUtil.appList2JSONAppList(model);
            array.add((Object)json);
        }
        return array;
    }

    public static JSONObject appList2JSONAppList(NetworkAppListModel model) {
        JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)model)));
        return json;
    }

    public static String formaterAtSomeone(String content) {
        List<String> atSomeones = PatternUtil.matcherAtUserAliasName(content);
        List<String> someones = PatternUtil.matcherUserAliasName(content);
        content = Html.escape((String)content);
        if (!(atSomeones != null && atSomeones.size() != 0 || someones != null && someones.size() != 0)) {
            return content;
        }
        ORGAPI orgApi = SDK.getORGAPI();
        UserModel userModel = null;
        for (String str : atSomeones) {
            userModel = orgApi.getUser(orgApi.getUserId(str));
            str = Html.escape((String)str);
            if (userModel == null) continue;
            content = content.replace("@" + str, "<span class=\"network-at-someone awsui-user-profile\" userId=\"" + userModel.getUID() + "\">@" + userModel.getUserName() + "</span>");
        }
        for (String str : someones) {
            userModel = orgApi.getUser(orgApi.getUserId(str));
            str = Html.escape((String)str);
            if (userModel == null) continue;
            content = content.replace(str, "<span class=\"network-at-someone awsui-user-profile\" userId=\"" + userModel.getUID() + "\">" + userModel.getUserName() + "</span> ");
        }
        return content;
    }

    public static String getTwoLevelDeptName(String fullDeptName) {
        if (UtilString.isEmpty((String)fullDeptName)) {
            return "";
        }
        Object deptName = "";
        String[] deptNames = fullDeptName.split("/");
        int len = deptNames.length;
        int start = len - 2;
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < len; ++i) {
            deptName = (String)deptName + deptNames[i] + "/";
        }
        return deptName;
    }

    public static JSONArray searchUsersOfNetwork(String networkId, String key, int limit, UserContext context) {
        if (limit == 0) {
            limit = 10;
        }
        Set<UserModel> users = NetworkDataUtil.searchUserListOfNetwork(networkId, key, limit, context);
        JSONArray userArray = new JSONArray();
        for (UserModel user : users) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)user.getUniqueId());
            json.put("uid", (Object)user.getUID());
            json.put("userName", (Object)user.getUserNameAlias());
            userArray.add((Object)json);
        }
        return userArray;
    }

    public static Set<UserModel> searchUserListOfNetwork(String networkId, String key, int limit, UserContext context) {
        Set<UserModel> userList = NetworkDataUtil.getUsersByNetwork(networkId, context);
        Pattern p = Pattern.compile(Pattern.quote(key), 2);
        for (UserModel userModel : userList) {
            String name = userModel.getUserName();
            String uid = userModel.getUID();
            String preSpell = userModel.getPreSpell();
            if (!p.matcher(name).find() && !p.matcher(uid).find() && !p.matcher(preSpell).find()) continue;
            userList.add(userModel);
            if (limit <= 0 || userList.size() < limit) continue;
            break;
        }
        return userList;
    }

    public static Set<UserModel> getUsersByNetwork(String networkId, UserContext context) {
        LinkedHashSet<UserModel> userList = new LinkedHashSet<UserModel>();
        PermAPI permApi = SDK.getPermAPI();
        List acList = permApi.getACListByResource("network.myAcTypeManage", networkId, 0);
        if (acList == null) {
            return userList;
        }
        ORGAPI orgApi = SDK.getORGAPI();
        for (AccessControlModel ac : acList) {
            UserModel user;
            if ("company".equals(ac._assignmentType)) {
                CompanyModel company = orgApi.getCompanyById(ac._assignmentId);
                CompanyModel curCompany = context.getCompanyModel();
                List companyIds = orgApi.getConcurrentlyCompanyId(context.getUID());
                try {
                    List departments;
                    if (!company.getId().equals(curCompany.getId()) && !orgApi.hasCompanySec(company.getId(), context.getUID()) && !companyIds.contains(company.getId()) || (departments = DepartmentCache.getDepartmentListOfLayer((int)1, (String)company.getId())).size() <= 0) continue;
                    userList.addAll(NetworkDataUtil.getUsersByDept(departments, context));
                }
                catch (Exception e) {
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
                continue;
            }
            if ("department".equals(ac._assignmentType)) {
                DepartmentModel department = orgApi.getDepartmentById(ac._assignmentId);
                userList.addAll(NetworkDataUtil.getUsersByDept(department, context));
                continue;
            }
            if (!"user".equals(ac._assignmentType) || (user = orgApi.getUser(ac._assignmentId)).isClosed()) continue;
            userList.add(user);
        }
        return userList;
    }

    private static List<UserModel> getUsersByDept(List<DepartmentModel> departments, UserContext context) {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        try {
            for (DepartmentModel departmentModel : departments) {
                result.addAll(NetworkDataUtil.getUsersByDept(departmentModel, context));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result;
    }

    private static List<UserModel> getUsersByDept(DepartmentModel department, UserContext context) {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        ORGAPI orgApi = SDK.getORGAPI();
        List userList = orgApi.getUsersByDepartment(department.getId());
        for (UserModel user : userList) {
            if (user.isClosed()) continue;
            result.add(user);
        }
        List subDepartments = orgApi.getSubDepartments(department.getId());
        if (subDepartments.size() > 0) {
            result.addAll(NetworkDataUtil.getUsersByDept(subDepartments, context));
        }
        return result;
    }

    public static JSONArray getTextBoxData(String uidStr) {
        JSONArray array = new JSONArray();
        if (UtilString.isEmpty((String)uidStr)) {
            return array;
        }
        String[] uids = uidStr.split(",");
        int len = uids.length;
        for (int i = 0; i < len; ++i) {
            if (UtilString.isEmpty((String)uids[i])) continue;
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)uids[i]);
            obj.put("value", (Object)uids[i]);
            UserModel user = UserCache.getModel((String)uids[i]);
            if (user != null) {
                obj.put("label", (Object)user.getUserName());
            } else {
                obj.put("label", (Object)uids[i]);
            }
            array.add((Object)obj);
        }
        return array;
    }

    public static boolean isJson(String content) {
        try {
            JSONObject jsonStr = JSONObject.parseObject((String)content);
            return true;
        }
        catch (Exception e) {
            try {
                JSONArray array = JSONArray.parseArray((String)content);
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    public static String getSupportType(UserContext ctx) {
        Object support = UtilDoc.getOnlinedocSupportType((UserContext)ctx);
        if (SDK.getAppAPI().isActive("com.actionsoft.apps.addons.wpsonline")) {
            support = (String)support + "doc,dot,wps,wpt,docx,dotx,docm,dotm,xls,xlt,et,xlsx,xltx,csv,xlsm,xltm,ppt,pptx,pptm,ppsx,ppsm,pps,potx,potm,dpt,dps,pdf";
        }
        return support;
    }

    public static void main(String[] args) {
        LOGGER.info(NetworkDataUtil.getTwoLevelDeptName("\u90e8\u95e8\u4e00/\u90e8\u95e8\u4e8c/\u90e8\u95e8\u4e09/"));
    }

    public static boolean isAnonymousByStreamId(String streamId) {
        NetworkStreamModel stream = NetworkStreamCache.getModel(streamId);
        if (stream != null) {
            if (stream.getIsAnonymity() == null) {
                return false;
            }
            return stream.getIsAnonymity().equals("1");
        }
        return false;
    }

    public static boolean isAnonymousByCommentId(String commentId) {
        NetworkStreamCommentModel comment = NetworkStreamCommentCache.getModel(commentId);
        if (comment != null) {
            if (comment.getIsAnonymity() == null) {
                return false;
            }
            return comment.getIsAnonymity().equals("1");
        }
        return false;
    }
}

