/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.cache.NetworkStreamComment_AtUserIndex;
import com.actionsoft.apps.network.cache.NetworkStreamComment_CreateUserIndex;
import com.actionsoft.apps.network.cache.NetworkStreamComment_StreamIndex;
import com.actionsoft.apps.network.cache.NetworkStreamComment_TransStreamIndex;
import com.actionsoft.apps.network.dao.NetworkStreamCommentDao;
import com.actionsoft.apps.network.model.NetworkStreamCommentModel;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class NetworkStreamCommentCache
extends Cache<String, NetworkStreamCommentModel> {
    public static final Comparator<NetworkStreamCommentModel> SORT_CREATETIME_AESC = new Comparator<NetworkStreamCommentModel>(){

        @Override
        public int compare(NetworkStreamCommentModel o1, NetworkStreamCommentModel o2) {
            return o1.getCreateTime().compareTo(o2.getCreateTime());
        }
    };
    public static final Comparator<NetworkStreamCommentModel> SORT_CREATETIME_DESC = new Comparator<NetworkStreamCommentModel>(){

        @Override
        public int compare(NetworkStreamCommentModel o1, NetworkStreamCommentModel o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    };

    public NetworkStreamCommentCache(CachePluginProfile profile) {
        super(profile);
        this.registeIndex(NetworkStreamComment_StreamIndex.class, (CacheIndex)new NetworkStreamComment_StreamIndex());
        this.registeIndex(NetworkStreamComment_TransStreamIndex.class, (CacheIndex)new NetworkStreamComment_TransStreamIndex());
        this.registeIndex(NetworkStreamComment_CreateUserIndex.class, (CacheIndex)new NetworkStreamComment_CreateUserIndex());
        this.registeIndex(NetworkStreamComment_AtUserIndex.class, (CacheIndex)new NetworkStreamComment_AtUserIndex());
    }

    public static void putModel(NetworkStreamCommentModel model) {
        NetworkStreamCommentModel old = NetworkStreamCommentCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkStreamCommentDao().insert(model) : new NetworkStreamCommentDao().update(model);
        if (result == 1) {
            NetworkStreamCommentCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkStreamCommentModel getModel(String id) {
        return (NetworkStreamCommentModel)((Object)NetworkStreamCommentCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkStreamCommentDao().delete(id);
        if (result == 1) {
            NetworkStreamCommentCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static Iterator<NetworkStreamCommentModel> getStreamComment(String streamId) {
        return NetworkStreamCommentCache.getCache().getByIndex(NetworkStreamComment_StreamIndex.class, (Serializable)((Object)streamId), SORT_CREATETIME_AESC);
    }

    public static List<NetworkStreamCommentModel> loadStreamComment(String streamId) {
        return Cache.iteratorToList(NetworkStreamCommentCache.getStreamComment(streamId));
    }

    public static List<NetworkStreamCommentModel> loadStreamComment(String streamId, String commentType) {
        List<NetworkStreamCommentModel> lists = NetworkStreamCommentCache.loadStreamComment(streamId);
        ArrayList<NetworkStreamCommentModel> commentList = new ArrayList<NetworkStreamCommentModel>();
        if (lists.size() > 0) {
            for (NetworkStreamCommentModel model : lists) {
                if (!model.getCommentType().equals(commentType)) continue;
                commentList.add(model);
            }
        }
        return commentList;
    }

    public static List<NetworkStreamCommentModel> loadStreamComment(String streamId, String userId, String commentType) {
        List<NetworkStreamCommentModel> lists = NetworkStreamCommentCache.loadStreamComment(streamId);
        ArrayList<NetworkStreamCommentModel> commentList = new ArrayList<NetworkStreamCommentModel>();
        if (lists.size() > 0) {
            for (NetworkStreamCommentModel model : lists) {
                if (!model.getCommentType().equals(commentType) || !model.getCreateUserId().equals(userId)) continue;
                commentList.add(model);
            }
        }
        return commentList;
    }

    public static Iterator<NetworkStreamCommentModel> getStreamCommentByTrans(String streamId) {
        return NetworkStreamCommentCache.getCache().getByIndex(NetworkStreamComment_TransStreamIndex.class, (Serializable)((Object)streamId), SORT_CREATETIME_AESC);
    }

    public static List<NetworkStreamCommentModel> loadStreamCommentByTrans(String streamId) {
        return Cache.iteratorToList(NetworkStreamCommentCache.getStreamCommentByTrans(streamId));
    }

    public static Iterator<NetworkStreamCommentModel> getStreamCommentByCreateUser(String userId) {
        return NetworkStreamCommentCache.getCache().getByIndex(NetworkStreamComment_CreateUserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME_AESC);
    }

    public static List<NetworkStreamCommentModel> loadStreamCommentByCreateUserDesc(String userId) {
        return Cache.iteratorToList((Iterator)NetworkStreamCommentCache.getCache().getByIndex(NetworkStreamComment_CreateUserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME_DESC));
    }

    public static List<NetworkStreamCommentModel> loadStreamCommentByCreateUser(String userId) {
        return Cache.iteratorToList(NetworkStreamCommentCache.getStreamCommentByCreateUser(userId));
    }

    public static Iterator<NetworkStreamCommentModel> getStreamCommentOfAtUser(String userId) {
        return NetworkStreamCommentCache.getCache().getByIndex(NetworkStreamComment_AtUserIndex.class, (Serializable)((Object)userId), SORT_CREATETIME_DESC);
    }

    public static List<NetworkStreamCommentModel> loadStreamCommentOfAtUser(String userId) {
        return Cache.iteratorToList(NetworkStreamCommentCache.getStreamCommentOfAtUser(userId));
    }

    public void load() {
        List<NetworkStreamCommentModel> list = new NetworkStreamCommentDao().loadNetworkStreamCommentOfCache();
        for (NetworkStreamCommentModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u4fe1\u606f\u6d41\u8bc4\u8bba [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkStreamCommentCache getCache() {
        return (NetworkStreamCommentCache)CacheManager.getCache(NetworkStreamCommentCache.class);
    }
}

