/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.aslp;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.resource.interop.aslp.ASLP;
import com.actionsoft.apps.resource.interop.aslp.Meta;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStreams
implements ASLP {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryStreams.class);

    @Meta(parameter={"name: 'networkId', required: true, desc: '\u5de5\u4f5c\u7f51\u7edcID'", "name: 'teamId', required: false, desc: '\u5c0f\u7ec4ID'", "name: 'streamId', required: false, desc: '\u6700\u65b0\u7684\u4fe1\u606f\u6d41ID'", "name: 'start', required: false, desc: '\u5f00\u59cb\u8bb0\u5f55\u6570'", "name: 'limit', required: false, desc: '\u6bcf\u6b21\u52a0\u8f7d\u8bb0\u5f55\u6570'"})
    public ResponseObject call(Map<String, Object> params) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            String sid = (String)params.get("sid");
            UserContext ctx = UserContext.fromSessionId((String)sid);
            String networkId = (String)params.get("networkId");
            String teamId = (String)params.get("teamId");
            String streamId = params.get("streamId") == null ? "" : params.get("streamId").toString();
            int start = params.get("start") == null ? 0 : (Integer)params.get("start");
            int limit = params.get("limit") == null ? -1 : (Integer)params.get("limit");
            List<Object> streamList = new ArrayList();
            streamList = UtilString.isEmpty((String)teamId) ? NetworkStreamCache.loadStreamOfNetwork(networkId, ctx.getUID()) : NetworkStreamCache.loadStreamOfTeam(teamId);
            ArrayList<NetworkStreamModel> newStreamList = new ArrayList<NetworkStreamModel>();
            if (!UtilString.isEmpty((String)streamId)) {
                NetworkStreamModel stream;
                if (NetworkStreamCache.getModel(streamId) == null) {
                    ro.errorCode("901");
                    ro.err("\u9996\u6761\u52a8\u6001\u88ab\u5220\u9664\uff0c\u5c06\u91cd\u65b0\u5237\u65b0\u52a8\u6001\u5217\u8868");
                    return ro;
                }
                Iterator<Object> iterator = streamList.iterator();
                while (iterator.hasNext() && !streamId.equals((stream = (NetworkStreamModel)((Object)iterator.next())).getId())) {
                    newStreamList.add(stream);
                }
                start += newStreamList.size();
            }
            if (limit > 0) {
                if (streamList.size() > start) {
                    Page<Object> page = new Page<Object>(start, limit, streamList);
                    streamList = page.getListModel();
                    ro.put("start", (Object)page.getStart());
                    ro.put("limit", (Object)page.getLimit());
                    ro.put("pageCount", (Object)page.getPageCount());
                } else {
                    streamList = new ArrayList();
                    ro.put("start", (Object)start);
                    ro.put("limit", (Object)0);
                    ro.put("pageCount", (Object)0);
                }
            } else {
                streamList = newStreamList;
            }
            JSONArray teams = NetworkDataUtil.stream2JSONOfOriginal(streamList, ctx);
            ro.put("streams", (Object)teams);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro = ResponseObject.newErrResponse();
            ro.err(e.getMessage());
        }
        return ro;
    }
}

