/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.favorite;

import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.cache.NetworkStreamCommentCache;
import com.actionsoft.apps.network.model.NetworkStreamCommentModel;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FavoriteViewWeb
extends ActionWeb {
    private static final Logger LOGGER = LoggerFactory.getLogger(FavoriteViewWeb.class);

    public FavoriteViewWeb() {
    }

    public FavoriteViewWeb(UserContext uc) {
        super(uc);
    }

    public String getHome(String title, String favoriteId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sid", this.getContext().getSessionId());
        result.put("userId", this.getContext().getUID());
        NetworkStreamCommentModel comment = NetworkStreamCommentCache.getModel(favoriteId);
        if (comment != null) {
            NetworkStreamModel stream = NetworkStreamCache.getModel(comment.getStreamId());
            if (stream != null) {
                result.put("dynamicStream", (String)NetworkDataUtil.stream2JSON(stream, this.getContext()));
            } else {
                result.put("dynamicStream", "false");
            }
        } else {
            result.put("dynamicStream", "false");
        }
        return HtmlPageTemplate.merge((String)"com.actionsoft.apps.network", (String)"network.favorite.view.html", result);
    }

    public String cancel(String title, String favoriteId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkStreamCommentCache.removeById(favoriteId);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }
}

