/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.util;

import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.i18n.I18nRes;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATE_DFT_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_DFT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIME_DFT_PATTERN2 = "yyyy-MM-dd-HH-mm-ss";

    public static String getCurrentDate() {
        return DateUtils.getCurrentDate(new Date(), DATE_DFT_PATTERN);
    }

    public static String getCurrentDate(String pattern) {
        return DateUtils.getCurrentDate(new Date(), pattern);
    }

    public static String getCurrentDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String getCurrentDateTime() {
        return DateUtils.format(new Date(), DATETIME_DFT_PATTERN);
    }

    public static String getCurrentDateTime2() {
        return DateUtils.format(new Date(), DATETIME_DFT_PATTERN2);
    }

    public static String getCurrentDateTime(String pattern) {
        return DateUtils.format(new Date(), pattern);
    }

    public static String format(long datetime) {
        Date date = new Date(datetime);
        return DateUtils.format(date);
    }

    public static String format(long datetime, String pattern) {
        Date date = new Date(datetime);
        return DateUtils.format(date, pattern);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DATE_DFT_PATTERN);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public static String format(String dateStr) {
        Date date = DateUtils.parse(dateStr, DATETIME_DFT_PATTERN);
        return DateUtils.format(date, DATETIME_DFT_PATTERN);
    }

    public static String format(String dateStr, String pattern) {
        Date date = DateUtils.parse(dateStr, DATETIME_DFT_PATTERN);
        return DateUtils.format(date, pattern);
    }

    public static String format(String dateStr, String orgPattern, String pattern) {
        Date date = DateUtils.parse(dateStr, orgPattern);
        return DateUtils.format(date, pattern);
    }

    public static Date parse(String dateStr) {
        return DateUtils.parse(dateStr, DATE_DFT_PATTERN);
    }

    public static Date parse2(String dateStr) {
        String[] tmpStr = dateStr.split("-");
        StringBuffer tmpStringBuffer = new StringBuffer();
        for (int i = 0; i < tmpStr.length; ++i) {
            if (i < 2) {
                tmpStringBuffer.append(tmpStr[i] + "-");
                continue;
            }
            if (i == 2) {
                tmpStringBuffer.append(tmpStr[i] + " ");
                continue;
            }
            tmpStringBuffer.append(tmpStr[i] + ":");
        }
        return DateUtils.parse(tmpStringBuffer.toString(), DATETIME_DFT_PATTERN);
    }

    public static Date parse(String dateStr, String pattern) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return date;
    }

    public static Date parse(Date date) {
        return DateUtils.parse(date, DATE_DFT_PATTERN);
    }

    public static Date parse(Date date, String pattern) {
        String dateStr = DateUtils.format(date, DATETIME_DFT_PATTERN);
        return DateUtils.parse(dateStr, pattern);
    }

    public static Date parse(long datetime) {
        return new Date(datetime);
    }

    public static Date parse(long datetime, String pattern) {
        Date date = new Date(datetime);
        return DateUtils.parse(date, pattern);
    }

    public static String parseStr(String dateStr, String pattern) {
        Date date = DateUtils.parse(dateStr);
        return DateUtils.format(date, pattern);
    }

    public static Date getFirstOfMonth() {
        return DateUtils.getFirstOfMonth(new Date());
    }

    public static Date getFirstOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstOfMonth(long datetime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(datetime);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static String getFirstOfMonthStr(Date date) {
        return DateUtils.format(DateUtils.getFirstOfMonth(date));
    }

    public static String getFirstOfMonthStr(Date date, String pattern) {
        return DateUtils.format(DateUtils.getFirstOfMonth(date), pattern);
    }

    public static Date getLastOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getLastOfMonth(long datetime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(datetime);
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date addDate(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        return cal.getTime();
    }

    public static String getFriendlytime(Date d) {
        long delta = (new Date().getTime() - d.getTime()) / 1000L;
        if (delta <= 0L) {
            return DateUtils.format(d, DATE_DFT_PATTERN);
        }
        if (delta / 31536000L > 0L) {
            return delta / 31536000L + "\u5e74\u524d";
        }
        if (delta / 5184000L > 0L) {
            return delta / 2592000L + "\u4e2a\u6708\u524d";
        }
        if (delta / 86400L > 0L) {
            return delta / 86400L + "\u5929\u524d";
        }
        if (delta / 3600L > 0L) {
            return delta / 3600L + "\u5c0f\u65f6\u524d";
        }
        if (delta / 60L > 0L) {
            return delta / 60L + "\u5206\u949f\u524d";
        }
        return "\u521a\u521a";
    }

    public static String getAliasDate(Timestamp timestamp) {
        long difOfDay;
        long compare = timestamp.getTime();
        long now = System.currentTimeMillis();
        Timestamp timestampNow = new Timestamp(now);
        double difOfHour = (double)(compare - now) / 3600000.0;
        int compareDay = DateUtils.getDay(timestamp);
        int currentDay = DateUtils.getDay(timestampNow);
        int compareYear = DateUtils.getYear(timestamp);
        int currentYear = DateUtils.getYear(timestampNow);
        int compareMonth = DateUtils.getMonth(timestamp);
        int currentMonth = DateUtils.getMonth(timestampNow);
        Date compareDate = new Date(timestamp.getTime());
        String appId = "_platform.runtime";
        String lang = "cn";
        try {
            lang = DispatcherRequest.getUserContext().getLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compareYear == currentYear && compareMonth == currentMonth && compareDay == currentDay && Math.abs(difOfHour) > 1.0) {
            return DateUtils.timeFormat(timestamp, "HH:mm");
        }
        Object result = "";
        result = compareYear == currentYear ? (compareMonth == currentMonth && compareDay == currentDay ? DateUtils.timeFormat(timestamp, "HH:mm") : ((difOfDay = (long)(compareDay - currentDay)) == -1L ? I18nRes.findValue((String)appId, (String)"\u6628\u5929") + DateUtils.timeFormat(timestamp, "HH:mm") : (difOfDay == -2L ? I18nRes.findValue((String)appId, (String)"\u524d\u5929") + DateUtils.timeFormat(timestamp, "HH:mm") : (difOfDay == 1L ? I18nRes.findValue((String)appId, (String)"\u660e\u5929") + DateUtils.timeFormat(timestamp, "HH:mm") : (lang.equals("en") ? DateUtils.datetimeFormat(compareDate, "MMM,d", Locale.US) + DateUtils.timeFormat(timestamp, "HH:mm") : DateUtils.datetimeFormat(compareDate, "M\u6708d\u65e5") + DateUtils.timeFormat(timestamp, "HH:mm")))))) : DateUtils.format(timestamp, "yyyy\u5e74M\u6708d\u65e5 HH:mm");
        return result;
    }

    public static int getYear(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(1);
    }

    public static int getHour(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(11);
    }

    public static int getMonth(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar gregorianCalendar = GregorianCalendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(5);
    }

    public static String datetimeFormat(Date date, String format, Locale locale) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat(format, locale);
        return datetimeFormat.format(date);
    }

    public static String datetimeFormat(Date date, String format) {
        return DateUtils.datetimeFormat(date, format, Locale.CHINA);
    }

    public static String timeFormat(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat datetimeFormat = new SimpleDateFormat(format);
        return datetimeFormat.format(date);
    }

    public static void main(String[] args) {
    }
}

