/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dc;

import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.model.impl.UserModelImpl;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.AbstFileProcessor;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.FileProcessorListener;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.DCStoreUtil;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.i18n.I18nRes;
import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PictureProcessor
extends AbstFileProcessor
implements FileProcessorListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PictureProcessor.class);
    private static final String[] images = new String[]{"png", "jpg", "jpeg", "gif"};
    private static final String tempSuffix = "_big";

    public static boolean isPhotoFile(String fn) {
        if (fn.indexOf(".") == -1) {
            return false;
        }
        fn = fn.toLowerCase();
        for (String image : images) {
            if (!fn.endsWith("." + (image = image.toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    public static String getPhotoFileSuffix(String fn) {
        String suffix = fn.substring(fn.lastIndexOf("."));
        return suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadReady(Map<String, Object> param) {
        File folder;
        DCContext context = (DCContext)param.get("DCContext");
        DCContext dc = null;
        String uuid = UUIDGener.getUUID();
        if ("-".equals(context.getFileValue())) {
            dc = new DCContext(context.getSession(), context.getDCProfile(), context.getAppId(), context.getGroupValue(), uuid, context.getFileName());
        }
        String fileName = context.getFileName();
        context.setFileNameShow(fileName);
        if (!PictureProcessor.isPhotoFile(fileName)) {
            context.setDCMessage("error", I18nRes.findValue((String)"_platform.runtime", (String)"\u4e0d\u652f\u6301\u7684\u5934\u50cf\u56fe\u7247\u7c7b\u578b"));
            return false;
        }
        String filePrefix = "logo";
        context.setFileName(filePrefix + tempSuffix + PictureProcessor.getPhotoFileSuffix(fileName));
        InputStream data = (InputStream)param.get("data");
        DataOutputStream os = null;
        File tempImage = new File(context.getPath() + context.getFileName());
        String url = context.getStremURL();
        if (dc != null) {
            folder = new File(dc.getPath());
            if (!folder.exists()) {
                folder.mkdirs();
            }
            dc.setFileName(filePrefix + tempSuffix + PictureProcessor.getPhotoFileSuffix(fileName));
            tempImage = new File(dc.getPath() + dc.getFileName());
            url = dc.getStremURL();
        } else {
            folder = new File(context.getPath());
            if (!folder.exists()) {
                folder.mkdirs();
            }
        }
        try {
            os = new DataOutputStream(new FileOutputStream(tempImage));
            UtilIO.copy((InputStream)data, (OutputStream)os);
            os.close();
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            context.setDCMessage("error", e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
        int width = 0;
        int height = 0;
        try {
            BufferedImage bi = ImageIO.read(tempImage);
            if (bi == null) {
                context.setDCMessage("error", I18nRes.findValue((String)"_platform.runtime", (String)"\u8bfb\u53d6\u56fe\u50cf\u51fa\u9519!"));
                return false;
            }
            width = bi.getWidth();
            height = bi.getHeight();
            if (width < 120 || height < 120) {
                tempImage.delete();
                context.setDCMessage("error", I18nRes.findValue((String)"_platform.runtime", (String)"\u5934\u50cf\u56fe\u7247\u5bbd\u548c\u9ad8\u4e0d\u80fd\u5c0f\u4e8e120\u50cf\u7d20"));
                return false;
            }
            Metadata metadata = ImageMetadataReader.readMetadata((File)tempImage);
            Directory exif = null;
            for (Directory directory : metadata.getDirectoriesOfType(ExifIFD0Directory.class)) {
                if (!directory.containsTag(274)) continue;
                exif = directory;
            }
            if (exif != null) {
                int degree = 0;
                int orientation = 0;
                try {
                    orientation = exif.getInt(274);
                }
                catch (MetadataException e) {
                    LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                }
                switch (orientation) {
                    case 1: {
                        degree = 0;
                        break;
                    }
                    case 2: {
                        degree = 0;
                        break;
                    }
                    case 3: {
                        degree = 180;
                        break;
                    }
                    case 4: {
                        degree = 0;
                        break;
                    }
                    case 5: {
                        degree = 270;
                        break;
                    }
                    case 6: {
                        degree = 90;
                        break;
                    }
                    case 7: {
                        degree = 90;
                        break;
                    }
                    case 8: {
                        degree = 270;
                        break;
                    }
                    default: {
                        degree = 0;
                    }
                }
                if (degree != 0) {
                    int type = bi.getColorModel().getTransparency();
                    if (degree == 180) {
                        BufferedImage img = new BufferedImage(width, height, type);
                        Graphics2D graphics2d = img.createGraphics();
                        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                        graphics2d.drawImage((Image)bi, 0, 0, null);
                        graphics2d.dispose();
                        ImageIO.write((RenderedImage)img, "JPG", tempImage);
                        img.flush();
                    } else if (degree == 90 || degree == 270) {
                        width = bi.getHeight();
                        height = bi.getWidth();
                        BufferedImage img = new BufferedImage(width, height, type);
                        Graphics2D graphics2d = img.createGraphics();
                        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
                        int x = 0;
                        int y = 0;
                        if (width > height) {
                            x = -(height - width) / 2;
                            y = (height - width) / 2;
                        } else {
                            y = -(width - height) / 2;
                            x = (width - height) / 2;
                        }
                        graphics2d.drawImage((Image)bi, x, y, null);
                        graphics2d.dispose();
                        ImageIO.write((RenderedImage)img, "JPG", tempImage);
                        img.flush();
                    }
                }
            }
            bi.flush();
        }
        catch (IOException e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            context.setDCMessage("error", I18nRes.findValue((String)"_platform.runtime", (String)"\u56fe\u7247\u5904\u7406\u51fa\u9519") + "\uff1a" + e.getMessage());
            return false;
        }
        catch (JpegProcessingException e1) {
            e1.printStackTrace();
        }
        catch (ImageProcessingException e1) {
            e1.printStackTrace();
            context.setDCMessage("error", I18nRes.findValue((String)"_platform.runtime", (String)"\u56fe\u7247\u5904\u7406\u51fa\u9519") + "\uff1a" + e1.getMessage());
            return false;
        }
        context.setDCMessage("ok", "");
        context.getDCMessage().addAttr("fileName", (Object)context.getFileName());
        context.getDCMessage().addAttr("uuid", (Object)uuid);
        context.getDCMessage().addAttr("url", (Object)url);
        context.getDCMessage().addAttr("width", (Object)width);
        context.getDCMessage().addAttr("height", (Object)height);
        param.put("DCContext", context);
        return true;
    }

    public void uploadSuccess(Map<String, Object> param) {
        block1: {
            String[] stringArray;
            int n;
            int n2;
            DCContext context = (DCContext)param.get("DCContext");
            UserModel user = UserCache.getModel((String)context.getGroupValue());
            if (user == null) {
                return;
            }
            File dir = new File(context.getPath());
            if (dir == null || !dir.exists() || (n2 = 0) >= (n = (stringArray = dir.list()).length)) break block1;
            String fileName = stringArray[n2];
            File photoFile = new File(dir.getPath() + "/" + fileName);
            ((UserModelImpl)user).setPhotoLastModified(photoFile.lastModified());
        }
    }

    public InputStream downloadContent(Map<String, Object> param) throws Exception {
        DCContext context = (DCContext)param.get("DCContext");
        return DCStoreUtil.read((DCContext)context);
    }

    public void downloadComplete(Map<String, Object> param) {
        super.downloadComplete(param);
    }

    public static String getPictureUrl(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        DCContext dc = PictureProcessor.getDCContext(me, appId, groupValue, fileValue, repositoryName, fileName);
        if (dc == null) {
            return "../commons/img/photo.png";
        }
        return dc.getDownloadURL();
    }

    public static String getTmpPictureUrl(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        DCContext dc = PictureProcessor.getDCContext(me, appId, groupValue, fileValue, repositoryName, fileName);
        if (dc == null) {
            return "";
        }
        return dc.getDownloadURL();
    }

    public static DCContext getDCContext(UserContext me, String appId, String repositoryName, String groupValue, String fileValue, String fileName) {
        DCContext dc = new DCContext(me, DCProfileManager.getDCProfile((String)appId, (String)repositoryName), appId, groupValue, fileValue, fileName);
        if (!dc.existFile()) {
            return null;
        }
        return dc;
    }

    public static DCContext getDCContext(UserContext me, String appId, String repositoryName, String groupValue, String fileValue) {
        DCContext dc = new DCContext(me, DCProfileManager.getDCProfile((String)appId, (String)repositoryName), appId, groupValue, fileValue);
        File dir = new File(dc.getPath());
        if (dir == null || !dir.exists()) {
            return null;
        }
        return dc;
    }

    public static DCContext getTmpDCContext(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        DCContext dc = new DCContext(me, DCProfileManager.getDCProfile((String)appId, (String)repositoryName), appId, groupValue, fileValue, fileName);
        File dir = new File(dc.getPath());
        if (dir == null || !dir.exists()) {
            return null;
        }
        return dc;
    }

    public static DCContext getDCContextOutFile(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return null;
        }
        return new DCContext(me, DCProfileManager.getDCProfile((String)appId, (String)repositoryName), appId, groupValue, fileValue, fileName);
    }

    public static DCContext getTmpDCContextOutFile(UserContext me, String appId, String groupValue, String fileValue, String repositoryName, String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return null;
        }
        return new DCContext(me, DCProfileManager.getDCProfile((String)appId, (String)repositoryName), appId, groupValue, fileValue, fileName);
    }
}

