/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.dao.NetworkAppToolBarDao;
import com.actionsoft.apps.network.model.NetworkAppToolBarModel;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class NetworkAppToolBarCache
extends Cache<String, NetworkAppToolBarModel> {
    public NetworkAppToolBarCache(CachePluginProfile profile) {
        super(profile);
    }

    public static void putModel(NetworkAppToolBarModel model) {
        NetworkAppToolBarModel old = NetworkAppToolBarCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkAppToolBarDao().insert(model) : new NetworkAppToolBarDao().update(model);
        if (result == 1) {
            NetworkAppToolBarCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkAppToolBarModel getModel(String id) {
        return (NetworkAppToolBarModel)((Object)NetworkAppToolBarCache.getCache().get((Serializable)((Object)id)));
    }

    public static NetworkAppToolBarModel getModel(String teamId, String appId) {
        List<NetworkAppToolBarModel> lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar();
        if (lists.size() > 0) {
            for (NetworkAppToolBarModel model : lists) {
                if (!model.getTeamId().equals(teamId) || !model.getAppId().trim().equals(appId.trim())) continue;
                return model;
            }
        }
        return null;
    }

    public static void removeById(String id) {
        int result = new NetworkAppToolBarDao().delete(id);
        if (result == 1) {
            NetworkAppToolBarCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static List<NetworkAppToolBarModel> loadAllNetworkAppToolBar() {
        Iterator iter = NetworkAppToolBarCache.getCache().iterator();
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkAppToolBarModel> loadAllNetworkAppToolBar(String teamId, String userId) {
        ArrayList<NetworkAppToolBarModel> toolBarList = new ArrayList<NetworkAppToolBarModel>();
        List<NetworkAppToolBarModel> lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar();
        if (lists.size() > 0) {
            for (NetworkAppToolBarModel model : lists) {
                if (!model.getTeamId().equals(teamId) || !model.getCreateUserId().equals(userId)) continue;
                toolBarList.add(model);
            }
        }
        return toolBarList;
    }

    public static List<NetworkAppToolBarModel> loadAllNetworkAppToolBar(String teamId, String userId, String type) {
        ArrayList<NetworkAppToolBarModel> toolBarList = new ArrayList<NetworkAppToolBarModel>();
        List<NetworkAppToolBarModel> lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar();
        if (lists.size() > 0) {
            for (NetworkAppToolBarModel model : lists) {
                if (!model.getTeamId().equals(teamId) || !model.getIsShow().equals(type)) continue;
                toolBarList.add(model);
            }
        }
        return toolBarList;
    }

    public static List<NetworkAppToolBarModel> loadAllNetworkAppToolBarBy(String teamId) {
        ArrayList<NetworkAppToolBarModel> toolBarList = new ArrayList<NetworkAppToolBarModel>();
        List<NetworkAppToolBarModel> lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar();
        if (lists.size() > 0) {
            for (NetworkAppToolBarModel model : lists) {
                if (!model.getTeamId().equals(teamId)) continue;
                toolBarList.add(model);
            }
        }
        return toolBarList;
    }

    public static List<NetworkAppToolBarModel> loadAllNetworkAppToolBar(String appId) {
        ArrayList<NetworkAppToolBarModel> toolBarList = new ArrayList<NetworkAppToolBarModel>();
        List<NetworkAppToolBarModel> lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar();
        if (lists.size() > 0) {
            for (NetworkAppToolBarModel model : lists) {
                if (!model.getAppId().trim().equals(appId.trim())) continue;
                toolBarList.add(model);
            }
        }
        return toolBarList;
    }

    public void load() {
        List<NetworkAppToolBarModel> list = new NetworkAppToolBarDao().loadNetworkAppToolBarOfCache();
        for (NetworkAppToolBarModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u5c0f\u7ec4\u5e94\u7528\u5de5\u5177\u680f [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkAppToolBarCache getCache() {
        return (NetworkAppToolBarCache)CacheManager.getCache(NetworkAppToolBarCache.class);
    }
}

