/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.web;

import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.network.cache.NetworkAppAccessCache;
import com.actionsoft.apps.network.cache.NetworkAppListCache;
import com.actionsoft.apps.network.cache.NetworkAppToolBarCache;
import com.actionsoft.apps.network.cache.NetworkCache;
import com.actionsoft.apps.network.cache.NetworkStreamCache;
import com.actionsoft.apps.network.cache.NetworkStreamCommentCache;
import com.actionsoft.apps.network.cache.NetworkTeamCache;
import com.actionsoft.apps.network.cache.NetworkTeamMemberCache;
import com.actionsoft.apps.network.cache.NetworkTopicCache;
import com.actionsoft.apps.network.dao.NetworkAppAccessDao;
import com.actionsoft.apps.network.dao.NetworkTeamDao;
import com.actionsoft.apps.network.dc.PictureProcessor;
import com.actionsoft.apps.network.extend.TeamAppManager;
import com.actionsoft.apps.network.extend.TeamAppProfile;
import com.actionsoft.apps.network.favorite.FavoriteTool;
import com.actionsoft.apps.network.helper.AttachementFile;
import com.actionsoft.apps.network.helper.StreamContent;
import com.actionsoft.apps.network.helper.StreamContentHelper;
import com.actionsoft.apps.network.helper.StreamContentNotice;
import com.actionsoft.apps.network.helper.StreamContentPraise;
import com.actionsoft.apps.network.model.NetworkAppAccessModel;
import com.actionsoft.apps.network.model.NetworkAppListModel;
import com.actionsoft.apps.network.model.NetworkAppToolBarModel;
import com.actionsoft.apps.network.model.NetworkModel;
import com.actionsoft.apps.network.model.NetworkStreamCommentModel;
import com.actionsoft.apps.network.model.NetworkStreamModel;
import com.actionsoft.apps.network.model.NetworkTeamMemberDto;
import com.actionsoft.apps.network.model.NetworkTeamMemberModel;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.network.model.NetworkTopicModel;
import com.actionsoft.apps.network.mydriver.MydriverTool;
import com.actionsoft.apps.network.notification.NetworkNotification;
import com.actionsoft.apps.network.taskutil.TaskmgtTool;
import com.actionsoft.apps.network.util.HttpUtil;
import com.actionsoft.apps.network.util.NetworkDataUtil;
import com.actionsoft.apps.network.util.Page;
import com.actionsoft.apps.network.util.PatternUtil;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ActionWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.org.cache.DepartmentCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.DepartmentModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.server.fs.dc.DCUtil;
import com.actionsoft.bpms.util.ClassReflect;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilDoc;
import com.actionsoft.bpms.util.UtilIO;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilListSort;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import com.actionsoft.sdk.local.api.ORGAPI;
import com.actionsoft.sdk.local.api.PortalAPI;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkWeb
extends ActionWeb {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkWeb.class);

    public NetworkWeb() {
    }

    public NetworkWeb(UserContext uc) {
        super(uc);
    }

    public String getHome(String streamId, String streamCommentId, String loc_teamId) throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("sid", this.getContext().getSessionId());
        result.put("viewStreamId", streamId == null ? "" : streamId);
        result.put("viewStreamCommentId", streamCommentId);
        loc_teamId = loc_teamId == null ? "" : loc_teamId;
        result.put("loc_teamId", loc_teamId);
        NetworkTeamDao networkTeamDao = new NetworkTeamDao();
        NetworkTeamModel networkTeamModel = networkTeamDao.getNoteworkTeamById(loc_teamId);
        String loc_netWorkId = "";
        if (networkTeamModel != null && networkTeamModel.getNetworkId() != null) {
            loc_netWorkId = networkTeamModel.getNetworkId();
        }
        result.put("loc_netWorkId", loc_netWorkId);
        result.put("userName", I18nRes.findValue((String)"com.actionsoft.apps.network", (String)this.getContext().getUserName()));
        result.put("uid", this.getContext().getUID());
        result.put("departmentName", I18nRes.findValue((String)"com.actionsoft.apps.network", (String)this.getContext().getDepartmentModel().getName()));
        PortalAPI portalApi = SDK.getPortalAPI();
        result.put("userPhoto", portalApi.getUserPhoto(this.getContext(), this.getContext().getUID()));
        result.put("sysAppId", "_platform.infra");
        result.put("appId", "com.actionsoft.apps.network");
        result.put("resourceTypeId", "NETWORK.STREAM");
        AppsAPIManager appsApiManager = AppsAPIManager.getInstance();
        result.put("icon16", appsApiManager.getIcon16URL("com.actionsoft.apps.network", this.getContext()));
        result.put("icon96", appsApiManager.getIcon96URL("com.actionsoft.apps.network", this.getContext()));
        AppAPI appApi = SDK.getAppAPI();
        String appIsShowNum = appApi.getProperty("com.actionsoft.apps.network", "isShowNum");
        int isShowNum = 3;
        try {
            isShowNum = Integer.parseInt(appIsShowNum);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        result.put("isShowNum", isShowNum);
        Date date = new Date();
        result.put("yearMonth", UtilDate.yearFormat((Date)date) + UtilDate.monthFormat((Date)date));
        String titleBgColor = appApi.getProperty("com.actionsoft.apps.network", "titleBgColor");
        result.put("titleBgColor", titleBgColor);
        String isShowCreateBtn = appApi.getProperty("com.actionsoft.apps.network", "isShowCreateBtn");
        result.put("isShowCreateBtn", isShowCreateBtn);
        String showTeamApp = appApi.getProperty("com.actionsoft.apps.network", "showTeamApp");
        result.put("showTeamApp", showTeamApp);
        com.alibaba.fastjson.JSONArray badgeList = new com.alibaba.fastjson.JSONArray();
        String[] praiseBadges = "to-force:\u7ed9\u529b,gift:\u793c\u7269,good-news:\u559c\u62a5,trophy: \u5956\u676f,team: \u56e2\u961f,love:\u6709\u7231,cake: \u86cb\u7cd5,coffee:\u5496\u5561".split(",");
        int len = praiseBadges.length;
        try {
            for (int i = 0; i < len; ++i) {
                com.alibaba.fastjson.JSONObject badge = new com.alibaba.fastjson.JSONObject();
                String[] praiseBadge = praiseBadges[i].split(":");
                badge.put("name", (Object)praiseBadge[0]);
                badge.put("label", (Object)praiseBadge[1]);
                String definition = I18nRes.findValue((String)"com.actionsoft.apps.network", (String)appApi.getProperty("com.actionsoft.apps.network", praiseBadge[0]));
                badge.put("definition", (Object)(UtilString.isEmpty((String)definition) ? I18nRes.findValue((String)"com.actionsoft.apps.network", (String)praiseBadge[1]) : definition));
                badgeList.add((Object)badge);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        result.put("badgeList", badgeList);
        AppContext favoriteApp = appApi.getAppContext("com.actionsoft.apps.favorite");
        boolean favoriteActive = false;
        if (favoriteApp != null && appApi.isActive(favoriteApp.getId())) {
            favoriteActive = true;
        }
        result.put("isFavoriteActive", favoriteActive);
        String storeMyDriver = appApi.getProperty("com.actionsoft.apps.network", "storeMyDriver");
        boolean existMydriverApp = false;
        if (!UtilString.isEmpty((String)storeMyDriver)) {
            try {
                existMydriverApp = Boolean.parseBoolean(storeMyDriver);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        if (existMydriverApp) {
            AppContext mydriverApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.mydriver");
            existMydriverApp = mydriverApp != null && appApi.isActive(mydriverApp.getId());
        }
        result.put("existMydriverApp", existMydriverApp);
        String usingVote = appApi.getProperty("com.actionsoft.apps.network", "usingVote");
        boolean isVoteActive = false;
        if (!UtilString.isEmpty((String)usingVote)) {
            try {
                isVoteActive = Boolean.parseBoolean(usingVote);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        if (isVoteActive) {
            AppContext voteApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.vote");
            isVoteActive = voteApp != null && appApi.isActive(voteApp.getId());
        }
        result.put("isVoteActive", isVoteActive);
        String isOpenAdmin = appApi.getProperty("com.actionsoft.apps.network", "isOpenAdmin");
        String isOpenLeader = appApi.getProperty("com.actionsoft.apps.network", "isOpenLeader");
        result.put("isOpenAdmin", isOpenAdmin);
        result.put("isOpenLeader", isOpenLeader);
        String isShowSource = appApi.getProperty("com.actionsoft.apps.network", "isShowSource");
        result.put("isShowSource", isShowSource);
        String isAllowJoinTeam = appApi.getProperty("com.actionsoft.apps.network", "isAllowJoinTeam");
        result.put("isAllowJoinTeam", isAllowJoinTeam);
        String isShowNetworkList = appApi.getProperty("com.actionsoft.apps.network", "isShowNetworkList");
        result.put("isShowNetworkList", isShowNetworkList);
        String showCommentNum = appApi.getProperty("com.actionsoft.apps.network", "showCommentNum");
        result.put("showCommentNum", showCommentNum);
        String isShowMyFavorites = appApi.getProperty("com.actionsoft.apps.network", "isShowMyFavorites");
        result.put("isShowMyFavorites", isShowMyFavorites);
        result.put("currentLanguage", this.getContext().getLanguage());
        result.put("supportType", NetworkDataUtil.getSupportType(this.getContext()));
        return HtmlPageTemplate.merge((String)"com.actionsoft.apps.network", (String)"network.home.html", result);
    }

    public ResponseObject searchAllNetworkAndTeamData(String networkId, String teamId, String searchValue, int start, int limit, String type, boolean aslp) {
        ResponseObject result = ResponseObject.newOkResponse();
        List<NetworkTeamModel> networkTeamList = new ArrayList<NetworkTeamModel>();
        ArrayList<String> networkTeamNameList = new ArrayList<String>();
        List<NetworkStreamModel> networkStreamList = new ArrayList<NetworkStreamModel>();
        UtilListSort sortTeamList = new UtilListSort();
        try {
            List<String> networkList = NetworkCache.loadNetworkByUserId(this.getContext().getUID());
            if (searchValue == null) {
                searchValue = "";
            }
            searchValue = searchValue.toLowerCase();
            searchValue = DBSql.convertLike((String)searchValue);
            List<NetworkTeamModel> teamList = NetworkTeamCache.loadAllNetworkTeam();
            sortTeamList.sort(teamList, "lastActive", "asc");
            if (teamList.size() > 0) {
                for (NetworkTeamModel team : teamList) {
                    if (team == null) continue;
                    List<String> memberUserList = NetworkTeamMemberCache.loadNetworkTeamMemberBy(team.getId(), "1");
                    if (!team.getTeamStatus().equals("1") || team.getTeamName().toLowerCase().indexOf(searchValue.toLowerCase()) <= -1 || networkTeamNameList.contains(team.getTeamName()) || !networkList.contains(team.getNetworkId())) continue;
                    if (team.getTeamType().equals("3")) {
                        if (!team.getCreateUserId().equals(this.getContext().getUID()) && !memberUserList.contains(this.getContext().getUID())) continue;
                        networkTeamList.add(team);
                        networkTeamNameList.add(team.getTeamName());
                        continue;
                    }
                    networkTeamList.add(team);
                    networkTeamNameList.add(team.getTeamName());
                }
            }
            int networkTeamCount = networkTeamList.size();
            result.put("networkTeamCount", (Object)networkTeamCount);
            List<Object> streamList = new ArrayList();
            streamList = NetworkStreamCache.loadStreamOfNetwork();
            if (streamList.size() > 0) {
                for (NetworkStreamModel networkStreamModel : streamList) {
                    if (networkStreamModel == null) continue;
                    StreamContent streamContent = StreamContentHelper.format(networkStreamModel.getStreamContent(), Integer.parseInt(networkStreamModel.getStreamType()), this.getContext());
                    if (!UtilString.isEmpty((String)networkStreamModel.getTeamId())) {
                        NetworkTeamModel team = NetworkTeamCache.getModel(networkStreamModel.getTeamId());
                        if (team == null) continue;
                        List<String> memberUserList = NetworkTeamMemberCache.loadNetworkTeamMemberBy(team.getId(), "1");
                        if (!streamContent.getContent().toLowerCase().contains(searchValue) || UtilString.isEmpty((String)searchValue) || !networkList.contains(team.getNetworkId()) || !memberUserList.contains(this.getContext().getUID())) continue;
                        networkStreamList.add(networkStreamModel);
                        continue;
                    }
                    if (!streamContent.getContent().toLowerCase().contains(searchValue) || UtilString.isEmpty((String)searchValue) || !networkList.contains(networkStreamModel.getNetworkId())) continue;
                    networkStreamList.add(networkStreamModel);
                }
            }
            int networkStreamCount = networkStreamList.size();
            result.put("networkStreamCount", (Object)networkStreamCount);
            if (!UtilString.isEmpty((String)searchValue) && type.equals("team")) {
                if (limit != -1) {
                    networkTeamList = networkTeamList.subList(start, start + limit > networkTeamCount ? networkTeamCount : start + limit);
                }
                result.put("networkTeamList", (Object)NetworkDataUtil.team2JSON(networkTeamList, this.getContext(), true));
            } else if (type.equals("stream")) {
                if (limit != -1) {
                    networkStreamList = networkStreamList.subList(start, start + limit > networkStreamCount ? networkStreamCount : start + limit);
                }
                result.put("networkStreamList", (Object)(aslp ? NetworkDataUtil.stream2JSONOfOriginal(networkStreamList, this.getContext()) : NetworkDataUtil.stream2JSON(networkStreamList, this.getContext())));
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result;
    }

    public String loadAllNetworkAndTeamData() {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkModel> networkList = NetworkCache.loadNetworkBy(this.getContext().getUID());
            UtilListSort sortList = new UtilListSort();
            sortList.sort(networkList, "networkName", "asc");
            result.put("networkList", (Object)NetworkDataUtil.network2JSON(networkList, this.getContext()));
            com.alibaba.fastjson.JSONObject teamList = new com.alibaba.fastjson.JSONObject();
            if (networkList.size() > 0) {
                for (NetworkModel network : networkList) {
                    UtilListSort sortTeamList = new UtilListSort();
                    List<NetworkTeamModel> lists = NetworkTeamCache.loadNetworkTeamBy(network.getId(), "1");
                    ArrayList<NetworkTeamModel> networkTeamList = new ArrayList<NetworkTeamModel>();
                    if (lists.size() > 0) {
                        for (NetworkTeamModel team : lists) {
                            List<String> userList;
                            if (team == null || !(userList = this.loadAllNetworkTeamMemberList(team.getId())).contains(this.getContext().getUID())) continue;
                            networkTeamList.add(team);
                        }
                    }
                    sortTeamList.sort(networkTeamList, "lastActive", "asc");
                    teamList.put(network.getId(), (Object)NetworkDataUtil.team2JSON(networkTeamList, this.getContext()));
                }
            }
            result.put("networkGroupList", (Object)teamList);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String loadAllNetworkTeamMembermanager(String teamId) {
        StringBuffer content = new StringBuffer();
        try {
            List<NetworkTeamMemberModel> networkTeamMemberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId, "1");
            if (networkTeamMemberList.size() > 0) {
                for (int i = 0; i < networkTeamMemberList.size(); ++i) {
                    NetworkTeamMemberModel model = networkTeamMemberList.get(i);
                    if (model == null || !model.getTeamId().equals(teamId) || !model.getMemberType().equals("1")) continue;
                    if (i < networkTeamMemberList.size()) {
                        content.append(model.getUserId() + " ");
                        continue;
                    }
                    content.append(model.getUserId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return content.toString();
    }

    public String loadAllNetworkTeamMember(String teamId, String searchValue) {
        ResponseObject result = ResponseObject.newOkResponse();
        PortalAPI portalApi = SDK.getPortalAPI();
        try {
            if (searchValue == null) {
                searchValue = "";
            }
            searchValue = DBSql.convertLike((String)searchValue);
            ArrayList<NetworkTeamMemberDto> list = new ArrayList<NetworkTeamMemberDto>();
            List<NetworkTeamMemberModel> networkTeamMemberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId, "1");
            if (networkTeamMemberList.size() > 0) {
                for (NetworkTeamMemberModel model : networkTeamMemberList) {
                    UserModel userModel = SDK.getORGAPI().getUser(model.getUserId());
                    if (userModel == null || userModel.isClosed()) continue;
                    DepartmentModel dept = SDK.getORGAPI().getDepartmentById(userModel.getDepartmentId());
                    if (!model.getTeamId().equals(teamId) || userModel.getUID().toLowerCase().indexOf(searchValue.toLowerCase()) <= -1 && userModel.getUserName().toLowerCase().indexOf(searchValue.toLowerCase()) <= -1 && userModel.getEmail().toLowerCase().indexOf(searchValue.toLowerCase()) <= -1 && dept.getName().toLowerCase().indexOf(searchValue.toLowerCase()) <= -1) continue;
                    NetworkTeamMemberDto dto = new NetworkTeamMemberDto();
                    dto.setId(model.getId());
                    dto.setTeamId(model.getTeamId());
                    dto.setUserId(model.getUserId());
                    dto.setMemberType(model.getMemberType());
                    dto.setMemberStatus(model.getMemberStatus());
                    dto.setJoinType(model.getJoinType());
                    dto.setJoinStatus(model.getJoinStatus());
                    dto.setCreateUserId(model.getCreateUserId());
                    dto.setCreateUserName(model.getCreateUserName());
                    dto.setCreateTime(model.getCreateTime());
                    dto.setLastActive(model.getLastActive());
                    dto.setUserName(userModel.getUserName());
                    dto.setUserPhoto(portalApi.getUserPhoto(this.getContext(), dto.getUserId()));
                    dto.setDepartmentId(userModel.getDepartmentId());
                    dto.setDepartmentName(NetworkDataUtil.getTwoLevelDeptName(dept.getPathNameOfCache()));
                    dto.setEmail(userModel.getEmail());
                    list.add(dto);
                }
            }
            UtilListSort sortUtil = new UtilListSort();
            sortUtil.sort(list, "userName", "asc");
            sortUtil.sort(list, "memberType", "asc");
            result.put("networkTeamMemberList", (Object)NetworkDataUtil.teamMemberDto2JSON(list, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public List<String> loadAllNetworkTeamMemberList(String teamId) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<NetworkTeamMemberModel> networkTeamMemberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId, "1");
            if (networkTeamMemberList.size() > 0) {
                for (NetworkTeamMemberModel model : networkTeamMemberList) {
                    UserModel userModel;
                    if (model.getUserId() == null || (userModel = UserCache.getModel((String)model.getUserId())) == null || !model.getTeamId().equals(teamId)) continue;
                    list.add(model.getUserId());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public ResponseObject saveTeamMember(NetworkTeamMemberModel model) {
        return this.saveTeamMember(model, null);
    }

    public ResponseObject saveTeamMember(NetworkTeamMemberModel model, String deviceType) {
        ResponseObject result = ResponseObject.newOkResponse();
        StringBuffer errMsg = new StringBuffer();
        try {
            String[] userIds;
            if (UtilString.isEmpty((String)deviceType)) {
                deviceType = this.getContext().getDeviceType();
            }
            if (UtilString.isEmpty((String)model.getUserId())) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u9080\u8bf7\u6210\u5458\u4e0d\u5b58\u5728"));
                return result;
            }
            for (String userId : userIds = model.getUserId().split(",")) {
                NetworkTeamModel team;
                UserModel user = UserCache.getModel((String)userId);
                if (user == null || user.isClosed()) {
                    errMsg.append(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u7528\u6237") + userId + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u6ce8\u9500") + "\uff0c");
                    continue;
                }
                NetworkTeamMemberModel oldModel = NetworkTeamMemberCache.getModel(model.getTeamId(), model.getUserId());
                if (oldModel != null && "2".equals(oldModel.getJoinStatus()) && oldModel.getMemberStatus().equals("1")) {
                    team = NetworkTeamCache.getModel(oldModel.getTeamId());
                    errMsg.append(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5c0f\u7ec4") + "\uff08" + team.getTeamName() + "\uff09" + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u4e2d\u5df2\u5b58\u5728\u8be5\u6210\u5458") + "\uff08" + user.getUserName() + "\uff09<br/>");
                    continue;
                }
                if (oldModel != null) {
                    oldModel.setMemberStatus("0");
                    oldModel.setJoinStatus("1");
                    NetworkTeamMemberCache.putModel(oldModel);
                    team = NetworkTeamCache.getModel(oldModel.getTeamId());
                    NetworkNotification networkNotification = new NetworkNotification();
                    com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                    String content = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u9080\u8bf7\u4f60\u52a0\u5165") + team.getTeamName();
                    json.put("data", (Object)content);
                    json.put("sid", (Object)this.getContext().getSessionId());
                    json.put("memberId", (Object)oldModel.getId());
                    json.put("memberType", (Object)oldModel.getMemberType());
                    json.put("memberStatus", (Object)oldModel.getMemberStatus());
                    json.put("deviceType", (Object)deviceType);
                    networkNotification.complexNotificationMessage(this.getContext().getUID(), oldModel.getUserId(), json, "info", model.getId());
                    continue;
                }
                NetworkTeamMemberModel newModel = new NetworkTeamMemberModel();
                newModel.setId(UUIDGener.getUUID());
                newModel.setTeamId(model.getTeamId());
                newModel.setUserId(userId);
                newModel.setJoinType(model.getJoinType());
                newModel.setMemberType(model.getMemberType());
                newModel.setMemberStatus(model.getMemberStatus());
                newModel.setCreateUserId(model.getCreateUserId());
                newModel.setCreateUserName(model.getCreateUserName());
                newModel.setLastActive(new Timestamp(System.currentTimeMillis()));
                newModel.setJoinStatus("1");
                NetworkTeamModel team2 = NetworkTeamCache.getModel(newModel.getTeamId());
                NetworkNotification networkNotification = new NetworkNotification();
                NetworkTeamMemberCache.putModel(newModel);
                com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                String content = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u9080\u8bf7\u4f60\u52a0\u5165") + team2.getTeamName();
                json.put("data", (Object)content);
                json.put("sid", (Object)this.getContext().getSessionId());
                json.put("memberId", (Object)newModel.getId());
                json.put("memberType", (Object)newModel.getMemberType());
                json.put("memberStatus", (Object)newModel.getMemberStatus());
                json.put("deviceType", (Object)deviceType);
                networkNotification.complexNotificationMessage(this.getContext().getUID(), newModel.getUserId(), json, "info", newModel.getId());
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        if (!UtilString.isEmpty((String)errMsg.toString())) {
            result.err(errMsg.toString());
        }
        return result;
    }

    public String updateTeamMember(String memberId, String memberStatus, String deviceType) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            if (UtilString.isEmpty((String)deviceType)) {
                deviceType = this.getContext().getDeviceType();
            }
            NetworkTeamMemberModel model = NetworkTeamMemberCache.getModel(memberId);
            NetworkNotification networkNotification = new NetworkNotification();
            UserModel user = UserCache.getModel((String)model.getUserId());
            if (user == null || user.isClosed()) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u6ce8\u9500"));
                return result.toString();
            }
            NetworkTeamModel team = NetworkTeamCache.getModel(model.getTeamId());
            NetworkTeamMemberModel oldModel = NetworkTeamMemberCache.getModel(model.getTeamId(), model.getUserId());
            if (oldModel != null && "2".equals(oldModel.getJoinStatus()) && oldModel.getMemberStatus().equals("1")) {
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(oldModel.getTeamId());
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5c0f\u7ec4") + "\uff08" + teamModel.getTeamName() + "\uff09" + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u4e2d\u5df2\u5b58\u5728\u8be5\u6210\u5458") + "\uff08" + user.getUserName() + "\uff09<br/>");
                return result.toString();
            }
            if (oldModel != null && "2".equals(oldModel.getJoinStatus()) && oldModel.getMemberStatus().equals("2")) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u64cd\u4f5c\u5df2\u5931\u6548"));
                return result.toString();
            }
            model.setMemberStatus(memberStatus);
            model.setLastActive(new Timestamp(System.currentTimeMillis()));
            model.setJoinStatus("2");
            NetworkTeamMemberCache.putModel(model);
            Object content = "";
            ORGAPI orgApi = SDK.getORGAPI();
            if (!UtilString.isEmpty((String)memberStatus)) {
                if ("1".equals(memberStatus)) {
                    content = "1".equals(model.getJoinType()) ? this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5df2\u540c\u610f\u4f60\u7684\u9080\u8bf7") + "\uff0c" + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u52a0\u5165") + team.getTeamName() : this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5df2\u540c\u610f\u4f60\u52a0\u5165") + team.getTeamName();
                    NetworkStreamModel stream = new NetworkStreamModel();
                    stream.setId(UUIDGener.getUUID());
                    StringBuffer stramContent = new StringBuffer();
                    stramContent.append(orgApi.getUserAliasNames(model.getUserId())).append(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u52a0\u5165\u5c0f\u7ec4")).append(team.getTeamName());
                    String streamContext = StreamContentHelper.format(Integer.parseInt("1"), stramContent.toString());
                    stream.setStreamContent(streamContext);
                    stream.setStreamType("1");
                    if (team != null) {
                        stream.setTeamId(team.getId());
                        stream.setNetworkId(team.getNetworkId());
                    }
                    stream.setAttached("0");
                    stream.setIpAddress(this.getContext().getClientIP());
                    stream.setDeviceType(deviceType);
                    stream.setCreateUserId(this.getContext().getUID());
                    stream.setCreateUserName(this.getContext().getUserName());
                    stream.setOrgId(this.getContext().getCompanyModel().getId());
                    stream.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    stream.setCacheed("1");
                    NetworkStreamCache.putModel(stream);
                } else if ("2".equals(memberStatus)) {
                    content = "1".equals(model.getJoinType()) ? this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5df2\u62d2\u7edd\u4f60\u7684\u9080\u8bf7\u52a0\u5165") + team.getTeamName() : this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5df2\u62d2\u7edd\u4f60\u52a0\u5165") + team.getTeamName();
                }
                if ("1".equals(model.getJoinType())) {
                    networkNotification.simpleNotificationMessage(this.getContext().getUID(), model.getCreateUserId(), (String)content, "info", model.getId());
                } else {
                    networkNotification.simpleNotificationMessage(this.getContext().getUID(), model.getUserId(), (String)content, "info", model.getId());
                }
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public ResponseObject saveTeamMemberData(UserContext me, NetworkTeamMemberModel model) {
        return this.saveTeamMemberData(me, model, null);
    }

    public ResponseObject saveTeamMemberData(UserContext me, NetworkTeamMemberModel model, String deviceType) {
        ResponseObject result = ResponseObject.newOkResponse();
        StringBuffer errMsg = new StringBuffer();
        try {
            String[] userIds;
            if (UtilString.isEmpty((String)deviceType)) {
                deviceType = this.getContext().getDeviceType();
            }
            if (UtilString.isEmpty((String)model.getUserId())) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6210\u5458\u4e0d\u5b58\u5728"));
                return result;
            }
            for (String userId : userIds = model.getUserId().split(",")) {
                TaskmgtTool tool;
                com.alibaba.fastjson.JSONArray array;
                UserModel user = UserCache.getModel((String)userId);
                if (user == null || user.isClosed()) {
                    errMsg.append(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u7528\u6237") + userId + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u6ce8\u9500") + "\uff0c<br/>");
                    continue;
                }
                NetworkTeamMemberModel oldModel = NetworkTeamMemberCache.getModel(model.getTeamId(), userId);
                if (oldModel != null && "2".equals(oldModel.getJoinStatus()) && oldModel.getMemberStatus().equals("1")) {
                    NetworkTeamModel team = NetworkTeamCache.getModel(oldModel.getTeamId());
                    errMsg.append(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5c0f\u7ec4") + "\uff08" + team.getTeamName() + "\uff09" + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u4e2d\u5df2\u5b58\u5728\u8be5\u6210\u5458") + "\uff08" + user.getUserName() + "\uff09<br/>");
                    continue;
                }
                if (oldModel != null) {
                    oldModel.setMemberStatus("1");
                    oldModel.setJoinStatus("2");
                    NetworkTeamMemberCache.putModel(oldModel);
                    this.sendEmail(user, model);
                    continue;
                }
                NetworkTeamMemberModel newModel = new NetworkTeamMemberModel();
                newModel.setId(UUIDGener.getUUID());
                newModel.setTeamId(model.getTeamId());
                newModel.setUserId(userId);
                newModel.setJoinType(model.getJoinType());
                newModel.setMemberType(model.getMemberType());
                newModel.setMemberStatus(model.getMemberStatus());
                newModel.setCreateUserId(model.getCreateUserId());
                newModel.setCreateUserName(model.getCreateUserName());
                newModel.setLastActive(new Timestamp(System.currentTimeMillis()));
                newModel.setJoinStatus("2");
                NetworkTeamMemberCache.putModel(newModel);
                this.sendEmail(user, model);
                boolean isTeamTaskStart = false;
                NetworkTeamModel team = NetworkTeamCache.getModel(model.getTeamId());
                ResponseObject rs = this.geNetworktTeamNav(team.getNetworkId(), model.getTeamId());
                if (rs.isOk() && (array = (com.alibaba.fastjson.JSONArray)rs.get("metroNavs")).size() > 0) {
                    for (int i = 0; i < array.size(); ++i) {
                        com.alibaba.fastjson.JSONObject j = array.getJSONObject(i);
                        String appId = UtilJson.optString((com.alibaba.fastjson.JSONObject)j, (String)"appContentId");
                        if (!appId.equals("com.actionsoft.apps.taskmgt")) continue;
                        isTeamTaskStart = true;
                        break;
                    }
                }
                if (!isTeamTaskStart || !(tool = new TaskmgtTool()).isExistsProject(me.getSessionId(), model.getTeamId())) continue;
                if (model.getMemberType().equals("2")) {
                    tool.addProjectMember(me.getSessionId(), model.getTeamId(), userId);
                    continue;
                }
                if (!model.getMemberType().equals("3")) continue;
                tool.addProjectMemberLeader(me.getSessionId(), model.getTeamId(), userId);
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        if (!UtilString.isEmpty((String)errMsg.toString())) {
            result.err(errMsg.toString());
        }
        return result;
    }

    private void sendEmail(UserModel user, NetworkTeamMemberModel model) {
        ResponseObject responseObject = SDK.getNotificationAPI().getEmailTemplate("ea6c4332-7522-4c43-ac58-3a34ae637138");
        String mailTemplateJS = null;
        if (responseObject != null && responseObject.isOk()) {
            mailTemplateJS = responseObject.toDataString();
        }
        if (!UtilString.isEmpty(mailTemplateJS)) {
            com.alibaba.fastjson.JSONObject mailTemplateJO = com.alibaba.fastjson.JSONObject.parseObject(mailTemplateJS);
            String to = user.getEmail();
            String cc = mailTemplateJO.getString("copyto");
            String title = mailTemplateJO.getString("email_title");
            String content = mailTemplateJO.getString("email_content");
            content = content.replace("@userName", user.getUserName());
            String teamId = model.getTeamId();
            if (!UtilString.isEmpty((String)teamId)) {
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(teamId);
                content = content.replace("\u3010xx\u3011", "\u3010" + teamModel.getTeamName() + "\u3011");
            }
            SDK.getNotificationAPI().sendEMailAsync("", to, cc, title, content);
        }
    }

    public ResponseObject cleanTeamMember(UserContext me, String teamId, String userId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkTeamMemberModel model = NetworkTeamMemberCache.getModel(teamId, userId);
            if (model != null) {
                NetworkTeamMemberCache.removeById(model.getId());
                TaskmgtTool tool = new TaskmgtTool();
                tool.deleteProjectMember(me.getSessionId(), teamId, userId);
            } else {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5c0f\u7ec4\u6210\u5458\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
            NetworkTeamModel team = NetworkTeamCache.getModel(teamId);
            result.put("team", (Object)NetworkDataUtil.team2JSON(team, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result;
    }

    public String loadAllNetworkTeam(String networkId, String searchValue, String order, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            if (searchValue == null) {
                searchValue = "";
            }
            searchValue = DBSql.convertLike((String)searchValue);
            List<NetworkTeamModel> lists = NetworkTeamCache.loadNetworkTeam(networkId, searchValue);
            ArrayList<NetworkTeamModel> networkTeamList = new ArrayList<NetworkTeamModel>();
            if (lists.size() > 0) {
                for (NetworkTeamModel team : lists) {
                    if (team == null) continue;
                    List<String> userManagerList = NetworkDataUtil.loadAllNetworkTeamMemberManagerList(team.getId());
                    List<String> userList = this.loadAllNetworkTeamMemberList(team.getId());
                    boolean flag = NetworkDataUtil.isNetworkManager(team.getNetworkId(), this.getContext().getUID());
                    if (!userManagerList.contains(this.getContext().getUID()) && !userList.contains(this.getContext().getUID()) && !flag) continue;
                    networkTeamList.add(team);
                }
            }
            UtilListSort sortList = new UtilListSort();
            String orderName = "DESC";
            if (!UtilString.isEmpty((String)order) && order.equals("teamName")) {
                orderName = "ASC";
            }
            sortList.sort(networkTeamList, order, orderName);
            int counts = networkTeamList.size();
            result.put("counts", (Object)networkTeamList.size());
            networkTeamList = networkTeamList.subList(start, start + limit > counts ? counts : start + limit);
            result.put("networkTeamList", (Object)NetworkDataUtil.team2JSON(networkTeamList, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public List<String> loadNetworkAppAccess(String teamId) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<NetworkAppAccessModel> networkAppAccess = NetworkAppAccessCache.loadAllNetworkAppAccess();
            if (networkAppAccess.size() > 0) {
                for (NetworkAppAccessModel model : networkAppAccess) {
                    if (model == null || !model.getTeamId().equals(teamId)) continue;
                    list.add(model.getAppId().trim());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public String saveNetworkAppAccess(NetworkAppAccessModel model) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkAppAccessDao dao = new NetworkAppAccessDao();
        try {
            NetworkTeamModel teamModel;
            if (!UtilString.isEmpty((String)model.getTeamId()) && (teamModel = NetworkTeamCache.getModel(model.getTeamId())) == null) {
                result.err();
                result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5c0f\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728"));
                return result.toString();
            }
            List<NetworkAppAccessModel> lists = dao.findAppAccessByTeam(model.getTeamId(), model.getAppId().trim());
            if (lists.size() < 1) {
                model.setId(UUIDGener.getUUID());
                NetworkAppAccessCache.putModel(model);
            } else {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5c0f\u7ec4\u5df2\u5305\u62ec\u6b64\u5e94\u7528"));
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String saveNetworkAppToolBar(String teamId, String appId) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkAppToolBarModel model = null;
        try {
            String[] appIds;
            if (!UtilString.isEmpty((String)appId) && (appIds = appId.split(",")).length > 0) {
                for (int i = 0; i < appIds.length; ++i) {
                    String appIdStr = appIds[i].toString().trim();
                    model = NetworkAppToolBarCache.getModel(teamId, appIdStr);
                    if (model != null) {
                        model.setOrderNo("" + (i + 1));
                    } else {
                        model = new NetworkAppToolBarModel();
                        model.setTeamId(teamId);
                        model.setAppId(appIds[i]);
                        model.setOrderNo("" + (i + 1));
                        model.setCreateUserId(this.getContext().getUID());
                        model.setCreateUserName(this.getContext().getUserName());
                        model.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        model.setIsShow("0");
                        model.setId(UUIDGener.getUUID());
                    }
                    NetworkAppToolBarCache.putModel(model);
                }
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String updateNetworkAppToolBar(String teamId, String appId) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkAppToolBarModel model = null;
        try {
            String[] appIds;
            List<NetworkAppToolBarModel> lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar(teamId, this.getContext().getUID());
            if (lists.size() > 0) {
                for (NetworkAppToolBarModel toolBar : lists) {
                    if (toolBar == null) continue;
                    toolBar.setIsShow("0");
                    NetworkAppToolBarCache.putModel(toolBar);
                }
            }
            if (!UtilString.isEmpty((String)appId) && (appIds = appId.split(",")).length > 0) {
                for (int i = 0; i < appIds.length; ++i) {
                    String appIdStr = appIds[i].toString().trim();
                    model = NetworkAppToolBarCache.getModel(teamId, appIdStr);
                    if (model != null) {
                        model.setIsShow("1");
                    } else {
                        model = new NetworkAppToolBarModel();
                        model.setTeamId(teamId);
                        model.setAppId(appIds[i]);
                        model.setOrderNo("" + (i + 1));
                        model.setCreateUserId(this.getContext().getUID());
                        model.setCreateUserName(this.getContext().getUserName());
                        model.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        model.setIsShow("1");
                        model.setId(UUIDGener.getUUID());
                    }
                    NetworkAppToolBarCache.putModel(model);
                }
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String loadAllNetworkAppToolBar(String teamId, String type) {
        ResponseObject result = ResponseObject.newOkResponse();
        ArrayList<NetworkAppToolBarModel> toolBarlist = new ArrayList<NetworkAppToolBarModel>();
        try {
            List<NetworkAppToolBarModel> lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar(teamId, this.getContext().getUID(), type);
            if (lists.size() > 0) {
                for (NetworkAppToolBarModel tooBar : lists) {
                    TeamAppProfile model;
                    if (tooBar == null || (model = TeamAppManager.getProfile(tooBar.getAppId().trim())) == null) continue;
                    AppContext appContext = model.getAppContext();
                    boolean isActive = SDK.getAppAPI().isActive(appContext);
                    if (appContext == null || !isActive) continue;
                    toolBarlist.add(tooBar);
                }
            }
            UtilListSort sortList = new UtilListSort();
            sortList.sort(toolBarlist, "orderNo", "DESC");
            result.put("toolBarList", (Object)NetworkDataUtil.appToolBar2JSON(toolBarlist));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String loadAllNetworkAppAccess(String teamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkAppAccessModel> networkTeamList = NetworkAppAccessCache.loadAllNetworkAppAccessByTeam(teamId);
            UtilListSort sortList = new UtilListSort();
            sortList.sort(networkTeamList, "id", "DESC");
            result.put("networkAppAccess", (Object)NetworkDataUtil.appAccess2JSON(networkTeamList));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String saveNetworkAppLIst(NetworkAppListModel model) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkAppListModel> lists = NetworkAppListCache.loadAllNetwork(model.getAppId().trim(), model.getNetworkId());
            if (lists.size() < 1) {
                model.setId(UUIDGener.getUUID());
                model.setLastActive(new Timestamp(System.currentTimeMillis()));
                NetworkAppListCache.putModel(model);
            } else {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5de5\u4f5c\u7f51\u7edc\u5df2\u5305\u62ec\u6b64\u5e94\u7528"));
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String loadAllNetworkAppList(String networkId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkAppListModel> networkTeamList = NetworkAppListCache.loadAllNetwork(networkId);
            UtilListSort sortList = new UtilListSort();
            sortList.sort(networkTeamList, "id", "DESC");
            result.put("networkAppAList", (Object)NetworkDataUtil.appList2JSONAppList(networkTeamList));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public List<String> loadAllNetworkAppListData(String networkId) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List<NetworkAppListModel> networkTeamList = NetworkAppListCache.loadAllNetwork(networkId);
            if (networkTeamList.size() > 0) {
                for (NetworkAppListModel model : networkTeamList) {
                    if (model == null) continue;
                    list.add(model.getAppId().trim());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public String stopNetworkAppList(String appId, String networkId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkAppListModel> modelList = NetworkAppListCache.loadAllNetwork(appId, networkId);
            List<NetworkAppAccessModel> teamApplList = NetworkAppAccessCache.loadAllNetworkAppAccessByApp(appId);
            List<NetworkAppToolBarModel> appToolBarlList = NetworkAppToolBarCache.loadAllNetworkAppToolBar(appId);
            if (modelList.size() > 0) {
                for (NetworkAppListModel networkAppListModel : modelList) {
                    if (networkAppListModel == null) continue;
                    NetworkAppListCache.removeById(networkAppListModel.getId());
                }
            } else {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
            if (teamApplList.size() > 0) {
                for (NetworkAppAccessModel networkAppAccessModel : teamApplList) {
                    List<NetworkAppToolBarModel> toolBarlList;
                    NetworkTeamModel team = NetworkTeamCache.getModel(networkAppAccessModel.getTeamId());
                    if (team == null) continue;
                    if (team.getNetworkId().equals(networkId)) {
                        NetworkAppAccessCache.removeById(networkAppAccessModel.getId());
                    }
                    if ((toolBarlList = NetworkAppToolBarCache.loadAllNetworkAppToolBar(team.getId(), this.getContext().getUID())).size() <= 0) continue;
                    for (NetworkAppToolBarModel tool : toolBarlList) {
                        if (tool == null) continue;
                        NetworkAppToolBarCache.removeById(tool.getId());
                    }
                }
            }
            if (appToolBarlList.size() > 0) {
                for (NetworkAppToolBarModel networkAppToolBarModel : appToolBarlList) {
                    NetworkTeamModel teamModel = NetworkTeamCache.getModel(networkAppToolBarModel.getTeamId());
                    if (teamModel == null || !teamModel.getNetworkId().equals(networkId)) continue;
                    NetworkAppToolBarCache.removeById(networkAppToolBarModel.getId());
                }
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String loadAllNetwork() {
        ResponseObject result = ResponseObject.newOkResponse();
        com.alibaba.fastjson.JSONArray jsonArray = new com.alibaba.fastjson.JSONArray();
        try {
            List<NetworkModel> networkList = NetworkCache.loadNetwork(this.getContext().getUID());
            if (networkList.size() > 0) {
                for (NetworkModel model : networkList) {
                    if (model == null) continue;
                    com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                    json.put("label", (Object)model.getNetworkName());
                    json.put("value", (Object)model.getId());
                    jsonArray.add((Object)json);
                }
            }
            result.put("networkList", (Object)jsonArray);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String loadAllNetworkTeamBy(String networkId, String appId) {
        ResponseObject result = ResponseObject.newOkResponse();
        com.alibaba.fastjson.JSONArray jsonArray = new com.alibaba.fastjson.JSONArray();
        List<Object> lists = new ArrayList();
        ArrayList<NetworkTeamModel> networkTeamList = new ArrayList<NetworkTeamModel>();
        try {
            lists = !UtilString.isEmpty((String)networkId) ? NetworkTeamCache.loadNetworkTeamBy(networkId) : NetworkTeamCache.loadAllNetworkTeam();
            if (lists.size() > 0) {
                for (NetworkTeamModel team : lists) {
                    if (team == null) continue;
                    List<String> userManagerList = NetworkDataUtil.loadAllNetworkTeamMemberManagerList(team.getId());
                    List<String> userList = this.loadAllNetworkTeamMemberList(team.getId());
                    boolean flag = NetworkDataUtil.isNetworkManager(team.getNetworkId(), this.getContext().getUID());
                    if (!userManagerList.contains(this.getContext().getUID()) && !userList.contains(this.getContext().getUID()) && !flag || !team.getTeamStatus().equals("1")) continue;
                    networkTeamList.add(team);
                }
            }
            if (networkTeamList.size() > 0) {
                List<String> appIdList = NetworkAppAccessCache.loadTeamIdsBy(appId, networkId);
                for (NetworkTeamModel model : networkTeamList) {
                    if (model == null || appIdList.contains(model.getId())) continue;
                    com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                    json.put("text", (Object)model.getTeamName());
                    json.put("label", (Object)model.getTeamName());
                    json.put("value", (Object)model.getId());
                    jsonArray.add((Object)json);
                }
            }
            result.put("networkTeamList", (Object)jsonArray);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String loadAllNetworkTeamBy(String appId) {
        ResponseObject result = ResponseObject.newOkResponse();
        ArrayList<NetworkAppAccessModel> networkAppAccessList = new ArrayList();
        try {
            networkAppAccessList = NetworkAppAccessCache.loadAllNetworkAppAccessByApp(appId);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        result.put("networkAppAccessList", (Object)NetworkDataUtil.appAccess2JSON(networkAppAccessList));
        return result.toString();
    }

    public String deleteNetworkTeamBy(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkAppAccessModel model = NetworkAppAccessCache.getModel(id);
            if (model != null) {
                NetworkAppAccessCache.removeById(model.getId());
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(model.getTeamId());
                List<NetworkAppToolBarModel> toolBarlList = NetworkAppToolBarCache.loadAllNetworkAppToolBar(teamModel.getId(), this.getContext().getUID());
                if (toolBarlList.size() > 0) {
                    for (NetworkAppToolBarModel tool : toolBarlList) {
                        if (tool == null) continue;
                        NetworkAppToolBarCache.removeById(tool.getId());
                    }
                }
            } else {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5c0f\u7ec4\u6743\u9650\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String saveNetworkTeam(NetworkTeamModel model) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            model = this.saveTeam(model);
            result.put("networkTeam", (Object)NetworkDataUtil.team2JSON(model, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public NetworkTeamModel saveTeam(NetworkTeamModel model) throws Exception {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            model.setCreateUserId(this.getContext().getUID());
            model.setCreateUserName(this.getContext().getUserName());
            model.setTeamStatus("1");
            model.setCreateTime(new Timestamp(System.currentTimeMillis()));
            model.setLastActive(new Timestamp(System.currentTimeMillis()));
            NetworkTeamCache.putModel(model);
            NetworkTeamMemberModel member = new NetworkTeamMemberModel();
            member.setId(UUIDGener.getUUID());
            member.setTeamId(model.getId());
            member.setUserId(this.getContext().getUID());
            member.setMemberStatus("1");
            member.setMemberType("1");
            member.setJoinType("1");
            member.setJoinStatus("2");
            member.setCreateUserId(this.getContext().getUID());
            member.setCreateUserName(this.getContext().getUserName());
            member.setCreateTime(new Timestamp(System.currentTimeMillis()));
            NetworkTeamMemberCache.putModel(member);
            result.put("networkTeam", (Object)NetworkDataUtil.team2JSON(model, this.getContext()));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new Exception(e);
        }
        return model;
    }

    public String updateNetworkTeam(NetworkTeamModel model) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            model = this.updateTeam(model);
            result.put("networkTeam", (Object)NetworkDataUtil.team2JSON(model, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public NetworkTeamModel updateTeam(NetworkTeamModel model) throws Exception {
        try {
            model.setUpdateUserId(this.getContext().getUID());
            model.setUpdateUserName(this.getContext().getUserName());
            model.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            model.setLastActive(new Timestamp(System.currentTimeMillis()));
            NetworkTeamCache.putModel(model);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new Exception(e);
        }
        return model;
    }

    public String deleteTeamLogo(String teamId, boolean force) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            File folder;
            NetworkTeamModel team;
            if (!force && (team = NetworkTeamCache.getModel(teamId)) != null) {
                return result.toString();
            }
            DCContext dc = PictureProcessor.getDCContext(this.getContext(), "com.actionsoft.apps.network", "!network-logo", "team", teamId);
            if (dc != null && (folder = new File(dc.getPath())).exists() && folder.isDirectory()) {
                File[] files = folder.listFiles();
                if (files.length > 0) {
                    for (File file : files) {
                        file.delete();
                    }
                    result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u56fe\u7247\u5220\u9664\u6210\u529f"));
                }
                folder.delete();
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String getNetworkTeamDetail(String teamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkTeamModel team = NetworkTeamCache.getModel(teamId);
            if (team != null) {
                com.alibaba.fastjson.JSONArray array;
                result.put("team", (Object)NetworkDataUtil.team2JSON(team, this.getContext()));
                List<NetworkTeamMemberDto> memberList = NetworkTeamMemberCache.loadNetworkTeamMemberDtoByTeam(teamId, "1", this.getContext());
                result.put("teamMemberList", (Object)NetworkDataUtil.teamMemberDto2JSON(memberList, this.getContext()));
                List<String> userManagerList = NetworkDataUtil.loadAllNetworkTeamMemberManagerList(team.getId());
                boolean isNetworkManager = NetworkDataUtil.isNetworkManager(team.getNetworkId(), this.getContext().getUID());
                boolean flag = userManagerList.contains(this.getContext().getUID()) || isNetworkManager;
                result.put("isTeamManager", (Object)flag);
                boolean isTeamAppShow = false;
                ResponseObject rs = this.geNetworktTeamNav(team.getNetworkId(), team.getId());
                if (rs.isOk() && (array = (com.alibaba.fastjson.JSONArray)rs.get("metroNavs")).size() > 0) {
                    isTeamAppShow = true;
                }
                result.put("isTeamAppShow", (Object)isTeamAppShow);
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String getNetworkTeamMemberDetail(String teamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        StringBuffer principalStr = new StringBuffer();
        String principal = "";
        try {
            List<NetworkTeamMemberModel> memberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId, "1");
            if (memberList.size() > 0) {
                for (int i = 0; i < memberList.size(); ++i) {
                    NetworkTeamMemberModel model = memberList.get(i);
                    if (model == null) continue;
                    principalStr.append(model.getUserId()).append(",");
                }
            }
            if (principalStr.toString().indexOf(",") > 0) {
                principal = principalStr.toString().substring(0, principalStr.toString().length() - 1);
            }
            result.put("userId", (Object)principal);
            result.put("userIdData", (Object)NetworkDataUtil.getTextBoxData(principal));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public ResponseObject stopNetworkTeam(String teamId, String teamStatus) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkTeamModel team = NetworkTeamCache.getModel(teamId);
            if (team == null) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5c0f\u7ec4\u4e0d\u5b58\u5728"));
                return result;
            }
            boolean isManager = NetworkDataUtil.isNetworkManager(team.getNetworkId(), this.getContext().getUID());
            if (!isManager) {
                isManager = NetworkDataUtil.isTeamManager(teamId, this.getContext().getUID());
            }
            if (!isManager) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6743\u9650\u4e0d\u8db3"));
                return result;
            }
            team.setTeamStatus(teamStatus);
            team.setUpdateUserId(this.getContext().getUID());
            team.setUpdateUserName(this.getContext().getUserName());
            team.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            team.setLastActive(new Timestamp(System.currentTimeMillis()));
            NetworkTeamCache.putModel(team);
            result.put("networkTeam", (Object)NetworkDataUtil.team2JSON(team, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result;
    }

    public ResponseObject deleteNetworkTeam(UserContext me, String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            File folder;
            List<NetworkAppToolBarModel> appToolBar;
            List<NetworkAppAccessModel> appAccess;
            NetworkTeamModel team = NetworkTeamCache.getModel(id);
            if (team == null) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5c0f\u7ec4\u4e0d\u5b58\u5728"));
                return result;
            }
            boolean isManager = NetworkDataUtil.isNetworkManager(team.getNetworkId(), this.getContext().getUID());
            if (!isManager) {
                isManager = NetworkDataUtil.isTeamManager(id, this.getContext().getUID());
            }
            if (!isManager) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6743\u9650\u4e0d\u8db3"));
                return result;
            }
            TaskmgtTool tool = new TaskmgtTool();
            tool.updateProjectStatus(me.getSessionId(), id, "2");
            List<NetworkTeamMemberModel> memberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(team.getId());
            if (memberList.size() > 0) {
                for (Object member : memberList) {
                    if (member == null) continue;
                    NetworkTeamMemberCache.removeById(member.getId());
                }
            }
            if ((appAccess = NetworkAppAccessCache.loadAllNetworkAppAccessByTeam(team.getId())).size() > 0) {
                for (Object app : appAccess) {
                    if (app == null) continue;
                    NetworkAppAccessCache.removeById(app.getId());
                }
            }
            if ((appToolBar = NetworkAppToolBarCache.loadAllNetworkAppToolBarBy(team.getId())).size() > 0) {
                for (NetworkAppToolBarModel networkAppToolBarModel : appToolBar) {
                    if (networkAppToolBarModel == null) continue;
                    NetworkAppToolBarCache.removeById(networkAppToolBarModel.getId());
                }
            }
            List<NetworkStreamModel> streamList = NetworkStreamCache.loadStreamOfTeam(team.getId());
            for (NetworkStreamModel stream : streamList) {
                List<NetworkStreamCommentModel> streamCommentList;
                if (stream == null) continue;
                StreamContent sc = StreamContentHelper.format(stream.getStreamContent(), Integer.parseInt(stream.getStreamType()), me);
                List<AttachementFile> attachementList = sc.getAttachement();
                if (attachementList.size() > 0) {
                    String groupValue = UtilDate.yearFormat((Timestamp)stream.getCreateTime()) + UtilDate.monthFormat((Timestamp)stream.getCreateTime());
                    for (AttachementFile attachementFile : attachementList) {
                        DCContext dc = new DCContext(this.getContext(), DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", groupValue, attachementFile.getCreateUser(), attachementFile.getFileName());
                        dc.delete();
                        if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(attachementFile.getFileType() + ",")) {
                            dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                            dc.delete();
                            continue;
                        }
                        if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(attachementFile.getFileType() + ",")) {
                            dc.setFileName(attachementFile.getFileUUID() + ".pdf");
                            dc.delete();
                            dc.setFileName(attachementFile.getFileUUID() + ".jpg");
                            dc.delete();
                            dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                            dc.delete();
                            continue;
                        }
                        if (!"pdf".equals(attachementFile.getFileType())) continue;
                        dc.setFileName(attachementFile.getFileUUID() + ".jpg");
                        dc.delete();
                        dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                        dc.delete();
                    }
                }
                ArrayList<String> transpondStreamIds = new ArrayList<String>();
                if (!UtilString.isEmpty((String)stream.getStreamId())) {
                    streamCommentList = NetworkStreamCommentCache.loadStreamCommentByTrans(stream.getId());
                    for (NetworkStreamCommentModel streamComment : streamCommentList) {
                        transpondStreamIds.add(streamComment.getStreamId());
                        NetworkStreamCommentCache.removeById(streamComment.getId());
                    }
                }
                streamCommentList = NetworkStreamCommentCache.loadStreamComment(stream.getId());
                for (NetworkStreamCommentModel streamComment : streamCommentList) {
                    NetworkStreamCommentCache.removeById(streamComment.getId());
                }
                List<String> list = PatternUtil.matcherTopic(sc.getContent());
                Map<String, NetworkTopicModel> topicMaps = NetworkTopicCache.vailModelByName(list, stream.getNetworkId(), stream.getTeamId());
                Set<String> keySet = topicMaps.keySet();
                for (String topicName : keySet) {
                    NetworkTopicModel topic = topicMaps.get(topicName);
                    if (topic == null) continue;
                    if (topic.getTopicCount() == 1) {
                        NetworkTopicCache.removeById(topic.getId());
                        continue;
                    }
                    topic.setTopicCount(topic.getTopicCount() - 1);
                    topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                    NetworkTopicCache.putModel(topic);
                }
                NetworkStreamCache.removeById(stream.getId());
            }
            DCContext dCContext = PictureProcessor.getDCContext(this.getContext(), "com.actionsoft.apps.network", "!network-logo", "team", id);
            if (dCContext != null && (folder = new File(dCContext.getPath())).exists() && folder.isDirectory()) {
                File[] files;
                for (File file : files = folder.listFiles()) {
                    file.delete();
                }
                folder.delete();
            }
            NetworkTeamCache.removeById(id);
            TeamAppManager.signalTeamDeleted(team.getId());
            result.put("networkTeam", (Object)NetworkDataUtil.team2JSON(team, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result;
    }

    public String getNetworkTeamById(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkTeamModel model = null;
        try {
            model = NetworkTeamCache.getModel(id);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        result.put("networkTeamModel", (Object)NetworkDataUtil.team2JSON(model, this.getContext()));
        return result.toString();
    }

    public String updateNetworkTeamMemo(String teamId, String teamMemo) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkTeamModel model = null;
        try {
            model = NetworkTeamCache.getModel(teamId);
            if (model == null) {
                result.err();
                result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5c0f\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728"));
                return result.toString();
            }
            model.setTeamMemo(teamMemo);
            model.setUpdateUserId(this.getContext().getUID());
            model.setUpdateUserName(this.getContext().getUserName());
            model.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            NetworkTeamCache.putModel(model);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        result.put("networkTeamModel", (Object)NetworkDataUtil.team2JSON(model, this.getContext()));
        return result.toString();
    }

    public String toTeamAppManage(String sid) {
        HashMap<String, String> macroLibraries = new HashMap<String, String>();
        macroLibraries.put("sid", sid);
        return HtmlPageTemplate.merge((String)"com.actionsoft.apps.network", (String)"network.team.app.manage.html", macroLibraries);
    }

    public String loadAllNetwork(String sid, String searchValue, String order, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            if (searchValue == null) {
                searchValue = "";
            }
            searchValue = DBSql.convertLike((String)searchValue);
            List<NetworkModel> networkList = NetworkCache.loadNetwork(this.getContext().getUID(), searchValue);
            UtilListSort sortList = new UtilListSort();
            if ("networkName".equals(order)) {
                sortList.sort(networkList, order, "ASC");
            } else {
                sortList.sort(networkList, order, "DESC");
            }
            int counts = networkList.size();
            result.put("counts", (Object)networkList.size());
            networkList = networkList.subList(start, start + limit > counts ? counts : start + limit);
            result.put("networkList", (Object)NetworkDataUtil.network2JSON(networkList, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String toCreateNetwork(String sid) {
        HashMap<String, String> macroLibraries = new HashMap<String, String>();
        macroLibraries.put("sid", sid);
        return HtmlPageTemplate.merge((String)"com.actionsoft.apps.network", (String)"network.team.create.network.html", macroLibraries);
    }

    public String saveNetwork(NetworkModel model) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkModel> list = NetworkCache.loadAllNetwork();
            boolean exist = false;
            for (NetworkModel network : list) {
                if (network == null || !model.getNetworkName().equals(network.getNetworkName())) continue;
                exist = true;
                break;
            }
            if (exist) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5de5\u4f5c\u7f51\u7edc") + "[" + model.getNetworkName() + "]" + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5df2\u5b58\u5728"));
                return result.toString();
            }
            model.setCreateUserId(this.getContext().getUID());
            model.setCreateUserName(this.getContext().getUserName());
            model.setNetworkStatus("1");
            model.setCreateTime(new Timestamp(System.currentTimeMillis()));
            model.setLastActive(new Timestamp(System.currentTimeMillis()));
            NetworkCache.putModel(model);
            result.put("networkModel", (Object)NetworkDataUtil.network2JSON(model, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String updateNetwork(NetworkModel model) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            model.setUpdateUserId(this.getContext().getUID());
            model.setUpdateUserName(this.getContext().getUserName());
            model.setNetworkStatus("1");
            model.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            model.setLastActive(new Timestamp(System.currentTimeMillis()));
            NetworkCache.putModel(model);
            result.put("networkModel", (Object)NetworkDataUtil.network2JSON(model, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String deleteNetworkLogo(String networkId, boolean force) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            File folder;
            NetworkModel network;
            if (!force && (network = NetworkCache.getModel(networkId)) != null) {
                return result.toString();
            }
            DCContext dc = PictureProcessor.getDCContext(this.getContext(), "com.actionsoft.apps.network", "!network-logo", "network", networkId);
            if (dc != null && (folder = new File(dc.getPath())).exists() && folder.isDirectory()) {
                File[] files = folder.listFiles();
                if (files.length > 0) {
                    for (File file : files) {
                        file.delete();
                    }
                    result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u56fe\u7247\u5220\u9664\u6210\u529f"));
                }
                folder.delete();
            }
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String deleteNetwork(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkTopicModel> topicList;
            File folder;
            DCContext dc;
            List<NetworkAppListModel> appList;
            NetworkModel network = NetworkCache.getModel(id);
            if (network == null) {
                result.err();
                result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5de5\u4f5c\u7f51\u7edc\u4fe1\u606f\u4e0d\u5b58\u5728"));
                return result.toString();
            }
            List<NetworkTeamModel> teamList = NetworkTeamCache.loadNetworkTeamBy(id);
            if (teamList.size() > 0) {
                for (NetworkTeamModel networkTeamModel : teamList) {
                    Object folder2;
                    List<NetworkAppToolBarModel> appToolBar;
                    List<NetworkAppAccessModel> appAccess;
                    if (networkTeamModel == null) continue;
                    List<NetworkTeamMemberModel> list = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(networkTeamModel.getId());
                    if (list.size() > 0) {
                        for (Object member : list) {
                            if (member == null) continue;
                            NetworkTeamMemberCache.removeById(member.getId());
                        }
                    }
                    if ((appAccess = NetworkAppAccessCache.loadAllNetworkAppAccessByTeam(networkTeamModel.getId())).size() > 0) {
                        Object member;
                        member = appAccess.iterator();
                        while (member.hasNext()) {
                            Object app = (NetworkAppAccessModel)((Object)member.next());
                            if (app == null) continue;
                            NetworkAppAccessCache.removeById(app.getId());
                        }
                    }
                    if ((appToolBar = NetworkAppToolBarCache.loadAllNetworkAppToolBarBy(networkTeamModel.getId())).size() > 0) {
                        for (NetworkAppToolBarModel networkAppToolBarModel : appToolBar) {
                            if (networkAppToolBarModel == null) continue;
                            NetworkAppToolBarCache.removeById(networkAppToolBarModel.getId());
                        }
                    }
                    List<NetworkStreamModel> streamList = NetworkStreamCache.loadStreamOfTeam(networkTeamModel.getId());
                    for (NetworkStreamModel stream : streamList) {
                        List<NetworkStreamCommentModel> streamCommentList;
                        if (stream == null) continue;
                        StreamContent streamContent = StreamContentHelper.format(stream.getStreamContent(), Integer.parseInt(stream.getStreamType()), this.getContext());
                        List<AttachementFile> list2 = streamContent.getAttachement();
                        if (list2.size() > 0) {
                            String groupValue = UtilDate.yearFormat((Timestamp)stream.getCreateTime()) + UtilDate.monthFormat((Timestamp)stream.getCreateTime());
                            for (AttachementFile attachementFile : list2) {
                                DCContext dc2 = new DCContext(this.getContext(), DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", groupValue, attachementFile.getCreateUser(), attachementFile.getFileName());
                                dc2.delete();
                                if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(attachementFile.getFileType() + ",")) {
                                    dc2.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                                    dc2.delete();
                                    continue;
                                }
                                if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(attachementFile.getFileType() + ",")) {
                                    dc2.setFileName(attachementFile.getFileUUID() + ".pdf");
                                    dc2.delete();
                                    dc2.setFileName(attachementFile.getFileUUID() + ".jpg");
                                    dc2.delete();
                                    dc2.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                                    dc2.delete();
                                    continue;
                                }
                                if (!"pdf".equals(attachementFile.getFileType())) continue;
                                dc2.setFileName(attachementFile.getFileUUID() + ".jpg");
                                dc2.delete();
                                dc2.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                                dc2.delete();
                            }
                        }
                        ArrayList<String> transpondStreamIds = new ArrayList<String>();
                        if (!UtilString.isEmpty((String)stream.getStreamId())) {
                            streamCommentList = NetworkStreamCommentCache.loadStreamCommentByTrans(stream.getId());
                            for (NetworkStreamCommentModel streamComment : streamCommentList) {
                                transpondStreamIds.add(streamComment.getStreamId());
                                NetworkStreamCommentCache.removeById(streamComment.getId());
                            }
                        }
                        streamCommentList = NetworkStreamCommentCache.loadStreamComment(stream.getId());
                        for (NetworkStreamCommentModel streamComment : streamCommentList) {
                            NetworkStreamCommentCache.removeById(streamComment.getId());
                        }
                        List<String> list3 = PatternUtil.matcherTopic(streamContent.getContent());
                        Map<String, NetworkTopicModel> topicMaps = NetworkTopicCache.vailModelByName(list3, stream.getNetworkId(), stream.getTeamId());
                        Set<String> keySet = topicMaps.keySet();
                        for (String topicName : keySet) {
                            NetworkTopicModel topic = topicMaps.get(topicName);
                            if (topic == null) continue;
                            if (topic.getTopicCount() == 1) {
                                NetworkTopicCache.removeById(topic.getId());
                                continue;
                            }
                            topic.setTopicCount(topic.getTopicCount() - 1);
                            topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                            NetworkTopicCache.putModel(topic);
                        }
                        NetworkStreamCache.removeById(stream.getId());
                    }
                    DCContext dCContext = PictureProcessor.getDCContext(this.getContext(), "com.actionsoft.apps.network", "!network-logo", "team", networkTeamModel.getId());
                    if (dCContext != null && ((File)(folder2 = new File(dCContext.getPath()))).exists() && ((File)folder2).isDirectory()) {
                        File[] fileArray;
                        for (File file : fileArray = ((File)folder2).listFiles()) {
                            file.delete();
                        }
                        ((File)folder2).delete();
                    }
                    NetworkTeamCache.removeById(networkTeamModel.getId());
                    TeamAppManager.signalTeamDeleted(networkTeamModel.getId());
                }
            }
            if ((appList = NetworkAppListCache.loadAllNetwork(id)).size() > 0) {
                for (NetworkAppListModel networkAppListModel : appList) {
                    if (networkAppListModel == null) continue;
                    NetworkAppListCache.removeById(networkAppListModel.getId());
                }
            }
            List<NetworkStreamModel> list = NetworkStreamCache.loadStreamOfNetwork(network.getId());
            for (NetworkStreamModel stream : list) {
                if (stream == null) continue;
                StreamContent sc = StreamContentHelper.format(stream.getStreamContent(), Integer.parseInt(stream.getStreamType()), this.getContext());
                List<AttachementFile> attachementList = sc.getAttachement();
                if (attachementList.size() > 0) {
                    String string = UtilDate.yearFormat((Timestamp)stream.getCreateTime()) + UtilDate.monthFormat((Timestamp)stream.getCreateTime());
                    for (AttachementFile attachementFile : attachementList) {
                        DCContext dCContext = new DCContext(this.getContext(), DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", string, attachementFile.getCreateUser(), attachementFile.getFileName());
                        dCContext.delete();
                        if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(attachementFile.getFileType() + ",")) {
                            dCContext.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                            dCContext.delete();
                            continue;
                        }
                        if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(attachementFile.getFileType() + ",")) {
                            dCContext.setFileName(attachementFile.getFileUUID() + ".pdf");
                            dCContext.delete();
                            dCContext.setFileName(attachementFile.getFileUUID() + ".jpg");
                            dCContext.delete();
                            dCContext.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                            dCContext.delete();
                            continue;
                        }
                        if (!"pdf".equals(attachementFile.getFileType())) continue;
                        dCContext.setFileName(attachementFile.getFileUUID() + ".jpg");
                        dCContext.delete();
                        dCContext.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                        dCContext.delete();
                    }
                }
                ArrayList<String> transpondStreamIds = new ArrayList<String>();
                if (!UtilString.isEmpty((String)stream.getStreamId())) {
                    List<NetworkStreamCommentModel> list4 = NetworkStreamCommentCache.loadStreamCommentByTrans(stream.getId());
                    for (NetworkStreamCommentModel networkStreamCommentModel : list4) {
                        transpondStreamIds.add(networkStreamCommentModel.getStreamId());
                        NetworkStreamCommentCache.removeById(networkStreamCommentModel.getId());
                    }
                }
                List<NetworkStreamCommentModel> list5 = NetworkStreamCommentCache.loadStreamComment(stream.getId());
                for (NetworkStreamCommentModel networkStreamCommentModel : list5) {
                    NetworkStreamCommentCache.removeById(networkStreamCommentModel.getId());
                }
                List<String> list6 = PatternUtil.matcherTopic(sc.getContent());
                Map<String, NetworkTopicModel> map = NetworkTopicCache.vailModelByName(list6, stream.getNetworkId(), stream.getTeamId());
                Set<String> keySet = map.keySet();
                for (String string : keySet) {
                    NetworkTopicModel topic = map.get(string);
                    if (topic == null) continue;
                    if (topic.getTopicCount() == 1) {
                        NetworkTopicCache.removeById(topic.getId());
                        continue;
                    }
                    topic.setTopicCount(topic.getTopicCount() - 1);
                    topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                    NetworkTopicCache.putModel(topic);
                }
                NetworkStreamCache.removeById(stream.getId());
            }
            SDK.getPermAPI().removeAC("network.myAcTypeManage", id);
            boolean bl = NetworkDataUtil.isNetworkManager(id, this.getContext().getUID());
            if (bl) {
                this.delNetworkManager(this.getContext(), id, this.getContext().getUID());
            }
            if ((dc = PictureProcessor.getDCContext(this.getContext(), "com.actionsoft.apps.network", "!network-logo", "network", id)) != null && (folder = new File(dc.getPath())).exists() && folder.isDirectory()) {
                void var13_47;
                File[] files;
                File[] fileArray = files = folder.listFiles();
                int n = fileArray.length;
                boolean bl2 = false;
                while (var13_47 < n) {
                    File file = fileArray[var13_47];
                    file.delete();
                    ++var13_47;
                }
                folder.delete();
            }
            if ((topicList = NetworkTopicCache.loadTopicOfNetwork(id)).size() > 0) {
                for (NetworkTopicModel networkTopicModel : topicList) {
                    if (networkTopicModel == null) continue;
                    NetworkTopicCache.removeById(networkTopicModel.getId());
                }
            }
            NetworkCache.removeById(id);
            result.put("networkModel", (Object)NetworkDataUtil.network2JSON(network, this.getContext()));
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String getNetworkById(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkModel model = null;
        try {
            model = NetworkCache.getModel(id);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        result.put("networkModel", (Object)NetworkDataUtil.network2JSON(model, this.getContext()));
        return result.toString();
    }

    public String getNetworkManagerUser(String networkId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            PortalAPI portalApi = SDK.getPortalAPI();
            com.alibaba.fastjson.JSONObject json = portalApi.queryUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username");
            com.alibaba.fastjson.JSONArray networkArray = (com.alibaba.fastjson.JSONArray)json.get((Object)"networkManage") == null ? new com.alibaba.fastjson.JSONArray() : (com.alibaba.fastjson.JSONArray)json.get((Object)"networkManage");
            int len = 0;
            com.alibaba.fastjson.JSONArray records = new com.alibaba.fastjson.JSONArray();
            if (networkArray != null) {
                len = networkArray.size();
                for (int i = 0; i < len; ++i) {
                    com.alibaba.fastjson.JSONObject record = networkArray.getJSONObject(i);
                    if (UtilString.isEmpty((String)networkId) || record.get((Object)"networkId") == null || !record.getString("networkId").equals(networkId)) continue;
                    record.put("userId", (Object)record.getString("userId"));
                    record.put("userIdData", (Object)NetworkDataUtil.getTextBoxData(record.getString("userId")));
                    record.put("userName", (Object)SDK.getORGAPI().getUserNames(record.getString("userId"), ","));
                    records.add((Object)record);
                }
            }
            result.put("networkArray", (Object)records);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public com.alibaba.fastjson.JSONArray getNetworkAuthorityByUID(String uid) {
        com.alibaba.fastjson.JSONArray records = new com.alibaba.fastjson.JSONArray();
        try {
            PortalAPI portalApi = SDK.getPortalAPI();
            com.alibaba.fastjson.JSONObject json = portalApi.queryUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username");
            com.alibaba.fastjson.JSONArray networkArray = (com.alibaba.fastjson.JSONArray)json.get((Object)"networkManage") == null ? new com.alibaba.fastjson.JSONArray() : (com.alibaba.fastjson.JSONArray)json.get((Object)"networkManage");
            int len = 0;
            if (networkArray != null) {
                len = networkArray.size();
                for (int i = 0; i < len; ++i) {
                    List<String> rangeList;
                    com.alibaba.fastjson.JSONObject record = networkArray.getJSONObject(i);
                    if (UtilString.isEmpty((String)uid) || !(rangeList = NetworkDataUtil.getRangeList(record.get((Object)"userId").toString())).contains(uid)) continue;
                    records.add((Object)record);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return records;
    }

    public String delNetworkManager(UserContext me, String networkId, String userId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            PortalAPI portalApi = SDK.getPortalAPI();
            JSONObject json = portalApi.getUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username");
            JSONArray networkArray = (com.alibaba.fastjson.JSONArray)json.get("networkManage") == null ? new JSONArray() : (JSONArray)json.get("networkManage");
            int len = 0;
            StringBuffer principalStr = new StringBuffer();
            if (networkArray != null) {
                len = networkArray.size();
                for (int i = 0; i < len; ++i) {
                    JSONObject record = networkArray.getJSONObject(i);
                    List<String> rangeList = NetworkDataUtil.getRangeList(record.get("userId").toString());
                    if (!networkId.equals(record.getString("networkId")) || !rangeList.contains(userId)) continue;
                    for (int k = 0; k < rangeList.size(); ++k) {
                        if (rangeList.get(k).equals(userId)) continue;
                        principalStr.append(rangeList.get(k)).append(",");
                    }
                    String userIdOLd = principalStr.toString().substring(0, principalStr.toString().length() - 1);
                    record.put((Object)"userId", (Object)userIdOLd.toString());
                    break;
                }
            }
            json.put((Object)"networkManage", (Object)networkArray);
            portalApi.setUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username", json);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String setNetworkTeamManager(String memberId, String memberType) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkTeamMemberModel model = NetworkTeamMemberCache.getModel(memberId);
            if (model == null) {
                result.err();
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5c0f\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728"));
                return result.toString();
            }
            model.setMemberType(memberType);
            model.setLastActive(new Timestamp(System.currentTimeMillis()));
            NetworkTeamMemberCache.putModel(model);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String saveNetworkManager(UserContext me, String networkId, String userId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            PortalAPI portalApi = SDK.getPortalAPI();
            JSONObject json = portalApi.getUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username");
            JSONArray networkArray = (JSONArray)json.get("networkManage") == null ? new JSONArray() : (JSONArray)json.get("networkManage");
            int len = 0;
            boolean isExist = false;
            if (networkArray.size() > 0) {
                len = networkArray.size();
                for (int i = 0; i < len; ++i) {
                    JSONObject record = networkArray.getJSONObject(i);
                    if (record.get("networkId") == null || !networkId.equals(record.getString("networkId"))) continue;
                    record.put((Object)"userId", (Object)userId);
                    record.put((Object)"userName", (Object)SDK.getORGAPI().getUserNames(userId, ","));
                    isExist = true;
                    break;
                }
            }
            if (!isExist) {
                com.alibaba.fastjson.JSONObject record = new com.alibaba.fastjson.JSONObject();
                record.put("networkId", (Object)networkId);
                record.put("userId", (Object)userId);
                record.put("userName", (Object)SDK.getORGAPI().getUserNames(userId, ","));
                networkArray.add((Object)record);
            }
            json.put((Object)"networkManage", (Object)networkArray);
            portalApi.setUserProfileSchema("com.actionsoft.apps.network", "admin", "network_range_username", json);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String getUserList(String key, String teamId, int limit) {
        int n = 0;
        com.alibaba.fastjson.JSONArray userJsonArray = new com.alibaba.fastjson.JSONArray();
        ORGAPI orgApi = SDK.getORGAPI();
        PortalAPI portalApi = SDK.getPortalAPI();
        List users = orgApi.liveSearchUser(this.getContext().getUID(), key, limit);
        if (!UtilString.isEmpty((String)teamId)) {
            List<String> userId = NetworkTeamMemberCache.loadNetworkTeamMemberBy(teamId, "1");
            for (UserModel userModel : users) {
                if (n < limit) {
                    if ((userModel == null || !userModel.getUID().toLowerCase().contains(key.toLowerCase())) && !userModel.getUserName().toLowerCase().contains(key.toLowerCase()) || userId.contains(userModel.getUID())) continue;
                    DepartmentModel dept = DepartmentCache.getModel((String)userModel.getDepartmentId());
                    com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                    json.put("id", (Object)userModel.getUID());
                    json.put("label", (Object)(dept.getPathNameOfCache() + userModel.getUserName()));
                    json.put("value", (Object)userModel.getUID());
                    userJsonArray.add((Object)json);
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            for (UserModel userModel : users) {
                if (n < limit) {
                    if ((userModel == null || !userModel.getUID().toLowerCase().contains(key.toLowerCase())) && !userModel.getUserName().toLowerCase().contains(key.toLowerCase()) || !userModel.getUID().toLowerCase().contains(key.toLowerCase()) && !userModel.getUserName().toLowerCase().contains(key.toLowerCase())) continue;
                    DepartmentModel dept = DepartmentCache.getModel((String)userModel.getDepartmentId());
                    com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                    json.put("id", (Object)userModel.getUID());
                    json.put("label", (Object)(dept.getPathNameOfCache() + userModel.getUserName()));
                    json.put("value", (Object)userModel.getUID());
                    userJsonArray.add((Object)json);
                    ++n;
                    continue;
                }
                break;
            }
        }
        return userJsonArray.toString();
    }

    public String saveNetworkStream(String networkId, String teamId, String streamType, String content, String attachement, String link, String tags, String notifier, String notifierTeam, String title, String praisePeople, String praiseBadge, String pariseDefinition, String voteContext, String sourceAppId, String sourceType, String sourceId, String channelType, String configContent, String srcObjectContent, String address) {
        return this.saveNetworkStream(networkId, teamId, streamType, content, attachement, link, tags, notifier, notifierTeam, title, praisePeople, praiseBadge, pariseDefinition, voteContext, sourceAppId, sourceType, sourceId, channelType, configContent, srcObjectContent, address, "0");
    }

    public String saveNetworkStream(String networkId, String teamId, String streamType, String content, String attachement, String link, String tags, String notifier, String notifierTeam, String title, String praisePeople, String praiseBadge, String pariseDefinition, String voteContext, String sourceAppId, String sourceType, String sourceId, String channelType, String configContent, String srcObjectContent, String address, String isAnonymous) {
        Iterator<NetworkTeamModel> _content;
        NetworkNotification networkNotification;
        Iterator iter;
        com.alibaba.fastjson.JSONObject voteObject;
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkStreamModel model = new NetworkStreamModel();
        String boId = "";
        String boItemId = "";
        String createAfterAslp = "";
        model.setId(UUIDGener.getUUID());
        if (UtilString.isEmpty((String)notifierTeam)) {
            notifierTeam = "0";
        }
        if (NetworkDataUtil.isJson(voteContext) && (voteObject = com.alibaba.fastjson.JSONObject.parseObject((String)voteContext)) != null && (iter = voteObject.keySet().iterator()).hasNext()) {
            String voteId = voteObject.getString("voteId");
            String data = voteObject.getString("data");
            String txtVoteTitle = voteObject.getString("title");
            String txtVoteMemo = voteObject.getString("memo");
            String txtEndTime = voteObject.getString("endTime");
            try {
                ResponseObject ro = this.addVote(voteId, data, txtVoteTitle, txtVoteMemo, txtEndTime, networkId, teamId);
                if (!ro.isOk()) {
                    result.err();
                    result.msg(ro.getMsg());
                    return result.toString();
                }
                model.setId(voteId);
                title = txtVoteTitle;
                content = txtVoteMemo;
                link = title;
            }
            catch (Exception e) {
                result.err();
                result.msg(e.getMessage());
                return result.toString();
            }
        }
        String StreamContent2 = StreamContentHelper.format(Integer.parseInt(streamType), content, attachement, link, tags, notifier, notifierTeam, title, praisePeople, praiseBadge, pariseDefinition, this.getContext());
        model.setStreamContent(StreamContent2);
        model.setStreamType(streamType);
        model.setNetworkId(networkId);
        model.setTeamId(teamId);
        model.setAddress(address);
        model.setIsAnonymity(isAnonymous);
        if (UtilString.isEmpty((String)attachement)) {
            model.setAttached("0");
        } else {
            model.setAttached("1");
        }
        model.setIpAddress(this.getContext().getClientIP());
        model.setDeviceType(this.getContext().getDeviceType());
        if (this.getContext().getDeviceType().equals("pc")) {
            model.setDeviceType(this.getContext().getDeviceType().toUpperCase());
        }
        model.setCreateUserId(this.getContext().getUID());
        model.setCreateUserName(this.getContext().getUserName());
        model.setOrgId(this.getContext().getCompanyModel().getId());
        model.setCreateTime(new Timestamp(System.currentTimeMillis()));
        model.setCacheed("1");
        model.setSourceAppId(sourceAppId);
        model.setSourceId(sourceId);
        model.setSourceType(sourceType);
        model.setChannelType(channelType);
        if (!UtilString.isEmpty((String)configContent)) {
            try {
                com.alibaba.fastjson.JSONObject configJSON = com.alibaba.fastjson.JSONObject.parseObject((String)configContent);
                if (configJSON != null) {
                    networkId = UtilString.isEmpty((String)configJSON.getString("networkId")) ? "" : configJSON.getString("networkId");
                    teamId = UtilString.isEmpty((String)configJSON.getString("networkTeamId")) ? "" : configJSON.getString("networkTeamId");
                    sourceId = UtilString.isEmpty((String)configJSON.getString("sourceId")) ? sourceId : configJSON.getString("sourceId");
                    sourceType = UtilString.isEmpty((String)configJSON.getString("sourceType")) ? "" : configJSON.getString("sourceType");
                    String parentSourceId = UtilString.isEmpty((String)configJSON.getString("parentSourceId")) ? "" : configJSON.getString("parentSourceId");
                    String sourceDeptId = UtilString.isEmpty((String)configJSON.getString("sourceDeptId")) ? "" : configJSON.getString("sourceDeptId");
                    boId = UtilString.isEmpty((String)configJSON.getString("boId")) ? "" : configJSON.getString("boId");
                    String string = boItemId = UtilString.isEmpty((String)configJSON.getString("boItemId")) ? "" : configJSON.getString("boItemId");
                    if (configJSON.containsKey((Object)"createAfterAslp")) {
                        String string2 = createAfterAslp = UtilString.isEmpty((String)configJSON.getString("createAfterAslp")) ? "" : configJSON.getString("createAfterAslp");
                    }
                    if (UtilString.isEmpty((String)sourceAppId)) {
                        model.setSourceAppId("_bpm.platform.stream.ui");
                    }
                    model.setNetworkId(networkId);
                    model.setTeamId(teamId);
                    model.setSourceId(sourceId);
                    model.setSourceType(sourceType);
                    model.setParentSourceId(parentSourceId);
                    model.setSourceDeptId(sourceDeptId);
                }
            }
            catch (Exception e) {
                result.err();
                result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u914d\u7f6e\u4fe1\u606f\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684json\u683c\u5f0f\u6570\u636e"));
                return result.toString();
            }
        }
        if (!UtilString.isEmpty((String)srcObjectContent)) {
            try {
                com.alibaba.fastjson.JSONObject srcJson = com.alibaba.fastjson.JSONObject.parseObject((String)srcObjectContent);
                if (srcJson != null && !UtilString.isEmpty((String)srcJson.getString("srcObjType"))) {
                    String srcObjUrl = srcJson.getString("srcObjUrl");
                    srcObjUrl = URLDecoder.decode(srcObjUrl, "utf-8");
                    srcJson.put("srcObjUrl", (Object)srcObjUrl);
                    model.setSrcObjectContent(srcJson.toString());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                result.err();
                result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5173\u8054\u5bf9\u8c61\u4fe1\u606f\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684json\u683c\u5f0f\u6570\u636e"));
                return result.toString();
            }
        }
        NetworkStreamCache.putModel(model);
        List<String> topics = PatternUtil.matcherTopic(content);
        Map<String, NetworkTopicModel> topicMaps = NetworkTopicCache.vailModelByName(topics, networkId, teamId);
        Set<String> keySet = topicMaps.keySet();
        for (String topicName : keySet) {
            NetworkTopicModel topic = topicMaps.get(topicName);
            if (topic == null) {
                topic = new NetworkTopicModel();
                topic.setId(UUIDGener.getUUID());
                topic.setTopicName(topicName);
                topic.setTopicCount(1);
                topic.setNetworkId(networkId);
                topic.setTeamId(teamId);
                topic.setCreateUserId(this.getContext().getUID());
                topic.setCreateUserName(this.getContext().getUserName());
                topic.setCreateTime(new Timestamp(System.currentTimeMillis()));
                topic.setLastActive(new Timestamp(System.currentTimeMillis()));
            } else {
                topic.setTopicCount(topic.getTopicCount() + 1);
                topic.setLastActive(new Timestamp(System.currentTimeMillis()));
            }
            NetworkTopicCache.putModel(topic);
        }
        String userAlisName = PatternUtil.matcherAtUserAliasNameStr(content);
        ORGAPI orgApi = SDK.getORGAPI();
        String userIds = orgApi.getUserIds(userAlisName) + " ";
        if (!UtilString.isEmpty((String)notifier)) {
            String[] uids = notifier.split(",");
            for (String uid : uids) {
                if (userIds.contains((String)uid + " ") || this.getContext().getUID().equals(uid)) continue;
                userIds = userIds + (String)uid + " ";
            }
        }
        if ("1".equals(notifierTeam)) {
            List<NetworkTeamMemberModel> memberList = NetworkTeamMemberCache.loadNetworkTeamMemberByTeam(teamId);
            for (NetworkTeamMemberModel member : memberList) {
                if (userIds.contains(member.getUserId() + " ") || this.getContext().getUID().equals(member.getUserId())) continue;
                userIds = userIds + member.getUserId() + " ";
            }
        }
        if (!UtilString.isEmpty((String)userIds)) {
            networkNotification = new NetworkNotification();
            _content = HttpUtil.getSubString(content, 150, "...");
            String senderName = UtilString.isNotEmpty((String)isAnonymous) && isAnonymous.equals("1") ? I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u533f\u540d\u7528\u6237") : this.getContext().getUserModel().getUserNameAlias();
            Object notificationContent = senderName + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u63d0\u5230\u6211") + "\uff1a   " + (String)((Object)_content);
            com.alibaba.fastjson.JSONObject contentJson = new com.alibaba.fastjson.JSONObject();
            notificationContent = ((String)notificationContent).replaceAll("&lt;", "<").replaceAll("&gt;", ">");
            contentJson.put("data", notificationContent);
            contentJson.put("streamId", (Object)model.getId());
            ResponseObject execResult = networkNotification.dynamicNotification(this.getContext().getUID(), userIds, contentJson, "info", model.getId());
            if (execResult.isErr()) {
                LOGGER.info(execResult.getMsg());
            }
        }
        if (!UtilString.isEmpty((String)praisePeople)) {
            networkNotification = new NetworkNotification();
            _content = HttpUtil.getSubString(content, 150, "...");
            praisePeople = praisePeople.replace(",", " ");
            String notificationContent = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8868\u626c\u4e86\u6211") + "\uff1a   " + _content;
            com.alibaba.fastjson.JSONObject contentJson = new com.alibaba.fastjson.JSONObject();
            contentJson.put("data", (Object)notificationContent);
            contentJson.put("streamId", (Object)model.getId());
            ResponseObject execResult = networkNotification.dynamicNotification(this.getContext().getUID(), praisePeople, contentJson, "info", model.getId());
            if (execResult.isErr()) {
                LOGGER.info(execResult.getMsg());
            }
        }
        if (model.getStreamType().equals("5")) {
            List<NetworkTeamModel> teamList;
            if (!UtilString.isEmpty((String)teamId)) {
                List<String> userList = this.loadAllNetworkTeamMemberList(teamId);
                if (userList.size() > 0) {
                    for (String id : userList) {
                        if (UtilString.isEmpty((String)id) || userIds.contains(id + " ") || id.equals(this.getContext().getUID())) continue;
                        userIds = userIds + id + " ";
                    }
                }
            } else if (!UtilString.isEmpty((String)networkId) && (teamList = NetworkTeamCache.loadNetworkTeamBy(networkId, "1")).size() > 0) {
                for (NetworkTeamModel team : teamList) {
                    List<String> userList;
                    if (team == null || (userList = this.loadAllNetworkTeamMemberList(team.getId())).size() <= 0) continue;
                    for (String id : userList) {
                        if (UtilString.isEmpty((String)id) || userIds.contains(id + " ") || id.equals(this.getContext().getUID())) continue;
                        userIds = userIds + id + " ";
                    }
                }
            }
            networkNotification = new NetworkNotification();
            com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
            String voteContent = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u53d1\u8d77\u4e86\u4e00\u4e2a\u6295\u7968\u8c03\u67e5\u6b22\u8fce\u5404\u4f4d\u79ef\u6781\u53c2\u4e0e\u54e6");
            json.put("data", (Object)voteContent);
            json.put("sid", (Object)this.getContext().getSessionId());
            json.put("voteId", (Object)model.getId());
            networkNotification.complexNotificationVoteMessage(this.getContext().getUID(), userIds, json, "info");
        }
        if (!UtilString.isEmpty((String)createAfterAslp) && !UtilString.isEmpty((String)boId)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sid", this.getContext().getSessionId());
            params.put("streamId", model.getId());
            params.put("sourceId", model.getSourceId());
            params.put("sourceType", model.getSourceType());
            params.put("channelType", model.getChannelType());
            params.put("boId", boId);
            params.put("content", content);
            params.put("boItemId", boItemId);
            try {
                NetworkWeb.triggerASLPEvent(model.getSourceAppId(), createAfterAslp, params);
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        try {
            com.alibaba.fastjson.JSONObject jo;
            String type;
            if (SDK.getAppAPI().isActive("com.crmpaas.apps.sales") && ("CRM.SO".equals(type = (jo = com.alibaba.fastjson.JSONObject.parseObject((String)configContent)).getString("sourceType")) || "CRM.CUST".equals(type) || "CRM.CONTACTS".equals(type))) {
                String appId = "com.actionsoft.apps.network";
                String aslp = "aslp://com.crmpaas.apps.sales/ChangeFollowUpDate";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("type", type);
                params.put("sourceId", sourceId);
                params.put("sid", this.getContext().getSessionId());
                AppAPI appAPI = SDK.getAppAPI();
                appAPI.callASLP(appAPI.getAppContext(appId), aslp, params);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        result.put("stream", (Object)NetworkDataUtil.stream2JSON(model, this.getContext()));
        return result.toString();
    }

    public String loadNetworkStream(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkStreamModel model = NetworkStreamCache.getModel(id);
        if (model == null) {
            result.err();
            result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u4fe1\u606f\u4e0d\u5b58\u5728"));
            return result.toString();
        }
        result.put("streamModel", (Object)NetworkDataUtil.stream2JSON(model, this.getContext()));
        return result.toString();
    }

    public String loadNetworkStream(String networkId, String teamId, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        List<Object> stream = new ArrayList();
        try {
            if (!UtilString.isEmpty((String)networkId) && UtilString.isEmpty((String)teamId)) {
                stream = NetworkStreamCache.loadStreamOfNetwork(networkId, this.getContext().getUID());
            } else if (!UtilString.isEmpty((String)teamId)) {
                stream = NetworkStreamCache.loadStreamOfTeam(teamId);
            }
            Page page = new Page(start, limit, stream);
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
            result.put("page", page);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String getNetworkStream(String streamId, String streamCommentId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkStreamModel model = NetworkStreamCache.getModel(streamId);
            result.put("stream", (Object)NetworkDataUtil.stream2JSON(model, this.getContext()));
            if (!UtilString.isEmpty((String)streamCommentId)) {
                List<NetworkStreamCommentModel> commentList = NetworkStreamCommentCache.loadStreamComment(streamId, "3");
                UtilListSort sortList = new UtilListSort();
                sortList.sort(commentList, "createTime", "DESC");
                result.put("streamComments", (Object)NetworkDataUtil.streamComment2JSON(commentList, this.getContext()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String loadMyNetworkStream(String userId, String streamType, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<Object> streamList = new ArrayList();
            streamList = this.loadMyNetworkStream(userId, streamType);
            Page page = new Page(start, limit, streamList);
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
            result.put("page", page);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public List<NetworkStreamModel> loadMyNetworkStream(String userId, String streamType) {
        ArrayList<NetworkStreamModel> streamList = new ArrayList<NetworkStreamModel>();
        try {
            List<NetworkModel> visNwList;
            String visitor = this.getContext().getUID();
            String interviewee = userId;
            if (visitor.equals(interviewee)) {
                visNwList = NetworkCache.loadNetwork(visitor);
                for (NetworkModel networkModel : visNwList) {
                    if (networkModel == null) continue;
                    List<NetworkStreamModel> list = NetworkStreamCache.loadCreateStreamOfNetwork(networkModel.getId(), visitor);
                    streamList.addAll(list);
                }
            } else {
                visNwList = NetworkCache.loadNetwork(visitor);
                List<NetworkModel> intNwList = NetworkCache.loadNetwork(interviewee);
                for (NetworkModel network : intNwList) {
                    if (network == null || !visNwList.contains((Object)network)) continue;
                    List<NetworkStreamModel> list = NetworkStreamCache.loadCreateStreamOfNetwork(network.getId(), interviewee);
                    List<String> visTeamList = NetworkTeamMemberCache.getTeamIdListByUser(visitor);
                    for (NetworkStreamModel stream : list) {
                        if (stream == null || !UtilString.isEmpty((String)stream.getTeamId()) && !visTeamList.contains(stream.getTeamId())) continue;
                        streamList.add(stream);
                    }
                }
            }
            if (!UtilString.isEmpty((String)streamType)) {
                ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
                for (NetworkStreamModel networkStreamModel : streamList) {
                    if (networkStreamModel == null || !streamType.equals(networkStreamModel.getStreamType())) continue;
                    list.add(networkStreamModel);
                }
                streamList = list;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return streamList;
    }

    public String deleteNetworkStream(String streamId, String configContent) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkStreamModel model = NetworkStreamCache.getModel(streamId);
        String streamType = model.getStreamType();
        try {
            List<NetworkStreamCommentModel> streamCommentList;
            StreamContent sc = StreamContentHelper.format(model.getStreamContent(), Integer.parseInt(model.getStreamType()), this.getContext());
            List<AttachementFile> attachementList = sc.getAttachement();
            if (attachementList.size() > 0) {
                String groupValue = UtilDate.yearFormat((Timestamp)model.getCreateTime()) + UtilDate.monthFormat((Timestamp)model.getCreateTime());
                for (AttachementFile attachementFile : attachementList) {
                    DCContext dc = new DCContext(this.getContext(), DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", groupValue, attachementFile.getCreateUser(), attachementFile.getFileName());
                    dc.delete();
                    if ("bmp,jpg,jpeg,tiff,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,png,".contains(attachementFile.getFileType() + ",")) {
                        dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                        dc.delete();
                        continue;
                    }
                    if ("txt,doc,docx,xls,xlsx,ppt,pptx,".contains(attachementFile.getFileType() + ",")) {
                        dc.setFileName(attachementFile.getFileUUID() + ".pdf");
                        dc.delete();
                        dc.setFileName(attachementFile.getFileUUID() + ".jpg");
                        dc.delete();
                        dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                        dc.delete();
                        continue;
                    }
                    if (!"pdf".equals(attachementFile.getFileType())) continue;
                    dc.setFileName(attachementFile.getFileUUID() + ".jpg");
                    dc.delete();
                    dc.setFileName(attachementFile.getFileUUID() + "_thum.jpg");
                    dc.delete();
                }
            }
            ArrayList<String> transpondStreamIds = new ArrayList<String>();
            if (!UtilString.isEmpty((String)model.getStreamId())) {
                streamCommentList = NetworkStreamCommentCache.loadStreamCommentByTrans(streamId);
                for (NetworkStreamCommentModel streamComment : streamCommentList) {
                    transpondStreamIds.add(streamComment.getStreamId());
                    NetworkStreamCommentCache.removeById(streamComment.getId());
                }
            }
            result.put("transpondStreamIds", transpondStreamIds);
            streamCommentList = NetworkStreamCommentCache.loadStreamComment(streamId);
            for (NetworkStreamCommentModel streamComment : streamCommentList) {
                NetworkStreamCommentCache.removeById(streamComment.getId());
            }
            List<String> list = PatternUtil.matcherTopic(sc.getContent());
            Map<String, NetworkTopicModel> topicMaps = NetworkTopicCache.vailModelByName(list, model.getNetworkId(), model.getTeamId());
            Set<String> keySet = topicMaps.keySet();
            for (String topicName : keySet) {
                NetworkTopicModel topic = topicMaps.get(topicName);
                if (topic == null) continue;
                if (topic.getTopicCount() == 1) {
                    NetworkTopicCache.removeById(topic.getId());
                    continue;
                }
                topic.setTopicCount(topic.getTopicCount() - 1);
                topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                NetworkTopicCache.putModel(topic);
            }
            NetworkStreamCache.removeById(streamId);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        if (!UtilString.isEmpty((String)configContent)) {
            try {
                com.alibaba.fastjson.JSONObject configJSON = com.alibaba.fastjson.JSONObject.parseObject((String)configContent);
                if (configJSON != null) {
                    String boItemId;
                    String deleteAfterAslp = "";
                    String boId = UtilString.isEmpty((String)configJSON.getString("boId")) ? "" : configJSON.getString("boId");
                    String string = boItemId = UtilString.isEmpty((String)configJSON.getString("boItemId")) ? "" : configJSON.getString("boItemId");
                    if (configJSON.containsKey((Object)"deleteAfterAslp")) {
                        String string2 = deleteAfterAslp = UtilString.isEmpty((String)configJSON.getString("deleteAfterAslp")) ? "" : configJSON.getString("deleteAfterAslp");
                    }
                    if (!UtilString.isEmpty((String)deleteAfterAslp) && !UtilString.isEmpty((String)boId)) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put("sid", this.getContext().getSessionId());
                        hashMap.put("streamId", streamId);
                        hashMap.put("sourceId", model.getSourceId());
                        hashMap.put("sourceType", model.getSourceType());
                        hashMap.put("channelType", model.getChannelType());
                        hashMap.put("boId", boId);
                        hashMap.put("boItemId", boItemId);
                        NetworkWeb.triggerASLPEvent(model.getSourceAppId(), deleteAfterAslp, hashMap);
                    }
                }
            }
            catch (Exception e) {
                result.err();
                result.msg(e.getMessage());
                return result.toString();
            }
        }
        result.put("streamType", (Object)streamType);
        return result.toString();
    }

    public String getNetworkStreamDetail(String streamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            NetworkStreamModel originalStream;
            NetworkStreamModel transpondStream = NetworkStreamCache.getModel(streamId);
            String networkId = transpondStream.getNetworkId();
            String teamId = transpondStream.getTeamId();
            if (!UtilString.isEmpty((String)transpondStream.getStreamId())) {
                originalStream = NetworkStreamCache.getModel(transpondStream.getStreamId());
                if (originalStream == null) {
                    originalStream = transpondStream;
                }
            } else {
                originalStream = transpondStream;
                transpondStream = null;
            }
            List<NetworkTeamModel> list = NetworkTeamCache.loadNetworkTeamBy(networkId);
            com.alibaba.fastjson.JSONArray teams = new com.alibaba.fastjson.JSONArray();
            List<String> teamIds = NetworkTeamMemberCache.getTeamIdListByUser(this.getContext().getUID());
            for (NetworkTeamModel team : list) {
                if (!teamIds.contains(team.getId()) || !"1".equals(team.getTeamStatus())) continue;
                com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                json.put("id", (Object)team.getId());
                json.put("teamName", (Object)team.getTeamName());
                teams.add((Object)json);
            }
            result.put("transpondStream", (Object)transpondStream);
            result.put("originalStream", (Object)originalStream);
            result.put("networkId", (Object)networkId);
            result.put("teamId", (Object)teamId);
            result.put("transpondScope", (Object)teams);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public ResponseObject saveNetworkStreamComment(String streamId, String commentId, String commentContent, String commentType, String teamId, boolean isaslp) {
        return this.saveNetworkStreamComment(streamId, commentId, commentContent, commentType, teamId, isaslp, "0");
    }

    public ResponseObject saveNetworkStreamComment(String streamId, String commentId, String commentContent, String commentType, String teamId, boolean isaslp, String isAnonymous) {
        return this.saveNetworkStreamComment(streamId, commentId, commentContent, commentType, teamId, null, null, null, null, null, isaslp, isAnonymous);
    }

    public ResponseObject saveNetworkStreamComment(String streamId, String commentId, String commentContent, String commentType, String teamId, boolean isaslp, String sourceAppId, String sourceType, String sourceId, String isAnonymous) {
        return this.saveNetworkStreamComment(streamId, commentId, commentContent, commentType, teamId, sourceAppId, sourceType, sourceId, null, null, isaslp, isAnonymous);
    }

    public ResponseObject saveNetworkStreamComment(String streamId, String commentId, String commentContent, String commentType, String teamId, String sourceAppId, String sourceType, String sourceId, String ipAddress, String deviceType, boolean isaslp, String isAnonymous) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkStreamCommentModel model = null;
        try {
            String senderName;
            String newStreamId = UUIDGener.getUUID();
            model = new NetworkStreamCommentModel();
            model.setId(UUIDGener.getUUID());
            model.setStreamId(streamId);
            model.setCommentId(commentId);
            model.setCommentContent(commentContent);
            model.setCommentType(commentType);
            model.setAttached("0");
            model.setIpAddress(this.getContext().getClientIP());
            if (UtilString.isEmpty((String)deviceType)) {
                deviceType = this.getContext().getDeviceType();
            }
            model.setDeviceType(deviceType);
            model.setCreateUserId(this.getContext().getUID());
            model.setCreateUserName(this.getContext().getUserName());
            model.setCreateTime(new Timestamp(System.currentTimeMillis()));
            model.setIsAnonymity(isAnonymous);
            com.alibaba.fastjson.JSONArray transpondStreamIds = new com.alibaba.fastjson.JSONArray();
            if ("4".equals(commentType)) {
                model.setTransStreamId(newStreamId);
                transpondStreamIds.add((Object)streamId);
            }
            NetworkStreamCommentCache.putModel(model);
            NetworkStreamModel stream = NetworkStreamCache.getModel(streamId);
            if (!UtilString.isEmpty((String)stream.getSourceAppId()) && stream.getSourceAppId().equals("com.actionsoft.apps.coe.teamwork")) {
                AppContext teamWorkApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.coe.teamwork");
                AppContext networkApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.network");
                if (teamWorkApp != null && SDK.getAppAPI().isActive(teamWorkApp.getId())) {
                    String aslp = "aslp://com.actionsoft.apps.coe.teamwork/replyDiagramStream";
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("sid", this.getContext().getSessionId());
                    params.put("userId", this.getContext().getUID());
                    params.put("streamId", streamId);
                    params.put("message", commentContent);
                    params.put("id", model.getId());
                    params.put("teamId", teamId);
                    ResponseObject ro = SDK.getAppAPI().callASLP(networkApp, aslp, params);
                    if (!ro.isOk()) {
                        SDK.getAppAPI().err(teamWorkApp, ro.getMsg());
                    }
                }
            }
            com.alibaba.fastjson.JSONObject json = com.alibaba.fastjson.JSONObject.parseObject((String)stream.getStreamContent());
            String networkId = stream.getNetworkId();
            if ("4".equals(commentType)) {
                String streamType = "1";
                NetworkStreamModel newStream = new NetworkStreamModel();
                newStream.setId(newStreamId);
                String StreamContent2 = StreamContentHelper.format(Integer.parseInt(streamType), commentContent);
                newStream.setStreamContent(StreamContent2);
                newStream.setStreamType(streamType);
                newStream.setNetworkId(networkId);
                newStream.setTeamId(teamId);
                newStream.setIsAnonymity(isAnonymous);
                if (UtilString.isEmpty((String)stream.getStreamId())) {
                    newStream.setStreamId(stream.getId());
                } else {
                    transpondStreamIds.add((Object)stream.getStreamId());
                    newStream.setStreamId(stream.getStreamId());
                    model = new NetworkStreamCommentModel();
                    model.setId(UUIDGener.getUUID());
                    model.setStreamId(stream.getStreamId());
                    model.setTransStreamId(newStreamId);
                    model.setCommentId(commentId);
                    model.setCommentContent(commentContent);
                    model.setCommentType(commentType);
                    model.setAttached("0");
                    model.setIpAddress(this.getContext().getClientIP());
                    model.setDeviceType(deviceType);
                    model.setCreateUserId(this.getContext().getUID());
                    model.setCreateUserName(this.getContext().getUserName());
                    model.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    NetworkStreamCommentCache.putModel(model);
                }
                newStream.setAttached("0");
                if (UtilString.isEmpty((String)sourceAppId)) {
                    sourceAppId = stream.getSourceAppId();
                }
                newStream.setSourceAppId(sourceAppId);
                if (UtilString.isEmpty((String)sourceType)) {
                    sourceType = stream.getSourceType();
                }
                newStream.setSourceType(sourceType);
                if (UtilString.isEmpty((String)sourceType)) {
                    sourceType = stream.getSourceId();
                }
                newStream.setSourceId(sourceId);
                if (UtilString.isEmpty((String)ipAddress)) {
                    newStream.setIpAddress(ipAddress);
                } else {
                    newStream.setIpAddress(this.getContext().getClientIP());
                }
                newStream.setDeviceType(deviceType);
                newStream.setCreateUserId(this.getContext().getUID());
                newStream.setCreateUserName(this.getContext().getUserName());
                newStream.setOrgId(this.getContext().getCompanyModel().getId());
                newStream.setCreateTime(new Timestamp(System.currentTimeMillis()));
                newStream.setCacheed("1");
                NetworkStreamCache.putModel(newStream);
                if (isaslp) {
                    result.put("stream", (Object)NetworkDataUtil.stream2JSONOfOriginal(newStream, this.getContext()));
                } else {
                    result.put("stream", (Object)NetworkDataUtil.stream2JSON(newStream, this.getContext()));
                }
            } else if (!"3".equals(commentType) && "2".equals(commentType)) {
                FavoriteTool favorite = new FavoriteTool();
                Object title = "";
                if ("1".equals(stream.getStreamType()) || "2".equals(stream.getStreamType())) {
                    StreamContent sc = StreamContentHelper.format(stream.getStreamContent(), Integer.parseInt(stream.getStreamType()), this.getContext());
                    title = sc.getContent();
                    if (UtilString.isEmpty((String)title)) {
                        title = sc.getLink();
                    }
                    if (((String)title).length() > 100) {
                        title = ((String)title).substring(0, 100);
                    }
                } else if ("3".equals(stream.getStreamType())) {
                    StreamContentNotice notice = (StreamContentNotice)StreamContentHelper.format(stream.getStreamContent(), Integer.parseInt(stream.getStreamType()), this.getContext());
                    title = notice.getTitle();
                } else if ("4".equals(stream.getStreamType())) {
                    StreamContentPraise praise = (StreamContentPraise)StreamContentHelper.format(stream.getStreamContent(), Integer.parseInt(stream.getStreamType()), this.getContext());
                    String praisePeople = praise.getPraisePeople();
                    ORGAPI orgApi = SDK.getORGAPI();
                    String praisePeopleName = orgApi.getUserNames(praisePeople, ",");
                    title = praisePeopleName + json.getString("content");
                    if (((String)title).length() > 100) {
                        title = ((String)title).substring(0, 100);
                    }
                }
                favorite.favorite(this.getContext().getSessionId(), (String)title, model.getId());
            }
            ORGAPI orgApi = SDK.getORGAPI();
            if ("3".equals(commentType) || "4".equals(commentType)) {
                String userAlisName = PatternUtil.matcherAtUserAliasNameStr(commentContent);
                String userIds = orgApi.getUserIds(userAlisName);
                if (!UtilString.isEmpty((String)userIds)) {
                    NetworkNotification networkNotification = new NetworkNotification();
                    senderName = UtilString.isNotEmpty((String)isAnonymous) && isAnonymous.equals("1") ? I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u533f\u540d\u7528\u6237") : this.getContext().getUserModel().getUserNameAlias();
                    String notificationContent = senderName + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u63d0\u5230\u6211") + "\uff1a   " + commentContent;
                    com.alibaba.fastjson.JSONObject contentJson = new com.alibaba.fastjson.JSONObject();
                    contentJson.put("data", (Object)notificationContent);
                    contentJson.put("streamId", (Object)streamId);
                    contentJson.put("streamCommentId", (Object)model.getId());
                    ResponseObject execResult = networkNotification.dynamicNotification(this.getContext().getUID(), userIds, contentJson, "info", model.getId());
                    if (execResult.isErr()) {
                        LOGGER.info(execResult.getMsg());
                    }
                }
                List<String> topics = PatternUtil.matcherTopic(commentContent);
                Map<String, NetworkTopicModel> topicMaps = NetworkTopicCache.vailModelByName(topics, networkId, teamId);
                Set<String> keySet = topicMaps.keySet();
                for (String topicName : keySet) {
                    NetworkTopicModel topic = topicMaps.get(topicName);
                    if (topic == null) {
                        topic = new NetworkTopicModel();
                        topic.setId(UUIDGener.getUUID());
                        topic.setTopicName(topicName);
                        topic.setTopicCount(1);
                        topic.setNetworkId(networkId);
                        topic.setTeamId(teamId);
                        topic.setCreateUserId(this.getContext().getUID());
                        topic.setCreateUserName(this.getContext().getUserName());
                        topic.setCreateTime(new Timestamp(System.currentTimeMillis()));
                        topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                    } else {
                        topic.setTopicCount(topic.getTopicCount() + 1);
                        topic.setLastActive(new Timestamp(System.currentTimeMillis()));
                    }
                    NetworkTopicCache.putModel(topic);
                }
            }
            if (transpondStreamIds.size() > 0) {
                result.put("transpondStreamIds", (Object)transpondStreamIds);
            }
            if (!isaslp) {
                result.put("streamOld", (Object)NetworkDataUtil.stream2JSON(stream, this.getContext()));
            } else {
                result.put("streamOld", (Object)NetworkDataUtil.stream2JSONOfOriginal(stream, this.getContext()));
            }
            NetworkNotification networkNotification = new NetworkNotification();
            com.alibaba.fastjson.JSONObject contentJson = new com.alibaba.fastjson.JSONObject();
            contentJson.put("streamId", (Object)streamId);
            contentJson.put("streamCommentId", (Object)model.getId());
            Object content = "";
            if ("1".equals(commentType)) {
                content = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8d5e\u4e86\u4f60\u7684\u52a8\u6001") + "\uff1a" + json.getString("content");
            } else if ("2".equals(commentType)) {
                content = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6536\u85cf\u4e86\u4f60\u7684\u52a8\u6001") + "\uff1a" + json.getString("content");
            } else if ("3".equals(commentType)) {
                senderName = UtilString.isNotEmpty((String)isAnonymous) && isAnonymous.equals("1") ? I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u533f\u540d\u7528\u6237") : this.getContext().getUserModel().getUserNameAlias();
                content = senderName + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u56de\u590d\u4e86\u4f60\u7684\u52a8\u6001") + "\uff1a" + commentContent + " //" + json.getString("content");
            } else if ("4".equals(commentType)) {
                contentJson.put("streamId", (Object)newStreamId);
                senderName = UtilString.isNotEmpty((String)isAnonymous) && isAnonymous.equals("1") ? I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u533f\u540d\u7528\u6237") : this.getContext().getUserModel().getUserNameAlias();
                content = senderName + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8f6c\u53d1\u4e86\u4f60\u7684\u52a8\u6001") + "\uff1a" + commentContent + " //" + json.getString("content");
            }
            if (!stream.getCreateUserId().equals(this.getContext().getUID())) {
                contentJson.put("data", content);
                networkNotification.dynamicSimpleNotificationMessage(this.getContext().getUID(), stream.getCreateUserId(), contentJson.toString(), "info", model.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        if (isaslp) {
            result.put("streamComment", (Object)NetworkDataUtil.streamComment2JSONOfOriginal(model, this.getContext()));
        } else {
            result.put("streamComment", (Object)NetworkDataUtil.streamComment2JSON(model, this.getContext()));
        }
        return result;
    }

    public String deleteNetworkStreamComment(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkStreamCommentModel model = null;
        try {
            model = NetworkStreamCommentCache.getModel(id);
            if (model == null) {
                result.err();
                result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u8bc4\u8bba\u4fe1\u606f\u4e0d\u5b58\u5728"));
                return result.toString();
            }
            NetworkStreamCommentCache.removeById(id);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String deleteNetworkStreamCommentOperate(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkStreamCommentModel> lists = NetworkStreamCommentCache.loadStreamComment(id, this.getContext().getUID(), "1");
            if (lists.size() > 0) {
                NetworkStreamCommentModel model = null;
                for (int i = 0; i < lists.size(); ++i) {
                    model = lists.get(i);
                    if (model == null) continue;
                    NetworkStreamCommentCache.removeById(model.getId());
                }
            }
            NetworkStreamCommentCache.removeById(id);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public ResponseObject applyNetworkTeamMember(String teamId) {
        return this.applyNetworkTeamMember(teamId, null);
    }

    public ResponseObject applyNetworkTeamMember(String teamId, String deviceType) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            if (UtilString.isEmpty((String)deviceType)) {
                deviceType = this.getContext().getDeviceType();
            }
            if (!UtilString.isEmpty((String)teamId)) {
                NetworkTeamModel teamModel = NetworkTeamCache.getModel(teamId);
                if (teamModel == null) {
                    result.err();
                    result.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u5c0f\u7ec4\u4fe1\u606f\u4e0d\u5b58\u5728"));
                    return result;
                }
                result.put("team", (Object)NetworkDataUtil.team2JSON(teamModel, this.getContext()));
            }
            ORGAPI orgApi = SDK.getORGAPI();
            NetworkNotification networkNotification = new NetworkNotification();
            NetworkTeamMemberModel model = new NetworkTeamMemberModel();
            model.setId(UUIDGener.getUUID());
            model.setTeamId(teamId);
            model.setUserId(this.getContext().getUID());
            model.setJoinType("2");
            model.setMemberType("2");
            model.setMemberStatus("0");
            model.setJoinStatus("1");
            model.setCreateUserId(this.getContext().getUID());
            model.setCreateUserName(this.getContext().getUserName());
            UserModel user = UserCache.getModel((String)model.getUserId());
            if (user == null || user.isClosed()) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u6ce8\u9500"));
                return result;
            }
            NetworkTeamMemberModel oldModel = NetworkTeamMemberCache.getModel(model.getTeamId(), model.getUserId());
            NetworkTeamModel team = NetworkTeamCache.getModel(teamId);
            if (oldModel != null && "2".equals(oldModel.getJoinStatus()) && oldModel.getMemberStatus().equals("1")) {
                result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5c0f\u7ec4") + "\uff08" + team.getTeamName() + "\uff09" + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u4e2d\u5df2\u5b58\u5728\u8be5\u6210\u5458") + "\uff08" + user.getUserName() + "\uff09");
            } else if (oldModel != null) {
                oldModel.setMemberStatus("0");
                oldModel.setJoinStatus("1");
                NetworkTeamMemberCache.putModel(oldModel);
                com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                String content = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u7533\u8bf7\u52a0\u5165") + team.getTeamName();
                json.put("data", (Object)content);
                json.put("sid", (Object)this.getContext().getSessionId());
                json.put("memberId", (Object)oldModel.getId());
                json.put("memberType", (Object)model.getMemberType());
                json.put("memberStatus", (Object)model.getMemberStatus());
                String teamManager = this.loadAllNetworkTeamMembermanager(teamId);
                networkNotification.complexNotificationMessage(this.getContext().getUID(), teamManager, json, "info", oldModel.getId());
            } else {
                com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                json.put("sid", (Object)this.getContext().getSessionId());
                json.put("memberId", (Object)model.getId());
                json.put("memberType", (Object)model.getMemberType());
                json.put("memberStatus", (Object)model.getMemberStatus());
                String targetIds = this.loadAllNetworkTeamMembermanager(teamId);
                NetworkTeamMemberCache.putModel(model);
                if (team.getTeamType().equals("1")) {
                    model.setMemberStatus("1");
                    model.setJoinStatus("2");
                    NetworkTeamMemberCache.putModel(model);
                    String content = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5df2\u6210\u529f\u52a0\u5165") + team.getTeamName();
                    networkNotification.simpleNotificationMessage(this.getContext().getUID(), team.getCreateUserId(), content, "info", model.getId());
                    NetworkStreamModel stream = new NetworkStreamModel();
                    stream.setId(UUIDGener.getUUID());
                    StringBuffer stramContent = new StringBuffer();
                    stramContent.append(orgApi.getUserAliasNames(model.getUserId())).append(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u52a0\u5165\u5c0f\u7ec4")).append(team.getTeamName());
                    String streamContext = StreamContentHelper.format(Integer.parseInt("1"), stramContent.toString());
                    stream.setStreamContent(streamContext);
                    stream.setStreamType("1");
                    if (team != null) {
                        stream.setTeamId(team.getId());
                        stream.setNetworkId(team.getNetworkId());
                    }
                    stream.setAttached("0");
                    stream.setIpAddress(this.getContext().getClientIP());
                    stream.setDeviceType(deviceType);
                    stream.setCreateUserId(this.getContext().getUID());
                    stream.setCreateUserName(this.getContext().getUserName());
                    stream.setOrgId(this.getContext().getCompanyModel().getId());
                    stream.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    stream.setCacheed("1");
                    NetworkStreamCache.putModel(stream);
                } else {
                    String content = this.getContext().getUserModel().getUserNameAlias() + I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u7533\u8bf7\u52a0\u5165") + team.getTeamName();
                    json.put("data", (Object)content);
                    json.put("deviceType", (Object)deviceType);
                    networkNotification.complexNotificationMessage(this.getContext().getUID(), targetIds, json, "info", model.getId());
                }
                model.setLastActive(new Timestamp(System.currentTimeMillis()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result;
    }

    public String loadNetworkStreamComment(String streamId, String commentId, String commentType) {
        ResponseObject result = ResponseObject.newOkResponse();
        ArrayList<NetworkStreamCommentModel> streamCommentList = new ArrayList();
        try {
            if (!UtilString.isEmpty((String)streamId)) {
                streamCommentList = NetworkStreamCommentCache.loadStreamComment(streamId, commentType);
            }
            UtilListSort sortList = new UtilListSort();
            sortList.sort(streamCommentList, "createTime", "DESC");
            result.put("commentList", (Object)NetworkDataUtil.streamComment2JSON(streamCommentList, this.getContext()));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String loadNetworkPraise(String streamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        List<Object> streamList = new ArrayList();
        boolean flag = false;
        try {
            streamList = NetworkStreamCommentCache.loadStreamComment(streamId, "2");
            result.put("favoritesSize", (Object)streamList.size());
            if (streamList.size() > 0) {
                for (NetworkStreamCommentModel networkStreamCommentModel : streamList) {
                    if (networkStreamCommentModel == null || !networkStreamCommentModel.getCreateUserId().equals(this.getContext().getUID())) continue;
                    flag = true;
                    break;
                }
            }
            result.put("isFavoritesPost", (Object)flag);
            streamList = new ArrayList();
            streamList = NetworkStreamCommentCache.loadStreamComment(streamId, "1");
            result.put("praiseSize", (Object)streamList.size());
            flag = false;
            if (streamList.size() > 0) {
                for (NetworkStreamCommentModel networkStreamCommentModel : streamList) {
                    if (networkStreamCommentModel == null || !networkStreamCommentModel.getCreateUserId().equals(this.getContext().getUID())) continue;
                    flag = true;
                    break;
                }
            }
            result.put("isPraisePost", (Object)flag);
            streamList = new ArrayList();
            streamList = NetworkStreamCommentCache.loadStreamComment(streamId, "3");
            result.put("replysSize", (Object)streamList.size());
            streamList = new ArrayList();
            streamList = NetworkStreamCommentCache.loadStreamComment(streamId, "4");
            result.put("transpondSize", (Object)streamList.size());
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public String geNetworktNav(String networkId, String type) {
        ResponseObject result = ResponseObject.newOkResponse();
        com.alibaba.fastjson.JSONArray metroNavs = new com.alibaba.fastjson.JSONArray();
        try {
            List<String> funIds = this.loadAllNetworkAppListData(networkId);
            List<TeamAppProfile> appList = TeamAppManager.getList();
            if (appList.size() > 0) {
                for (int i = 0; i < appList.size(); ++i) {
                    TeamAppProfile model = appList.get(i);
                    AppContext appContext = model.getAppContext();
                    boolean isActive = SDK.getAppAPI().isActive(appContext);
                    if (appContext == null || !isActive) continue;
                    com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                    json.put("id", (Object)model.getId());
                    json.put("name", (Object)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)model.getTitle()));
                    json.put("icon", (Object)model.getIcon());
                    json.put("networkId", (Object)networkId);
                    List<String> teamIds = NetworkAppAccessCache.loadTeamIdsBy(model.getId(), networkId);
                    if (teamIds.size() > 0) {
                        json.put("type", (Object)true);
                    } else {
                        json.put("type", (Object)false);
                    }
                    if (!UtilString.isEmpty((String)type)) {
                        if (!funIds.contains(model.getId())) continue;
                        metroNavs.add((Object)json);
                        continue;
                    }
                    if (funIds.contains(model.getId())) continue;
                    metroNavs.add((Object)json);
                }
            }
            result.put("metroNavs", (Object)metroNavs);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    public ResponseObject geNetworktTeamNav(String networkId, String teamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        List<Object> lists = new ArrayList();
        ArrayList<String> tooBarIdList = new ArrayList<String>();
        com.alibaba.fastjson.JSONArray appArray = new com.alibaba.fastjson.JSONArray();
        try {
            List<TeamAppProfile> appList;
            com.alibaba.fastjson.JSONObject json;
            boolean isActive;
            AppContext appContext;
            TeamAppProfile model;
            lists = NetworkAppToolBarCache.loadAllNetworkAppToolBar(teamId, this.getContext().getUID());
            UtilListSort sortList = new UtilListSort();
            sortList.sort(lists, "orderNo", "ASC");
            if (lists.size() > 0) {
                for (NetworkAppToolBarModel networkAppToolBarModel : lists) {
                    if (networkAppToolBarModel == null || (model = TeamAppManager.getProfile(networkAppToolBarModel.getAppId().trim())) == null || tooBarIdList.contains(networkAppToolBarModel.getAppId().trim())) continue;
                    appContext = model.getAppContext();
                    isActive = SDK.getAppAPI().isActive(appContext);
                    if (appContext == null || !isActive) continue;
                    json = new com.alibaba.fastjson.JSONObject();
                    json.put("id", (Object)model.getId());
                    json.put("name", (Object)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)model.getTitle()));
                    json.put("icon", (Object)model.getIcon());
                    json.put("functionId", (Object)model.getId());
                    json.put("isShow", (Object)networkAppToolBarModel.getIsShow());
                    json.put("appContentId", (Object)appContext.getId());
                    appArray.add((Object)json);
                    tooBarIdList.add(networkAppToolBarModel.getAppId().trim());
                }
            }
            if ((appList = TeamAppManager.getList()).size() > 0) {
                void var9_12;
                boolean bl = false;
                while (var9_12 < appList.size()) {
                    model = appList.get((int)var9_12);
                    if (model != null && !tooBarIdList.contains(model.getId())) {
                        appContext = model.getAppContext();
                        isActive = SDK.getAppAPI().isActive(appContext);
                        if (appContext != null && isActive) {
                            json = new com.alibaba.fastjson.JSONObject();
                            json.put("id", (Object)model.getId());
                            json.put("name", (Object)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)model.getTitle()));
                            json.put("icon", (Object)model.getIcon());
                            json.put("functionId", (Object)model.getId());
                            json.put("isShow", (Object)"0");
                            json.put("appContentId", (Object)appContext.getId());
                            List<NetworkAppListModel> networkAppList = NetworkAppListCache.loadAllNetwork(model.getId(), networkId);
                            List<NetworkAppAccessModel> appLists = NetworkAppAccessCache.loadAllNetworkAppAccessBy(model.getId(), teamId);
                            List<NetworkAppAccessModel> list = NetworkAppAccessCache.loadAllNetworkAppAccessByApp(model.getId(), networkId);
                            if (networkAppList.size() > 0) {
                                if (appLists.size() > 0) {
                                    appArray.add((Object)json);
                                } else if (list.size() == 0) {
                                    appArray.add((Object)json);
                                } else {
                                    List<String> teamIdList = NetworkAppAccessCache.loadTeamIdsBy(model.getId(), networkId);
                                    if (teamIdList.contains(teamId) && list.size() > 0) {
                                        appArray.add((Object)json);
                                    }
                                }
                            }
                        }
                    }
                    ++var9_12;
                }
            }
            result.put("metroNavs", (Object)appArray);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result;
    }

    public String openAppNav(String teamId, String id) {
        try {
            TeamAppProfile model = TeamAppManager.getProfile(id);
            if (model != null) {
                Class mainClass = ClassReflect.forName((String)model.getMainClass(), (String)model.getAppContext().getId());
                Method execute = mainClass.getMethod("getHome", String.class);
                return (String)execute.invoke(mainClass.newInstance(), teamId);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return null;
    }

    public String loadNetworkStreamOfNotices(String networkId, String teamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<Object> streamList = new ArrayList();
            streamList = UtilString.isEmpty((String)teamId) ? NetworkStreamCache.loadNoticeStreamOfNetwork(networkId, this.getContext().getUID()) : NetworkStreamCache.loadNoticeStreamOfTeam(teamId);
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamList, "createTime", "asc");
            Page page = new Page(0, 10, streamList);
            result.put("streamList", (Object)NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String loadNetworkStreamOfParise(String networkId, String teamId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<Object> streamList = new ArrayList();
            streamList = UtilString.isEmpty((String)teamId) ? NetworkStreamCache.loadPraiseStreamOfNetwork(networkId, this.getContext().getUID()) : NetworkStreamCache.loadPraiseStreamOfTeam(teamId);
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamList, "createTime", "asc");
            Page page = new Page(0, 10, streamList);
            result.put("streamList", (Object)NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String loadNetworkStreamOfSource(String sourceId, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<Object> streamList = new ArrayList();
            streamList = NetworkStreamCache.getStreamOfSourceId(sourceId);
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamList, "createTime", "DESC");
            Page page = new Page(start, limit, streamList);
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
            result.put("page", page);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err();
            result.msg(e.getMessage());
        }
        return result.toString();
    }

    public List<NetworkStreamModel> loadNetworkStreamBySource(String sourceType, String sourceDeptId) {
        ArrayList<NetworkStreamModel> streamList = new ArrayList();
        try {
            streamList = NetworkStreamCache.loadStreamOfSourceType(sourceType, sourceDeptId, this.getContext().getUID());
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamList, "createTime", "DESC");
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return streamList;
    }

    public String loadNetworkStreamOfChannelType(String sourceType, String sourceDeptId, String channelType, String searchVal, boolean isBoss, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        List<Object> streamList = new ArrayList();
        ArrayList<Object> streamArray = new ArrayList<Object>();
        try {
            String userId = this.getContext().getUID();
            streamList = isBoss ? NetworkStreamCache.getStreamBySourceType(sourceType) : NetworkStreamCache.loadStreamOfSourceType(sourceType, sourceDeptId, userId);
            if (streamList.size() > 0) {
                if (!UtilString.isEmpty((String)channelType)) {
                    for (NetworkStreamModel model : streamList) {
                        if (model == null || !model.getChannelType().equals(channelType)) continue;
                        streamArray.add((Object)model);
                    }
                } else {
                    streamArray.addAll(streamList);
                }
                if (!UtilString.isEmpty((String)searchVal)) {
                    streamList.clear();
                    streamList.addAll(streamArray);
                    streamArray.clear();
                    if (streamList.size() > 0) {
                        for (NetworkStreamModel model : streamList) {
                            if (model == null || model.getSourceType().indexOf(searchVal) <= -1 && model.getSrcObjectContent().indexOf(searchVal) <= -1 && model.getStreamContent().indexOf(searchVal) <= -1 && model.getCreateUserId().indexOf(searchVal) <= -1) continue;
                            streamArray.add((Object)model);
                        }
                    }
                }
            }
            UtilListSort listSort = new UtilListSort();
            listSort.sort(streamArray, "createTime", "DESC");
            Page page = new Page(start, limit, streamArray);
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
            result.put("page", page);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }

    public static String valiTeamType(String teamType) {
        String result = null;
        if (!UtilString.isEmpty((String)teamType)) {
            int number = Integer.parseInt(teamType);
            switch (number) {
                case 1: {
                    result = "\u516c\u5171\u5c0f\u7ec4";
                    break;
                }
                case 2: {
                    result = "\u79c1\u6709\u5c0f\u7ec4";
                    break;
                }
                case 3: {
                    result = "\u79d8\u5bc6\u5c0f\u7ec4";
                }
            }
        }
        return result;
    }

    public String loadJoinTeams(String networkId) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            UtilListSort sortTeamList = new UtilListSort();
            List<NetworkTeamModel> list = NetworkTeamCache.loadNetworkTeamBy(networkId);
            ArrayList<NetworkTeamModel> teamList = new ArrayList<NetworkTeamModel>();
            List<String> teamIds = NetworkTeamMemberCache.getTeamIdListByUser(this.getContext().getUID());
            for (NetworkTeamModel team : list) {
                if (team == null || this.getContext().isSaaSModel() || !"2".equals(team.getTeamType()) && !team.getTeamType().equals("1") || !team.getTeamStatus().equals("1") || teamIds.contains(team.getId())) continue;
                teamList.add(team);
            }
            sortTeamList.sort(teamList, "lastActive", "desc");
            result.put("teamList", (Object)NetworkDataUtil.team2JSON(teamList, this.getContext()));
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public com.alibaba.fastjson.JSONArray findNetworkTopic(String value, int limit, String networkId, String teamId) {
        if (limit == 0) {
            limit = 10;
        }
        if (!UtilString.isEmpty((String)value)) {
            value = value.replace("#", "");
        }
        com.alibaba.fastjson.JSONArray topicArray = new com.alibaba.fastjson.JSONArray();
        List<NetworkTopicModel> topicList = NetworkTopicCache.loadTopicOfNetwork(networkId);
        try {
            int len = topicList.size();
            for (int i = 0; i < len && topicArray.size() < limit; ++i) {
                NetworkTopicModel topic = topicList.get(i);
                if (topic == null || !UtilString.isEmpty((String)value) && !topic.getTopicName().contains(value)) continue;
                com.alibaba.fastjson.JSONObject json = new com.alibaba.fastjson.JSONObject();
                json.put("id", (Object)topic.getId());
                json.put("name", (Object)topic.getTopicName());
                topicArray.add((Object)json);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return topicArray;
    }

    public String loadNetworkTopic(String networkId, String teamId, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        ArrayList<Object> topicList = new ArrayList<Object>();
        List<Object> tempList = new ArrayList();
        List<NetworkModel> networkList = NetworkCache.loadNetwork(this.getContext().getUID());
        for (NetworkModel netowrk : networkList) {
            if (netowrk == null || (tempList = NetworkTopicCache.loadTopicOfNetwork(netowrk.getId())) == null || tempList.size() <= 0) continue;
            topicList.addAll(tempList);
        }
        UtilListSort sortList = new UtilListSort();
        sortList.sort(topicList, "topicName", "asc");
        sortList.sort(topicList, "topicCount", "desc");
        Page page = new Page(start, limit, topicList);
        page.setList(NetworkDataUtil.topic2JSON(page.getListModel(), this.getContext()));
        result.put("page", page);
        return result.toString();
    }

    public String loadNetworkTopicOfMine(int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        List<NetworkTopicModel> topicList = NetworkTopicCache.loadTopicOfUser(this.getContext().getUID());
        UtilListSort sortList = new UtilListSort();
        sortList.sort(topicList, "topicName", "asc");
        sortList.sort(topicList, "topicCount", "desc");
        Page<NetworkTopicModel> page = new Page<NetworkTopicModel>(start, limit, topicList);
        page.setList(NetworkDataUtil.topic2JSON(page.getListModel(), this.getContext()));
        result.put("page", page);
        return result.toString();
    }

    public String getNetworkTopicByName(String topicName) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkTopicModel topic = NetworkTopicCache.getTopicByName(topicName);
        result.put("topic", (Object)NetworkDataUtil.topic2JSON(topic, this.getContext()));
        return result.toString();
    }

    public String loadNetworkStreamOfTopic(String topicId, int start, int limit) {
        ResponseObject result = ResponseObject.newOkResponse();
        List<Object> stream = new ArrayList();
        try {
            NetworkTopicModel topic = NetworkTopicCache.getModel(topicId);
            if (topic != null) {
                stream = NetworkStreamCache.loadStreamOfTopic(topic.getNetworkId() + "_" + topic.getTopicName());
                Page page = new Page(start, limit, stream);
                page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
                result.put("page", page);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String searchAtSomeone(String networkId, String value, int limit) {
        return NetworkDataUtil.searchUsersOfNetwork(networkId, value, limit, this.getContext()).toString();
    }

    public String loadAtMe(int start, int limit, boolean unRead) {
        ResponseObject result = ResponseObject.newOkResponse();
        Object resourceIdStr = new String();
        List<Object> stream = new ArrayList();
        try {
            Page<Object> page = null;
            if (unRead) {
                page = this.loadUnreadStream(limit);
            } else {
                List<NetworkStreamModel> praisestream;
                List<NetworkStreamModel> notifierstream;
                stream = NetworkStreamCache.loadStreamOfAtUser(this.getContext().getUID());
                List<NetworkStreamCommentModel> commentList = NetworkStreamCommentCache.loadStreamCommentOfAtUser(this.getContext().getUID());
                if (commentList.size() > 0) {
                    for (Object commentModel : commentList) {
                        String streamId = commentModel.getStreamId();
                        NetworkStreamModel streamModel = NetworkStreamCache.getModel(streamId);
                        if (streamModel == null || stream.contains((Object)streamModel)) continue;
                        stream.add((Object)streamModel);
                    }
                }
                if ((notifierstream = NetworkStreamCache.loadStreamOfNotifier(this.getContext().getUID())).size() > 0) {
                    for (NetworkStreamModel notifier : notifierstream) {
                        if (notifier == null || stream.contains((Object)notifier)) continue;
                        stream.add((Object)notifier);
                    }
                }
                if ((praisestream = NetworkStreamCache.loadStreamOfPraiseUser(this.getContext().getUID())).size() > 0) {
                    for (NetworkStreamModel pr : praisestream) {
                        if (pr == null || stream.contains((Object)pr)) continue;
                        stream.add((Object)pr);
                    }
                }
                Collections.sort(stream, new Comparator<NetworkStreamModel>(){

                    @Override
                    public int compare(NetworkStreamModel o1, NetworkStreamModel o2) {
                        return o2.getCreateTime().compareTo(o1.getCreateTime());
                    }
                });
                page = new Page<Object>(start, limit, stream);
            }
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
            com.alibaba.fastjson.JSONArray array = page.getList();
            if (array.size() > 0) {
                for (int i = 0; i < array.size(); ++i) {
                    com.alibaba.fastjson.JSONObject model = array.getJSONObject(i);
                    if (model == null || ((String)resourceIdStr).contains(model.get((Object)"id").toString())) continue;
                    resourceIdStr = (String)resourceIdStr + model.get((Object)"id").toString() + ",";
                }
                if (((String)resourceIdStr).length() > 0) {
                    this.readStreamUnreadMessage((String)resourceIdStr);
                }
            }
            result.put("page", page);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String getNetworkFileSave(UserContext me, String uid, int x, int y, int w, int h, String fileName, String groupValue) {
        DCContext dc = new DCContext(this.getContext(), DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!network-logo"), "com.actionsoft.apps.network", groupValue, this.getContext().getUID(), (String)fileName);
        File f = null;
        if (dc != null) {
            f = new File(dc.getFilePath());
        }
        if (f != null) {
            try {
                FileInputStream input = new FileInputStream(f);
                String postfix = ((String)fileName).substring(((String)fileName).lastIndexOf("."), ((String)fileName).length());
                String uuid = UUIDGener.getUUID();
                fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf("."));
                fileName = uuid + postfix;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                UtilIO.copyAndCloseInput((InputStream)input, (OutputStream)output);
                ByteArrayInputStream binput = new ByteArrayInputStream(output.toByteArray());
                Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(this.getFileExt(f.getName()));
                ImageReader reader = readers.next();
                reader.setInput(ImageIO.createImageInputStream(binput), true);
                ImageReadParam param = reader.getDefaultReadParam();
                param.setSourceRegion(new Rectangle(x, y, w, h));
                BufferedImage bi = reader.read(0, param);
                FileOutputStream outStream = new FileOutputStream(f);
                ImageIO.write((RenderedImage)bi, this.getFileExt(f.getName()), outStream);
                dc.setFileName(f.getName());
                outStream.close();
                DCContext dcc = new DCContext(this.getContext(), DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!network-logo"), "com.actionsoft.apps.network", groupValue, this.getContext().getUID(), f.getName());
                return dcc.getDownloadURL();
            }
            catch (IOException e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            }
        }
        return null;
    }

    public String loadTeamByStream(String streamId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            ArrayList<NetworkTeamModel> tmpList;
            NetworkStreamModel stream = NetworkStreamCache.getModel(streamId);
            if (stream != null) {
                List<NetworkTeamModel> teamList = NetworkTeamCache.loadNetworkTeamBy(stream.getNetworkId());
                tmpList = new ArrayList<NetworkTeamModel>();
                List<String> teamIds = NetworkTeamMemberCache.getTeamIdListByUser(this.getContext().getUID());
                for (NetworkTeamModel team : teamList) {
                    if (team == null || !teamIds.contains(team.getId())) continue;
                    tmpList.add(team);
                }
            } else {
                ro.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u8be5\u52a8\u6001\u5df2\u4e0d\u5b58\u5728"));
                return ro.toString();
            }
            UtilListSort sort = new UtilListSort();
            sort.sort(tmpList, "teamName", "asc");
            ro.put("teams", (Object)NetworkDataUtil.team2JSON(tmpList, this.getContext()));
            ro.put("teamId", (Object)stream.getTeamId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ro.toString();
    }

    public String resolveAtURL(String url) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String srcURL = "";
        try {
            if (!UtilString.isEmpty((String)url) && url.indexOf("@") > -1) {
                srcURL = SDK.getRuleAPI().executeAtScript(url, this.getContext());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        ro.put("srcURL", (Object)srcURL);
        return ro.toString();
    }

    public String storageMyDriver(String groupValue, String fileValue, String fileName, String fileActName, int fileSize) {
        LOGGER.error("network:storageMyDriver");
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            DCContext dc = new DCContext(this.getContext(), DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)"!stream-file-"), "com.actionsoft.apps.network", groupValue, fileValue, fileName);
            if (dc == null || !dc.existFile()) {
                ro.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728"));
                LOGGER.error("network:\u6587\u4ef6\u4e0d\u5b58\u5728");
                return ro.toString();
            }
            MydriverTool tool = new MydriverTool();
            ro = tool.storage(this.getContext().getSessionId(), fileActName, dc, fileSize);
            if (ro.isOk()) {
                ro.msg(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6587\u4ef6\u5df2\u8f6c\u5b58\u5230\u4f01\u4e1a\u7f51\u76d8"));
                LOGGER.error("network:\u6587\u4ef6\u5df2\u8f6c\u5b58\u5230\u4f01\u4e1a\u7f51\u76d8");
            }
        }
        catch (Exception e) {
            LOGGER.error("network:" + e.getMessage(), (Throwable)e);
            ro.err(e.getMessage());
        }
        LOGGER.error("network:" + ro.toString());
        return ro.toString();
    }

    private String getFileExt(String fn) {
        int pos = fn.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return fn.substring(pos + 1);
    }

    public ResponseObject addVote(String voteId, String data, String txtVoteTitle, String txtVoteMemo, String txtEndTime, String networkId, String teamId) throws Exception {
        AppContext voteApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.vote");
        ResponseObject result = ResponseObject.newOkResponse();
        if (voteApp != null && SDK.getAppAPI().isActive(voteApp.getId())) {
            String aslp = "aslp://com.actionsoft.apps.vote/createVote";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sid", this.getContext().getSessionId());
            params.put("voteId", voteId);
            params.put("data", data);
            params.put("txtVoteTitle", txtVoteTitle);
            params.put("voteResult", "1");
            params.put("txtVoteMemo", txtVoteMemo);
            params.put("txtEndTime", txtEndTime);
            params.put("voteType", "1");
            params.put("voteStatus", "2");
            params.put("isSocial", "1");
            params.put("networkId", networkId);
            params.put("teamId", teamId);
            result = SDK.getAppAPI().callASLP(voteApp, aslp, params);
            if (!result.isOk()) {
                SDK.getAppAPI().err(voteApp, result.getMsg());
            }
        }
        return result;
    }

    public boolean checkPostVote(String voteId) throws Exception {
        boolean isPostVote = false;
        AppContext voteApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.vote");
        if (voteApp != null && SDK.getAppAPI().isActive(voteApp.getId())) {
            String aslp = "aslp://com.actionsoft.apps.vote/checkPostVote";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sid", this.getContext().getSessionId());
            params.put("voteId", voteId);
            ResponseObject ro = SDK.getAppAPI().callASLP(voteApp, aslp, params);
            if (!ro.isOk()) {
                SDK.getAppAPI().err(voteApp, ro.getMsg());
            } else {
                isPostVote = (Boolean)ro.get("isVote");
            }
        }
        return isPostVote;
    }

    public String terminationVote(String voteId, String voteStatus) throws Exception {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext voteApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.vote");
        if (voteApp != null && SDK.getAppAPI().isActive(voteApp.getId())) {
            String aslp = "aslp://com.actionsoft.apps.vote/terminationVote";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sid", this.getContext().getSessionId());
            params.put("voteId", voteId);
            params.put("voteStatus", voteStatus);
            ro = SDK.getAppAPI().callASLP(voteApp, aslp, params);
            if (!ro.isOk()) {
                SDK.getAppAPI().err(voteApp, ro.getMsg());
            }
        }
        return ro.toString();
    }

    public String readStreamUnreadMessage(String resourceId) throws Exception {
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
            AppContext networkApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.network");
            if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
                String aslp2 = "aslp://com.actionsoft.apps.notification/readMessageBySourceId";
                HashMap<String, String> paramArray = new HashMap<String, String>();
                paramArray.put("sid", this.getContext().getSessionId());
                paramArray.put("sourceId", resourceId);
                ro = SDK.getAppAPI().callASLP(networkApp, aslp2, paramArray);
                if (!ro.isOk()) {
                    SDK.getAppAPI().err(notificationApp, ro.getMsg());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return ro.toString();
    }

    public Page<NetworkStreamModel> loadUnreadStream(int limit) throws Exception {
        ArrayList<NetworkStreamModel> list = new ArrayList<NetworkStreamModel>();
        Page<NetworkStreamModel> page = new Page<NetworkStreamModel>(0, limit, list);
        AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
        AppContext networkApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.network");
        if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
            String aslp = "aslp://com.actionsoft.apps.notification/queryUnreadMessageBySysName";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sid", this.getContext().getSessionId());
            params.put("systemName", "\u5de5\u4f5c\u7f51\u7edc\u52a8\u6001\u63d0\u9192");
            params.put("start", 0);
            params.put("limit", limit);
            ResponseObject ro = SDK.getAppAPI().callASLP(networkApp, aslp, params);
            if (!ro.isOk()) {
                SDK.getAppAPI().err(notificationApp, ro.getMsg());
            } else {
                com.alibaba.fastjson.JSONObject result = ro.toJSONObject();
                com.alibaba.fastjson.JSONObject data = result.getJSONObject("data");
                if (data == null) {
                    return page;
                }
                int pageCount = data.get((Object)"pageCount") == null ? 0 : Integer.parseInt(data.get((Object)"pageCount").toString());
                com.alibaba.fastjson.JSONArray messageList = com.alibaba.fastjson.JSONArray.parseArray((String)com.alibaba.fastjson.JSONObject.toJSONString((Object)data.get((Object)"list")));
                int len = messageList.size();
                for (int i = 0; i < len; ++i) {
                    NetworkStreamModel stream;
                    String streamId;
                    com.alibaba.fastjson.JSONObject json = messageList.getJSONObject(i);
                    String string = streamId = json.get((Object)"sourceId") == null ? "" : json.getString("sourceId");
                    if (streamId.equals("") || (stream = NetworkStreamCache.getModel(streamId)) == null) continue;
                    list.add(stream);
                }
                if (list.size() < limit && pageCount > limit) {
                    page.setPageCount(pageCount - (limit - list.size()));
                } else {
                    page.setPageCount(pageCount);
                }
                page.setListModel(list);
            }
        }
        return page;
    }

    public int queryStreamUnreadMessageCount() throws Exception {
        ResponseObject result = ResponseObject.newOkResponse();
        int count = 0;
        try {
            AppContext notificationApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.notification");
            AppContext networkApp = SDK.getAppAPI().getAppContext("com.actionsoft.apps.network");
            if (notificationApp != null && SDK.getAppAPI().isActive(notificationApp.getId())) {
                String aslp = "aslp://com.actionsoft.apps.notification/queryUnreadMessageCountBySysName";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("sid", this.getContext().getSessionId());
                params.put("systemName", "\u5de5\u4f5c\u7f51\u7edc\u52a8\u6001\u63d0\u9192");
                ResponseObject ro = SDK.getAppAPI().callASLP(networkApp, aslp, params);
                if (!ro.isOk()) {
                    SDK.getAppAPI().err(notificationApp, ro.getMsg());
                } else {
                    count = Integer.parseInt(ro.get("count").toString());
                }
            }
        }
        catch (Exception e) {
            result.err();
            result.msg(e.getMessage());
        }
        return count;
    }

    public String queryStreamUnreadMessage() throws Exception {
        ResponseObject result = ResponseObject.newOkResponse();
        int count = 0;
        try {
            count = this.queryStreamUnreadMessageCount();
        }
        catch (Exception e) {
            result.err();
            result.msg(e.getMessage());
        }
        result.put("unReadMessageSize", (Object)count);
        return result.toString();
    }

    public ResponseObject getStreamSourceType() {
        ResponseObject result = ResponseObject.newOkResponse();
        AppAPI appApi = SDK.getAppAPI();
        ArrayList<String> sourceTypeList = new ArrayList<String>();
        try {
            String[] sourceType;
            int len;
            String streamSourceType = appApi.getProperty("com.actionsoft.apps.network", "streamSourceType");
            if (!UtilString.isEmpty((String)streamSourceType) && (len = (sourceType = streamSourceType.split(" ")).length) > 0) {
                for (int i = 0; i < len; ++i) {
                    String model = sourceType[i];
                    if (UtilString.isEmpty((String)model)) continue;
                    sourceTypeList.add(model);
                }
            }
            result.put("sourceTypeList", sourceTypeList);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err();
            result.msg(e.getMessage());
        }
        return result;
    }

    public static void triggerASLPEvent(String sourceAppId, String aslp, Map<String, Object> params) throws Exception {
        try {
            AppContext resourceApp = SDK.getAppAPI().getAppContext(sourceAppId);
            if (resourceApp != null && SDK.getAppAPI().isActive(resourceApp.getId())) {
                SDK.getAppAPI().asynCallASLP(resourceApp, aslp, params);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
    }

    public String openFile(UserContext me, String repositoryName, String groupValue, String fileValue, String fileName, String fileNameOriginal, String isShowDefaultToolbar, String isCopy, String isPrint, String isDownload) {
        DCContext sourceDc = new DCContext(me, DCProfileManager.getDCProfile((String)"com.actionsoft.apps.network", (String)repositoryName), "com.actionsoft.apps.network", groupValue, fileValue, fileName);
        boolean isEncrypt = DCUtil.isHighSecurityStorage((String)repositoryName);
        HashMap<String, String> extendeds = new HashMap<String, String>();
        extendeds.put("fileNameOriginal", fileNameOriginal);
        extendeds.put("isShowDefaultToolbar", isShowDefaultToolbar);
        extendeds.put("isCopy", isCopy);
        extendeds.put("isPrint", isPrint);
        extendeds.put("isDownload", isDownload);
        return UtilDoc.filePreview((UserContext)me, (DCContext)sourceDc, (boolean)isEncrypt, extendeds);
    }

    public ResponseObject openFileMobile(UserContext me, String repositoryName, String groupValue, String fileValue, String fileName, String fileNameOriginal, String isShowDefaultToolbar, String isCopy, String isPrint, String isDownload) {
        ResponseObject result = ResponseObject.newOkResponse();
        if (SDK.getAppAPI().isActive("com.actionsoft.apps.addons.onlinedoc")) {
            AppAPI appAPI = SDK.getAppAPI();
            String sourceAppId = "com.actionsoft.apps.network";
            boolean isEncrypt = DCUtil.isHighSecurityStorage((String)repositoryName);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("sid", me.getSessionId());
            params.put("fileNameOriginal", fileNameOriginal);
            DCContext sourceDc = new DCContext(me, DCProfileManager.getDCProfile((String)sourceAppId, (String)repositoryName), sourceAppId, groupValue, fileValue, fileName);
            params.put("sourceDc", sourceDc);
            params.put("isShowDefaultToolbar", isShowDefaultToolbar);
            params.put("isCopy", isCopy);
            params.put("isPrint", isPrint);
            params.put("isDownload", isDownload);
            params.put("isEncrypt", isEncrypt);
            ResponseObject responseObject = appAPI.callASLP(appAPI.getAppContext(sourceAppId), "aslp://com.actionsoft.apps.addons.onlinedoc/filePreview", params);
            if (responseObject != null) {
                if (responseObject.isOk()) {
                    String url = responseObject.get("url").toString();
                    result.put("url", (Object)url);
                } else {
                    result = ResponseObject.newErrResponse((String)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6587\u6863\u8f6c\u6362\u670d\u52a1\u4e0d\u53ef\u7528"));
                }
            }
        } else {
            result = ResponseObject.newErrResponse((String)I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u6587\u6863\u8f6c\u6362\u670d\u52a1\u4e0d\u53ef\u7528"));
        }
        return result;
    }

    public String getUserAddressList(UserContext me, String userIds) {
        String[] ids;
        ResponseObject result = ResponseObject.newOkResponse();
        if (!UtilString.isEmpty((String)userIds) && (ids = userIds.split(",")).length > 0) {
            com.alibaba.fastjson.JSONArray array = new com.alibaba.fastjson.JSONArray();
            for (int i = 0; i < ids.length; ++i) {
                String uid = ids[i];
                UserModel user = UserCache.getModel((String)uid);
                array.add((Object)user);
            }
            result.put("userInfo", (Object)array);
        }
        return result.toString();
    }

    public String loadMyFavorite(int start, int limit) {
        ResponseObject ro = ResponseObject.newOkResponse();
        ArrayList stream = new ArrayList();
        try {
            Page<NetworkStreamModel> page = null;
            List<NetworkStreamModel> streamList = new ArrayList<NetworkStreamModel>();
            List<NetworkStreamCommentModel> streamCommentList = NetworkStreamCommentCache.loadStreamCommentByCreateUserDesc(this.getContext().getUID());
            for (NetworkStreamCommentModel comment : streamCommentList) {
                if (!"2".equals(comment.getCommentType())) continue;
                streamList.add(NetworkStreamCache.getModel(comment.getStreamId()));
            }
            if (limit > 0) {
                page = new Page<NetworkStreamModel>(start, limit, streamList);
                streamList = page.getListModel();
                ro.put("start", (Object)page.getStart());
                ro.put("limit", (Object)page.getLimit());
                ro.put("pageCount", (Object)page.getPageCount());
            }
            com.alibaba.fastjson.JSONArray teams = NetworkDataUtil.stream2JSONOfOriginal(streamList, this.getContext());
            page.setList(NetworkDataUtil.stream2JSON(page.getListModel(), this.getContext()));
            ro.put("page", page);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            ro.err(e.getMessage());
        }
        return ro.toString();
    }

    public String deleteNetworkStreamCommentFavorite(String id) {
        ResponseObject result = ResponseObject.newOkResponse();
        try {
            List<NetworkStreamCommentModel> lists = NetworkStreamCommentCache.loadStreamComment(id, this.getContext().getUID(), "2");
            if (lists.size() > 0) {
                NetworkStreamCommentModel model = null;
                for (int i = 0; i < lists.size(); ++i) {
                    model = lists.get(i);
                    if (model == null) continue;
                    NetworkStreamCommentCache.removeById(model.getId());
                }
            }
            NetworkStreamCommentCache.removeById(id);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            result.err(e.getMessage());
        }
        return result.toString();
    }

    public String updateNetworkAnonymity(UserContext ctx, String networkId, String isAnonymous) {
        ResponseObject result = ResponseObject.newOkResponse();
        NetworkModel networkModel = NetworkCache.getModel(networkId);
        if (networkModel == null) {
            return result.err(I18nRes.findValue((String)"com.actionsoft.apps.network", (String)"\u5de5\u4f5c\u7f51\u7edc\u4e0d\u5b58\u5728")).toString();
        }
        try {
            networkModel.setIsAnonymity(isAnonymous);
            NetworkCache.putModel(networkModel);
        }
        catch (Exception e) {
            result.err(e.getMessage());
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return result.toString();
    }
}

