/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.sdk.local.SDK;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
public class testController {
    private static final Logger logger = LoggerFactory.getLogger(testController.class);
    private static final String RICH_TEXT_FIELD = "RESOLUTION";
    private static final String BO_TABLE = "BO_EU_DNSDK_TASK";
    private static final String CONTENT_SEPARATOR = "<br/><br/>";
    private static final String PARAGRAPH_START = "<p>";
    private static final String PARAGRAPH_END = "</p>";

    @Mapping(value="com.awspaas.user.apps.donenow_tst_updatex")
    public ResponseObject updateResolution(UserContext uc, String id, String newSolution) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseObject.newErrResponse((String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)newSolution)) {
            return ResponseObject.newErrResponse((String)"newSolution\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BO bo = SDK.getBOAPI().get(BO_TABLE, id);
            if (bo == null) {
                logger.warn("\u672a\u627e\u5230ID\u4e3a\u3010{}\u3011\u7684\u8bb0\u5f55\uff0c\u65e0\u6cd5\u83b7\u53d6\u5bcc\u6587\u672c\u5185\u5bb9", (Object)id);
                return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230ID\u4e3a\u3010" + id + "\u3011\u7684\u8bb0\u5f55"));
            }
            String currentContent = bo.getString(RICH_TEXT_FIELD);
            currentContent = StringUtils.defaultString((String)currentContent).trim();
            logger.debug("\u83b7\u53d6\u5230ID\u4e3a\u3010{}\u3011\u7684\u5bcc\u6587\u672c\u539f\u59cb\u5185\u5bb9\uff1a{}", (Object)id, (Object)currentContent);
            String formattedNewContent = this.formatNewContent(newSolution);
            String finalContent = this.\u62fc\u63a5\u5185\u5bb9(currentContent, formattedNewContent);
            bo.set(RICH_TEXT_FIELD, (Object)finalContent);
            int updateCount = SDK.getBOAPI().update(BO_TABLE, bo);
            if (updateCount <= 0) {
                logger.warn("ID\u4e3a\u3010{}\u3011\u7684\u5bcc\u6587\u672c\u66f4\u65b0\u5931\u8d25", (Object)id);
                return ResponseObject.newErrResponse((String)"\u5bcc\u6587\u672c\u66f4\u65b0\u5931\u8d25\uff0c\u65e0\u6709\u6548\u53d8\u66f4");
            }
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("id", id);
            result.put("originalContent", currentContent);
            result.put("updatedContent", finalContent);
            result.put("updateTime", System.currentTimeMillis());
            ResponseObject response = ResponseObject.newOkResponse();
            response.setData(result);
            return response;
        }
        catch (Exception e) {
            logger.error("\u5bcc\u6587\u672c\u66f4\u65b0\u5f02\u5e38\uff0cID:{}", (Object)id, (Object)e);
            return ResponseObject.newErrResponse((String)("\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private String \u62fc\u63a5\u5185\u5bb9(String currentContent, String newContent) {
        if (currentContent.isEmpty()) {
            return newContent;
        }
        if (currentContent.endsWith(PARAGRAPH_END)) {
            int endIndex = currentContent.lastIndexOf(PARAGRAPH_END);
            return currentContent.substring(0, endIndex) + newContent + PARAGRAPH_END;
        }
        return currentContent + CONTENT_SEPARATOR + newContent;
    }

    private String formatNewContent(String newContent) {
        String trimmedContent = newContent.trim();
        if (trimmedContent.startsWith(PARAGRAPH_START) && trimmedContent.endsWith(PARAGRAPH_END)) {
            return trimmedContent;
        }
        return PARAGRAPH_START + trimmedContent + PARAGRAPH_END;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_tst_updatestatus")
    public ResponseObject updateStatus(UserContext uc, String id, String status) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseObject.newErrResponse((String)"\u5de5\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)status)) {
            return ResponseObject.newErrResponse((String)"\u72b6\u6001\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BO bo = SDK.getBOAPI().get(BO_TABLE, id);
            if (bo == null) {
                return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230ID\u4e3a\u3010" + id + "\u3011\u7684\u8bb0\u5f55"));
            }
            bo.set("STATUS_ID", (Object)status);
            int updateCount = SDK.getBOAPI().update(BO_TABLE, bo);
            if (updateCount <= 0) {
                return ResponseObject.newErrResponse((String)("ID\u4e3a\u3010" + id + "\u3011\u7684\u72b6\u6001\u66f4\u65b0\u5931\u8d25"));
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("id", id);
            result.put("updatedStatus", status);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(result);
            return responseObject;
        }
        catch (Exception e) {
            return ResponseObject.newErrResponse((String)("\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

