/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt;

import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PeriodCalculationUtil {
    private static final Logger LOGGERU;
    public static final String PERIOD_TYPE_ONCE = "609";
    public static final String PERIOD_TYPE_MONTH = "610";
    public static final String PERIOD_TYPE_QUARTER = "611";
    public static final String PERIOD_TYPE_HALFYEAR = "612";
    public static final String PERIOD_TYPE_YEAR = "613";
    private static final DateTimeFormatter DATE_FORMATTER;
    private static final DateTimeFormatter MONTH_FORMATTER;

    private PeriodCalculationUtil() {
        throw new AssertionError((Object)"\u5de5\u5177\u7c7b\u4e0d\u5141\u8bb8\u5b9e\u4f8b\u5316");
    }

    public static List<Period> getPeriodListByConfig(String ruleCate, LocalDate contractStartDate, LocalDate periodBeginDate, LocalDate periodEndDate, String CALC_METHOD_1STPERIOD, String CALC_METHOD_1STYEAR, String MONTH_1STQUARTER) {
        boolean isNaturalMonth = true;
        boolean userMonthDay = true;
        int monthDayType = 0;
        int startMonth = 0;
        if (CALC_METHOD_1STPERIOD.equals("4599")) {
            switch (MONTH_1STQUARTER) {
                case "4642": {
                    startMonth = 1;
                    break;
                }
                case "4643": {
                    startMonth = 11;
                    break;
                }
                case "4644": {
                    startMonth = 12;
                    break;
                }
                default: {
                    startMonth = 0;
                }
            }
        }
        switch (CALC_METHOD_1STPERIOD) {
            case "4601": 
            case "4596": 
            case "4593": 
            case "4590": {
                monthDayType = -1;
                break;
            }
            case "4597": 
            case "4594": 
            case "4591": {
                monthDayType = -2;
            }
        }
        if (ruleCate.equals(PERIOD_TYPE_YEAR)) {
            isNaturalMonth = false;
            boolean bl = userMonthDay = !"4637".equals(CALC_METHOD_1STYEAR);
        }
        if (ruleCate.equals(PERIOD_TYPE_HALFYEAR)) {
            isNaturalMonth = false;
        }
        isNaturalMonth = CALC_METHOD_1STPERIOD.equals("4601");
        return PeriodCalculationUtil.getPeriodList(ruleCate, contractStartDate, periodBeginDate, periodEndDate, isNaturalMonth, userMonthDay, monthDayType, startMonth);
    }

    public static List<Period> getPeriodList(String ruleCate, LocalDate contractStartDate, LocalDate periodBeginDate, LocalDate periodEndDate, boolean isNaturalMonth, boolean userMonthDay, int monthDayType, int startMonth) {
        LOGGERU.info("\u3010\u5468\u671f\u8ba1\u7b97\u3011\u5f00\u59cb\u751f\u6210\u5468\u671f\u5217\u8868");
        LOGGERU.info("\u3010\u5468\u671f\u8ba1\u7b97\u3011\u53c2\u6570\uff1aruleCate=" + ruleCate + ", contractStartDate=" + contractStartDate + ", periodBeginDate=" + periodBeginDate + ", periodEndDate=" + periodEndDate + ", isNaturalMonth=" + isNaturalMonth + ", userMonthDay=" + userMonthDay + ", monthDayType=" + monthDayType + ",startMonth=" + startMonth);
        LOGGERU.info("\u5468\u671f\u5f00\u59cb\u65e5\u671f--\u8ba1\u7b97\u524d\uff1a" + contractStartDate);
        if (!PeriodCalculationUtil.validateParams(ruleCate, contractStartDate, periodBeginDate, periodEndDate)) {
            return null;
        }
        ArrayList<Period> periodList = new ArrayList<Period>();
        if (PERIOD_TYPE_ONCE.equals(ruleCate)) {
            Period oncePeriod = new Period();
            oncePeriod.setPeriodBeginDate(periodBeginDate);
            oncePeriod.setPeriodEndDate(periodEndDate);
            oncePeriod.setRate(BigDecimal.ONE);
            periodList.add(oncePeriod);
            return periodList;
        }
        if (!isNaturalMonth && contractStartDate.getDayOfMonth() != 1) {
            if (monthDayType == -1) {
                contractStartDate = contractStartDate.with(TemporalAdjusters.firstDayOfMonth());
            } else if (monthDayType == -2) {
                contractStartDate = contractStartDate.with(TemporalAdjusters.firstDayOfNextMonth());
            } else if (monthDayType > 0) {
                int totalDays = contractStartDate.lengthOfMonth();
                LocalDate localDate = contractStartDate = monthDayType > totalDays ? LocalDate.of(contractStartDate.getYear(), contractStartDate.getMonth(), totalDays) : LocalDate.of(contractStartDate.getYear(), contractStartDate.getMonth(), monthDayType);
            }
        }
        if (startMonth > 0) {
            contractStartDate = PeriodCalculationUtil.getClosestPeriodStartDate(contractStartDate, startMonth);
        }
        LOGGERU.info("\u5468\u671f\u5f00\u59cb\u65e5\u671f--\u8ba1\u7b97\u540e\uff1a" + contractStartDate);
        LocalDate startDate = null;
        LocalDate currLastDay = null;
        int totalPeriodDays = 0;
        switch (ruleCate) {
            case "610": {
                if (isNaturalMonth) {
                    currLastDay = PeriodCalculationUtil.getNaturalMonthLastDay(periodBeginDate);
                    totalPeriodDays = periodBeginDate.lengthOfMonth();
                    break;
                }
                currLastDay = PeriodCalculationUtil.getActualMonthFirstEndDay(contractStartDate, periodBeginDate, periodEndDate);
                totalPeriodDays = PeriodCalculationUtil.getActualMonthTotalDays(contractStartDate, periodBeginDate);
                break;
            }
            case "611": {
                if (isNaturalMonth) {
                    currLastDay = PeriodCalculationUtil.getNaturalQuarterLastDay(periodBeginDate);
                    totalPeriodDays = PeriodCalculationUtil.getDaysInCurrentQuarter(periodBeginDate);
                    break;
                }
                currLastDay = PeriodCalculationUtil.getActualQuarterFirstEndDay(contractStartDate, periodBeginDate, periodEndDate);
                totalPeriodDays = PeriodCalculationUtil.getActualQuarterTotalDays(contractStartDate, periodBeginDate);
                break;
            }
            case "612": {
                if (isNaturalMonth) {
                    currLastDay = PeriodCalculationUtil.getNaturalHalfYearLastDay(periodBeginDate);
                    totalPeriodDays = PeriodCalculationUtil.getDaysInCurrentHalfYear(periodBeginDate);
                    break;
                }
                currLastDay = PeriodCalculationUtil.getActualHalfYearFirstEndDay(contractStartDate, periodBeginDate, periodEndDate);
                totalPeriodDays = PeriodCalculationUtil.getActualHalfYearTotalDays(contractStartDate, periodBeginDate);
                break;
            }
            case "613": {
                if (isNaturalMonth) {
                    currLastDay = PeriodCalculationUtil.getNaturalYearLastDay(periodBeginDate);
                    totalPeriodDays = periodBeginDate.lengthOfYear();
                    break;
                }
                currLastDay = PeriodCalculationUtil.getActualYearFirstEndDay(contractStartDate, periodBeginDate, periodEndDate);
                totalPeriodDays = PeriodCalculationUtil.getActualYearTotalDays(contractStartDate, periodBeginDate);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5468\u671f\u7c7b\u578b\uff1a" + ruleCate);
            }
        }
        if (currLastDay != null && !currLastDay.equals(periodBeginDate)) {
            if (userMonthDay) {
                Period period = new Period();
                period.setPeriodBeginDate(periodBeginDate);
                period.setPeriodEndDate(currLastDay);
                period.setRate(PeriodCalculationUtil.divideToBigDecimal(PeriodCalculationUtil.getDateRate(periodBeginDate, currLastDay, false), (Object)PeriodCalculationUtil.GetPeriodMonth(ruleCate)));
                periodList.add(period);
            } else {
                Period firstPeriod = PeriodCalculationUtil.buildPeriod(periodBeginDate, currLastDay, totalPeriodDays);
                periodList.add(firstPeriod);
            }
            startDate = currLastDay.plusDays(1L);
        } else {
            startDate = periodBeginDate;
        }
        if (startDate != null && !startDate.isAfter(periodEndDate)) {
            while (!startDate.isAfter(periodEndDate)) {
                LocalDate nextPeriodStart = PeriodCalculationUtil.getNextPeriodStart(startDate, ruleCate);
                LocalDate periodEnd = nextPeriodStart.minusDays(1L);
                BigDecimal rate = BigDecimal.ONE;
                if (periodEnd.isAfter(periodEndDate)) {
                    if (userMonthDay) {
                        rate = PeriodCalculationUtil.divideToBigDecimal(PeriodCalculationUtil.getDateRate(startDate, periodEndDate, false), (Object)PeriodCalculationUtil.GetPeriodMonth(ruleCate));
                    } else {
                        int actualDays = PeriodCalculationUtil.getPeriodDays(startDate, periodEndDate);
                        int fullPeriodDays = PeriodCalculationUtil.getPeriodDays(startDate, periodEnd);
                        rate = PeriodCalculationUtil.divideToBigDecimal(actualDays, fullPeriodDays);
                    }
                    periodEnd = periodEndDate;
                }
                Period cyclePeriod = new Period();
                cyclePeriod.setPeriodBeginDate(startDate);
                cyclePeriod.setPeriodEndDate(periodEnd);
                cyclePeriod.setRate(rate);
                periodList.add(cyclePeriod);
                startDate = periodEnd.plusDays(1L);
            }
        }
        LOGGERU.info("\u5468\u671f\u5217\u8868\u4e2a\u6570\uff1a" + periodList.size());
        LOGGERU.info("\u5468\u671f\u5217\u8868\uff1a" + JSON.toJSONString(periodList));
        return periodList;
    }

    public static LocalDate getClosestPeriodStartDate(LocalDate contractStartDate, int startMonth) {
        Objects.requireNonNull(contractStartDate, "\u5408\u540c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (startMonth < 1 || startMonth > 12) {
            throw new IllegalArgumentException("\u8d77\u59cb\u6708\u4efd\u5fc5\u987b\u57281-12\u4e4b\u95f4");
        }
        long totalMonths = (long)(contractStartDate.getYear() - 1970) * 12L + (long)(contractStartDate.getMonthValue() - 1);
        long baseMonth = startMonth - 1;
        long periodIndex = (totalMonths - baseMonth) / 3L;
        if (totalMonths - baseMonth < 0L && (totalMonths - baseMonth) % 3L != 0L) {
            --periodIndex;
        }
        long periodStartTotal = baseMonth + 3L * periodIndex;
        int year = 1970 + (int)(periodStartTotal / 12L);
        int month = (int)(periodStartTotal % 12L) + 1;
        return LocalDate.of(year, month, 1);
    }

    public static List<Period> getAdjustPeriodList(String ruleCate, LocalDate lastPeriodBeginDate, LocalDate lastPeriodEndDate, boolean userMonthDay, LocalDate newEndDate) {
        ArrayList<Period> periodList = new ArrayList<Period>();
        if (lastPeriodEndDate.equals(newEndDate)) {
            return null;
        }
        if (lastPeriodEndDate.isAfter(newEndDate)) {
            if (userMonthDay) {
                Period period = new Period();
                period.setPeriodBeginDate(lastPeriodBeginDate);
                period.setPeriodEndDate(newEndDate);
                period.setRate(PeriodCalculationUtil.divideToBigDecimal(PeriodCalculationUtil.getDateRate(lastPeriodBeginDate, newEndDate, false), (Object)PeriodCalculationUtil.GetPeriodMonth(ruleCate)));
                periodList.add(period);
            } else {
                periodList.add(PeriodCalculationUtil.buildPeriod(lastPeriodBeginDate, lastPeriodEndDate, PeriodCalculationUtil.getPeriodDays(lastPeriodBeginDate, lastPeriodEndDate)));
            }
        } else {
            LocalDate currPeriodEnd = PeriodCalculationUtil.getNextPeriodStart(lastPeriodBeginDate, ruleCate).minusDays(1L);
            if (currPeriodEnd.isAfter(lastPeriodEndDate)) {
                lastPeriodEndDate = newEndDate;
                if (userMonthDay) {
                    Period period = new Period();
                    period.setPeriodBeginDate(lastPeriodBeginDate);
                    period.setPeriodEndDate(currPeriodEnd);
                    period.setRate(PeriodCalculationUtil.divideToBigDecimal(PeriodCalculationUtil.getDateRate(lastPeriodBeginDate, currPeriodEnd, false), (Object)PeriodCalculationUtil.GetPeriodMonth(ruleCate)));
                    periodList.add(period);
                } else {
                    periodList.add(PeriodCalculationUtil.buildPeriod(lastPeriodBeginDate, lastPeriodEndDate, PeriodCalculationUtil.getPeriodDays(lastPeriodBeginDate, currPeriodEnd)));
                }
                return periodList;
            }
            LocalDate startDate = lastPeriodBeginDate;
            if (startDate != null && !startDate.isAfter(newEndDate)) {
                while (!startDate.isAfter(newEndDate)) {
                    LocalDate nextPeriodStart = PeriodCalculationUtil.getNextPeriodStart(startDate, ruleCate);
                    LocalDate periodEnd = nextPeriodStart.minusDays(1L);
                    BigDecimal rate = BigDecimal.ONE;
                    if (periodEnd.isAfter(newEndDate)) {
                        if (userMonthDay) {
                            rate = PeriodCalculationUtil.divideToBigDecimal(PeriodCalculationUtil.getDateRate(startDate, newEndDate, false), (Object)PeriodCalculationUtil.GetPeriodMonth(ruleCate));
                        } else {
                            int actualDays = PeriodCalculationUtil.getPeriodDays(startDate, newEndDate);
                            int fullPeriodDays = PeriodCalculationUtil.getPeriodDays(startDate, periodEnd);
                            rate = PeriodCalculationUtil.divideToBigDecimal(actualDays, fullPeriodDays);
                        }
                        periodEnd = newEndDate;
                    }
                    Period cyclePeriod = new Period();
                    cyclePeriod.setPeriodBeginDate(startDate);
                    cyclePeriod.setPeriodEndDate(periodEnd);
                    cyclePeriod.setRate(rate);
                    periodList.add(cyclePeriod);
                    startDate = periodEnd.plusDays(1L);
                }
            }
        }
        return periodList;
    }

    private static boolean validateParams(String ruleCate, LocalDate contractStartDate, LocalDate periodBeginDate, LocalDate periodEndDate) {
        if (StringUtils.isBlank((CharSequence)ruleCate)) {
            LOGGERU.info("\u5468\u671f\u7c7b\u578b\uff08ruleCate\uff09\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (contractStartDate == null) {
            LOGGERU.info("\u5408\u540c\u5f00\u59cb\u65e5\u671f\uff08contractStartDate\uff09\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (periodBeginDate == null) {
            LOGGERU.info("\u670d\u52a1\u5f00\u59cb\u65e5\u671f\uff08periodBeginDate\uff09\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (periodEndDate == null) {
            LOGGERU.info("\u670d\u52a1\u7ed3\u675f\u65e5\u671f\uff08periodEndDate\uff09\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        if (periodBeginDate.isAfter(periodEndDate)) {
            LOGGERU.info("\u670d\u52a1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u670d\u52a1\u7ed3\u675f\u65e5\u671f");
            return false;
        }
        return true;
    }

    private static LocalDate getNaturalMonthLastDay(LocalDate periodBeginDate) {
        return periodBeginDate.getDayOfMonth() != 1 ? periodBeginDate.with(TemporalAdjusters.lastDayOfMonth()) : periodBeginDate.plusMonths(1L).minusDays(1L);
    }

    private static LocalDate getNaturalQuarterLastDay(LocalDate periodBeginDate) {
        Month endMonth = PeriodCalculationUtil.getQuarterEndMonth(periodBeginDate.getMonth());
        return LocalDate.of(periodBeginDate.getYear(), endMonth, endMonth.length(periodBeginDate.isLeapYear()));
    }

    private static LocalDate getNaturalHalfYearLastDay(LocalDate periodBeginDate) {
        Month endMonth = PeriodCalculationUtil.getHalfYearEndMonth(periodBeginDate.getMonth());
        return LocalDate.of(periodBeginDate.getYear(), endMonth, endMonth.length(periodBeginDate.isLeapYear()));
    }

    private static LocalDate getNaturalYearLastDay(LocalDate periodBeginDate) {
        return periodBeginDate.getDayOfMonth() != 1 || periodBeginDate.getMonthValue() != 1 ? LocalDate.of(periodBeginDate.getYear(), 12, 31) : periodBeginDate.plusYears(1L).minusDays(1L);
    }

    private static LocalDate getActualMonthFirstEndDay(LocalDate contractStartDate, LocalDate periodBeginDate, LocalDate periodEndDate) {
        LocalDate endDay;
        if (contractStartDate.isAfter(periodBeginDate)) {
            endDay = contractStartDate.minusDays(1L);
        } else if (contractStartDate.isBefore(periodBeginDate)) {
            endDay = contractStartDate.plusMonths(1L);
            while (endDay.isBefore(periodBeginDate)) {
                endDay = endDay.plusMonths(1L);
            }
            endDay = endDay.minusDays(1L);
        } else {
            return null;
        }
        return endDay.isAfter(periodEndDate) ? periodEndDate : endDay;
    }

    private static int getActualMonthTotalDays(LocalDate contractStartDate, LocalDate periodBeginDate) {
        if (contractStartDate.isAfter(periodBeginDate)) {
            return PeriodCalculationUtil.getPeriodDays(contractStartDate.minusMonths(1L), contractStartDate.minusDays(1L));
        }
        return PeriodCalculationUtil.getPeriodDays(contractStartDate, contractStartDate.plusMonths(1L).minusDays(1L));
    }

    private static LocalDate getActualQuarterFirstEndDay(LocalDate contractStartDate, LocalDate periodBeginDate, LocalDate periodEndDate) {
        LocalDate endDay;
        if (contractStartDate.isAfter(periodBeginDate)) {
            endDay = contractStartDate.minusDays(1L);
        } else if (contractStartDate.isBefore(periodBeginDate)) {
            endDay = contractStartDate.plusMonths(3L);
            while (endDay.isBefore(periodBeginDate)) {
                endDay = endDay.plusMonths(3L);
            }
            endDay = endDay.minusDays(1L);
        } else {
            return null;
        }
        return endDay.isAfter(periodEndDate) ? periodEndDate : endDay;
    }

    private static int getActualQuarterTotalDays(LocalDate contractStartDate, LocalDate periodBeginDate) {
        if (contractStartDate.isAfter(periodBeginDate)) {
            return PeriodCalculationUtil.getPeriodDays(contractStartDate.minusMonths(3L), contractStartDate.minusDays(1L));
        }
        return PeriodCalculationUtil.getPeriodDays(contractStartDate, contractStartDate.plusMonths(3L).minusDays(1L));
    }

    private static LocalDate getActualHalfYearFirstEndDay(LocalDate contractStartDate, LocalDate periodBeginDate, LocalDate periodEndDate) {
        LocalDate endDay;
        if (contractStartDate.isAfter(periodBeginDate)) {
            endDay = contractStartDate.minusDays(1L);
        } else if (contractStartDate.isBefore(periodBeginDate)) {
            endDay = contractStartDate.plusMonths(6L);
            while (endDay.isBefore(periodBeginDate)) {
                endDay = endDay.plusMonths(6L);
            }
            endDay = endDay.minusDays(1L);
        } else {
            return null;
        }
        return endDay.isAfter(periodEndDate) ? periodEndDate : endDay;
    }

    private static int getActualHalfYearTotalDays(LocalDate contractStartDate, LocalDate periodBeginDate) {
        if (contractStartDate.isAfter(periodBeginDate)) {
            return PeriodCalculationUtil.getPeriodDays(contractStartDate.minusMonths(6L), contractStartDate.minusDays(1L));
        }
        return PeriodCalculationUtil.getPeriodDays(contractStartDate, contractStartDate.plusMonths(6L).minusDays(1L));
    }

    private static LocalDate getActualYearFirstEndDay(LocalDate contractStartDate, LocalDate periodBeginDate, LocalDate periodEndDate) {
        LocalDate endDay;
        if (contractStartDate.isAfter(periodBeginDate)) {
            endDay = contractStartDate.minusDays(1L);
        } else if (contractStartDate.isBefore(periodBeginDate)) {
            endDay = contractStartDate.plusMonths(12L);
            while (endDay.isBefore(periodBeginDate)) {
                endDay = endDay.plusMonths(12L);
            }
            endDay = endDay.minusDays(1L);
        } else {
            return null;
        }
        return endDay.isAfter(periodEndDate) ? periodEndDate : endDay;
    }

    private static int getActualYearTotalDays(LocalDate contractStartDate, LocalDate periodBeginDate) {
        if (contractStartDate.isAfter(periodBeginDate)) {
            return PeriodCalculationUtil.getPeriodDays(contractStartDate.minusMonths(12L), contractStartDate.minusDays(1L));
        }
        return PeriodCalculationUtil.getPeriodDays(contractStartDate, contractStartDate.plusMonths(12L).minusDays(1L));
    }

    private static Period buildPeriod(LocalDate beginDate, LocalDate endDate, int totalPeriodDays) {
        Period period = new Period();
        period.setPeriodBeginDate(beginDate);
        period.setPeriodEndDate(endDate);
        int actualDays = PeriodCalculationUtil.getPeriodDays(beginDate, endDate);
        period.setRate(PeriodCalculationUtil.divideToBigDecimal(actualDays, totalPeriodDays));
        return period;
    }

    public static LocalDate getNextPeriodStart(LocalDate currentStart, String periodType) {
        switch (periodType) {
            case "610": {
                return currentStart.plus(1L, ChronoUnit.MONTHS);
            }
            case "611": {
                return currentStart.plus(3L, ChronoUnit.MONTHS);
            }
            case "612": {
                return currentStart.plus(6L, ChronoUnit.MONTHS);
            }
            case "613": {
                return currentStart.plus(1L, ChronoUnit.YEARS);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u5468\u671f\u7c7b\u578b\uff1a" + periodType);
    }

    public static int getPeriodDays(LocalDate start, LocalDate end) {
        if (start.isAfter(end)) {
            throw new IllegalArgumentException("\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        return (int)ChronoUnit.DAYS.between(start, end) + 1;
    }

    public static BigDecimal divideToBigDecimal(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("\u5206\u6bcd\u4e0d\u80fd\u4e3a\u96f6");
        }
        return new BigDecimal(numerator).divide(new BigDecimal(denominator), 10, RoundingMode.HALF_UP);
    }

    public static BigDecimal divideToBigDecimal(Object numerator, Object denominator) {
        BigDecimal num = PeriodCalculationUtil.toBigDecimal(numerator);
        BigDecimal den = PeriodCalculationUtil.toBigDecimal(denominator);
        if (den.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArithmeticException("\u5206\u6bcd\u4e0d\u80fd\u4e3a\u96f6");
        }
        return num.divide(den, 10, RoundingMode.HALF_UP);
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Number) {
            return new BigDecimal(obj.toString());
        }
        if (obj instanceof String) {
            try {
                return new BigDecimal((String)obj);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal: " + obj, e);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u8f6c\u6362: " + obj.getClass().getName());
    }

    private static Month getQuarterEndMonth(Month month) {
        switch (month.getValue()) {
            case 1: {
                return Month.MARCH;
            }
            case 2: {
                return Month.MARCH;
            }
            case 3: {
                return Month.MARCH;
            }
            case 4: {
                return Month.JUNE;
            }
            case 5: {
                return Month.JUNE;
            }
            case 6: {
                return Month.JUNE;
            }
            case 7: {
                return Month.SEPTEMBER;
            }
            case 8: {
                return Month.SEPTEMBER;
            }
            case 9: {
                return Month.SEPTEMBER;
            }
            case 10: {
                return Month.DECEMBER;
            }
            case 11: {
                return Month.DECEMBER;
            }
            case 12: {
                return Month.DECEMBER;
            }
        }
        throw new IllegalArgumentException("\u975e\u6cd5\u7684\u6708\u4efd\u503c\uff1a" + month.getValue());
    }

    public static int GetPeriodMonth(String period) {
        switch (period) {
            case "610": {
                return 1;
            }
            case "611": {
                return 3;
            }
            case "612": {
                return 6;
            }
            case "613": {
                return 12;
            }
        }
        return 0;
    }

    private static Month getQuarterStartMonth(Month month) {
        switch (month.getValue()) {
            case 1: {
                return Month.JANUARY;
            }
            case 2: {
                return Month.JANUARY;
            }
            case 3: {
                return Month.JANUARY;
            }
            case 4: {
                return Month.APRIL;
            }
            case 5: {
                return Month.APRIL;
            }
            case 6: {
                return Month.APRIL;
            }
            case 7: {
                return Month.JULY;
            }
            case 8: {
                return Month.JULY;
            }
            case 9: {
                return Month.JULY;
            }
            case 10: {
                return Month.OCTOBER;
            }
            case 11: {
                return Month.OCTOBER;
            }
            case 12: {
                return Month.OCTOBER;
            }
        }
        throw new IllegalArgumentException("\u975e\u6cd5\u7684\u6708\u4efd\u503c\uff1a" + month.getValue());
    }

    private static Month getHalfYearEndMonth(Month month) {
        return month.getValue() <= 6 ? Month.JUNE : Month.DECEMBER;
    }

    private static Month getHalfYearStartMonth(Month month) {
        return month.getValue() <= 6 ? Month.JANUARY : Month.JULY;
    }

    public static int getDaysInCurrentQuarter(LocalDate date) {
        Month startMonth = PeriodCalculationUtil.getQuarterStartMonth(date.getMonth());
        Month endMonth = PeriodCalculationUtil.getQuarterEndMonth(date.getMonth());
        LocalDate quarterStart = LocalDate.of(date.getYear(), startMonth, 1);
        LocalDate quarterEnd = LocalDate.of(date.getYear(), endMonth, endMonth.length(date.isLeapYear()));
        return PeriodCalculationUtil.getPeriodDays(quarterStart, quarterEnd);
    }

    public static int getDaysInCurrentHalfYear(LocalDate date) {
        Month startMonth = PeriodCalculationUtil.getHalfYearStartMonth(date.getMonth());
        Month endMonth = PeriodCalculationUtil.getHalfYearEndMonth(date.getMonth());
        LocalDate halfYearStart = LocalDate.of(date.getYear(), startMonth, 1);
        LocalDate halfYearEnd = LocalDate.of(date.getYear(), endMonth, endMonth.length(date.isLeapYear()));
        return PeriodCalculationUtil.getPeriodDays(halfYearStart, halfYearEnd);
    }

    public static BigDecimal getDateRate(LocalDate start, LocalDate end, boolean use30DaysPerMonth) {
        if (start.isAfter(end)) {
            return BigDecimal.ZERO;
        }
        int startYear = start.getYear();
        int startMonth = start.getMonthValue();
        int endYear = end.getYear();
        int endMonth = end.getMonthValue();
        if (startYear == endYear && startMonth == endMonth) {
            int totalDaysInMonth = use30DaysPerMonth ? 30 : start.lengthOfMonth();
            int daysBetween = end.getDayOfMonth() - start.getDayOfMonth() + 1;
            return BigDecimal.valueOf(daysBetween).divide(BigDecimal.valueOf(totalDaysInMonth), 10, RoundingMode.HALF_UP);
        }
        int startMonthTotalDays = use30DaysPerMonth ? 30 : start.lengthOfMonth();
        int startRemainingDays = startMonthTotalDays - start.getDayOfMonth() + 1;
        BigDecimal startRatio = BigDecimal.valueOf(startRemainingDays).divide(BigDecimal.valueOf(startMonthTotalDays), 10, RoundingMode.HALF_UP);
        int fullMonths = 0;
        int currentYear = startYear;
        int currentMonth = startMonth + 1;
        if (currentMonth > 12) {
            currentMonth = 1;
            ++currentYear;
        }
        int endPrevYear = endYear;
        int endPrevMonth = endMonth - 1;
        if (endPrevMonth < 1) {
            endPrevMonth = 12;
            --endPrevYear;
        }
        while (currentYear < endPrevYear || currentYear == endPrevYear && currentMonth <= endPrevMonth) {
            ++fullMonths;
            if (++currentMonth <= 12) continue;
            currentMonth = 1;
            ++currentYear;
        }
        int endMonthTotalDays = use30DaysPerMonth ? 30 : end.lengthOfMonth();
        int endPassedDays = end.getDayOfMonth();
        BigDecimal endRatio = BigDecimal.valueOf(endPassedDays).divide(BigDecimal.valueOf(endMonthTotalDays), 10, RoundingMode.HALF_UP);
        return startRatio.add(BigDecimal.valueOf(fullMonths)).add(endRatio);
    }

    static {
        SDK.getLogAPI();
        LOGGERU = LogAPI.getLogger(PeriodCalculationUtil.class);
        DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        MONTH_FORMATTER = DateTimeFormatter.ofPattern("yyyyMM");
    }

    public static class Period {
        private LocalDate periodBeginDate;
        private LocalDate periodEndDate;
        private BigDecimal rate;
        private String commissionPeriodId;

        public LocalDate getPeriodBeginDate() {
            return this.periodBeginDate;
        }

        public void setPeriodBeginDate(LocalDate periodBeginDate) {
            this.periodBeginDate = periodBeginDate;
        }

        public LocalDate getPeriodEndDate() {
            return this.periodEndDate;
        }

        public void setPeriodEndDate(LocalDate periodEndDate) {
            this.periodEndDate = periodEndDate;
        }

        public BigDecimal getRate() {
            return this.rate;
        }

        public void setRate(BigDecimal rate) {
            this.rate = rate;
        }

        public String getCommissionPeriodId() {
            return this.commissionPeriodId;
        }

        public void setCommissionPeriodId(String commissionPeriodId) {
            this.commissionPeriodId = commissionPeriodId;
        }

        public String getPeriodBeginDateStr() {
            return this.periodBeginDate.format(DATE_FORMATTER);
        }

        public String getPeriodEndDateStr() {
            return this.periodEndDate.format(DATE_FORMATTER);
        }

        public String getPeriodMonthStr() {
            return this.periodBeginDate.format(MONTH_FORMATTER);
        }
    }
}

