/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.controller;

import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bo.design.model.BOItemModel;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.service.contractService;
import com.awspaas.user.apps.donenow_ctt.service.contractServiceAdj;
import dn.recordFormChanges;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@Controller
public class contractCreateController {
    private static final Logger contractLogger;

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_submit")
    public ResponseObject contractSubmit(UserContext uc, String bindid) {
        contractLogger.info("contractLogger.info \u5408\u540c\u63d0\u4ea4\u540e---------------" + bindid);
        Map<String, Object> result = contractService.getInstance().SaveContract(uc, bindid, true);
        if (!result.getOrDefault("success", false).equals(true)) {
            return ResponseObject.newErrResponse((String)"\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ResponseObject.newOkResponse((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.get_contractapply")
    public ResponseObject getContractApply(UserContext uc, String bindid) {
        RowMap contractDetail = DBSql.getMap((String)"SELECT ID,BINDID,PROCESSDEFID FROM BO_EU_DNCTT_CONTRACT WHERE BINDID=? ", (Object[])new Object[]{bindid});
        if (contractDetail == null || contractDetail.isEmpty()) {
            contractDetail = DBSql.getMap((String)"SELECT ID,BINDID,PROCESSDEFID FROM BO_EU_DNCTT_CONTRACT_APPLY WHERE BINDID=? ", (Object[])new Object[]{bindid});
        }
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)contractDetail);
        return responseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_delete")
    public ResponseObject contractDelete(UserContext uc, String bindid, String id) throws SQLException {
        int cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNPRO_PROJECT WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u9879\u76ee\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNSDK_TASK WHERE CONTRACT_ID=? ", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u4efb\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCRM_INSTALLED_PRODUCT WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u4ea7\u54c1\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT_COST WHERE CONTRACT_ID=? AND CLOSED=0", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u5408\u540c\u6210\u672c\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCRM_ACCOUNT_DEDUCTION WHERE CONTRACT_ID=? ", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u5df2\u8ba1\u8d39\u6761\u76ee\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNSDK_WORK_ENTRY WHERE CONTRACT_ID=? ", (Object[])new Object[]{id});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)("\u8be5\u5408\u540c\u5173\u8054\u4e86" + cnt + "\u4e2a\u5de5\u65f6\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT WHERE (ID=? OR BINDID=?) AND SETUP_FEE!=0 AND SETUP_FEE IS NOT NULL AND CLOSED=0", (Object[])new Object[]{id, bindid});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)"\u8be5\u5408\u540c\u5408\u540c\u521d\u59cb\u8d39\u7528\u5df2\u5ba1\u6279\u5e76\u63d0\u4ea4\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE (CONTRACT_ID=? OR BINDID=?) AND APPROVE_AND_POST_DATE IS NOT NULL ", (Object[])new Object[]{id, bindid});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)"\u8be5\u5408\u540c\u670d\u52a1\u5df2\u5ba1\u6279\u5e76\u63d0\u4ea4\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        cnt = DBSql.getInt((String)"SELECT COUNT(0) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE (CONTRACT_ID=? OR BINDID=?) AND APPROVE_AND_POST_DATE IS NOT NULL ", (Object[])new Object[]{id, bindid});
        if (cnt > 0) {
            return ResponseObject.newErrResponse((String)"\u8be5\u5408\u540c\u670d\u52a1\u5df2\u5ba1\u6279\u5e76\u63d0\u4ea4\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("CONTRACT_ID", id);
            params.put("BINDID", bindid);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_RATE", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_MILESTONE", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_COST_DEFAULT", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_BUNDLE_SERVICE", " CONTRACT_SERVICE_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID)) ", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE", " CONTRACT_SERVICE_ADJUST_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID))  ", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE", " CONTRACT_SERVICE_ADJUST_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST WHERE (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID)) ", params, conn);
            this.updateContractCLOSED(uc, "BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE", " CONTRACT_SERVICE_PERIOD_ID IN (SELECT ID FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID))  ", params, conn);
            BO contractBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", id);
            if (contractBO != null) {
                contractBO.set("CLOSED", (Object)1);
                recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5220\u9664\u5408\u540c");
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", contractBO, conn);
            }
            if (!(contractBO != null && contractBO.getBindId().equals(bindid) || (contractBO = SDK.getBOAPI().getByProcess("BO_EU_DNCTT_CONTRACT", bindid)) == null)) {
                contractBO.set("CLOSED", (Object)1);
                recordFormChanges.record((UserContext)uc, (BO)contractBO, (String)"\u5220\u9664\u5408\u540c");
                SDK.getBOAPI().update("BO_EU_DNCTT_CONTRACT", contractBO, conn);
            }
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (conn != null && !conn.isClosed()) {
                conn.rollback();
            }
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        return ResponseObject.newOkResponse();
    }

    private void updateContractCLOSED(UserContext uc, String boName, String SqlWhere, Map<String, Object> params, Connection conn) {
        BOModel boModel = BOCache.getInstance().getModelByEntityName(boName);
        BOItemModel CLOSED = boModel.getItem("CLOSED");
        if (CLOSED != null && CLOSED.getName().equals("CLOSED")) {
            SqlWhere = SqlWhere + " AND CLOSED=0";
        }
        List boList = ((BOQueryAPI)SDK.getBOAPI().query(boName).addQuerySqlWhere(SqlWhere, params)).list();
        for (BO bo : boList) {
            recordFormChanges.deleteBeforeRecord((UserContext)uc, (String)boName, (String)bo.getId(), (String)"\u5220\u9664", (Connection)conn);
            SDK.getBOAPI().remove(boName, bo.getId(), conn);
        }
    }

    private void updateContractCLOSED(UserContext uc, String boName, Map<String, Object> params, Connection conn) {
        BOModel boModel = BOCache.getInstance().getModelByEntityName(boName);
        BOItemModel CLOSED = boModel.getItem("CLOSED");
        String whereSql = "";
        if (CLOSED != null && CLOSED.getName().equals("CLOSED")) {
            whereSql = " AND CLOSED=0";
        }
        List boList = ((BOQueryAPI)SDK.getBOAPI().query(boName).addQuerySqlWhere(" (CONTRACT_ID=:CONTRACT_ID OR BINDID=:BINDID) " + whereSql, params)).list();
        for (BO bo : boList) {
            recordFormChanges.deleteBeforeRecord((UserContext)uc, (String)boName, (String)bo.getId(), (String)"\u5220\u9664", (Connection)conn);
            SDK.getBOAPI().remove(boName, bo.getId(), conn);
        }
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_cost_delete", desc="\u5408\u540c\u4ea7\u54c1\u5220\u9664")
    public ResponseObject deleteContractProduct(UserContext uc, String costIds) {
        if (StringUtils.isBlank((CharSequence)costIds)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6761\u76ee\uff01");
        }
        String[] costIdArr = costIds.split(",");
        String sql = "SELECT * FROM BO_EU_DNCTT_CONTRACT_COST WHERE ID IN(";
        for (int i = 0; costIdArr.length > i; ++i) {
            sql = sql + "?,";
        }
        sql = sql.substring(0, sql.length() - 1) + ")";
        List costList = DBSql.getMaps((String)sql, (Object[])Arrays.stream(costIdArr).toArray());
        ArrayList<String> errorList = new ArrayList<String>();
        for (RowMap cost : costList) {
            if (DBSql.getInt((String)"SELECT COUNT(ID) FROM BO_EU_DNCTT_CONTRACT_COST_PRODUCT WHERE CONTRACT_COST_ID=?", (Object[])new Object[]{cost.getString("ID")}) > 0) {
                errorList.add(cost.getString("NAME") + "\u5df2\u62e3\u8d27");
            }
            if (DBSql.getInt((String)"SELECT COUNT(ID) FROM BO_EU_DNIVT_ORDER_PRODUCT WHERE CONTRACT_COST_ID=?", (Object[])new Object[]{cost.getString("ID")}) <= 0) continue;
            errorList.add(cost.getString("NAME") + "\u5df2\u521b\u5efa\u91c7\u8d2d\u5355");
        }
        if (errorList.size() > 0) {
            return ResponseObject.newErrResponse((String)(StringUtils.join(errorList, (String)"\u3001") + "\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        for (RowMap cost : costList) {
            SDK.getProcessAPI().deleteById(cost.getString("BINDID"), uc.getUID());
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_service_delete", desc="\u5220\u9664\u5408\u540c\u670d\u52a1")
    public ResponseObject deleteContractService(UserContext uc, String serviceIds) {
        String[] costIdArr = serviceIds.split(",");
        String selSql = "SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE ID IN(";
        for (int i = 0; costIdArr.length > i; ++i) {
            selSql = selSql + "?,";
        }
        selSql = selSql.substring(0, selSql.length() - 1) + ")";
        List serviceList = DBSql.getMaps((String)selSql, (Object[])Arrays.stream(costIdArr).toArray());
        for (RowMap service : serviceList) {
            Object costProducts;
            if (DBSql.getInt((String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE APPROVE_AND_POST_USER_ID IS NOT NULL AND LENGTH(APPROVE_AND_POST_USER_ID)>1 AND APPROVE_AND_POST_DATE IS NOT NULL and CONTRACT_ID=? and CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"ID")}) > 0) {
                return ResponseObject.newErrResponse((String)"\u5df2\u5ba1\u6279\u5408\u540c\u670d\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            }
            String CONTRACT_COST_ID = DBSql.getString((String)"SELECT ID FROM BO_EU_DNCTT_CONTRACT_COST WHERE IS_SERVICE_PRODUCT=1 AND SERVICE_ID=?", (Object[])new Object[]{service.get((Object)"ID")});
            if (!StringUtils.isNotBlank((CharSequence)CONTRACT_COST_ID) || (costProducts = ((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_COST_PRODUCT").addQuery("CONTRACT_COST_ID =", (Object)CONTRACT_COST_ID)).list()).size() <= 0) continue;
            return ResponseObject.newErrResponse((String)"\u5df2\u7ecf\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\uff0c\u8bf7\u5148\u5220\u9664\u91c7\u8d2d\u8ba2\u5355");
        }
        for (RowMap service : serviceList) {
            List csaIdList = DBSql.getList((String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"ID")});
            for (String csaId : csaIdList) {
                DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST_BUNDLE_SERVICE where CONTRACT_SERVICE_ADJUST_ID=? ", (Object[])new Object[]{csaId});
            }
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_ADJUST where  CONTRACT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"ID")});
            List cspIdList = DBSql.getList((String)"select ID from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where  CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", String.class, (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"OBJECT_ID"), service.get((Object)"ID")});
            for (String cspId : cspIdList) {
                DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD_BUNDLE_SERVICE where CONTRACT_SERVICE_PERIOD_ID=? ", (Object[])new Object[]{cspId});
            }
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD where CONTRACT_ID=? and OBJECT_ID=? and CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get((Object)"CONTRACT_ID"), service.get((Object)"OBJECT_ID"), service.get((Object)"ID")});
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE where  ID=?", (Object[])new Object[]{service.get((Object)"ID")});
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_SERVICE_EDIT where  CONTRACT_SERVICE_ID=?", (Object[])new Object[]{service.get((Object)"ID")});
            DBSql.update((String)"delete from BO_EU_DNCTT_CONTRACT_COST where IS_SERVICE_PRODUCT=1 AND SERVICE_ID=?", (Object[])new Object[]{service.get((Object)"ID")});
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_service_edit")
    public ResponseObject editContractService(UserContext uc, String serviceId) {
        RowMap contractService2 = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCTT_CONTRACT_SERVICE WHERE ID=?", (Object[])new Object[]{serviceId});
        contractService2.remove((Object)"ID");
        contractService2.remove((Object)"BINDID");
        ProcessInstance contractInstance = SDK.getProcessAPI().createBOProcessInstance("obj_e4b0c7ae587c406b808f3a4785f05e23", uc.getUID(), "\u670d\u52a1\u8c03\u6574-" + contractService2.getString("NAME") + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        BO editBO = new BO();
        contractService2.remove((Object)"CREATEDATE");
        contractService2.remove((Object)"CREATEUSER");
        editBO.setAll((Map)contractService2);
        editBO.set("CONTRACT_SERVICE_ID", (Object)serviceId);
        editBO.set("OLD_UNIT_PRICE", contractService2.get((Object)"UNIT_PRICE"));
        editBO.set("OLD_TOTAL_PRICE", contractService2.get((Object)"TOTAL_PRICE"));
        editBO.set("OLD_UNIT_COST", contractService2.get((Object)"UNIT_COST"));
        editBO.set("OLD_QUANTITY", contractService2.get((Object)"QUANTITY"));
        editBO.set("OLD_TOTAL_COST", contractService2.get((Object)"TOTAL_COST"));
        editBO.setBindId(contractInstance.getId());
        String maxEffectiveDate = DBSql.getString((String)"SELECT MAX(EFFECTIVE_DATE) FROM BO_EU_DNCTT_CONTRACT_SERVICE_EDIT WHERE CONTRACT_ID=? and CONTRACT_SERVICE_ID=? and IS_EFFECTIVE='\u5df2\u6267\u884c' ", (Object[])new Object[]{contractService2.get((Object)"CONTRACT_ID"), serviceId});
        if (StringUtils.isBlank((CharSequence)maxEffectiveDate)) {
            maxEffectiveDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        editBO.set("EFFECTIVE_DATE", (Object)maxEffectiveDate);
        editBO.set("IS_EFFECTIVE", (Object)"\u672a\u6267\u884c");
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_SERVICE_EDIT", editBO, contractInstance, uc);
        String processUrl = SDK.getFormAPI().getFormURL(SDK.getPortalAPI().getPortalUrl(), uc.getSessionId(), contractInstance.getId(), null, 1, null, editBO.getId(), null, true);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData((Object)processUrl);
        return responseObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_service_period")
    public ResponseObject servicePeriod(UserContext uc, String contractId, String serviceIds) {
        if (StringUtils.isBlank((CharSequence)contractId)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u5408\u540c");
        }
        if (StringUtils.isBlank((CharSequence)serviceIds)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u5408\u540c\u670d\u52a1");
        }
        BO contractBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", contractId);
        LocalDate START_DATE = contractService.getLocalDate(contractBO.get("START_DATE"));
        LocalDate END_DATE = contractService.getLocalDate(contractBO.get("END_DATE"));
        if (END_DATE == null || START_DATE == null) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u5148\u8bbe\u7f6e\u5408\u540c\u8ba1\u8d39\u5f00\u59cb\u65e5\u671f\u548c\u8ba1\u8d39\u7ed3\u675f\u65e5\u671f");
        }
        if (START_DATE.isAfter(END_DATE)) {
            return ResponseObject.newErrResponse((String)"\u5408\u540c\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
        }
        ArrayList<Object> services = new ArrayList<Object>();
        for (String serviceId : serviceIds.split(",")) {
            Object contraService = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").addQuery("CONTRACT_ID =", (Object)contractId)).addQuery("ID =", (Object)serviceId)).detail();
            LocalDate localDate = contractService.getLocalDate(contraService.get("EFFECTIVE_DATE"));
            if (localDate == null) {
                return ResponseObject.newErrResponse((String)"\u8bf7\u5148\u8bbe\u7f6e\u670d\u52a1\u751f\u6548\u65e5\u671f");
            }
            if (localDate.isBefore(START_DATE) || localDate.isAfter(END_DATE)) {
                return ResponseObject.newErrResponse((String)"\u670d\u52a1\u751f\u6548\u65e5\u671f\u5fc5\u987b\u5728\u5408\u540c\u8ba1\u8d39\u5f00\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u4e4b\u95f4");
            }
            if (DBSql.getInt((String)"SELECT COUNT(1) CNT FROM BO_EU_DNCTT_CONTRACT_SERVICE_SALE_ADJUST WHERE CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{serviceId}) > 0 && DBSql.getInt((String)"SELECT COUNT(1) CNT FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{serviceId}) > 0) continue;
            services.add(contraService);
        }
        if (services.size() == 0) {
            return ResponseObject.newOkResponse();
        }
        StringBuilder errMsg = new StringBuilder();
        StringBuilder succMsg = new StringBuilder();
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            RowMap dto = new RowMap(contractBO.asMap());
            for (BO bO : services) {
                contractService.getInstance().AddService(uc, conn, dto, bO);
                contractService.getInstance().AddContractServiceProductOne(uc, dto, bO, conn);
                if (DBSql.getInt((Connection)conn, (String)"SELECT count(1) FROM BO_EU_DNCTT_CONTRACT_SERVICE_PERIOD WHERE CONTRACT_SERVICE_ID=? ", (Object[])new Object[]{bO.get("ID")}) == 0) {
                    errMsg.append(bO.get("NAME") + "\u751f\u6210\u670d\u52a1\u5468\u671f\u5931\u8d25\uff0c");
                    continue;
                }
                succMsg.append(bO.get("NAME") + "\u751f\u6210\u670d\u52a1\u5468\u671f\u6210\u529f\uff0c");
            }
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        if (errMsg.length() > 0) {
            if (succMsg.length() > 0) {
                return ResponseObject.newWarnResponse((String)(succMsg.toString() + errMsg.toString()));
            }
            return ResponseObject.newErrResponse((String)errMsg.toString());
        }
        for (Object contraService : services) {
            contractServiceAdj.getInstance().paySplitServiceMonth(uc, contraService.getString("ID"));
        }
        return ResponseObject.newOkResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_service_cost")
    public ResponseObject serviceCost(UserContext uc, String contractId, String serviceIds) {
        if (StringUtils.isBlank((CharSequence)contractId)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u5408\u540c");
        }
        if (StringUtils.isBlank((CharSequence)serviceIds)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u5408\u540c\u670d\u52a1");
        }
        BO contractBO = SDK.getBOAPI().get("BO_EU_DNCTT_CONTRACT", contractId);
        ArrayList<Object> services = new ArrayList<Object>();
        for (String serviceId : serviceIds.split(",")) {
            BO contraService = (BO)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_CONTRACT_SERVICE").addQuery("CONTRACT_ID =", (Object)contractId)).addQuery("ID =", (Object)serviceId)).detail();
            String string = contraService.getString("NEED_PURCHASE");
            if (!string.equals("1")) {
                return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91c7\u8d2d\u7684\u670d\u52a1");
            }
            services.add(contraService);
        }
        StringBuilder errMsg = new StringBuilder();
        StringBuilder succMsg = new StringBuilder();
        Connection conn = null;
        try {
            conn = DBSql.open();
            conn.setAutoCommit(false);
            RowMap dto = new RowMap(contractBO.asMap());
            for (BO bO : services) {
                contractService.getInstance().AddContractServiceProductOne(uc, dto, bO, conn);
                String contractCostId = DBSql.getString((Connection)conn, (String)"select ID from BO_EU_DNCTT_CONTRACT_COST where IS_SERVICE_PRODUCT=1 AND  CONTRACT_ID=? and SERVICE_ID=? ", (Object[])new Object[]{bO.getString("CONTRACT_ID"), bO.getString("ID")});
                if (StringUtils.isBlank((CharSequence)contractCostId)) {
                    errMsg.append(bO.get("NAME") + "\u751f\u6210\u670d\u52a1\u4ea7\u54c1\u5931\u8d25\uff0c");
                    continue;
                }
                succMsg.append(bO.get("NAME") + "\u751f\u6210\u670d\u52a1\u4ea7\u54c1\u6210\u529f\uff0c");
            }
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            if (conn != null) {
                DBSql.close((Connection)conn);
            }
        }
        if (errMsg.length() > 0) {
            if (succMsg.length() > 0) {
                return ResponseObject.newWarnResponse((String)(succMsg.toString() + errMsg.toString()));
            }
            return ResponseObject.newErrResponse((String)errMsg.toString());
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.contract_service_add")
    public ResponseObject serviceAdd(UserContext uc, String contractId) {
        ProcessInstance processInstance = SDK.getProcessAPI().createProcessInstance("obj_58693e03feac4879901430440b42efd9", uc.getUID(), "\u5408\u540c\u670d\u52a1");
        BO service = new BO();
        service.setBindId(processInstance.getId());
        service.set("CONTRACT_ID", (Object)contractId);
        SDK.getBOAPI().create("BO_EU_DNCTT_CONTRACT_SERVICE", service, processInstance, uc);
        return ResponseObject.newOkResponse();
    }

    static {
        SDK.getLogAPI();
        contractLogger = LogAPI.getLogger(contractCreateController.class);
    }
}

