/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.controller;

import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.formfile.model.delegate.FormFile;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import com.awspaas.user.apps.donenow_ctt.QrCodeReaderUtil;
import com.awspaas.user.apps.donenow_ctt.service.InvoiceDealDto;
import com.awspaas.user.apps.donenow_ctt.service.InvoiceService;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Controller
public class invoiceController {
    @Mapping(value="com.awspaas.user.apps.donenow_ctt.preview_invoice")
    public ResponseObject previewInvoice(UserContext uc, String accDeduIds) {
        InvoiceDealDto invoiceDealDto = new InvoiceDealDto();
        invoiceDealDto.setIds(accDeduIds);
        String result = InvoiceService.getInstance().processInvoice(uc, accDeduIds, invoiceDealDto, false);
        if (StringUtils.isNotBlank((CharSequence)result) && !result.contains("\u6210\u529f")) {
            return ResponseObject.newErrResponse((String)result);
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.deal_invoice")
    public ResponseObject dealInvoice(UserContext uc, String accDeduIds, String startDate, String endDate) {
        InvoiceDealDto invoiceDealDto = new InvoiceDealDto();
        invoiceDealDto.setIds(accDeduIds);
        SDK.getLogAPI().consoleInfo("\u5904\u7406\u8d26\u5355\uff1a" + accDeduIds + "\u8d26\u5355\u5f00\u59cb\u65f6\u95f4\uff1a" + startDate + "\u8d26\u5355\u7ed3\u675f\u65f6\u95f4\uff1a" + endDate);
        if (StringUtils.isBlank((CharSequence)startDate) || StringUtils.isBlank((CharSequence)endDate)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u8d26\u5355\u65f6\u95f4");
        }
        invoiceDealDto.setDateRangeFromStr(startDate);
        invoiceDealDto.setDateRangeToStr(endDate);
        String result = InvoiceService.getInstance().processInvoice(uc, accDeduIds, invoiceDealDto, true);
        if (StringUtils.isNotBlank((CharSequence)result) && !result.contains("\u6210\u529f")) {
            return ResponseObject.newErrResponse((String)result);
        }
        String bindid = result.replace("\u6210\u529f--", "");
        return ResponseObject.newOkResponse().put("BINDID", (Object)bindid);
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.invoiceUpdate")
    public ResponseObject invoiceUpdate(UserContext uc, String invoiceIds, String dealStatus) throws SQLException {
        if (StringUtils.isBlank((CharSequence)dealStatus)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u5904\u7406\u72b6\u6001");
        }
        if (StringUtils.isBlank((CharSequence)invoiceIds)) {
            return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9");
        }
        if (dealStatus.contains("\u4f5c\u5e9f\u53d1\u7968")) {
            for (String invoiceId : invoiceIds.split(",")) {
                if (StringUtils.isBlank((CharSequence)invoiceId)) {
                    return ResponseObject.newErrResponse((String)"\u8bf7\u9009\u62e9\u8d26\u5355");
                }
                String sql = "SELECT d.ID,d.INVOICE_NO,COUNT(b.ID) CNT from BO_EU_DNCTT_INVOICE_PLAN a JOIN BO_EU_DNCTT_INVOICE_PLAN_DETAIL b ON a.BINDID=b.BINDID JOIN BO_EU_DNCTT_INVOICE_DETAIL c ON b.INVOICE_DETAIL_ID=c.ID JOIN BO_EU_DNCTT_INVOICE d ON c.BINDID=d.BINDID where d.ID=? GROUP BY d.ID,d.INVOICE_NO";
                RowMap invoice = DBSql.getMap((String)sql, (Object[])new Object[]{invoiceId});
                if (invoice == null || invoice.getInt("CNT") <= 0) continue;
                return ResponseObject.newErrResponse((String)(invoice.getString("INVOICE_NO") + "\u5df2\u7533\u8bf7\u5f00\u7968\u7684\u8d26\u5355\u4e0d\u5141\u8bb8\u4f5c\u5e9f"));
            }
        }
        InvoiceService.getInstance().invoiceUpdate(uc, invoiceIds, dealStatus);
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.delInvoicePlan")
    public ResponseObject delInvoicePlan(UserContext uc, String bindids) {
        for (String bindid : bindids.split(",")) {
            SDK.getProcessAPI().deleteById(bindid, uc.getUID());
            SDK.getBOAPI().removeByBindId("BO_EU_DNCTT_INVOICE_PLAN_DETAIL", bindid);
            SDK.getBOAPI().removeByBindId("BO_EU_DNCTT_INVOICE_PLAN", bindid);
        }
        return ResponseObject.newOkResponse();
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.getTaxRate")
    public ResponseObject getTaxRate(UserContext uc, String taxCategoryId) {
        String taxRate = DBSql.getString((String)"select EXT1 from bo_eu_dnd_general where is_active=1 and closed=0 and general_table_id=44 AND OID=? AND ORGID=?", (Object[])new Object[]{taxCategoryId, uc.getCompanyModel().getId()});
        return ResponseObject.newOkResponse().put("taxRate", (Object)taxRate);
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.QRReader")
    public ResponseObject QRReader(UserContext uc) {
        String qrContent = "";
        List jars = SDK.getBOAPI().getFiles("6da746b2-c84a-4502-ada8-f0b681d19ac3", "TU");
        for (FormFile jar : jars) {
            DCContext dcContext = SDK.getBOAPI().getFileDCContext(jar);
            Path source = Paths.get(dcContext.getFilePath(), new String[0]);
            qrContent = qrContent + "\n" + QrCodeReaderUtil.readQrCode(source.toFile());
        }
        return ResponseObject.newOkResponse().put("qrContent", (Object)qrContent);
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ctt.invoice_plan")
    public ResponseObject invoicePlan(UserContext uc, String accDeduIds) {
        InvoiceDealDto invoiceDealDto = new InvoiceDealDto();
        invoiceDealDto.setIds(accDeduIds);
        SDK.getLogAPI().consoleInfo("\u5904\u7406\u8d26\u5355\uff1a" + accDeduIds);
        String result = InvoiceService.getInstance().invoicePlan(uc, accDeduIds);
        if (StringUtils.isNotBlank((CharSequence)result) && !result.contains("\u6210\u529f")) {
            return ResponseObject.newErrResponse((String)result);
        }
        String bindid = result.replace("\u6210\u529f--", "");
        return ResponseObject.newOkResponse().put("BINDID", (Object)bindid);
    }
}

