/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.service;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class CityAbbreviationUtil {
    private static String processCityName(String city) {
        String[] suffixes;
        if (city == null || city.trim().isEmpty()) {
            return "";
        }
        for (String suffix : suffixes = new String[]{"\u5e02", "\u7701", "\u81ea\u6cbb\u533a", "\u81ea\u6cbb\u5dde", "\u5730\u533a", "\u76df", "\u53bf", "\u533a"}) {
            if (!city.endsWith(suffix)) continue;
            return city.substring(0, city.length() - suffix.length());
        }
        return city;
    }

    private static char getFirstLetter(char chineseChar) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)chineseChar, (HanyuPinyinOutputFormat)format);
            if (pinyinArray != null && pinyinArray.length > 0) {
                return pinyinArray[0].charAt(0);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return chineseChar;
    }

    public static String getCityAbbreviation(String city) {
        String processedCity = CityAbbreviationUtil.processCityName(city);
        if (processedCity.isEmpty()) {
            return "";
        }
        StringBuilder abbreviation = new StringBuilder();
        for (int i = 0; i < processedCity.length(); ++i) {
            char c = processedCity.charAt(i);
            abbreviation.append(CityAbbreviationUtil.getFirstLetter(c));
        }
        return abbreviation.toString();
    }

    public static void main(String[] args) {
        String cssx = "\u4e0a\u6d77\u5e02";
        System.out.println(CityAbbreviationUtil.getCityAbbreviation(cssx));
        System.out.println(CityAbbreviationUtil.getCityAbbreviation("\u5317\u4eac\u5e02"));
        System.out.println(CityAbbreviationUtil.getCityAbbreviation("\u5e7f\u5dde\u5e02"));
        System.out.println(CityAbbreviationUtil.getCityAbbreviation("\u56db\u5ddd\u7701"));
    }
}

