/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ctt.service;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.bpmn.engine.model.run.delegate.ProcessInstance;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.TypeUtil;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.BOQueryAPI;
import com.actionsoft.sdk.local.api.LogAPI;
import com.actionsoft.sdk.local.api.Logger;
import com.awspaas.user.apps.donenow_ctt.service.InvoiceDealDto;
import com.awspaas.user.apps.donenow_ctt.service.contractService;
import dn.recordFormChanges;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class InvoiceService {
    private static final Logger logger;
    private static volatile InvoiceService instance;

    private InvoiceService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InvoiceService getInstance() {
        if (instance != null) return instance;
        Class<InvoiceService> clazz = InvoiceService.class;
        synchronized (InvoiceService.class) {
            if (instance != null) return instance;
            instance = new InvoiceService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String processInvoice(UserContext uc, String accDeduIds, InvoiceDealDto param, boolean isDeal) {
        logger.info("\u5904\u7406\u53d1\u7968\u751f\u6210");
        logger.info("accDeduIds:" + accDeduIds);
        logger.info("\u65e5\u671f\u8303\u56f4:" + param.getDateRangeFrom() + "--" + param.getDateRangeTo());
        if (StringUtils.isBlank((CharSequence)accDeduIds)) {
            return "\u53c2\u6570\u9519\u8bef";
        }
        Object[] dedIdArr = accDeduIds.split(",");
        StringBuilder where = new StringBuilder("(");
        for (int i = 0; i < dedIdArr.length; ++i) {
            where.append("?").append(i < dedIdArr.length - 1 ? "," : ")");
        }
        String sqlWhere = where.toString();
        List postedDataList = DBSql.getMaps((String)("SELECT * FROM VIEW_EU_DNV_POSTED_ALL d WHERE d.ID IN " + sqlWhere + " AND (d.invoice_id is null OR d.invoice_id='' OR NOT EXISTS(SELECT 1 FROM bo_eu_dnctt_invoice i WHERE i.id=d.invoice_id AND IS_VOIDED=0))  AND  d.bill_account_id is NOT NULL AND d.ORGID='" + uc.getCompanyModel().getId() + "' ORDER BY ACCOUNT_ID,BILL_ACCOUNT_ID"), (Object[])dedIdArr);
        logger.info("\u8d26\u5355\u4e2a\u6570:" + postedDataList.size());
        if (postedDataList.isEmpty() || postedDataList.size() != dedIdArr.length) {
            return "\u6240\u9009\u6761\u76ee\u6709\u8d26\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u672a\u751f\u6210\u751f\u6210\u8d26\u5355";
        }
        postedDataList.forEach(row -> row.forEach((key, value) -> {
            if (key.toUpperCase().equals("BILL_ACCOUNT_ID")) {
                if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
                    row.put(key.toUpperCase(), row.get((Object)"ACCOUNT_ID"));
                } else {
                    row.put(key.toUpperCase(), value);
                }
            } else {
                row.put(key.toUpperCase(), value);
            }
        }));
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        String BILL_ACCOUNT_ID = null;
        for (RowMap row2 : postedDataList) {
            Object RECEIVE_STATUS;
            String ITEM_DATE = row2.getString("ITEM_DATE");
            if (!StringUtils.isNotBlank((CharSequence)ITEM_DATE)) continue;
            LocalDate itemDate = LocalDate.parse((String)ITEM_DATE, (DateTimeFormatter)formatter);
            if (itemDate.isBefore((ReadablePartial)param.getDateRangeFrom()) || itemDate.isAfter((ReadablePartial)param.getDateRangeTo())) {
                return "\u6240\u9009\u6761\u76ee\u8ba1\u8d39\u65e5\u671f\u5fc5\u987b\u5728\u8f93\u5165\u7684\u8d26\u5355\u8d77\u6b62\u65e5\u671f\u5185";
            }
            if (StringUtils.isBlank(BILL_ACCOUNT_ID)) {
                BILL_ACCOUNT_ID = row2.getString("BILL_ACCOUNT_ID");
            } else if (!BILL_ACCOUNT_ID.equals(row2.getString("BILL_ACCOUNT_ID"))) {
                return "\u6240\u9009\u6761\u76ee\u6709\u8d26\u5355\u5ba2\u6237\u5fc5\u987b\u76f8\u540c";
            }
            if (((String)(RECEIVE_STATUS = row2.getString("RECEIVE_STATUS"))).equals("4661")) continue;
            return "\u6240\u9009\u6761\u76ee\u6709\u8d26\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u672a\u751f\u6210\u751f\u6210\u8d26\u5355";
        }
        List accountDedList = DBSql.getMaps((String)("SELECT * FROM BO_EU_DNCRM_ACCOUNT_DEDUCTION WHERE ID IN " + sqlWhere + " ORDER BY ACCOUNT_ID,BILL_ACCOUNT_ID"), (Object[])dedIdArr);
        List itemTypeDict = DBSql.getMaps((String)"SELECT OID,NAME FROM BO_EU_DND_GENERAL WHERE GENERAL_TABLE_ID='121' AND ORGID=?", (Object[])new Object[]{uc.getCompanyModel().getId()});
        Map<String, List<RowMap>> customerDedMap = accountDedList.stream().filter(ded -> ded.get((Object)"BILL_ACCOUNT_ID") != null).collect(Collectors.groupingBy(ded -> ded.get((Object)"BILL_ACCOUNT_ID").toString()));
        if (customerDedMap.isEmpty()) {
            return null;
        }
        ArrayList<String> invoiceIds = new ArrayList<String>();
        for (Map.Entry entry : customerDedMap.entrySet()) {
            String ACCOUNT_ID = (String)entry.getKey();
            List customerDedList = (List)entry.getValue();
            RowMap customer = DBSql.getMap((String)"SELECT * FROM BO_EU_DNCRM_ACCOUNT WHERE ID = ?", (Object[])new Object[]{ACCOUNT_ID});
            logger.info("\u5904\u7406\u5ba2\u6237ID:" + ACCOUNT_ID);
            logger.info("RESOURCE_ID--" + customer.getString("RESOURCE_ID"));
            if (customer == null || StringUtils.isBlank((CharSequence)customer.getString("RESOURCE_ID"))) continue;
            List<RowMap> noPoDedList = customerDedList.stream().filter(ded -> StringUtils.isBlank((CharSequence)ded.getString("PURCHASE_ORDER_NO"))).collect(Collectors.toList());
            if (!noPoDedList.isEmpty()) {
                List<RowMap> noPoPostedList = postedDataList.stream().filter(p -> StringUtils.isBlank((CharSequence)p.getString("PURCHASE_ORDER_NO"))).filter(p -> ACCOUNT_ID.equals(p.get((Object)"ACCOUNT_ID")) || ACCOUNT_ID.equals(p.get((Object)"BILL_ACCOUNT_ID"))).collect(Collectors.toList());
                logger.info("\u65e0PO\u8d26\u5355\u6570\u91cf:" + noPoPostedList.size());
                String noPoInvoiceId = this.createInvoiceAndDetails(uc, customer, noPoPostedList, noPoDedList, itemTypeDict, param, isDeal, "");
                if (StringUtils.isNotBlank((CharSequence)noPoInvoiceId)) {
                    invoiceIds.add(noPoInvoiceId);
                }
            }
            Map<String, List<RowMap>> poDedMap = customerDedList.stream().filter(ded -> StringUtils.isNotBlank((CharSequence)ded.getString("PURCHASE_ORDER_NO"))).collect(Collectors.groupingBy(ded -> ded.getString("PURCHASE_ORDER_NO")));
            for (Map.Entry<String, List<RowMap>> poEntry : poDedMap.entrySet()) {
                String poNo = poEntry.getKey();
                List<RowMap> poDedList = poEntry.getValue();
                List<RowMap> poPostedList = postedDataList.stream().filter(p -> poNo.equals(p.getString("PURCHASE_ORDER_NO"))).filter(p -> ACCOUNT_ID.equals(p.get((Object)"ACCOUNT_ID")) || ACCOUNT_ID.equals(p.get((Object)"BILL_ACCOUNT_ID"))).collect(Collectors.toList());
                logger.info("\u5904\u7406\u91c7\u8d2d\u8ba2\u5355\uff1a" + poNo);
                String poInvoiceId = this.createInvoiceAndDetails(uc, customer, poPostedList, poDedList, itemTypeDict, param, isDeal, poNo);
                if (!StringUtils.isNotBlank((CharSequence)poInvoiceId)) continue;
                invoiceIds.add(poInvoiceId);
            }
        }
        logger.info("\u53d1\u7968ID:" + ((Object)invoiceIds).toString());
        String invoiceBINDID = DBSql.getString((String)"SELECT BINDID FROM BO_EU_DNCTT_INVOICE WHERE ID=?", (Object[])new Object[]{invoiceIds.get(0)});
        return "\u6210\u529f--" + invoiceBINDID;
    }

    private InvoiceSummary calculateSummary(List<RowMap> postedList) {
        InvoiceSummary summary = new InvoiceSummary();
        summary.totalMoney = postedList.stream().mapToDouble(p -> p.getDouble("DOLLARS")).sum();
        summary.totalTax = postedList.stream().mapToDouble(p -> p.getDouble("TAX_DOLLARS")).sum();
        summary.totalPrice = summary.totalMoney - summary.totalTax;
        summary.noBillHours = postedList.stream().filter(p -> StringUtils.isBlank((CharSequence)p.getString("BILLABLE"))).mapToDouble(p -> p.getDouble("BILLABLE_HOURS")).sum();
        summary.billHours = postedList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("BILLABLE"))).mapToDouble(p -> p.getDouble("BILLABLE_HOURS")).sum();
        summary.prepaidHours = postedList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("CONTRACT_BLOCK_ID"))).mapToDouble(p -> p.getDouble("BILLABLE_HOURS")).sum();
        return summary;
    }

    private String createInvoiceAndDetails(UserContext uc, RowMap customer, List<RowMap> postedList, List<RowMap> dedList, List<RowMap> itemTypeDict, InvoiceDealDto param, boolean isDeal, String poNo) {
        try {
            InvoiceSummary summary = this.calculateSummary(postedList);
            String invoiceNo = SDK.getRuleAPI().executeAtScript("B@left(@date,4)@mid(@date,6,2).@mid(@sequenceMonth(@companyId_invoice,4,0,1),7)", uc);
            ProcessInstance pi = SDK.getProcessAPI().createProcessInstance("obj_a7d46a9dd4df40b899ddcf02113fe0d2", uc.getUID(), "\u65b0\u589e\u8d26\u5355" + invoiceNo);
            BO invoice = new BO();
            invoice.set("INVOICE_NO", (Object)invoiceNo);
            invoice.set("ACCOUNT_ID", (Object)customer.getString("ID"));
            invoice.set("ACCOUNT_NAME", (Object)customer.getString("NAME"));
            invoice.set("OWNER_RESOURCE_NAME", (Object)DBSql.getString((String)"SELECT USERNAME FROM orguser WHERE USERID=?", (Object[])new Object[]{customer.getString("RESOURCE_ID")}));
            invoice.set("INVOICE_DATE", (Object)param.getInvoiceDate().toString());
            invoice.set("DATE_RANGE_FROM", (Object)param.getDateRangeFrom().toString());
            invoice.set("DATE_RANGE_TO", (Object)param.getDateRangeTo().toString());
            invoice.set("TOTAL", (Object)summary.totalMoney);
            invoice.set("TAX_VALUE", (Object)summary.totalTax);
            invoice.set("TOTAL_PRICE", (Object)summary.totalPrice);
            invoice.set("NOBILL_HOURS", (Object)summary.noBillHours);
            invoice.set("BILL_HOURS", (Object)summary.billHours);
            invoice.set("PREPAID_HOURS", (Object)summary.prepaidHours);
            invoice.set("PAYMENT_TERM_ID", (Object)param.getPaymentTermId());
            invoice.set("PURCHASE_ORDER_NO", (Object)poNo);
            invoice.set("NOTES", (Object)param.getNotes());
            String taxRegionName = StringUtils.isBlank((CharSequence)customer.getString("TAX_REGION_ID")) || customer.getString("TAX_REGION_ID").equals("0") ? "" : DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ?", (Object[])new Object[]{customer.getString("TAX_REGION_ID")});
            invoice.set("TAX_REGION_NAME", (Object)taxRegionName);
            invoice.setBindId(pi.getId());
            SDK.getBOAPI().create("BO_EU_DNCTT_INVOICE", invoice, pi, uc);
            recordFormChanges.record((UserContext)uc, (BO)invoice, (String)("\u4fdd\u5b58\u53d1\u7968\uff1a" + invoiceNo));
            Map<String, RowMap> dedIdMap = dedList.stream().collect(Collectors.toMap(ded -> ded.getString("ID"), ded -> ded));
            int lineNo = 1;
            for (RowMap posted : postedList) {
                String dedId = posted.getString("ID");
                RowMap ded2 = dedIdMap.get(dedId);
                BO detail = new BO();
                detail.setBindId(invoice.getBindId());
                detail.set("INVOICE_ID", (Object)invoice.getId());
                detail.set("ITEM_DATE", posted.get((Object)"ITEM_DATE"));
                detail.set("ITEM_DESC", StringUtils.isBlank((CharSequence)posted.getString("ITEM_DESC")) ? posted.get((Object)"ITEM_NAME") : posted.get((Object)"ITEM_DESC"));
                detail.set("RESOURCE_NAME", posted.get((Object)"RESOURCE_NAME"));
                detail.set("QUANTITY", posted.get((Object)"QUANTITY"));
                detail.set("RATE", posted.get((Object)"RATE"));
                detail.set("DOLLARS", posted.get((Object)"DOLLARS"));
                detail.set("TAX_DOLLARS", posted.get((Object)"TAX_DOLLARS"));
                BigDecimal DOLLARS_NOTAX = (posted.get((Object)"DOLLARS") == null ? BigDecimal.ZERO : (BigDecimal)TypeUtil.convert((Object)posted.get((Object)"DOLLARS"), BigDecimal.class)).subtract(posted.get((Object)"TAX_DOLLARS") == null ? BigDecimal.ZERO : (BigDecimal)TypeUtil.convert((Object)posted.get((Object)"TAX_DOLLARS"), BigDecimal.class));
                detail.set("DOLLARS_NOTAX", (Object)DOLLARS_NOTAX);
                detail.set("HOURLY_RATE", posted.get((Object)"HOURLY_RATE"));
                detail.set("ROLE_NAME", posted.get((Object)"ROLE_NAME"));
                detail.set("WORK_TYPE", posted.get((Object)"WORK_TYPE"));
                detail.set("BILL_ACCOUNT_ID", (Object)ded2.getString("BILL_ACCOUNT_ID"));
                detail.set("ACCOUNT_ID", (Object)ded2.getString("ACCOUNT_ID"));
                detail.set("ACCOUNT_DEDUCTION_ID", (Object)dedId);
                String contractTypeId = posted.getString("CONTRACT_TYPE_ID");
                String billableHours = posted.getString("BILLABLE_HOURS");
                if ("1199".equals(contractTypeId) || "1201".equals(contractTypeId)) {
                    billableHours = "\u5408\u540c\u5df2\u5305";
                } else if (("1202".equals(contractTypeId) || "1203".equals(contractTypeId)) && StringUtils.isNotBlank((CharSequence)posted.getString("BILLABLE"))) {
                    billableHours = "\u9884\u652f\u4ed8";
                }
                detail.set("BILLABLE_HOURS", (Object)billableHours);
                String itemTypeOid = posted.getString("ITEM_TYPE");
                String itemTypeName = itemTypeDict.stream().filter(type -> itemTypeOid.equals(type.getString("OID"))).findFirst().map(type -> type.getString("NAME")).orElse(null);
                if (itemTypeName == null) {
                    itemTypeName = DBSql.getString((String)"SELECT NAME FROM BO_EU_DND_GENERAL WHERE OID = ? AND ORGID=?", (Object[])new Object[]{itemTypeOid, uc.getCompanyModel().getId()});
                }
                detail.set("ITEM_TYPE", (Object)itemTypeName);
                detail.set("EFFECTIVE_TAX_RATE", (Object)(ded2.getDouble("EFFECTIVE_TAX_RATE") * 100.0));
                detail.set("TAX_CATEGORY_NAME", ded2.get((Object)"TAX_CATEGORY_NAME"));
                detail.set("TAX_CATEGORY_ID", ded2.get((Object)"TAX_CATEGORY_ID"));
                detail.set("CONTRACT_ID", ded2.get((Object)"CONTRACT_ID"));
                SDK.getBOAPI().createDataBO("BO_EU_DNCTT_INVOICE_DETAIL", detail, uc);
                recordFormChanges.record((UserContext)uc, (BO)detail, (String)("\u4fdd\u5b58\u8d26\u5355\u660e\u7ec6\uff1a" + detail.getId()));
                if (isDeal) {
                    BO dedBo = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", dedId);
                    dedBo.set("INVOICE_ID", (Object)invoice.getId());
                    dedBo.set("INVOICE_LINE_ITEM_NO", (Object)lineNo);
                    recordFormChanges.record((UserContext)uc, (BO)dedBo, (String)"\u751f\u6210\u8d26\u5355");
                    SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", dedBo);
                }
                ++lineNo;
            }
            return invoice.getId();
        }
        catch (Exception e) {
            logger.info("\u9519\u8bef---" + e.getMessage());
            logger.error("\u9519\u8bef--111-", (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }

    public boolean invoiceUpdate(UserContext uc, String invoiceIds, String dealStatus) throws SQLException {
        for (String invoiceId : invoiceIds.split(",")) {
            BO invoice = SDK.getBOAPI().get("BO_EU_DNCTT_INVOICE", invoiceId);
            List invoiceDetails = ((BOQueryAPI)((BOQueryAPI)((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCTT_INVOICE_DETAIL").bindId(invoice.getBindId()).addQuery("INVOICE_ID =", (Object)invoiceId)).orderBy("ACCOUNT_ID")).orderBy("BILL_ACCOUNT_ID")).list();
            HashMap TypeDedIds = new HashMap();
            int lineNo = 1;
            for (BO invoiceDetail : invoiceDetails) {
                BO accountDeduction;
                String accountDeductionId = invoiceDetail.getString("ACCOUNT_DEDUCTION_ID");
                if (StringUtils.isBlank((CharSequence)accountDeductionId) || (accountDeduction = SDK.getBOAPI().get("BO_EU_DNCRM_ACCOUNT_DEDUCTION", accountDeductionId)) == null) continue;
                String typeId = accountDeduction.getString("TYPE_ID");
                if (TypeDedIds.containsKey(typeId)) {
                    ((HashSet)TypeDedIds.get(typeId)).add(accountDeductionId);
                } else {
                    TypeDedIds.put(typeId, new HashSet());
                    ((HashSet)TypeDedIds.get(typeId)).add(accountDeductionId);
                }
                if (dealStatus.equals("\u751f\u6210\u53d1\u7968")) {
                    if (!StringUtils.isBlank((CharSequence)accountDeduction.getString("INVOICE_ID"))) continue;
                    accountDeduction.set("INVOICE_ID", (Object)invoice.getId());
                    accountDeduction.set("INVOICE_LINE_ITEM_NO", (Object)lineNo);
                    recordFormChanges.record((UserContext)uc, (BO)accountDeduction, (String)"\u751f\u6210\u53d1\u7968");
                    SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", accountDeduction);
                    ++lineNo;
                    continue;
                }
                if (!dealStatus.contains("\u4f5c\u5e9f\u53d1\u7968") || !StringUtils.isNotBlank((CharSequence)accountDeduction.getString("INVOICE_ID"))) continue;
                accountDeduction.set("INVOICE_ID", null);
                accountDeduction.set("INVOICE_LINE_ITEM_NO", (Object)0);
                recordFormChanges.record((UserContext)uc, (BO)accountDeduction, (String)"\u4f5c\u5e9f\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", accountDeduction);
                ++lineNo;
            }
            if (dealStatus.contains("\u4f5c\u5e9f\u53d1\u7968")) {
                SDK.getProcessAPI().deleteById(invoice.getBindId(), uc.getUID());
                SDK.getBOAPI().remove("BO_EU_DNCTT_INVOICE", invoiceId);
                SDK.getBOAPI().removeByBindId("BO_EU_DNCTT_INVOICE_DETAIL", invoice.getBindId());
                DBSql.update((String)"DELETE FROM BO_EU_DNCTT_INVOICE_DETAIL WHERE BINDID=? OR INVOICE_ID=?", (Object[])new Object[]{invoice.getBindId(), invoiceId});
            } else if (dealStatus.equals("\u751f\u6210\u53d1\u7968")) {
                invoice.set("IS_VOIDED", (Object)0);
                invoice.set("VOIDED_TIME", null);
                invoice.set("VOIDED_RESOURCE_ID", null);
                recordFormChanges.record((UserContext)uc, (BO)invoice, (String)"\u751f\u6210\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCTT_INVOICE", invoice);
            } else if (dealStatus.equals("\u4f5c\u5e9f\u53d1\u7968")) {
                invoice.set("IS_VOIDED", (Object)1);
                invoice.set("VOIDED_TIME", (Object)LocalDateTime.now().format(java.time.format.DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                invoice.set("VOIDED_RESOURCE_ID", (Object)uc.getUID());
                recordFormChanges.record((UserContext)uc, (BO)invoice, (String)"\u4f5c\u5e9f\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCTT_INVOICE", invoice);
            }
            if (!dealStatus.contains("\u4f5c\u5e9f\u53d1\u7968")) continue;
            List deductions = ((BOQueryAPI)SDK.getBOAPI().query("BO_EU_DNCRM_ACCOUNT_DEDUCTION").addQuery("INVOICE_ID =", (Object)invoiceId)).list();
            for (BO deduction : deductions) {
                String typeId = deduction.getString("TYPE_ID");
                if (!TypeDedIds.containsKey(typeId)) {
                    TypeDedIds.put(typeId, new HashSet());
                }
                ((HashSet)TypeDedIds.get(typeId)).add(deduction.getId());
                deduction.set("INVOICE_ID", null);
                deduction.set("INVOICE_LINE_ITEM_NO", (Object)0);
                recordFormChanges.record((UserContext)uc, (BO)deduction, (String)"\u4f5c\u5e9f\u53d1\u7968");
                SDK.getBOAPI().update("BO_EU_DNCRM_ACCOUNT_DEDUCTION", deduction);
                DBSql.update((String)"UPDATE BO_EU_DNCRM_ACCOUNT_DEDUCTION SET INVOICE_ID=null,INVOICE_LINE_ITEM_NO=0 WHERE INVOICE_ID=?", (Object[])new Object[]{invoiceId});
            }
            if (!dealStatus.contains("\u53d6\u6d88\u5ba1\u6279") || TypeDedIds.isEmpty()) continue;
            for (String typeId : TypeDedIds.keySet()) {
                String string;
                String ids = StringUtils.join((Iterable)((Iterable)TypeDedIds.get(typeId)), (String)",");
                if (typeId.equals(String.valueOf(1325)) || typeId.equals(String.valueOf(1327))) {
                    string = contractService.getInstance().revokeRecurringServices(uc, ids);
                    continue;
                }
                if (typeId.equals(String.valueOf(1321))) {
                    string = contractService.getInstance().revokeCost(uc, ids);
                    continue;
                }
                if (typeId.equals(String.valueOf(1323))) {
                    string = contractService.getInstance().revokeMilestones(uc, ids);
                    continue;
                }
                if (typeId.equals(String.valueOf(1322))) {
                    string = contractService.getInstance().revokeExpense(uc, ids);
                    continue;
                }
                if (typeId.equals(String.valueOf(1318))) {
                    string = contractService.getInstance().revokeLabor(uc, ids);
                    continue;
                }
                if (!typeId.equals(String.valueOf(1328))) continue;
                string = contractService.getInstance().revokeCommission(uc, ids);
            }
        }
        return true;
    }

    public String invoicePlan(UserContext uc, String accDeduIds) {
        if (StringUtils.isBlank((CharSequence)accDeduIds)) {
            return "\u53c2\u6570\u9519\u8bef";
        }
        Object[] dedIdArr = accDeduIds.split(",");
        StringBuilder where = new StringBuilder("(");
        for (int i = 0; i < dedIdArr.length; ++i) {
            where.append("?").append(i < dedIdArr.length - 1 ? "," : ")");
        }
        String sqlWhere = where.toString();
        List postedDataList = DBSql.getMaps((String)("SELECT * FROM VIEW_EU_DNV_POSTED_ALL d WHERE d.ID IN " + sqlWhere + "  AND  d.bill_account_id is NOT NULL AND d.ORGID='" + uc.getCompanyModel().getId() + "' ORDER BY ACCOUNT_ID,BILL_ACCOUNT_ID"), (Object[])dedIdArr);
        logger.info("\u8d26\u5355\u4e2a\u6570:" + postedDataList.size());
        postedDataList.forEach(row -> row.forEach((key, value) -> {
            if (key.toUpperCase().equals("BILL_ACCOUNT_ID")) {
                if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
                    row.put(key.toUpperCase(), row.get((Object)"ACCOUNT_ID"));
                } else {
                    row.put(key.toUpperCase(), value);
                }
            } else {
                row.put(key.toUpperCase(), value);
            }
        }));
        String BILL_ACCOUNT_ID = null;
        for (RowMap row2 : postedDataList) {
            String RECEIVE_STATUS;
            String ITEM_DATE = row2.getString("ITEM_DATE");
            if (!StringUtils.isNotBlank((CharSequence)ITEM_DATE)) continue;
            if (StringUtils.isBlank(BILL_ACCOUNT_ID)) {
                BILL_ACCOUNT_ID = row2.getString("BILL_ACCOUNT_ID");
            } else if (!BILL_ACCOUNT_ID.equals(row2.getString("BILL_ACCOUNT_ID"))) {
                return "\u6240\u9009\u6761\u76ee\u6709\u8d26\u5355\u5ba2\u6237\u5fc5\u987b\u76f8\u540c";
            }
            if ((RECEIVE_STATUS = row2.getString("RECEIVE_STATUS")).equals("4662")) continue;
            return "\u6240\u9009\u6761\u76ee\u6709\u8d26\u5355\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u751f\u6210\u751f\u6210\u8d26\u5355";
        }
        List accountDedList = DBSql.getMaps((String)("SELECT * FROM VIEW_EU_DNCTT_INVOICE_DETAIL WHERE ACCOUNT_DEDUCTION_ID IN " + sqlWhere + " ORDER BY ACCOUNT_ID,BILL_ACCOUNT_ID"), (Object[])dedIdArr);
        if (accountDedList.size() == 0) {
            return "\u6240\u9009\u6761\u76ee\u65e0\u8d26\u5355";
        }
        ProcessInstance pi = SDK.getProcessAPI().createProcessInstance("obj_a1a00d7c7c0e4eb69acd57291557521d", uc.getUID(), "\u5f00\u7968\u7533\u8bf7");
        BO invoice = new BO();
        invoice.setBindId(pi.getId());
        invoice.set("BILL_ACCOUNT_ID", (Object)BILL_ACCOUNT_ID);
        invoice.set("BILL_ACCOUNT_NAME", (Object)DBSql.getString((String)"select NAME from bo_eu_dncrm_account where ID=?", (Object[])new Object[]{BILL_ACCOUNT_ID}));
        invoice.set("INVOICE_AMOUNT", (Object)0);
        invoice.set("STATUS_ID", (Object)"4471");
        SDK.getBOAPI().create("BO_EU_DNCTT_INVOICE_PLAN", invoice, pi, uc);
        SDK.getProcessAPI().start(pi);
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        for (RowMap row3 : accountDedList) {
            invoiceAmount = invoiceAmount.add((BigDecimal)TypeUtil.convert((Object)row3.get((Object)"INVOICE_AMOUNT"), BigDecimal.class));
            BO dedBO = new BO();
            dedBO.setAll((Map)row3);
            dedBO.setBindId(pi.getId());
            dedBO.set("INVOICE_DETAIL_ID", (Object)row3.getString("ID"));
            SDK.getBOAPI().create("BO_EU_DNCTT_INVOICE_PLAN_DETAIL", dedBO, pi, uc);
        }
        DBSql.update((String)"UPDATE BO_EU_DNCTT_INVOICE_PLAN SET INVOICE_AMOUNT=? WHERE ID=?", (Object[])new Object[]{invoiceAmount, invoice.getId()});
        return "\u6210\u529f--" + invoice.getBindId();
    }

    static {
        SDK.getLogAPI();
        logger = LogAPI.getLogger(InvoiceService.class);
    }

    private static class InvoiceSummary {
        double totalMoney;
        double totalTax;
        double totalPrice;
        double noBillHours;
        double billHours;
        double prepaidHours;

        private InvoiceSummary() {
        }
    }
}

