/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.dao;

import com.actionsoft.apps.network.model.NetworkAppAccessModel;
import com.actionsoft.bpms.commons.database.RowMapper;
import com.actionsoft.bpms.commons.mvc.dao.DaoObject;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AWSDataAccessException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAppAccessDao
extends DaoObject<NetworkAppAccessModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkAppAccessDao.class);

    public List<NetworkAppAccessModel> loadNetworkAppAccessOfCache() {
        List<NetworkAppAccessModel> list = new ArrayList<NetworkAppAccessModel>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_ACCESS");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppAccessModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
        }
        return list;
    }

    public List<NetworkAppAccessModel> findAppAccessByTeam(String teamId) throws SQLException {
        ArrayList<NetworkAppAccessModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_ACCESS").append(" T WHERE T.TEAMID = ? ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppAccessModelRowMapper(), (Object[])new Object[]{teamId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public List<NetworkAppAccessModel> findAppAccessByTeam(String teamId, String appId) throws SQLException {
        ArrayList<NetworkAppAccessModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_ACCESS").append(" T WHERE T.TEAMID = ? AND T.APPID = ? ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppAccessModelRowMapper(), (Object[])new Object[]{teamId, appId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public List<NetworkAppAccessModel> findAppAccessByAppId(String appId) throws SQLException {
        ArrayList<NetworkAppAccessModel> list = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_ACCESS").append(" T WHERE T.APPID = ? ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppAccessModelRowMapper(), (Object[])new Object[]{appId});
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public NetworkAppAccessModel getAppAccessById(String id) throws SQLException {
        NetworkAppAccessModel model = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT * FROM ").append("APP_ACT_NETWORK_APP_ACCESS").append(" WHERE ID = ? ");
            model = (NetworkAppAccessModel)((Object)DBSql.getObject((String)sql.toString(), (RowMapper)new NetworkAppAccessModelRowMapper(), (Object[])new Object[]{id}));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return model;
    }

    public boolean clearNetworkAppAccess(String id) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append("APP_ACT_NETWORK_APP_ACCESS").append(" where id=:id");
        params.put("id", id);
        return DBSql.update((String)sql.toString(), params) > 0;
    }

    public List<NetworkAppAccessModel> loadNetworkAppAccessList(String networkId, String searchValue, String order) throws SQLException {
        LinkedList<NetworkAppAccessModel> list = new LinkedList();
        try {
            StringBuffer sql = new StringBuffer();
            if (UtilString.isEmpty((String)order)) {
                order = "createtime";
            }
            sql.append("select * from ").append("APP_ACT_NETWORK_APP_ACCESS").append(" where teamstatus = '1' and  networkid = '").append(networkId).append("' and teamName like '%").append(searchValue).append("%' order by ").append(order).append(" desc ");
            list = DBSql.query((String)sql.toString(), (RowMapper)new NetworkAppAccessModelRowMapper(), (Object[])new Object[0]);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return list;
    }

    public int insert(NetworkAppAccessModel model) throws AWSDataAccessException {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("ID", model.getId());
        paramsMap.put("TEAMID", model.getTeamId());
        paramsMap.put("APPID", model.getAppId());
        int result = DBSql.update((String)DBSql.getInsertStatement((String)"APP_ACT_NETWORK_APP_ACCESS", paramsMap), paramsMap);
        return result;
    }

    public int update(NetworkAppAccessModel model) throws AWSDataAccessException {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("TEAMID", model.getTeamId());
        paramsMap.put("APPID", model.getAppId());
        return super.update((Object)model.getId(), paramsMap);
    }

    public String entityName() {
        return "APP_ACT_NETWORK_APP_ACCESS";
    }

    public RowMapper<NetworkAppAccessModel> rowMapper() {
        return null;
    }

    private static class NetworkAppAccessModelRowMapper
    implements RowMapper<NetworkAppAccessModel> {
        private NetworkAppAccessModelRowMapper() {
        }

        public NetworkAppAccessModel mapRow(ResultSet rs, int param) throws SQLException {
            NetworkAppAccessModel model = new NetworkAppAccessModel();
            model.setId(rs.getString("ID"));
            model.setTeamId(rs.getString("TEAMID"));
            model.setAppId(rs.getString("APPID"));
            return model;
        }
    }
}

