/*
 * Decompiled with CFR 0.152.
 */
package com.awspaas.user.apps.donenow_ivt.controller;

import com.actionsoft.bpms.bo.engine.BO;
import com.actionsoft.bpms.commons.database.RowMap;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.DBSql;
import com.actionsoft.sdk.local.SDK;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
public class testController {
    private static final Logger logger = LoggerFactory.getLogger(testController.class);
    private static final String RICH_TEXT_FIELD = "RESOLUTION";
    private static final String BO_TABLE = "BO_EU_DNSDK_TASK";
    private static final String CONTENT_SEPARATOR = "<br/><br/>";
    private static final String PARAGRAPH_START = "<p>";
    private static final String PARAGRAPH_END = "</p>";

    @Mapping(value="com.awspaas.user.apps.donenow_tst_updatex")
    public ResponseObject updateResolution(UserContext uc, String id, String newSolution) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseObject.newErrResponse((String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)newSolution)) {
            return ResponseObject.newErrResponse((String)"newSolution\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BO bo = SDK.getBOAPI().get(BO_TABLE, id);
            if (bo == null) {
                logger.warn("\u672a\u627e\u5230ID\u4e3a\u3010{}\u3011\u7684\u8bb0\u5f55\uff0c\u65e0\u6cd5\u83b7\u53d6\u5bcc\u6587\u672c\u5185\u5bb9", (Object)id);
                return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230ID\u4e3a\u3010" + id + "\u3011\u7684\u8bb0\u5f55"));
            }
            String currentContent = bo.getString(RICH_TEXT_FIELD);
            currentContent = StringUtils.defaultString((String)currentContent).trim();
            logger.debug("\u83b7\u53d6\u5230ID\u4e3a\u3010{}\u3011\u7684\u5bcc\u6587\u672c\u539f\u59cb\u5185\u5bb9\uff1a{}", (Object)id, (Object)currentContent);
            String formattedNewContent = this.formatNewContent(newSolution);
            String finalContent = this.\u62fc\u63a5\u5185\u5bb9(currentContent, formattedNewContent);
            bo.set(RICH_TEXT_FIELD, (Object)finalContent);
            int updateCount = SDK.getBOAPI().update(BO_TABLE, bo);
            if (updateCount <= 0) {
                logger.warn("ID\u4e3a\u3010{}\u3011\u7684\u5bcc\u6587\u672c\u66f4\u65b0\u5931\u8d25", (Object)id);
                return ResponseObject.newErrResponse((String)"\u5bcc\u6587\u672c\u66f4\u65b0\u5931\u8d25\uff0c\u65e0\u6709\u6548\u53d8\u66f4");
            }
            HashMap<String, Object> result = new HashMap<String, Object>(4);
            result.put("id", id);
            result.put("originalContent", currentContent);
            result.put("updatedContent", finalContent);
            result.put("updateTime", System.currentTimeMillis());
            ResponseObject response = ResponseObject.newOkResponse();
            response.setData(result);
            return response;
        }
        catch (Exception e) {
            logger.error("\u5bcc\u6587\u672c\u66f4\u65b0\u5f02\u5e38\uff0cID:{}", (Object)id, (Object)e);
            return ResponseObject.newErrResponse((String)("\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    private String \u62fc\u63a5\u5185\u5bb9(String currentContent, String newContent) {
        if (currentContent.isEmpty()) {
            return newContent;
        }
        if (currentContent.endsWith(PARAGRAPH_END)) {
            int endIndex = currentContent.lastIndexOf(PARAGRAPH_END);
            return currentContent.substring(0, endIndex) + newContent + PARAGRAPH_END;
        }
        return currentContent + CONTENT_SEPARATOR + newContent;
    }

    private String formatNewContent(String newContent) {
        String trimmedContent = newContent.trim();
        if (trimmedContent.startsWith(PARAGRAPH_START) && trimmedContent.endsWith(PARAGRAPH_END)) {
            return trimmedContent;
        }
        return PARAGRAPH_START + trimmedContent + PARAGRAPH_END;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_tst_updatestatus")
    public ResponseObject updateStatus(UserContext uc, String id, String status) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseObject.newErrResponse((String)"\u5de5\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)status)) {
            return ResponseObject.newErrResponse((String)"\u72b6\u6001\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            BO bo = SDK.getBOAPI().get(BO_TABLE, id);
            if (bo == null) {
                return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230ID\u4e3a\u3010" + id + "\u3011\u7684\u8bb0\u5f55"));
            }
            bo.set("STATUS_ID", (Object)status);
            int updateCount = SDK.getBOAPI().update(BO_TABLE, bo);
            if (updateCount <= 0) {
                return ResponseObject.newErrResponse((String)("ID\u4e3a\u3010" + id + "\u3011\u7684\u72b6\u6001\u66f4\u65b0\u5931\u8d25"));
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("id", id);
            result.put("updatedStatus", status);
            ResponseObject responseObject = ResponseObject.newOkResponse();
            responseObject.setData(result);
            return responseObject;
        }
        catch (Exception e) {
            return ResponseObject.newErrResponse((String)("\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryAccount")
    public ResponseObject queryAccountByAccountId(UserContext uc, String accountId) {
        if (StringUtils.isBlank((CharSequence)accountId)) {
            return ResponseObject.newErrResponse((String)"\u8d26\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String accountSql = "select ADDRESS, DISTRICT_ID from BO_EU_DNCRM_ACCOUNT where id = ?";
        RowMap accountMap = DBSql.getMap((String)accountSql, (Object[])new Object[]{accountId});
        if (accountMap == null) {
            return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230ID\u4e3a\u3010" + accountId + "\u3011\u7684\u8d26\u6237\u4fe1\u606f"));
        }
        String districtId = accountMap.getString("DISTRICT_ID");
        String districtName = "";
        if (StringUtils.isNotBlank((CharSequence)districtId)) {
            String dictSql = "select CNNAME from bo_act_dict_kv_item where ITEMNO = ? and DICTKEY = 'GB.ADDR'";
            RowMap dictMap = DBSql.getMap((String)dictSql, (Object[])new Object[]{districtId});
            districtName = dictMap != null ? dictMap.getString("CNNAME") : "";
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ADDRESS", accountMap.getString("ADDRESS"));
        result.put("DISTRICT_ID", districtId);
        result.put("DISTRICT_NAME", districtName);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryTaskCount")
    public ResponseObject queryTaskCountByAccountId(UserContext uc, String accountId) {
        if (StringUtils.isBlank((CharSequence)accountId)) {
            return ResponseObject.newErrResponse((String)"\u8d26\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select count(*) as task_count from BO_EU_DNSDK_TASK where account_id = ? and type_id=1809";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{accountId});
        int taskCount = map.getInt("task_count");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("task_count", taskCount);
        result.put("account_id", accountId);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryTaskCountByContactId")
    public ResponseObject queryTaskCountByContactId(UserContext uc, String contactId) {
        if (StringUtils.isBlank((CharSequence)contactId)) {
            return ResponseObject.newErrResponse((String)"\u8054\u7cfb\u4eba ID \u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select count(*) as task_count from BO_EU_DNSDK_TASK where contact_id = ? and type_id=1809";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{contactId});
        int taskCount = map.getInt("task_count");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("task_count", taskCount);
        result.put("contact_id", contactId);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryTaskCountByProductId")
    public ResponseObject queryTaskCountByProductId(UserContext uc, String installedProductId) {
        if (StringUtils.isBlank((CharSequence)installedProductId)) {
            return ResponseObject.newErrResponse((String)"\u914d\u7f6e\u9879ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "select count(*) as task_count from BO_EU_DNSDK_TASK where INSTALLED_PRODUCT_ID = ?";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{installedProductId});
        int taskCount = map.getInt("task_count");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("task_count", taskCount);
        result.put("installed_product_id", installedProductId);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryProductInfoByBindid")
    public ResponseObject queryProductInfoByBindid(UserContext uc, String bindid) {
        if (StringUtils.isBlank((CharSequence)bindid)) {
            return ResponseObject.newErrResponse((String)"bindid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String productSql = "SELECT LOCATION, CONTACT_ID, START_DATE, THROUGH_DATE, VENDOR_ACCOUNT_ID FROM BO_EU_DNCRM_INSTALLED_PRODUCT WHERE bindid = ?";
        RowMap productMap = DBSql.getMap((String)productSql, (Object[])new Object[]{bindid});
        if (productMap == null) {
            return ResponseObject.newErrResponse((String)("\u672a\u627e\u5230bindid\u4e3a\u3010" + bindid + "\u3011\u7684\u4ea7\u54c1\u6570\u636e"));
        }
        Date startDate = productMap.getDate("START_DATE");
        Date throughDate = productMap.getDate("THROUGH_DATE");
        long warrantyDays = 0L;
        String warrantyDesc = "";
        if (startDate == null || throughDate == null) {
            warrantyDesc = "\u65e5\u671f\u4fe1\u606f\u4e0d\u5b8c\u6574";
        } else if (throughDate.before(startDate)) {
            warrantyDesc = "\u65e5\u671f\u8303\u56f4\u5f02\u5e38";
        } else {
            warrantyDays = (throughDate.getTime() - startDate.getTime()) / 86400000L;
            warrantyDesc = warrantyDays + "\u5929";
        }
        String contactId = productMap.getString("CONTACT_ID");
        String contactName = "";
        if (StringUtils.isNotBlank((CharSequence)contactId)) {
            String contactSql = "SELECT NAME FROM BO_EU_DNCRM_CONTACT WHERE id = ?";
            RowMap contactMap = DBSql.getMap((String)contactSql, (Object[])new Object[]{contactId});
            contactName = contactMap != null ? contactMap.getString("NAME") : "\u672a\u77e5\u8054\u7cfb\u4eba";
        }
        String vendorAccountId = productMap.getString("VENDOR_ACCOUNT_ID");
        String vendorName = "";
        if (StringUtils.isNotBlank((CharSequence)vendorAccountId)) {
            String vendorSql = "SELECT NAME FROM bo_eu_dncrm_account WHERE id = ?";
            RowMap vendorMap = DBSql.getMap((String)vendorSql, (Object[])new Object[]{vendorAccountId});
            vendorName = vendorMap != null ? vendorMap.getString("NAME") : "\u672a\u77e5\u4f9b\u5e94\u5546";
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("LOCATION", productMap.getString("LOCATION"));
        result.put("CONTACT_ID", contactId);
        result.put("CONTACT_NAME", contactName);
        result.put("VENDOR_ACCOUNT_ID", vendorAccountId);
        result.put("VENDOR_NAME", vendorName);
        result.put("WARRANTY_DAYS", warrantyDays);
        result.put("WARRANTY_DESC", warrantyDesc);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }

    @Mapping(value="com.awspaas.user.apps.donenow_ivt.queryHoursWorkedByTaskId")
    public ResponseObject queryHoursWorkedByTaskId(UserContext uc, String taskId) {
        Object hoursObj;
        if (StringUtils.isBlank((CharSequence)taskId)) {
            return ResponseObject.newErrResponse((String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String sql = "SELECT SUM(hours_worked) AS total_hours FROM BO_EU_DNSDK_WORK_ENTRY WHERE task_id = ?";
        RowMap map = DBSql.getMap((String)sql, (Object[])new Object[]{taskId});
        double totalHours = map != null ? ((hoursObj = map.get((Object)"total_hours")) != null && hoursObj instanceof Number ? ((Number)hoursObj).doubleValue() : 0.0) : 0.0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total_hours", totalHours);
        result.put("task_id", taskId);
        ResponseObject responseObject = ResponseObject.newOkResponse();
        responseObject.setData(result);
        return responseObject;
    }
}

