/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.cache;

import com.actionsoft.apps.network.cache.NetworkTeam_NetworkIndex;
import com.actionsoft.apps.network.dao.NetworkTeamDao;
import com.actionsoft.apps.network.model.NetworkTeamModel;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.bpms.commons.cache.Cache;
import com.actionsoft.bpms.commons.cache.CacheIndex;
import com.actionsoft.bpms.commons.cache.CacheManager;
import com.actionsoft.bpms.util.ConsolePrinter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class NetworkTeamCache
extends Cache<String, NetworkTeamModel> {
    public static final Comparator<NetworkTeamModel> SORT_CREATETIME = new Comparator<NetworkTeamModel>(){

        @Override
        public int compare(NetworkTeamModel o1, NetworkTeamModel o2) {
            return o2.getCreateTime().compareTo(o1.getCreateTime());
        }
    };

    public NetworkTeamCache(CachePluginProfile profile) {
        super(profile);
        this.registeIndex(NetworkTeam_NetworkIndex.class, (CacheIndex)new NetworkTeam_NetworkIndex());
    }

    public static void putModel(NetworkTeamModel model) {
        NetworkTeamModel old = NetworkTeamCache.getModel(model.getId());
        int result = -1;
        result = old == null ? new NetworkTeamDao().insert(model) : new NetworkTeamDao().update(model);
        if (result == 1) {
            NetworkTeamCache.getCache().put((Serializable)((Object)model.getId()), (Serializable)((Object)model), true);
        }
    }

    public static NetworkTeamModel getModel(String id) {
        return (NetworkTeamModel)((Object)NetworkTeamCache.getCache().get((Serializable)((Object)id)));
    }

    public static void removeById(String id) {
        int result = new NetworkTeamDao().delete(id);
        if (result == 1) {
            NetworkTeamCache.getCache().remove((Serializable)((Object)id));
        }
    }

    public static List<NetworkTeamModel> loadAllNetworkTeam() {
        Iterator iter = NetworkTeamCache.getCache().iteratorSorted(SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkTeamModel> loadNetworkTeamBy(String networkId) {
        Iterator iter = NetworkTeamCache.getCache().getByIndex(NetworkTeam_NetworkIndex.class, (Serializable)((Object)networkId), SORT_CREATETIME);
        return Cache.iteratorToList((Iterator)iter);
    }

    public static List<NetworkTeamModel> loadNetworkTeam(String networkId, String teamName) {
        ArrayList<NetworkTeamModel> list = new ArrayList<NetworkTeamModel>();
        List<NetworkTeamModel> allNetworkTeam = NetworkTeamCache.loadAllNetworkTeam();
        for (NetworkTeamModel model : allNetworkTeam) {
            if (!model.getNetworkId().equals(networkId) || model.getTeamName().toLowerCase().indexOf(teamName.toLowerCase()) < 0) continue;
            list.add(model);
        }
        return list;
    }

    public static List<NetworkTeamModel> loadNetworkTeamBy(String networkId, String teamStatus) {
        ArrayList<NetworkTeamModel> list = new ArrayList<NetworkTeamModel>();
        List<NetworkTeamModel> allNetworkTeam = NetworkTeamCache.loadAllNetworkTeam();
        for (NetworkTeamModel model : allNetworkTeam) {
            if (!model.getNetworkId().equals(networkId) || !model.getTeamStatus().equals(teamStatus)) continue;
            list.add(model);
        }
        return list;
    }

    public void load() {
        List<NetworkTeamModel> list = new NetworkTeamDao().loadNetworkTeamOfCache();
        for (NetworkTeamModel model : list) {
            this.put((Serializable)((Object)model.getId()), (Serializable)((Object)model), false);
        }
        ConsolePrinter.info((String)("[\u540c\u4e8b\u5708]Cache\u52a0\u8f7d\u5c0f\u7ec4 [" + list.size() + "\u4e2a][\u6210\u529f]"));
    }

    public static NetworkTeamCache getCache() {
        return (NetworkTeamCache)CacheManager.getCache(NetworkTeamCache.class);
    }
}

