/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.apps.network.taskutil;

import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.AppAPI;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskmgtTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskmgtTool.class);

    public static boolean isActive() {
        AppAPI appAPI = SDK.getAppAPI();
        AppContext jodApp = appAPI.getAppContext("com.actionsoft.apps.taskmgt");
        return jodApp != null && SDK.getAppAPI().isActive(jodApp.getId());
    }

    public ResponseObject addProjectMember(String sid, String projectId, String userIds) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        if (TaskmgtTool.isActive()) {
            String aslp = "aslp://com.actionsoft.apps.taskmgt/addProjectNormalMembers";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sid", sid);
                params.put("projectId", projectId);
                params.put("userIds", userIds);
                ro = appAPI.callASLP(appAPI.getAppContext("com.actionsoft.apps.network"), aslp, params);
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)appAPI.getAppContext("com.actionsoft.apps.network"), (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public ResponseObject addProjectMemberLeader(String sid, String projectId, String userIds) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        if (TaskmgtTool.isActive()) {
            String aslp = "aslp://com.actionsoft.apps.taskmgt/addProjectLeaderMember";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sid", sid);
                params.put("projectId", projectId);
                params.put("userIds", userIds);
                ro = appAPI.callASLP(appAPI.getAppContext("com.actionsoft.apps.network"), aslp, params);
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)appAPI.getAppContext("com.actionsoft.apps.network"), (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public ResponseObject deleteProjectMember(String sid, String projectId, String userId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        if (TaskmgtTool.isActive()) {
            String aslp = "aslp://com.actionsoft.apps.taskmgt/deleteProjectMember";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sid", sid);
                params.put("projectId", projectId);
                params.put("userId", userId);
                ro = appAPI.callASLP(appAPI.getAppContext("com.actionsoft.apps.network"), aslp, params);
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)appAPI.getAppContext("com.actionsoft.apps.network"), (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public ResponseObject updateProjectStatus(String sid, String projectId, String status) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        if (TaskmgtTool.isActive()) {
            String aslp = "aslp://com.actionsoft.apps.taskmgt/updateProjectStatus";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sid", sid);
                params.put("projectId", projectId);
                params.put("status", status);
                ro = appAPI.callASLP(appAPI.getAppContext("com.actionsoft.apps.network"), aslp, params);
                if (ro.isErr()) {
                    AppsLogger.err((AppContext)appAPI.getAppContext("com.actionsoft.apps.network"), (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return ro;
    }

    public boolean isExistsProject(String sid, String projectId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppAPI appAPI = SDK.getAppAPI();
        boolean isExists = true;
        if (TaskmgtTool.isActive()) {
            String aslp = "aslp://com.actionsoft.apps.taskmgt/getProjectInfo";
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                params.put("sid", sid);
                params.put("projectId", projectId);
                ro = appAPI.callASLP(appAPI.getAppContext("com.actionsoft.apps.network"), aslp, params);
                if (ro.isErr()) {
                    isExists = false;
                    AppsLogger.err((AppContext)appAPI.getAppContext("com.actionsoft.apps.network"), (String)ro.getMsg());
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
                ro.err(e.getMessage());
            }
        }
        return isExists;
    }
}

